/*
 * Decompiled with CFR 0.152.
 */
package org.openscada.da.server.opc.job;

import org.openscada.da.server.opc.job.GuardianHandler;
import org.openscada.da.server.opc.job.Job;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Guardian
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(Guardian.class);
    private volatile boolean running = true;
    private Job currentJob;
    private GuardianHandler handler;
    private boolean completed = false;

    @Override
    public synchronized void run() {
        this.signalInitialized();
        while (this.running) {
            try {
                try {
                    this.doLoop();
                }
                catch (Throwable e) {
                    logger.warn("Failed to wait for job", e);
                    this.cleanUp();
                    continue;
                }
            }
            catch (Throwable throwable) {
                this.cleanUp();
                throw throwable;
            }
            this.cleanUp();
        }
        logger.info("Guardian is shut down");
    }

    private synchronized void doLoop() throws InterruptedException {
        this.wait();
        logger.debug("Woke up");
        if (this.currentJob == null) {
            logger.info("Woke up without a job");
            return;
        }
        this.notifyAll();
        long timeout = this.currentJob.getTimeout();
        long start = System.currentTimeMillis();
        logger.debug("Job timeout: {}", (Object)timeout);
        while (!this.completed && System.currentTimeMillis() - start < timeout) {
            this.wait(10L);
        }
        logger.debug("Stopped waiting: completed: {}, diff: {}", (Object)this.completed, (Object)(System.currentTimeMillis() - start));
        if (!this.completed) {
            this.cancel();
        }
        this.notifyAll();
    }

    public synchronized void startJob(Job job, GuardianHandler handler) {
        if (!this.running) {
            throw new RuntimeException("Guardian is already shut down");
        }
        if (this.currentJob != null) {
            throw new RuntimeException("Guardian already running");
        }
        logger.debug("Starting new job");
        this.currentJob = job;
        this.handler = handler;
        this.completed = false;
        this.notifyAll();
    }

    public synchronized void jobCompleted() {
        logger.debug("current job completed");
        if (this.currentJob != null) {
            logger.debug("mark job as complete");
            this.completed = true;
            this.notifyAll();
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                logger.error("Failed to wait for guardian completion");
            }
        } else {
            logger.debug("There is no job active .. maybe guardian already knows that the job is completed since he canceled it");
        }
    }

    private void cancel() {
        try {
            this.handler.performCancel();
        }
        catch (Throwable e) {
            logger.error("Failed to cancel operation", e);
        }
    }

    private void cleanUp() {
        this.currentJob = null;
        this.handler = null;
    }

    private void signalInitialized() {
        logger.debug("Signalize that we are up");
        this.notifyAll();
    }

    public synchronized void shutdown() {
        logger.info("Shutting down guardian");
        this.running = false;
        this.notifyAll();
    }
}

