/*
 * Decompiled with CFR 0.152.
 */
package org.openscada.da.server.opc.job;

import java.lang.reflect.InvocationTargetException;
import org.openscada.da.server.opc.job.Guardian;
import org.openscada.da.server.opc.job.GuardianHandler;
import org.openscada.da.server.opc.job.Job;
import org.openscada.da.server.opc.job.JobHandler;
import org.openscada.da.server.opc.job.JobResult;
import org.openscada.da.server.opc.job.WorkUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Worker
implements GuardianHandler {
    private static final Logger logger = LoggerFactory.getLogger(Worker.class);
    private volatile WorkUnit currentWorkUnit;
    private final Guardian guardian;
    private final Thread guardianThread;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Worker() {
        Guardian guardian = this.guardian = new Guardian();
        synchronized (guardian) {
            this.guardianThread = new Thread((Runnable)this.guardian, "OPCGuardian");
            this.guardianThread.setDaemon(true);
            this.guardianThread.start();
            try {
                logger.info("Waiting for guardian...");
                this.guardian.wait();
                logger.info("Guardian is up...");
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Failed to initialize OPC guardian", e);
            }
        }
    }

    protected void finalize() throws Throwable {
        this.guardian.shutdown();
        super.finalize();
    }

    public <T> T execute(Job job, JobResult<T> result) throws InvocationTargetException {
        OPCResultJobHandler<T> handler = new OPCResultJobHandler<T>(result);
        WorkUnit workUnit = new WorkUnit(job, handler);
        this.execute(workUnit);
        if (handler.getError() != null) {
            throw new InvocationTargetException(handler.getError(), "Failed to call DCOM method");
        }
        return handler.getResult();
    }

    public void execute(Job job, Runnable runnable) throws InvocationTargetException {
        OPCRunnableJobHandler handler = new OPCRunnableJobHandler(runnable);
        WorkUnit workUnit = new WorkUnit(job, handler);
        this.execute(workUnit);
        if (handler.getError() != null) {
            throw new InvocationTargetException(handler.getError(), "Failed to call DCOM method");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(WorkUnit currentWorkUnit) {
        if (currentWorkUnit == null) {
            throw new RuntimeException("Work unit must not be null");
        }
        if (currentWorkUnit.getJob() == null) {
            throw new RuntimeException("Job must be set");
        }
        if (currentWorkUnit.getJobHandler() == null) {
            throw new RuntimeException("Job handler must be set");
        }
        Worker worker = this;
        synchronized (worker) {
            if (this.currentWorkUnit != null) {
                throw new RuntimeException("Already running");
            }
            this.currentWorkUnit = currentWorkUnit;
        }
        this.perform();
    }

    protected Throwable performCancelable() {
        try {
            try {
                logger.debug("Start guardian");
                this.guardian.startJob(this.currentWorkUnit.getJob(), this);
                logger.debug("Run job");
                this.currentWorkUnit.getJob().run();
                logger.debug("Run job finished");
            }
            catch (Throwable e) {
                logger.warn("Job failed", e);
                Throwable throwable = e;
                logger.debug("Notify guardian that job is complete");
                this.guardian.jobCompleted();
                logger.debug("guardian knows now");
                return throwable;
            }
        }
        finally {
            logger.debug("Notify guardian that job is complete");
            this.guardian.jobCompleted();
            logger.debug("guardian knows now");
        }
        return null;
    }

    protected void perform() {
        try {
            logger.debug("Starting new job");
            this.performCancelable();
            logger.debug("Job completed");
        }
        catch (Throwable e) {
            logger.warn("Failed to process", e);
        }
        if (this.currentWorkUnit.getJob().isCanceled()) {
            this.currentWorkUnit.getJobHandler().handleInterrupted();
        } else if (this.currentWorkUnit.getJob().getError() == null) {
            this.currentWorkUnit.getJobHandler().handleSuccess();
        } else {
            this.currentWorkUnit.getJobHandler().handleFailure(this.currentWorkUnit.getJob().getError());
        }
        this.currentWorkUnit = null;
    }

    @Override
    public void performCancel() {
        WorkUnit workUnit = this.currentWorkUnit;
        if (workUnit != null) {
            workUnit.getJob().interrupt();
        }
    }

    protected static class OPCResultJobHandler<T>
    implements JobHandler {
        private Throwable error;
        private T result;
        private final JobResult<T> jobResult;

        public OPCResultJobHandler(JobResult<T> jobResult) {
            this.jobResult = jobResult;
        }

        @Override
        public void handleFailure(Throwable e) {
            this.error = e;
        }

        @Override
        public void handleInterrupted() {
            this.error = new InterruptedException("Job got interrupted");
            this.error.fillInStackTrace();
        }

        @Override
        public void handleSuccess() {
            this.result = this.jobResult.getResult();
        }

        public Throwable getError() {
            return this.error;
        }

        public T getResult() {
            return this.result;
        }
    }

    protected static class OPCRunnableJobHandler
    implements JobHandler {
        private Throwable error;
        private final Runnable runnable;

        public OPCRunnableJobHandler(Runnable runnable) {
            this.runnable = runnable;
        }

        @Override
        public void handleFailure(Throwable e) {
            this.error = e;
        }

        @Override
        public void handleInterrupted() {
            this.error = new InterruptedException("Job got interrupted");
            this.error.fillInStackTrace();
        }

        @Override
        public void handleSuccess() {
            this.runnable.run();
        }

        public Throwable getError() {
            return this.error;
        }
    }
}

