/*
 * Decompiled with CFR 0.152.
 */
package org.openscada.da.server.opc.job.impl;

import org.openscada.da.server.opc.connection.OPCModel;
import org.openscada.da.server.opc.job.JobResult;
import org.openscada.da.server.opc.job.ThreadJob;
import org.openscada.opc.dcom.common.EventHandler;
import org.openscada.opc.dcom.da.IOPCDataCallback;
import org.openscada.opc.dcom.da.impl.OPCGroupStateMgt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttachGroupJob
extends ThreadJob
implements JobResult<EventHandler> {
    public static final long DEFAULT_TIMEOUT = 5000L;
    private static final Logger logger = LoggerFactory.getLogger(AttachGroupJob.class);
    private final OPCModel model;
    private final IOPCDataCallback dataCallback;
    private EventHandler result;

    public AttachGroupJob(long timeout, OPCModel model, IOPCDataCallback dataCallback) {
        super(timeout);
        this.model = model;
        this.dataCallback = dataCallback;
    }

    @Override
    protected void perform() throws Exception {
        logger.info("Perform group attach");
        OPCGroupStateMgt group = this.model.getGroup();
        if (group != null) {
            this.result = group.attach(this.dataCallback);
        }
    }

    @Override
    public EventHandler getResult() {
        return this.result;
    }
}

