/*
 * Decompiled with CFR 0.152.
 */
package org.openscada.da.server.opc.job.impl;

import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import org.eclipse.scada.da.data.IODirection;
import org.eclipse.scada.utils.str.StringHelper;
import org.jinterop.dcom.common.JIException;
import org.openscada.da.server.opc.browser.BrowseRequest;
import org.openscada.da.server.opc.browser.BrowseResult;
import org.openscada.da.server.opc.browser.BrowseResultEntry;
import org.openscada.da.server.opc.connection.OPCModel;
import org.openscada.da.server.opc.job.JobResult;
import org.openscada.da.server.opc.job.ThreadJob;
import org.openscada.opc.dcom.da.OPCBROWSEDIRECTION;
import org.openscada.opc.dcom.da.OPCBROWSETYPE;
import org.openscada.opc.dcom.da.impl.OPCBrowseServerAddressSpace;
import org.openscada.opc.lib.da.browser.Access;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrowseJob
extends ThreadJob
implements JobResult<BrowseResult> {
    private static final Logger logger = LoggerFactory.getLogger(BrowseJob.class);
    private final OPCModel model;
    private BrowseResult result;
    private final int batchSize = 100;
    private final BrowseRequest request;

    public BrowseJob(long timeout, OPCModel model, BrowseRequest request) {
        super(timeout);
        this.model = model;
        this.request = request;
    }

    @Override
    protected void perform() throws Exception {
        OPCBrowseServerAddressSpace browser;
        if (logger.isInfoEnabled()) {
            logger.info(String.format("Browsing folder: %s", StringHelper.join(this.request.getPath(), (String)"/")));
        }
        if ((browser = this.model.getServer().getBrowser()) == null) {
            logger.warn("Unable to fetch browser");
            return;
        }
        BrowseResult result = new BrowseResult();
        int accessMask = Access.READ.getCode() | Access.WRITE.getCode();
        browser.changePosition(null, OPCBROWSEDIRECTION.OPC_BROWSE_TO);
        for (String path : this.request.getPath()) {
            browser.changePosition(path, OPCBROWSEDIRECTION.OPC_BROWSE_DOWN);
        }
        result.setBranches(browser.browse(OPCBROWSETYPE.OPC_BRANCH, "", accessMask, 0).asCollection(100));
        Collection readLeaves = browser.browse(OPCBROWSETYPE.OPC_LEAF, "", Access.READ.getCode(), 0).asCollection(100);
        Collection writeLeaves = browser.browse(OPCBROWSETYPE.OPC_LEAF, "", Access.WRITE.getCode(), 0).asCollection(100);
        this.processLeaves(result, browser, readLeaves, writeLeaves);
        this.result = result;
        logger.info("Completed (Leaves: {}, Branches: {})", (Object)result.getLeaves().size(), (Object)result.getBranches().size());
    }

    private void processLeaves(BrowseResult result, OPCBrowseServerAddressSpace browser, Collection<String> readLeaves, Collection<String> writeLeaves) throws JIException {
        String itemId;
        BrowseResultEntry entry;
        HashMap<String, BrowseResultEntry> leavesResult = new HashMap<String, BrowseResultEntry>();
        for (String leaf : readLeaves) {
            entry = new BrowseResultEntry();
            entry.setEntryName(leaf);
            itemId = browser.getItemID(leaf);
            entry.setItemId(itemId);
            entry.setIoDirections(EnumSet.of(IODirection.INPUT));
            leavesResult.put(leaf, entry);
        }
        for (String leaf : writeLeaves) {
            entry = (BrowseResultEntry)leavesResult.get(leaf);
            if (entry != null) {
                entry.getIoDirections().add(IODirection.OUTPUT);
                continue;
            }
            entry = new BrowseResultEntry();
            entry.setEntryName(leaf);
            itemId = browser.getItemID(leaf);
            entry.setItemId(itemId);
            entry.setIoDirections(EnumSet.of(IODirection.OUTPUT));
            leavesResult.put(leaf, entry);
        }
        result.setLeaves(leavesResult.values());
    }

    @Override
    public BrowseResult getResult() {
        return this.result;
    }
}

