/*
 * Decompiled with CFR 0.152.
 */
package org.openscada.da.server.opc.job.impl;

import org.openscada.da.server.opc.connection.OPCModel;
import org.openscada.da.server.opc.job.JobResult;
import org.openscada.da.server.opc.job.ThreadJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorMessageJob
extends ThreadJob
implements JobResult<String> {
    public static final long DEFAULT_TIMEOUT = 1000L;
    private static final Logger logger = LoggerFactory.getLogger(ErrorMessageJob.class);
    private final OPCModel model;
    private String result;
    private final int errorCode;

    public ErrorMessageJob(long timeout, OPCModel model, int errorCode) {
        super(timeout);
        this.model = model;
        this.errorCode = errorCode;
    }

    @Override
    protected void perform() throws Exception {
        logger.debug("Request error message: {}", (Object)this.errorCode);
        this.result = this.model.getCommon().getErrorString(this.errorCode, 0);
    }

    @Override
    public String getResult() {
        return this.result;
    }
}

