/*
 * Decompiled with CFR 0.152.
 */
package org.openscada.da.server.opc.job.impl;

import org.openscada.da.server.opc.connection.OPCModel;
import org.openscada.da.server.opc.job.JobResult;
import org.openscada.da.server.opc.job.ThreadJob;
import org.openscada.opc.dcom.da.OPCSERVERSTATUS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerStatusJob
extends ThreadJob
implements JobResult<OPCSERVERSTATUS> {
    public static final long DEFAULT_TIMEOUT = 5000L;
    private static final Logger logger = LoggerFactory.getLogger(ServerStatusJob.class);
    private final OPCModel model;
    private OPCSERVERSTATUS status;

    public ServerStatusJob(long timeout, OPCModel model) {
        super(timeout);
        this.model = model;
    }

    @Override
    protected void perform() throws Exception {
        logger.debug("Request server status");
        this.status = this.model.getServer().getStatus();
    }

    public OPCSERVERSTATUS getStatus() {
        return this.status;
    }

    @Override
    public OPCSERVERSTATUS getResult() {
        return this.getStatus();
    }
}

