/*
 * Decompiled with CFR 0.152.
 */
package org.openscada.da.server.opc.job.impl;

import org.openscada.da.server.opc.connection.OPCModel;
import org.openscada.da.server.opc.job.JobResult;
import org.openscada.da.server.opc.job.ThreadJob;
import org.openscada.opc.dcom.common.KeyedResultSet;
import org.openscada.opc.dcom.da.OPCDATASOURCE;
import org.openscada.opc.dcom.da.OPCITEMSTATE;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncReadJob
extends ThreadJob
implements JobResult<KeyedResultSet<Integer, OPCITEMSTATE>> {
    public static final long DEFAULT_TIMEOUT = 5000L;
    private static final Logger logger = LoggerFactory.getLogger(SyncReadJob.class);
    private final OPCModel model;
    private final Integer[] clientHandles;
    private final OPCDATASOURCE dataSource;
    private KeyedResultSet<Integer, OPCITEMSTATE> result;

    public SyncReadJob(long timeout, OPCModel model, OPCDATASOURCE dataSource, Integer[] clientHandles) {
        super(timeout);
        this.model = model;
        this.clientHandles = clientHandles;
        this.dataSource = dataSource;
    }

    @Override
    protected void perform() throws Exception {
        logger.debug("Sync read job");
        this.result = this.model.getSyncIo().read(this.dataSource, this.clientHandles);
    }

    @Override
    public KeyedResultSet<Integer, OPCITEMSTATE> getResult() {
        return this.result;
    }
}

