/*
 * Decompiled with CFR 0.152.
 */
package org.openscada.da.server.opc.job.impl;

import org.openscada.da.server.opc.connection.OPCModel;
import org.openscada.da.server.opc.job.JobResult;
import org.openscada.da.server.opc.job.ThreadJob;
import org.openscada.opc.dcom.common.ResultSet;
import org.openscada.opc.dcom.da.WriteRequest;
import org.openscada.opc.dcom.da.impl.OPCSyncIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncWriteJob
extends ThreadJob
implements JobResult<ResultSet<WriteRequest>> {
    public static final long DEFAULT_TIMEOUT = 5000L;
    private static final Logger logger = LoggerFactory.getLogger(SyncWriteJob.class);
    private final OPCModel model;
    private final WriteRequest[] writeRequests;
    private ResultSet<WriteRequest> result;

    public SyncWriteJob(long timeout, OPCModel model, WriteRequest[] writeRequests) {
        super(timeout);
        this.model = model;
        this.writeRequests = writeRequests;
    }

    @Override
    protected void perform() throws Exception {
        logger.debug("Perform sync write");
        OPCSyncIO syncIo = this.model.getSyncIo();
        if (syncIo != null) {
            this.result = syncIo.write(this.writeRequests);
        }
    }

    @Override
    public ResultSet<WriteRequest> getResult() {
        return this.result;
    }
}

