/*
 * Decompiled with CFR 0.152.
 */
package org.openscada.da.server.opc.job.impl;

import org.openscada.da.server.opc.job.JobResult;
import org.openscada.da.server.opc.job.ThreadJob;
import org.openscada.opc.dcom.common.ResultSet;
import org.openscada.opc.dcom.da.impl.OPCItemMgt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnrealizeItemsJob
extends ThreadJob
implements JobResult<ResultSet<Integer>> {
    public static final long DEFAULT_TIMEOUT = 5000L;
    private static final Logger logger = LoggerFactory.getLogger(UnrealizeItemsJob.class);
    private final OPCItemMgt itemMgt;
    private final Integer[] serverHandles;
    private ResultSet<Integer> result;

    public UnrealizeItemsJob(long timeout, OPCItemMgt itemMgt, Integer[] serverHandles) {
        super(timeout);
        this.itemMgt = itemMgt;
        this.serverHandles = serverHandles;
    }

    @Override
    protected void perform() throws Exception {
        logger.info("UnRealizing items: {}", new Object[]{this.serverHandles});
        this.result = this.itemMgt.remove(this.serverHandles);
    }

    @Override
    public ResultSet<Integer> getResult() {
        return this.result;
    }
}

