/*
 * Decompiled with CFR 0.152.
 */
package rpc.security.ntlm;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import jcifs.ntlmssp.NtlmFlags;
import jcifs.util.Hexdump;
import ndr.NdrBuffer;
import ndr.NetworkDataRepresentation;
import org.bouncycastle.crypto.StreamCipher;
import rpc.IntegrityException;
import rpc.Security;
import rpc.security.ntlm.NTLMKeyFactory;

public class Ntlm1
implements NtlmFlags,
Security {
    private static final int NTLM1_VERIFIER_LENGTH = 16;
    private final StreamCipher clientCipher;
    private final StreamCipher serverCipher;
    private final byte[] clientSigningKey;
    private final byte[] serverSigningKey;
    private final NTLMKeyFactory keyFactory;
    private boolean isServer = false;
    private final int protectionLevel;
    private int requestCounter = 0;
    private int responseCounter = 0;
    private static final Logger logger = Logger.getLogger("org.jinterop");

    public Ntlm1(int flags, byte[] sessionKey, boolean isServer) {
        this.protectionLevel = (flags & 0x20) != 0 ? 6 : 5;
        this.isServer = isServer;
        this.keyFactory = new NTLMKeyFactory();
        this.clientSigningKey = this.keyFactory.generateClientSigningKeyUsingNegotiatedSecondarySessionKey(sessionKey);
        byte[] clientSealingKey = this.keyFactory.generateClientSealingKeyUsingNegotiatedSecondarySessionKey(sessionKey);
        this.serverSigningKey = this.keyFactory.generateServerSigningKeyUsingNegotiatedSecondarySessionKey(sessionKey);
        byte[] serverSealingKey = this.keyFactory.generateServerSealingKeyUsingNegotiatedSecondarySessionKey(sessionKey);
        this.clientCipher = this.keyFactory.getRC4(clientSealingKey);
        this.serverCipher = this.keyFactory.getRC4(serverSealingKey);
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("Client Signing Key derieved from the session key: [" + Ntlm1.dumpString(this.clientSigningKey) + "]");
            logger.finest("Client Sealing Key derieved from the session key: [" + Ntlm1.dumpString(clientSealingKey) + "]");
            logger.finest("Server Signing Key derieved from the session key: [" + Ntlm1.dumpString(this.serverSigningKey) + "]");
            logger.finest("Server Sealing Key derieved from the session key: [" + Ntlm1.dumpString(serverSealingKey) + "]");
        }
    }

    private static String dumpString(byte[] data) {
        StringBuilder sb = new StringBuilder(data.length * 3);
        int i = 0;
        while (i < data.length) {
            if (i % 20 == 0 && i != 0) {
                sb.append("\n");
            }
            sb.append(String.format("%02x ", data[i]));
            ++i;
        }
        return sb.toString();
    }

    @Override
    public int getVerifierLength() {
        return 16;
    }

    @Override
    public int getAuthenticationService() {
        return 10;
    }

    @Override
    public int getProtectionLevel() {
        return this.protectionLevel;
    }

    @Override
    public void processIncoming(NetworkDataRepresentation ndr, int index, int length, int verifierIndex, boolean isFragmented) throws IOException {
        try {
            StreamCipher cipher;
            byte[] signingKey;
            NdrBuffer buffer = ndr.getBuffer();
            if (!this.isServer) {
                signingKey = this.serverSigningKey;
                cipher = this.serverCipher;
            } else {
                signingKey = this.clientSigningKey;
                cipher = this.clientCipher;
            }
            byte[] data = new byte[length];
            System.arraycopy(ndr.getBuffer().getBuffer(), index, data, 0, data.length);
            if (this.getProtectionLevel() == 6) {
                data = this.keyFactory.applyRC4(cipher, data);
                System.arraycopy(data, 0, ndr.getBuffer().buf, index, data.length);
            }
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("\n AFTER Decryption");
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                Hexdump.hexdump((PrintStream)new PrintStream(byteArrayOutputStream), (byte[])data, (int)0, (int)data.length);
                logger.finest("\n" + byteArrayOutputStream.toString());
                logger.finest("\nLength is: " + data.length);
            }
            byte[] verifier = this.keyFactory.signingPt1(this.responseCounter, signingKey, buffer.getBuffer(), verifierIndex);
            this.keyFactory.signingPt2(verifier, cipher);
            buffer.setIndex(verifierIndex);
            byte[] signing = new byte[16];
            ndr.readOctetArray(signing, 0, signing.length);
            if (!this.keyFactory.compareSignature(verifier, signing)) {
                throw new IntegrityException("Message out of sequence. Perhaps the user being used to run this application is different from the one under which the COM server is running !.");
            }
            ++this.responseCounter;
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, "", ex);
            throw ex;
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "", ex);
            throw new IntegrityException("General error: " + ex.getMessage());
        }
    }

    @Override
    public void processOutgoing(NetworkDataRepresentation ndr, int index, int length, int verifierIndex, boolean isFragmented) throws IOException {
        try {
            StreamCipher cipher;
            byte[] signingKey;
            NdrBuffer buffer = ndr.getBuffer();
            if (this.isServer) {
                signingKey = this.serverSigningKey;
                cipher = this.serverCipher;
            } else {
                signingKey = this.clientSigningKey;
                cipher = this.clientCipher;
            }
            byte[] verifier = this.keyFactory.signingPt1(this.requestCounter, signingKey, buffer.getBuffer(), verifierIndex);
            byte[] data = new byte[length];
            System.arraycopy(ndr.getBuffer().getBuffer(), index, data, 0, data.length);
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("\n BEFORE Encryption");
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                Hexdump.hexdump((PrintStream)new PrintStream(byteArrayOutputStream), (byte[])data, (int)0, (int)data.length);
                logger.finest("\n" + byteArrayOutputStream.toString());
                logger.finest("\n Length is: " + data.length);
            }
            if (this.getProtectionLevel() == 6) {
                byte[] data2 = this.keyFactory.applyRC4(cipher, data);
                System.arraycopy(data2, 0, ndr.getBuffer().buf, index, data2.length);
            }
            this.keyFactory.signingPt2(verifier, cipher);
            buffer.setIndex(verifierIndex);
            buffer.writeOctetArray(verifier, 0, verifier.length);
            ++this.requestCounter;
        }
        catch (Exception ex) {
            throw new IntegrityException("General error: " + ex.getMessage());
        }
    }
}

