/*
 * Decompiled with CFR 0.152.
 */
package org.openscada.opc.lib.da.browser;

import java.net.UnknownHostException;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedList;
import org.jinterop.dcom.common.JIException;
import org.openscada.opc.dcom.da.OPCBROWSEDIRECTION;
import org.openscada.opc.dcom.da.OPCBROWSETYPE;
import org.openscada.opc.dcom.da.impl.OPCBrowseServerAddressSpace;
import org.openscada.opc.lib.da.browser.Access;
import org.openscada.opc.lib.da.browser.BaseBrowser;
import org.openscada.opc.lib.da.browser.Branch;
import org.openscada.opc.lib.da.browser.Leaf;

public class TreeBrowser
extends BaseBrowser {
    private String _filterCriteria = "";
    private EnumSet<Access> _accessMask = EnumSet.noneOf(Access.class);
    private int _variantType = 0;

    public TreeBrowser(OPCBrowseServerAddressSpace browser) {
        super(browser);
    }

    public TreeBrowser(OPCBrowseServerAddressSpace browser, String filterCriteria, EnumSet<Access> accessMask, int variantType) {
        super(browser);
        this._filterCriteria = filterCriteria;
        this._accessMask = accessMask;
        this._variantType = variantType;
    }

    protected void moveToRoot() throws JIException {
        this._browser.changePosition(null, OPCBROWSEDIRECTION.OPC_BROWSE_TO);
    }

    protected void moveToBranch(Branch branch) throws JIException {
        Collection<String> branchStack = branch.getBranchStack();
        this.moveToRoot();
        for (String branchName : branchStack) {
            this._browser.changePosition(branchName, OPCBROWSEDIRECTION.OPC_BROWSE_DOWN);
        }
    }

    public Branch browseBranches() throws JIException, IllegalArgumentException, UnknownHostException {
        Branch branch = new Branch();
        this.fillBranches(branch);
        return branch;
    }

    public Branch browseLeaves() throws IllegalArgumentException, UnknownHostException, JIException {
        Branch branch = new Branch();
        this.fillLeaves(branch);
        return branch;
    }

    public void fillBranches(Branch branch) throws JIException, IllegalArgumentException, UnknownHostException {
        this.moveToBranch(branch);
        this.browse(branch, false, true, false);
    }

    public void fillLeaves(Branch branch) throws IllegalArgumentException, UnknownHostException, JIException {
        this.moveToBranch(branch);
        this.browse(branch, true, false, false);
    }

    public Branch browse() throws JIException, IllegalArgumentException, UnknownHostException {
        Branch branch = new Branch();
        this.fill(branch);
        return branch;
    }

    public void fill(Branch branch) throws IllegalArgumentException, UnknownHostException, JIException {
        this.moveToBranch(branch);
        this.browse(branch, true, true, true);
    }

    protected void browseLeaves(Branch branch) throws IllegalArgumentException, UnknownHostException, JIException {
        branch.setLeaves(new LinkedList<Leaf>());
        for (String item : this.browse(OPCBROWSETYPE.OPC_LEAF, this._filterCriteria, this._accessMask, this._variantType)) {
            Leaf leaf = new Leaf(branch, item, this._browser.getItemID(item));
            branch.getLeaves().add(leaf);
        }
    }

    protected void browseBranches(Branch branch, boolean leaves, boolean descend) throws IllegalArgumentException, UnknownHostException, JIException {
        branch.setBranches(new LinkedList<Branch>());
        for (String item : this.browse(OPCBROWSETYPE.OPC_BRANCH, this._filterCriteria, this._accessMask, this._variantType)) {
            Branch subBranch = new Branch(branch, item);
            if (descend) {
                this._browser.changePosition(item, OPCBROWSEDIRECTION.OPC_BROWSE_DOWN);
                this.browse(subBranch, leaves, true, true);
                this._browser.changePosition(null, OPCBROWSEDIRECTION.OPC_BROWSE_UP);
            }
            branch.getBranches().add(subBranch);
        }
    }

    protected void browse(Branch branch, boolean leaves, boolean branches, boolean descend) throws IllegalArgumentException, UnknownHostException, JIException {
        if (leaves) {
            this.browseLeaves(branch);
        }
        if (branches) {
            this.browseBranches(branch, leaves, descend);
        }
    }
}

