/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.modeling.builder3d;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.fingerprint.BitSetFingerprint;
import org.openscience.cdk.fingerprint.HybridizationFingerprinter;
import org.openscience.cdk.fingerprint.IBitFingerprint;
import org.openscience.cdk.graph.Cycles;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IRingSet;
import org.openscience.cdk.io.MDLV2000Writer;
import org.openscience.cdk.io.iterator.IteratingSDFReader;
import org.openscience.cdk.isomorphism.matchers.QueryAtomContainerCreator;
import org.openscience.cdk.ringsearch.RingPartitioner;
import org.openscience.cdk.silent.SilentChemObjectBuilder;
import org.openscience.cdk.smiles.SmilesGenerator;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;
import org.openscience.cdk.tools.manipulator.RingSetManipulator;

public class TemplateExtractor {
    static final String usage = "Usage: TemplateExtractor SDFinfile outfile anyAtom=true/false anyBondAnyAtom=true/false";
    private static final IChemObjectBuilder builder = SilentChemObjectBuilder.getInstance();

    public void cleanDataSet(String dataFile) {
        IAtomContainerSet som = (IAtomContainerSet)builder.newInstance(IAtomContainerSet.class, new Object[0]);
        System.out.println("Start clean dataset...");
        try (BufferedReader fin = new BufferedReader(new FileReader(dataFile));
             IteratingSDFReader imdl = new IteratingSDFReader((Reader)fin, builder);){
            System.out.print("Read File in..");
            System.out.println("READY");
            int c = 0;
            while (imdl.hasNext()) {
                if (++c % 1000 == 0) {
                    System.out.println("...");
                }
                IAtomContainer m = (IAtomContainer)builder.newInstance(IAtomContainer.class, new Object[0]);
                m = imdl.next();
                if (m.getAtomCount() <= 2 || m.getAtom(0).getPoint3d() == null) continue;
                som.addAtomContainer(m);
            }
            System.out.println(som.getAtomContainerCount() + " Templates are read in");
            this.writeChemModel(som, dataFile, "_CLEAN");
        }
        catch (Exception exc) {
            System.out.println("Could not read Molecules from file " + dataFile + " due to: " + exc.getMessage());
        }
    }

    public void ReadNCISdfFileAsTemplate(String dataFile) {
        IAtomContainerSet som = (IAtomContainerSet)builder.newInstance(IAtomContainerSet.class, new Object[0]);
        System.out.println("Start...");
        try (BufferedReader fin = new BufferedReader(new FileReader(dataFile));
             IteratingSDFReader imdl = new IteratingSDFReader((Reader)fin, builder);){
            System.out.print("Read File in..");
            System.out.println("READY");
            while (imdl.hasNext()) {
                som.addAtomContainer(imdl.next());
            }
        }
        catch (Exception exc) {
            System.out.println("Could not read Molecules from file " + dataFile + " due to: " + exc.getMessage());
        }
        System.out.println(som.getAtomContainerCount() + " Templates are read in");
    }

    public void PartitionRingsFromComplexRing(String dataFile) {
        IAtomContainerSet som = (IAtomContainerSet)builder.newInstance(IAtomContainerSet.class, new Object[0]);
        try (BufferedReader fin = new BufferedReader(new FileReader(dataFile));
             IteratingSDFReader imdl = new IteratingSDFReader((Reader)fin, builder);){
            while (imdl.hasNext()) {
                IAtomContainer m = imdl.next();
                System.out.println("Atoms:" + m.getAtomCount());
                IRingSet ringSetM = Cycles.sssr((IAtomContainer)m).toRingSet();
                for (int i = 0; i < ringSetM.getAtomContainerCount(); ++i) {
                    som.addAtomContainer((IAtomContainer)builder.newInstance(IAtomContainer.class, new Object[]{ringSetM.getAtomContainer(i)}));
                }
            }
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
        }
        System.out.println(som.getAtomContainerCount() + " Templates are read in");
        this.writeChemModel(som, dataFile, "_VERSUCH");
    }

    /*
     * Unable to fully structure code
     */
    public void extractUniqueRingSystemsFromFile(String dataFile) {
        block35: {
            System.out.println("****** EXTRACT UNIQUE RING SYSTEMS ******");
            System.out.println("From file:" + dataFile);
            hashRingSystems = new HashMap<String, String>();
            smilesGenerator = new SmilesGenerator();
            counterRings = 0;
            counterMolecules = 0;
            counterUniqueRings = 0;
            molfile = dataFile + "_UniqueRings";
            try {
                fout = new FileOutputStream(molfile);
                try {
                    mdlw = new MDLV2000Writer((OutputStream)fout);
                    try {
                        fin = new BufferedReader(new FileReader(dataFile));
                        try {
                            imdl = new IteratingSDFReader((Reader)fin, TemplateExtractor.builder);
                            block30: while (true) {
                                if (!imdl.hasNext()) break block35;
                                m = imdl.next();
                                ringSetM = Cycles.sssr((IAtomContainer)m).toRingSet();
                                if (++counterMolecules % 1000 == 0) {
                                    System.out.println("Molecules:" + counterMolecules);
                                }
                                if (ringSetM.getAtomContainerCount() <= 0) continue;
                                ringSystems = RingPartitioner.partitionRings((IRingSet)ringSetM);
                                var18_26 = ringSystems.iterator();
                                while (true) {
                                    if (var18_26.hasNext()) ** break;
                                    continue block30;
                                    ringSet = ringSystem = (IRingSet)var18_26.next();
                                    ac = (IAtomContainer)TemplateExtractor.builder.newInstance(IAtomContainer.class, new Object[0]);
                                    for (IAtomContainer container : RingSetManipulator.getAllAtomContainers((IRingSet)ringSet)) {
                                        ac.add(container);
                                    }
                                    ++counterRings;
                                    for (j = 0; j < ac.getAtomCount(); ++j) {
                                        ac.getAtom(j).setSymbol("C");
                                    }
                                    try {
                                        key = smilesGenerator.create((IAtomContainer)TemplateExtractor.builder.newInstance(IAtomContainer.class, new Object[]{ac}));
                                    }
                                    catch (CDKException e) {
                                        LoggingToolFactory.createLoggingTool(this.getClass()).error((Object)e);
                                        imdl.close();
                                        fin.close();
                                        mdlw.close();
                                        fout.close();
                                        return;
                                    }
                                    if (hashRingSystems.containsKey(key)) continue;
                                    ++counterUniqueRings;
                                    hashRingSystems.put(key, "1");
                                    try {
                                        mdlw.write((IChemObject)TemplateExtractor.builder.newInstance(IAtomContainer.class, new Object[]{ac}));
                                    }
                                    catch (IllegalArgumentException | CDKException var20_32) {}
                                }
                                break;
                            }
                            finally {
                                imdl.close();
                            }
                        }
                        finally {
                            try {
                                fin.close();
                            }
                            catch (Throwable var17_25) {
                                var16_16.addSuppressed(var17_25);
                            }
                        }
                    }
                    finally {
                        try {
                            mdlw.close();
                        }
                        catch (Throwable var16_17) {
                            var15_13.addSuppressed(var16_17);
                        }
                    }
                }
                finally {
                    try {
                        fout.close();
                    }
                    catch (Throwable var15_14) {
                        var14_11.addSuppressed(var15_14);
                    }
                }
            }
            catch (Exception exc) {
                System.out.println("Could not read/write Molecules from file " + dataFile + " due to: " + exc.getMessage());
            }
        }
        System.out.println("READY Molecules:" + counterMolecules + " RingSystems:" + counterRings + " UniqueRingsSystem:" + counterUniqueRings);
        System.out.println("HashtableKeys:" + hashRingSystems.size());
    }

    public void writeChemModel(IAtomContainerSet som, String file, String endFix) {
        System.out.println("WRITE Molecules:" + som.getAtomContainerCount());
        String molfile = file + endFix;
        try (FileOutputStream fout = new FileOutputStream(molfile);
             MDLV2000Writer mdlw = new MDLV2000Writer((OutputStream)fout);){
            mdlw.write((IChemObject)som);
        }
        catch (IOException | CDKException ex2) {
            System.out.println("IOError:cannot write file due to:" + ex2);
        }
    }

    public void makeCanonicalSmileFromRingSystems(String dataFileIn, String dataFileOut) {
        System.out.println("Start make SMILES...");
        ArrayList<String> data = new ArrayList<String>();
        SmilesGenerator smiles = new SmilesGenerator();
        System.out.println("Start...");
        try (BufferedReader fin = new BufferedReader(new FileReader(dataFileIn));
             IteratingSDFReader imdl = new IteratingSDFReader((Reader)fin, builder);){
            System.out.println("Read File in..");
            while (imdl.hasNext()) {
                IAtomContainer m = imdl.next();
                try {
                    data.add(smiles.create((IAtomContainer)builder.newInstance(IAtomContainer.class, new Object[]{m})));
                }
                catch (IllegalArgumentException | CDKException exc1) {
                    System.out.println("Could not create smile due to: " + exc1.getMessage());
                }
            }
        }
        catch (Exception exc) {
            System.out.println("Could not read Molecules from file " + dataFileIn + " due to: " + exc.getMessage());
            return;
        }
        System.out.print("...ready\nWrite data...");
        try (BufferedWriter fout = new BufferedWriter(new FileWriter(dataFileOut));){
            for (String datum : data) {
                try {
                    fout.write(datum);
                    fout.write(10);
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exc3) {
            System.out.println("Could not write smile in file " + dataFileOut + " due to: " + exc3.getMessage());
            return;
        }
        System.out.println("number of smiles:" + data.size());
        System.out.println("...ready");
    }

    public List<IBitFingerprint> makeFingerprintsFromSdf(boolean anyAtom, boolean anyAtomAnyBond, Map<String, Integer> timings, BufferedReader fin, int limit) throws Exception {
        HybridizationFingerprinter fingerPrinter = new HybridizationFingerprinter(1024, 7);
        fingerPrinter.setHashPseudoAtoms(true);
        IteratingSDFReader imdl = null;
        ArrayList<IBitFingerprint> data = new ArrayList<IBitFingerprint>();
        ILoggingTool logger = LoggingToolFactory.createLoggingTool(this.getClass());
        try {
            logger.info((Object)"Read data file in ...");
            imdl = new IteratingSDFReader((Reader)fin, builder);
            logger.info((Object)"ready");
        }
        catch (Exception exc) {
            System.out.println("Could not read Molecules from file due to: " + exc.getMessage());
        }
        int moleculeCounter = 0;
        int fingerprintCounter = 0;
        logger.info((Object)("Generated Fingerprints: " + fingerprintCounter + "    "));
        while (imdl.hasNext() && (moleculeCounter < limit || limit == -1)) {
            IAtomContainer m = imdl.next();
            ++moleculeCounter;
            Object query = anyAtom && !anyAtomAnyBond ? QueryAtomContainerCreator.createAnyAtomContainer((IAtomContainer)m, (boolean)false) : AtomContainerManipulator.anonymise((IAtomContainer)m);
            try {
                long time = -System.currentTimeMillis();
                data.add(fingerPrinter.getBitFingerprint(query));
                ++fingerprintCounter;
                String bin = Integer.toString((int)Math.floor((double)(time += System.currentTimeMillis()) / 10.0));
                if (timings.containsKey(bin)) {
                    timings.put(bin, timings.get(bin) + 1);
                } else {
                    timings.put(bin, 1);
                }
            }
            catch (Exception exc1) {
                logger.info((Object)("QueryFingerprintError: from molecule:" + moleculeCounter + " due to:" + exc1.getMessage()));
                BitSetFingerprint allOnesFingerprint = new BitSetFingerprint(fingerPrinter.getSize());
                for (int i = 0; i < fingerPrinter.getSize(); ++i) {
                    allOnesFingerprint.set(i, true);
                }
                data.add((IBitFingerprint)allOnesFingerprint);
                ++fingerprintCounter;
            }
            if (fingerprintCounter % 2 == 0) {
                logger.info((Object)"\b/");
            } else {
                logger.info((Object)"\b\\");
            }
            if (fingerprintCounter % 100 != 0) continue;
            logger.info((Object)("\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\bGenerated Fingerprints: " + fingerprintCounter + "   \n"));
        }
        try {
            imdl.close();
        }
        catch (Exception exc2) {
            LoggingToolFactory.createLoggingTool(TemplateExtractor.class).warn((Object)"Unexpected Exception:", new Object[]{exc2});
        }
        logger.info((Object)("...ready with:" + moleculeCounter + " molecules\nWrite data...of data vector:" + data.size() + " fingerprintCounter:" + fingerprintCounter));
        return data;
    }

    public void makeFingerprintFromRingSystems(String dataFileIn, String dataFileOut, boolean anyAtom, boolean anyAtomAnyBond) throws Exception {
        HashMap<String, Integer> timings = new HashMap<String, Integer>();
        System.out.println("Start make fingerprint from file:" + dataFileIn + " ...");
        BufferedReader fin = new BufferedReader(new FileReader(dataFileIn));
        List<IBitFingerprint> data = this.makeFingerprintsFromSdf(anyAtom, anyAtomAnyBond, timings, fin, -1);
        BufferedWriter fout = null;
        try {
            fout = new BufferedWriter(new FileWriter(dataFileOut));
        }
        catch (Exception exc3) {
            System.out.println("Could not write Fingerprint in file " + dataFileOut + " due to: " + exc3.getMessage());
            return;
        }
        for (IBitFingerprint datum : data) {
            try {
                fout.write(datum.toString());
                fout.write(10);
            }
            catch (Exception exception) {}
        }
        System.out.println("\nFingerprints:" + data.size() + " are written...ready");
        System.out.println("\nComputing time statistics:\n" + timings);
        try {
            fout.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public IAtomContainer removeLoopBonds(IAtomContainer molecule, int position) {
        for (int i = 0; i < molecule.getBondCount(); ++i) {
            IBond bond = molecule.getBond(i);
            if (!bond.getBegin().equals(bond.getEnd())) continue;
            System.out.println("Loop found! Molecule:" + position);
            molecule.removeBond(bond);
        }
        return molecule;
    }

    public IAtomContainer createAnyAtomAtomContainer(IAtomContainer atomContainer) throws Exception {
        IAtomContainer query = atomContainer.clone();
        for (int i = 0; i < query.getAtomCount(); ++i) {
            query.getAtom(i).setSymbol("C");
        }
        return query;
    }

    public IAtomContainer resetFlags(IAtomContainer ac) {
        int f;
        for (f = 0; f < ac.getAtomCount(); ++f) {
            ac.getAtom(f).setFlag(16, false);
        }
        for (f = 0; f < ac.getElectronContainerCount(); ++f) {
            ac.getElectronContainer(f).setFlag(16, false);
        }
        return ac;
    }

    public static void main(String[] args) {
        if (args.length < 4) {
            System.out.println(usage);
        }
        try {
            new TemplateExtractor().makeFingerprintFromRingSystems(args[0], args[1], Boolean.valueOf(args[2]), Boolean.valueOf(args[3]));
        }
        catch (Exception e) {
            LoggingToolFactory.createLoggingTool(TemplateExtractor.class).warn((Object)"Unexpected Exception:", new Object[]{e});
        }
    }
}

