/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

final class CharIter {
    private final String string;
    private int position = 0;

    CharIter(String str) {
        this.string = str;
    }

    static boolean isSpace(char c) {
        return c == ' ';
    }

    static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    int position() {
        return this.position;
    }

    char next() {
        return this.string.charAt(this.position++);
    }

    char peek() {
        return this.position < this.string.length() ? this.string.charAt(this.position) : (char)'\u0000';
    }

    boolean hasNext() {
        return this.position < this.string.length();
    }

    String rest() {
        return this.string.substring(this.position);
    }

    void skipWhiteSpace() {
        while (this.hasNext() && CharIter.isSpace(this.string.charAt(this.position))) {
            ++this.position;
        }
    }

    int nextUnsignedNumber() {
        if (!this.hasNext()) {
            return -1;
        }
        if (!CharIter.isDigit(this.peek())) {
            return -1;
        }
        int num = this.next() - 48;
        while (this.hasNext() && CharIter.isDigit(this.peek())) {
            num = 10 * num + (this.next() - 48);
        }
        return num;
    }

    boolean consume(String substring) {
        if (this.position + substring.length() > this.string.length()) {
            return false;
        }
        int mark = this.position;
        for (int i = 0; i < substring.length(); ++i) {
            if (substring.charAt(i) != this.string.charAt(this.position)) {
                this.position = mark;
                break;
            }
            ++this.position;
        }
        return this.position - mark == substring.length();
    }

    String substring(int beg, int end) {
        return this.string.substring(beg, end);
    }

    void seek(int position) {
        this.position = position;
    }

    boolean nextIf(char c) {
        if (this.peek() == c) {
            this.next();
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.string, 0, this.position);
        sb.append('|');
        sb.append(this.string.substring(this.position));
        return sb.toString();
    }
}

