/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IChemFile;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IChemSequence;
import org.openscience.cdk.interfaces.IMapping;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.interfaces.IReactionSet;
import org.openscience.cdk.io.DefaultChemObjectReader;
import org.openscience.cdk.io.IChemObjectReader;
import org.openscience.cdk.io.MDLV2000Reader;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.io.formats.MDLRXNFormat;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

public class MDLRXNV2000Reader
extends DefaultChemObjectReader {
    private static final ILoggingTool logger = LoggingToolFactory.createLoggingTool(MDLRXNV2000Reader.class);
    private static final String UNEXPECTED_END_OF_INPUT = "Unexpected end of input";
    BufferedReader input;

    public MDLRXNV2000Reader(Reader in) {
        this(in, IChemObjectReader.Mode.RELAXED);
    }

    public MDLRXNV2000Reader(Reader in, IChemObjectReader.Mode mode) {
        this.input = in instanceof BufferedReader ? (BufferedReader)in : new BufferedReader(in);
        this.mode = mode;
    }

    public MDLRXNV2000Reader(InputStream input) {
        this(input, IChemObjectReader.Mode.RELAXED);
    }

    public MDLRXNV2000Reader(InputStream input, IChemObjectReader.Mode mode) {
        this(new InputStreamReader(input), mode);
    }

    public MDLRXNV2000Reader() {
        this(new StringReader(""));
    }

    public IResourceFormat getFormat() {
        return MDLRXNFormat.getInstance();
    }

    public void setReader(Reader input) throws CDKException {
        this.input = input instanceof BufferedReader ? (BufferedReader)input : new BufferedReader(input);
    }

    public void setReader(InputStream input) throws CDKException {
        this.setReader(new InputStreamReader(input));
    }

    public boolean accepts(Class<? extends IChemObject> classObject) {
        Class<?>[] interfaces;
        if (IChemFile.class.equals(classObject)) {
            return true;
        }
        if (IChemModel.class.equals(classObject)) {
            return true;
        }
        if (IReaction.class.equals(classObject)) {
            return true;
        }
        for (Class<?> anInterface : interfaces = classObject.getInterfaces()) {
            if (IChemModel.class.equals(anInterface)) {
                return true;
            }
            if (IChemFile.class.equals(anInterface)) {
                return true;
            }
            if (!IReaction.class.equals(anInterface)) continue;
            return true;
        }
        Class<? extends IChemObject> superClass = classObject.getSuperclass();
        if (superClass != null) {
            return this.accepts(superClass);
        }
        return false;
    }

    public <T extends IChemObject> T read(T object) throws CDKException {
        if (object instanceof IReaction) {
            return (T)this.readReaction(object.getBuilder());
        }
        if (object instanceof IReactionSet) {
            IReactionSet reactionSet = (IReactionSet)object.getBuilder().newInstance(IReactionSet.class, new Object[0]);
            reactionSet.addReaction(this.readReaction(object.getBuilder()));
            return (T)reactionSet;
        }
        if (object instanceof IChemModel) {
            IChemModel model = (IChemModel)object.getBuilder().newInstance(IChemModel.class, new Object[0]);
            IReactionSet reactionSet = (IReactionSet)object.getBuilder().newInstance(IReactionSet.class, new Object[0]);
            reactionSet.addReaction(this.readReaction(object.getBuilder()));
            model.setReactionSet(reactionSet);
            return (T)model;
        }
        if (object instanceof IChemFile) {
            IChemFile chemFile = (IChemFile)object.getBuilder().newInstance(IChemFile.class, new Object[0]);
            IChemSequence sequence = (IChemSequence)object.getBuilder().newInstance(IChemSequence.class, new Object[0]);
            sequence.addChemModel(this.read((IChemModel)object.getBuilder().newInstance(IChemModel.class, new Object[0])));
            chemFile.addChemSequence(sequence);
            return (T)chemFile;
        }
        throw new CDKException("Only supported are Reaction and ChemModel, and not " + object.getClass().getName() + ".");
    }

    public boolean accepts(IChemObject object) {
        if (object instanceof IReaction) {
            return true;
        }
        if (object instanceof IChemModel) {
            return true;
        }
        if (object instanceof IChemFile) {
            return true;
        }
        return object instanceof IReactionSet;
    }

    private IReaction readReaction(IChemObjectBuilder builder) throws CDKException {
        int numProducts;
        int numReactants;
        IReaction reaction = builder.newReaction();
        try {
            String header = this.input.readLine();
            if (header == null) {
                return null;
            }
            if (!header.equals("$RXN")) {
                throw new CDKException("Expected $RXN but got " + header);
            }
            String blank = this.input.readLine();
            if (blank == null) {
                throw new CDKException(UNEXPECTED_END_OF_INPUT);
            }
            blank = this.input.readLine();
            if (blank == null) {
                throw new CDKException(UNEXPECTED_END_OF_INPUT);
            }
            blank = this.input.readLine();
            if (blank == null) {
                throw new CDKException(UNEXPECTED_END_OF_INPUT);
            }
        }
        catch (IOException exception) {
            logger.debug((Object)exception);
            throw new CDKException("Error while reading header of RXN file", (Throwable)exception);
        }
        try {
            String countsLine = this.input.readLine();
            StringTokenizer tokenizer = new StringTokenizer(countsLine);
            numReactants = Integer.parseInt(tokenizer.nextToken());
            logger.info((Object)("Expecting " + numReactants + " reactants in file"));
            numProducts = Integer.parseInt(tokenizer.nextToken());
            logger.info((Object)("Expecting " + numProducts + " products in file"));
            if (tokenizer.hasMoreTokens()) {
                int agentCount = Integer.parseInt(tokenizer.nextToken());
                if (this.mode == IChemObjectReader.Mode.STRICT && agentCount > 0) {
                    throw new CDKException("RXN files uses agent count extension. This is not supported in mode " + this.mode);
                }
                logger.info((Object)("Expecting " + agentCount + " agents in file"));
            }
        }
        catch (IOException | NumberFormatException exception) {
            logger.debug((Object)exception);
            throw new CDKException("Error on counts line of RXN file", (Throwable)exception);
        }
        try {
            String line = this.input.readLine();
            if (line == null || !line.startsWith("$MOL")) {
                throw new CDKException("Expected $MOL to start, was" + line);
            }
            ArrayList<IAtomContainer> components = new ArrayList<IAtomContainer>();
            StringBuilder sb = new StringBuilder();
            while ((line = this.input.readLine()) != null) {
                if (line.startsWith("$MOL")) {
                    components.add(this.processMol(builder.newAtomContainer(), sb));
                    sb.setLength(0);
                    continue;
                }
                sb.append(line).append('\n');
            }
            if (sb.length() > 0) {
                components.add(this.processMol(builder.newAtomContainer(), sb));
            }
            if (this.mode == IChemObjectReader.Mode.STRICT && components.size() > numReactants + numProducts) {
                throw new CDKException(String.format("Agents are not supported in mode %s. Found %d molecular entities, but there are only %d molecular entities declared on the counts line.", this.mode, components.size(), numReactants + numProducts));
            }
            for (IAtomContainer component : components.subList(0, numReactants)) {
                reaction.addReactant(component);
            }
            for (IAtomContainer component : components.subList(numReactants, numReactants + numProducts)) {
                reaction.addProduct(component);
            }
            for (IAtomContainer component : components.subList(numReactants + numProducts, components.size())) {
                reaction.addAgent(component);
            }
        }
        catch (IOException | IllegalArgumentException exception) {
            logger.debug((Object)exception);
            throw new CDKException("Error while reading reactant", (Throwable)exception);
        }
        logger.info((Object)"Reading atom-atom mapping from file");
        IAtomContainer reactingSide = (IAtomContainer)builder.newInstance(IAtomContainer.class, new Object[0]);
        Iterator molecules = reaction.getReactants().atomContainers().iterator();
        while (molecules.hasNext()) {
            reactingSide.add((IAtomContainer)molecules.next());
        }
        IAtomContainer producedSide = (IAtomContainer)builder.newInstance(IAtomContainer.class, new Object[0]);
        molecules = reaction.getProducts().atomContainers().iterator();
        while (molecules.hasNext()) {
            producedSide.add((IAtomContainer)molecules.next());
        }
        int mappingCount = 0;
        block12: for (int i = 0; i < reactingSide.getAtomCount(); ++i) {
            for (int j = 0; j < producedSide.getAtomCount(); ++j) {
                IAtom eductAtom = reactingSide.getAtom(i);
                IAtom productAtom = producedSide.getAtom(j);
                if (eductAtom.getProperty((Object)"cdk:AtomAtomMapping") == null || !eductAtom.getProperty((Object)"cdk:AtomAtomMapping").equals(productAtom.getProperty((Object)"cdk:AtomAtomMapping"))) continue;
                reaction.addMapping((IMapping)builder.newInstance(IMapping.class, new Object[]{eductAtom, productAtom}));
                ++mappingCount;
                continue block12;
            }
        }
        logger.info((Object)("Mapped atom pairs: " + mappingCount));
        return reaction;
    }

    private IAtomContainer processMol(IAtomContainer mol, StringBuilder sb) throws CDKException, IOException {
        MDLV2000Reader reader = new MDLV2000Reader(new StringReader(sb.toString()), this.mode);
        IAtomContainer molecule = reader.read(mol);
        reader.close();
        return molecule;
    }

    public void close() throws IOException {
        this.input.close();
    }
}

