/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import org.openscience.cdk.config.Elements;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IPseudoAtom;
import org.openscience.cdk.interfaces.ISingleElectron;
import org.openscience.cdk.interfaces.IStereoElement;
import org.openscience.cdk.io.DefaultChemObjectReader;
import org.openscience.cdk.io.IChemObjectReader;
import org.openscience.cdk.io.MDLV2000Reader;
import org.openscience.cdk.io.MDLV2000Writer;
import org.openscience.cdk.io.MDLValence;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.io.formats.MDLV3000Format;
import org.openscience.cdk.io.setting.BooleanIOSetting;
import org.openscience.cdk.io.setting.IOSetting;
import org.openscience.cdk.isomorphism.matchers.Expr;
import org.openscience.cdk.isomorphism.matchers.IQueryAtomContainer;
import org.openscience.cdk.isomorphism.matchers.IQueryBond;
import org.openscience.cdk.isomorphism.matchers.QueryAtomContainer;
import org.openscience.cdk.isomorphism.matchers.QueryBond;
import org.openscience.cdk.sgroup.Sgroup;
import org.openscience.cdk.sgroup.SgroupType;
import org.openscience.cdk.stereo.StereoElementFactory;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.BondManipulator;

public class MDLV3000Reader
extends DefaultChemObjectReader {
    private static final ILoggingTool logger = LoggingToolFactory.createLoggingTool(MDLV3000Reader.class);
    private static final Pattern keyValueTuple = Pattern.compile("\\s*(\\w+)=([^\\s]*)(.*)");
    private static final Pattern keyValueTuple2 = Pattern.compile("\\s*(\\w+)=\\(([^\\)]*)\\)(.*)");
    public static final String M_END = "M  END";
    private BooleanIOSetting optForce3d;
    private BooleanIOSetting optHydIso;
    private BooleanIOSetting optStereoPerc;
    private BooleanIOSetting optStereo0d;
    private BufferedReader input;
    private int lineNumber;

    public MDLV3000Reader(Reader in) {
        this(in, IChemObjectReader.Mode.RELAXED);
    }

    public MDLV3000Reader(Reader in, IChemObjectReader.Mode mode) {
        this.input = new BufferedReader(in);
        this.initIOSettings();
        this.mode = mode;
        this.lineNumber = 0;
    }

    public MDLV3000Reader(InputStream input) {
        this(input, IChemObjectReader.Mode.RELAXED);
    }

    public MDLV3000Reader(InputStream input, IChemObjectReader.Mode mode) {
        this(new InputStreamReader(input), mode);
    }

    public MDLV3000Reader() {
        this(new StringReader(""));
    }

    public IResourceFormat getFormat() {
        return MDLV3000Format.getInstance();
    }

    public void setReader(Reader input) throws CDKException {
        this.input = input instanceof BufferedReader ? (BufferedReader)input : new BufferedReader(input);
        this.lineNumber = 0;
    }

    public void setReader(InputStream input) throws CDKException {
        this.setReader(new InputStreamReader(input));
    }

    public boolean accepts(Class<? extends IChemObject> classObject) {
        Class<?>[] interfaces;
        for (Class<?> anInterface : interfaces = classObject.getInterfaces()) {
            if (!IAtomContainer.class.equals(anInterface)) continue;
            return true;
        }
        if (IAtomContainer.class.equals(classObject)) {
            return true;
        }
        Class<? extends IChemObject> superClass = classObject.getSuperclass();
        if (superClass != null) {
            return this.accepts(superClass);
        }
        return false;
    }

    public <T extends IChemObject> T read(T object) throws CDKException {
        if (object instanceof IAtomContainer) {
            return (T)this.readMolecule(object.getBuilder());
        }
        throw new CDKException("Only supports AtomContainer objects.");
    }

    public IAtomContainer readMolecule(IChemObjectBuilder builder) throws CDKException {
        return this.readConnectionTable(builder);
    }

    public IAtomContainer readConnectionTable(IChemObjectBuilder builder) throws CDKException {
        IAtomContainer readData;
        logger.info((Object)"Reading CTAB block");
        ReadState state = new ReadState();
        state.mol = readData = builder.newAtomContainer();
        boolean foundEND = false;
        String lastLine = this.readHeader(state);
        while (this.isReady() && !foundEND) {
            String command = this.readCommand(lastLine);
            logger.debug((Object)("command found: " + command));
            if ("END CTAB".equals(command)) {
                foundEND = true;
            } else if (!"BEGIN CTAB".equals(command)) {
                if (command.startsWith("COUNTS ")) {
                    String[] counts = command.split(" ");
                    state.chiral = counts.length >= 6 && counts[5].equals("1");
                } else if ("BEGIN ATOM".equals(command)) {
                    this.readAtomBlock(state);
                } else if ("BEGIN BOND".equals(command)) {
                    this.readBondBlock(state);
                } else if ("BEGIN SGROUP".equals(command)) {
                    this.readSGroup(state);
                } else if ("BEGIN COLLECTION".equals(command)) {
                    this.readCollection(state);
                } else {
                    logger.warn((Object)("Unrecognized command: " + command));
                }
            }
            lastLine = this.readLine();
        }
        if (lastLine != null && lastLine.startsWith(M_END)) {
            try {
                MDLV2000Reader.readNonStructuralData(this.input, state.mol);
            }
            catch (IOException ex) {
                throw new CDKException("IO Error", (Throwable)ex);
            }
        }
        readData = this.finalizeMol(state);
        return readData;
    }

    private IAtomContainer finalizeMol(ReadState state) {
        this.finalizeDimensions(state);
        IAtomContainer readAtomContainer = state.mol;
        if (state.isQuery) {
            QueryAtomContainer queryAtomContainer = new QueryAtomContainer(readAtomContainer, readAtomContainer.getBuilder());
            readAtomContainer.stereoElements().forEach(arg_0 -> ((IQueryAtomContainer)queryAtomContainer).addStereoElement(arg_0));
            queryAtomContainer.setTitle(readAtomContainer.getTitle());
            queryAtomContainer.setProperties(readAtomContainer.getProperties());
            readAtomContainer = queryAtomContainer;
        }
        boolean isQueryOrAromaticBond = state.isQuery;
        for (IAtom atom : readAtomContainer.atoms()) {
            int valence = 0;
            for (IBond bond : readAtomContainer.getConnectedBondsList(atom)) {
                if (bond instanceof IQueryBond || bond.getOrder() == IBond.Order.UNSET) {
                    valence = -1;
                    break;
                }
                valence += bond.getOrder().numeric().intValue();
            }
            if (valence < 0) {
                isQueryOrAromaticBond = true;
                logger.warn((Object)"Cannot set valence for atom with query bonds (this includes aromatic bonds)");
                continue;
            }
            int unpaired = readAtomContainer.getConnectedSingleElectronsCount(atom);
            this.applyMDLValenceModel(atom, valence + unpaired, unpaired);
        }
        if (!isQueryOrAromaticBond) {
            this.finalizeStereochemistry(state, readAtomContainer);
        }
        return readAtomContainer;
    }

    private void finalizeStereochemistry(ReadState state, IAtomContainer readData) {
        block11: {
            block12: {
                if (!this.optStereoPerc.isSet()) break block11;
                if (state.dimensions == 3) {
                    readData.setStereoElements(StereoElementFactory.using3DCoordinates((IAtomContainer)readData).createAll());
                } else if (state.dimensions == 2) {
                    readData.setStereoElements(StereoElementFactory.using2DCoordinates((IAtomContainer)readData).createAll());
                } else if (state.dimensions == 0 && this.optStereo0d.isSet()) {
                    for (Map.Entry entry : state.stereo0d.entrySet()) {
                        Iterator<Integer> stereoElement = MDLV2000Reader.createStereo0d(state.mol, (IAtom)entry.getKey(), (Integer)entry.getValue());
                        if (stereoElement == null) continue;
                        state.mol.addStereoElement(stereoElement);
                    }
                }
                if (state.stereoflags == null || state.stereoflags.isEmpty()) break block12;
                int defaultRacGrp = 0;
                if (!state.chiral) {
                    int n;
                    boolean bl = false;
                    for (Integer val : state.stereoflags.values()) {
                        int num;
                        if ((val & 0x30000) != 65536 || (num = val >>> 18) <= n) continue;
                        n = num;
                    }
                    defaultRacGrp = 0x10000 | n + true << 18;
                }
                for (IStereoElement se : readData.stereoElements()) {
                    IAtom focus;
                    if (se.getConfigClass() != 16896 || (focus = (IAtom)se.getFocus()).getID() == null) continue;
                    int idx = Integer.parseInt(focus.getID());
                    Integer grpinfo = state.stereoflags.get(idx);
                    if (grpinfo != null) {
                        se.setGroupInfo(grpinfo.intValue());
                        continue;
                    }
                    if (state.chiral) continue;
                    se.setGroupInfo(defaultRacGrp);
                }
                break block11;
            }
            if (state.chiral) break block11;
            for (IStereoElement iStereoElement : readData.stereoElements()) {
                if (iStereoElement.getConfigClass() != 16896) continue;
                iStereoElement.setGroupInfo(327680);
            }
        }
    }

    private void finalizeDimensions(ReadState state) {
        block7: {
            Point3d p3d;
            int dimensions;
            block6: {
                if (state.dimensions == 3 || this.optForce3d.isSet()) {
                    return;
                }
                dimensions = 0;
                for (IAtom atom : state.mol.atoms()) {
                    p3d = atom.getPoint3d();
                    if (p3d.z != 0.0) {
                        dimensions = 3;
                        break;
                    }
                    if (dimensions != 0 || p3d.x == 0.0 || p3d.y == 0.0) continue;
                    dimensions = 2;
                }
                if (dimensions == 0) {
                    dimensions = state.dimensions;
                }
                state.dimensions = dimensions;
                if (dimensions != 0) break block6;
                for (IAtom atom : state.mol.atoms()) {
                    atom.setPoint3d(null);
                }
                break block7;
            }
            if (dimensions != 2) break block7;
            for (IAtom atom : state.mol.atoms()) {
                p3d = atom.getPoint3d();
                atom.setPoint2d(new Point2d(p3d.x, p3d.y));
                atom.setPoint3d(null);
            }
        }
    }

    private boolean isDigit(char ch) {
        return ch >= '0' && ch <= '9';
    }

    private void parseStereoGroup(Map<Integer, Integer> flags, String str, int type) throws CDKException {
        char ch;
        int i;
        int len = str.length();
        int num = 0;
        for (i = "MDLV30/STE???".length(); i < len && this.isDigit(ch = str.charAt(i)); ++i) {
            num = 10 * num + (ch - 48);
        }
        type |= num << 18;
        while (i < len && str.charAt(i) == ' ') {
            ++i;
        }
        if (str.startsWith("ATOMS=(", i)) {
            i += "ATOMS=(".length();
        } else {
            this.handleError("Error while parsing stereo group: Expected an atom collection.");
            return;
        }
        while (i < len && this.isDigit(str.charAt(i))) {
            ++i;
        }
        while (i < len && str.charAt(i) == ' ') {
            ++i;
        }
        while (i < len) {
            int val = 0;
            while (i < len && this.isDigit(ch = str.charAt(i))) {
                val = 10 * val + (ch - 48);
                ++i;
            }
            if (val > 0) {
                flags.put(val, type);
            }
            while (i < len && str.charAt(i) == ' ') {
                ++i;
            }
            if (i >= len || str.charAt(i) != ')') continue;
            break;
        }
    }

    private void readCollection(ReadState state) throws CDKException {
        String command;
        String line;
        if (state.stereoflags == null) {
            state.stereoflags = new HashMap<Integer, Integer>();
        }
        while ((line = this.readLine()) != null && !(command = this.readCommand(line)).startsWith("END COLLECTION")) {
            if (command.startsWith("MDLV30/STERAC")) {
                this.parseStereoGroup(state.stereoflags, command, 65536);
                continue;
            }
            if (command.startsWith("MDLV30/STEREL")) {
                this.parseStereoGroup(state.stereoflags, command, 131072);
                continue;
            }
            if (!command.startsWith("MDLV30/STEABS")) continue;
            this.parseStereoGroup(state.stereoflags, command, 0);
        }
    }

    private static int parseDimensions(String info) {
        if (info.startsWith("2D", 20)) {
            return 2;
        }
        if (info.startsWith("3D", 20)) {
            return 3;
        }
        return 0;
    }

    private String readHeader(ReadState state) throws CDKException {
        String line4;
        String line1 = this.readLine();
        if (line1 == null) {
            throw new CDKException("Expected a header line, but found nothing.");
        }
        if (!line1.isEmpty()) {
            if (line1.startsWith("M  V30")) {
                return line1;
            }
            state.mol.setTitle(line1);
        }
        String infoLine = this.readLine();
        state.dimensions = MDLV3000Reader.parseDimensions(infoLine);
        String line3 = this.readLine();
        if (!line3.isEmpty()) {
            state.mol.setProperty((Object)"cdk:Comment", (Object)line3);
        }
        if (!(line4 = this.readLine()).contains("3000")) {
            throw new CDKException("This file is not a MDL V3000 molfile.");
        }
        return this.readLine();
    }

    private void readAtomBlock(ReadState state) throws CDKException {
        IAtomContainer readData = state.mol;
        logger.info((Object)"Reading ATOM block");
        int RGroupCounter = 1;
        boolean foundEND = false;
        while (this.isReady() && !foundEND) {
            String id;
            String command = this.readCommand(this.readLine());
            if ("END ATOM".equals(command)) {
                foundEND = true;
                continue;
            }
            logger.debug((Object)("Parsing atom from: " + command));
            IAtom atom = readData.getBuilder().newAtom();
            StringTokenizer tokenizer = new StringTokenizer(command);
            try {
                id = tokenizer.nextToken();
            }
            catch (Exception exception) {
                String errorMessage = "Error while parsing atom index";
                logger.error((Object)errorMessage);
                logger.debug((Object)exception);
                throw new CDKException(errorMessage, (Throwable)exception);
            }
            String elementString = tokenizer.nextToken();
            Elements element = Elements.ofString((String)elementString);
            if (element != Elements.Unknown) {
                atom.setAtomicNumber(Integer.valueOf(element.number()));
            } else if ("D".equals(elementString) && this.optHydIso.isSet()) {
                atom.setMassNumber(Integer.valueOf(2));
                atom.setAtomicNumber(Integer.valueOf(1));
            } else if ("T".equals(elementString) && this.optHydIso.isSet()) {
                atom.setMassNumber(Integer.valueOf(3));
                atom.setAtomicNumber(Integer.valueOf(1));
            } else if ("A".equals(elementString)) {
                atom = (IAtom)readData.getBuilder().newInstance(IPseudoAtom.class, new Object[]{elementString});
            } else if ("Q".equals(elementString)) {
                atom = (IAtom)readData.getBuilder().newInstance(IPseudoAtom.class, new Object[]{elementString});
            } else if ("*".equals(elementString)) {
                atom = (IAtom)readData.getBuilder().newInstance(IPseudoAtom.class, new Object[]{elementString});
            } else if ("LP".equals(elementString)) {
                atom = (IAtom)readData.getBuilder().newInstance(IPseudoAtom.class, new Object[]{elementString});
            } else if ("L".equals(elementString)) {
                atom = (IAtom)readData.getBuilder().newInstance(IPseudoAtom.class, new Object[]{elementString});
            } else if (!elementString.isEmpty() && elementString.charAt(0) == 'R') {
                logger.debug((Object)"Atom ", new Object[]{elementString, " is not an regular element. Creating a PseudoAtom."});
                String[] rGroup = elementString.split("^R");
                if (rGroup.length > 1) {
                    int Rnumber;
                    try {
                        RGroupCounter = Rnumber = Integer.parseInt(rGroup[rGroup.length - 1]);
                    }
                    catch (Exception ex) {
                        Rnumber = RGroupCounter++;
                    }
                    elementString = "R" + Rnumber;
                }
                atom = (IAtom)readData.getBuilder().newInstance(IPseudoAtom.class, new Object[]{elementString});
            } else {
                if (this.mode == IChemObjectReader.Mode.STRICT) {
                    throw new CDKException("Invalid element type. Must be an existing element, or one in: A, Q, L, LP, *.");
                }
                atom = (IAtom)readData.getBuilder().newInstance(IPseudoAtom.class, new Object[]{elementString});
                atom.setSymbol(elementString);
            }
            try {
                double x = Double.parseDouble(tokenizer.nextToken());
                double y = Double.parseDouble(tokenizer.nextToken());
                double z = Double.parseDouble(tokenizer.nextToken());
                atom.setPoint3d(new Point3d(x, y, z));
            }
            catch (Exception exception) {
                String errorMessage = "Error while parsing atom coordinates";
                logger.error((Object)errorMessage);
                logger.debug((Object)exception);
                throw new CDKException(errorMessage, (Throwable)exception);
            }
            String mapping = tokenizer.nextToken();
            if (!mapping.equals("0")) {
                atom.setMapIdx(Integer.parseInt(mapping));
            }
            if (command.indexOf(61) != -1) {
                Map<String, String> options = this.parseOptions(this.exhaustStringTokenizer(tokenizer));
                block25: for (String key : options.keySet()) {
                    String value = options.get(key);
                    try {
                        switch (key) {
                            case "CFG": {
                                int cfg = Integer.parseInt(value);
                                if (cfg == 0) continue block25;
                                atom.setStereoParity(Integer.valueOf(cfg));
                                state.stereo0d.put(atom, cfg);
                                break;
                            }
                            case "CHG": {
                                int charge = Integer.parseInt(value);
                                if (charge == 0) continue block25;
                                atom.setFormalCharge(Integer.valueOf(charge));
                                break;
                            }
                            case "RAD": {
                                MDLV2000Writer.SPIN_MULTIPLICITY spinMultiplicity = MDLV2000Writer.SPIN_MULTIPLICITY.ofValue(Integer.parseInt(value));
                                int numElectons = spinMultiplicity.getSingleElectrons();
                                atom.setProperty((Object)"cdk:SpinMultiplicity", (Object)spinMultiplicity);
                                while (numElectons-- > 0) {
                                    readData.addSingleElectron((ISingleElectron)readData.getBuilder().newInstance(ISingleElectron.class, new Object[]{atom}));
                                }
                                continue block25;
                            }
                            case "MASS": {
                                atom.setMassNumber(Integer.valueOf(Integer.parseInt(value)));
                                break;
                            }
                            case "VAL": {
                                if (!(atom instanceof IPseudoAtom)) {
                                    try {
                                        int valence = Integer.parseInt(value);
                                        if (valence == 0) continue block25;
                                        if (valence == 15) {
                                            atom.setValency(Integer.valueOf(0));
                                            break;
                                        }
                                        atom.setValency(Integer.valueOf(valence));
                                    }
                                    catch (Exception exception) {
                                        this.handleError("Could not parse valence information field", this.lineNumber, 0, 0, exception);
                                    }
                                    break;
                                }
                                logger.error((Object)"Cannot set valence information for a non-element!");
                                break;
                            }
                            default: {
                                logger.warn((Object)("Not parsing key: " + key));
                            }
                        }
                    }
                    catch (Exception exception) {
                        String errorMessage = "Error while parsing key/value " + key + "=" + value + ": " + exception.getMessage();
                        logger.error((Object)errorMessage);
                        logger.debug((Object)exception);
                        throw new CDKException(errorMessage, (Throwable)exception);
                    }
                }
            }
            atom.setID(id);
            readData.addAtom(atom);
            state.addAtom(Integer.parseInt(id), readData.getAtom(readData.getAtomCount() - 1));
            logger.debug((Object)("Added atom: " + atom));
        }
    }

    private void readBondBlock(ReadState state) throws CDKException {
        IAtomContainer readData = state.mol;
        logger.info((Object)"Reading BOND block");
        boolean foundEND = false;
        while (this.isReady() && !foundEND) {
            Object queryBond;
            String errorMessage;
            String line = this.readLine();
            String command = this.readCommand(line);
            if ("END BOND".equals(command)) {
                foundEND = true;
                continue;
            }
            logger.debug((Object)("Parsing bond from: " + command));
            StringTokenizer tokenizer = new StringTokenizer(command);
            Object bond = readData.getBuilder().newBond();
            try {
                String indexString = tokenizer.nextToken();
                bond.setID(indexString);
            }
            catch (Exception exception) {
                errorMessage = "Error while parsing bond index: " + exception.getMessage() + ", line='" + line + "'";
                logger.error((Object)errorMessage);
                logger.debug((Object)exception);
                throw new CDKException(errorMessage, (Throwable)exception);
            }
            try {
                String bondTypeString = tokenizer.nextToken();
                int bondType = Integer.parseInt(bondTypeString);
                Expr.Type queryBondExpressionType = null;
                switch (bondType) {
                    case 1: 
                    case 2: 
                    case 3: {
                        bond.setOrder(BondManipulator.createBondOrder((double)bondType));
                        break;
                    }
                    case 4: {
                        bond.setOrder(IBond.Order.UNSET);
                        bond.setFlag(32, true);
                        bond.setFlag(4096, true);
                        break;
                    }
                    case 5: {
                        queryBondExpressionType = Expr.Type.SINGLE_OR_DOUBLE;
                        break;
                    }
                    case 6: {
                        queryBondExpressionType = Expr.Type.SINGLE_OR_AROMATIC;
                        break;
                    }
                    case 7: {
                        queryBondExpressionType = Expr.Type.DOUBLE_OR_AROMATIC;
                        break;
                    }
                    case 8: {
                        queryBondExpressionType = Expr.Type.TRUE;
                        break;
                    }
                    case 9: 
                    case 10: {
                        throw new CDKException("Unsupported bond type: " + bondType);
                    }
                    default: {
                        throw new CDKException("Invalid bond type: " + bondType);
                    }
                }
                if (queryBondExpressionType != null) {
                    queryBond = new QueryBond(queryBondExpressionType, readData.getBuilder());
                    queryBond.setID(bond.getID());
                    bond = queryBond;
                }
            }
            catch (Exception exception) {
                errorMessage = "Error while parsing bond type: " + exception.getMessage() + ", line='" + line + "'";
                logger.error((Object)errorMessage);
                logger.debug((Object)exception);
                throw new CDKException(errorMessage, (Throwable)exception);
            }
            try {
                String indexAtom1String = tokenizer.nextToken();
                int indexAtom1 = Integer.parseInt(indexAtom1String);
                IAtom atom1 = state.getAtom(indexAtom1);
                bond.setAtom(atom1, 0);
            }
            catch (Exception exception) {
                String errorMessage2 = "Error while parsing index atom 1 in bond" + exception.getMessage() + ", line='" + line + "'";
                logger.error((Object)errorMessage2);
                logger.debug((Object)exception);
                throw new CDKException(errorMessage2, (Throwable)exception);
            }
            try {
                String indexAtom2String = tokenizer.nextToken();
                int indexAtom2 = Integer.parseInt(indexAtom2String);
                IAtom atom2 = state.getAtom(indexAtom2);
                bond.setAtom(atom2, 1);
            }
            catch (Exception exception) {
                String errorMessage3 = "Error while parsing index atom 2 in bond" + exception.getMessage() + ", line='" + line + "'";
                logger.error((Object)errorMessage3);
                logger.debug((Object)exception);
                throw new CDKException(errorMessage3, (Throwable)exception);
            }
            ArrayList<IAtom> endpts = new ArrayList<IAtom>();
            String attach = null;
            if (command.indexOf(61) != -1) {
                Map<String, String> options = this.parseOptions(this.exhaustStringTokenizer(tokenizer));
                block37: for (String key : options.keySet()) {
                    String value = options.get(key);
                    try {
                        block20 : switch (key) {
                            case "CFG": {
                                int configuration = Integer.parseInt(value);
                                if (configuration == 0) {
                                    bond.setStereo(IBond.Stereo.NONE);
                                    break;
                                }
                                if (configuration == 1) {
                                    bond.setStereo(IBond.Stereo.UP);
                                    break;
                                }
                                if (configuration == 2) {
                                    bond.setStereo(IBond.Stereo.UP_OR_DOWN);
                                    break;
                                }
                                if (configuration != 3) continue block37;
                                bond.setStereo(IBond.Stereo.DOWN);
                                break;
                            }
                            case "ENDPTS": {
                                String[] endptStr = value.split(" ");
                                for (int i = 1; i < endptStr.length; ++i) {
                                    endpts.add(readData.getAtom(Integer.parseInt(endptStr[i]) - 1));
                                }
                                continue block37;
                            }
                            case "ATTACH": {
                                attach = value;
                                break;
                            }
                            case "TOPO": {
                                if (bond instanceof IQueryBond) {
                                    int topology = Integer.parseInt(value);
                                    Expr bondTypeExpression = ((QueryBond)bond).getExpression();
                                    switch (topology) {
                                        case 0: {
                                            break block20;
                                        }
                                        case 1: {
                                            Expr expressionBondTypeAndInRing = bondTypeExpression.and(new Expr(Expr.Type.IS_IN_RING));
                                            ((QueryBond)bond).setExpression(expressionBondTypeAndInRing);
                                            break block20;
                                        }
                                        case 2: {
                                            Expr expressionBondTypeAndInChain = bondTypeExpression.and(new Expr(Expr.Type.IS_IN_CHAIN));
                                            ((QueryBond)bond).setExpression(expressionBondTypeAndInChain);
                                            break block20;
                                        }
                                    }
                                    this.handleError("Invalid value " + topology + " for key " + key, this.lineNumber, 0, 0);
                                    break;
                                }
                                this.handleError("Key " + key + " is only defined for query bonds", this.lineNumber, 0, 0);
                                break;
                            }
                            default: {
                                logger.warn((Object)("Not parsing key: " + key));
                            }
                        }
                    }
                    catch (Exception exception) {
                        String errorMessage4 = "Error while parsing key/value " + key + "=" + value + ": " + exception.getMessage() + ", line='" + line + "'";
                        logger.error((Object)errorMessage4);
                        logger.debug((Object)exception);
                        throw new CDKException(errorMessage4, (Throwable)exception);
                    }
                }
            }
            boolean bl = state.isQuery = state.isQuery || bond instanceof IQueryBond;
            if (state.isQuery && bond.getClass() != QueryBond.class) {
                Expr expr = bond.isAromatic() ? new Expr(Expr.Type.IS_AROMATIC) : new Expr(Expr.Type.ORDER, bond.getOrder().numeric().intValue());
                queryBond = new QueryBond(bond.getBegin(), bond.getEnd(), expr);
                queryBond.setID(bond.getID());
                bond = queryBond;
            }
            readData.addBond((IBond)bond);
            state.addBond(Integer.parseInt(bond.getID()), readData.getBond(readData.getBondCount() - 1));
            if ("ANY".equals(attach)) {
                Sgroup sgroup = new Sgroup();
                sgroup.setType(SgroupType.ExtMulticenter);
                sgroup.addAtom(bond.getBegin());
                sgroup.addBond((IBond)bond);
                for (IAtom endpt : endpts) {
                    sgroup.addAtom(endpt);
                }
                ArrayList<Sgroup> sgroups = (ArrayList<Sgroup>)readData.getProperty((Object)"cdk:CtabSgroups");
                if (sgroups == null) {
                    sgroups = new ArrayList<Sgroup>(4);
                    readData.setProperty((Object)"cdk:CtabSgroups", sgroups);
                }
                if (MDLV2000Reader.fixCrossingBonds(sgroup)) {
                    this.handleError("Fixed incorrect SBL list on SGroup " + sgroup.getSubscript());
                }
                sgroups.add(sgroup);
            }
            if (bond.isAromatic()) {
                bond.getBegin().setFlag(32, true);
                bond.getEnd().setFlag(32, true);
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("Added " + (bond.getClass().getSimpleName().toLowerCase(Locale.ROOT).contains("query") ? "query" : "") + " bond: " + bond));
        }
    }

    private void readSGroup(ReadState state) throws CDKException {
        IAtomContainer readData = state.mol;
        boolean foundEND = false;
        while (this.isReady() && !foundEND) {
            String command = this.readCommand(this.readLine());
            if ("END SGROUP".equals(command)) {
                foundEND = true;
                continue;
            }
            logger.debug((Object)("Parsing Sgroup line: " + command));
            StringTokenizer tokenizer = new StringTokenizer(command);
            String indexString = tokenizer.nextToken();
            logger.warn((Object)("Skipping external index: " + indexString));
            String type = tokenizer.nextToken();
            String externalIndexString = tokenizer.nextToken();
            logger.warn((Object)("Skipping external index: " + externalIndexString));
            Map<Object, Object> options = new HashMap();
            if (command.indexOf(61) != -1) {
                options = this.parseOptions(this.exhaustStringTokenizer(tokenizer));
            }
            Sgroup sgroup = new Sgroup();
            if (type.startsWith("SUP")) {
                sgroup.setType(SgroupType.CtabAbbreviation);
                Iterator<Object> keys = options.keySet().iterator();
                String label = "";
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    String value = (String)options.get(key);
                    try {
                        switch (key) {
                            case "ATOMS": {
                                StringTokenizer atomsTokenizer = new StringTokenizer(value);
                                int nExpected = Integer.parseInt(atomsTokenizer.nextToken());
                                while (atomsTokenizer.hasMoreTokens()) {
                                    sgroup.addAtom(state.getAtom(Integer.parseInt(atomsTokenizer.nextToken())));
                                }
                                break;
                            }
                            case "XBONDS": {
                                StringTokenizer xbonds = new StringTokenizer(value);
                                int nExpected = Integer.parseInt(xbonds.nextToken());
                                while (xbonds.hasMoreTokens()) {
                                    sgroup.addBond(state.getBond(Integer.parseInt(xbonds.nextToken())));
                                }
                                break;
                            }
                            case "LABEL": {
                                label = value;
                                break;
                            }
                            default: {
                                logger.warn((Object)("Not parsing key: " + key));
                                break;
                            }
                        }
                    }
                    catch (Exception exception) {
                        String error = "Error while parsing key/value " + key + "=" + value + ": " + exception.getMessage();
                        logger.error((Object)error);
                        logger.debug((Object)exception);
                        throw new CDKException(error, (Throwable)exception);
                    }
                    if (sgroup.getAtoms().isEmpty() || label.isEmpty()) continue;
                    sgroup.setSubscript(label);
                }
                ArrayList<Sgroup> sgroups = (ArrayList<Sgroup>)readData.getProperty((Object)"cdk:CtabSgroups");
                if (sgroups == null) {
                    sgroups = new ArrayList<Sgroup>();
                }
                sgroups.add(sgroup);
                readData.setProperty((Object)"cdk:CtabSgroups", sgroups);
                continue;
            }
            logger.warn((Object)("Skipping unrecognized SGROUP type: " + type));
        }
    }

    private String readCommand(String line) throws CDKException {
        if (line.startsWith("M  V30 ")) {
            String command = line.substring(7);
            if (command.endsWith("-")) {
                command = command.substring(0, command.length() - 1);
                command = command + this.readCommand(this.readLine());
            }
            return command;
        }
        throw new CDKException("Could not read MDL file: unexpected line: " + line);
    }

    private Map<String, String> parseOptions(String string) {
        HashMap<String, String> keyValueTuples = new HashMap<String, String>();
        while (string.length() >= 3) {
            logger.debug((Object)("Matching remaining option string: " + string));
            Matcher tuple1Matcher = keyValueTuple2.matcher(string);
            if (tuple1Matcher.matches()) {
                String key = tuple1Matcher.group(1);
                String value = tuple1Matcher.group(2);
                string = tuple1Matcher.group(3);
                logger.debug((Object)("Found key: " + key));
                logger.debug((Object)("Found value: " + value));
                keyValueTuples.put(key, value);
                continue;
            }
            Matcher tuple2Matcher = keyValueTuple.matcher(string);
            if (tuple2Matcher.matches()) {
                String key = tuple2Matcher.group(1);
                String value = tuple2Matcher.group(2);
                string = tuple2Matcher.group(3);
                logger.debug((Object)("Found key: " + key));
                logger.debug((Object)("Found value: " + value));
                keyValueTuples.put(key, value);
                continue;
            }
            logger.warn((Object)("Quiting; could not parse: " + string + "."));
            string = "";
        }
        return keyValueTuples;
    }

    private String exhaustStringTokenizer(StringTokenizer tokenizer) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(' ');
        while (tokenizer.hasMoreTokens()) {
            stringBuilder.append(tokenizer.nextToken());
            stringBuilder.append(' ');
        }
        return stringBuilder.toString();
    }

    private String readLine() throws CDKException {
        try {
            String line = this.input.readLine();
            ++this.lineNumber;
            logger.debug((Object)("read line " + this.lineNumber + ":"), new Object[]{line});
            return line;
        }
        catch (Exception exception) {
            String error = "Unexpected error while reading file: " + exception.getMessage();
            logger.error((Object)error);
            logger.debug((Object)exception);
            throw new CDKException(error, (Throwable)exception);
        }
    }

    public boolean isReady() throws CDKException {
        try {
            return this.input.ready();
        }
        catch (Exception exception) {
            String error = "Unexpected error while reading file: " + exception.getMessage();
            logger.error((Object)error);
            logger.debug((Object)exception);
            throw new CDKException(error, (Throwable)exception);
        }
    }

    public void close() throws IOException {
        this.input.close();
    }

    private void initIOSettings() {
        this.optForce3d = (BooleanIOSetting)this.addSetting((IOSetting)new BooleanIOSetting("ForceReadAs3DCoordinates", IOSetting.Importance.LOW, "Should coordinates always be read as 3D?", "false"));
        this.optHydIso = (BooleanIOSetting)this.addSetting((IOSetting)new BooleanIOSetting("InterpretHydrogenIsotopes", IOSetting.Importance.LOW, "Should D and T be interpreted as hydrogen isotopes?", "true"));
        this.optStereoPerc = (BooleanIOSetting)this.addSetting((IOSetting)new BooleanIOSetting("AddStereoElements", IOSetting.Importance.LOW, "Detect and create IStereoElements for the input.", "true"));
        this.optStereo0d = (BooleanIOSetting)this.addSetting((IOSetting)new BooleanIOSetting("AddStereo0d", IOSetting.Importance.LOW, "Allow stereo created from parity value when no coordinates", "true"));
    }

    private void applyMDLValenceModel(IAtom atom, int explicitValence, int unpaired) {
        if (atom.getValency() != null) {
            if (atom.getValency() >= explicitValence) {
                atom.setImplicitHydrogenCount(Integer.valueOf(atom.getValency() - (explicitValence - unpaired)));
            } else {
                atom.setImplicitHydrogenCount(Integer.valueOf(0));
            }
        } else {
            int implicitValence;
            Integer charge;
            Integer element = atom.getAtomicNumber();
            if (element == null) {
                element = 0;
            }
            if ((charge = atom.getFormalCharge()) == null) {
                charge = 0;
            }
            if ((implicitValence = MDLValence.implicitValence(element, charge, explicitValence)) < explicitValence) {
                atom.setValency(Integer.valueOf(explicitValence));
                atom.setImplicitHydrogenCount(Integer.valueOf(0));
            } else {
                atom.setValency(Integer.valueOf(implicitValence));
                atom.setImplicitHydrogenCount(Integer.valueOf(implicitValence - explicitValence));
            }
        }
    }

    private static final class ReadState {
        IAtomContainer mol;
        int dimensions = 0;
        boolean chiral = false;
        boolean isQuery = false;
        Map<Integer, Integer> stereoflags = null;
        final Map<IAtom, Integer> stereo0d = new HashMap<IAtom, Integer>();
        IAtom[] atomById = new IAtom[64];
        IBond[] bondById = new IBond[64];

        private ReadState() {
        }

        <T> T[] grow(T[] arr, int req) {
            int cap = arr.length;
            return Arrays.copyOf(arr, Math.max(cap + cap >> 1, req + 1));
        }

        void addAtom(int id, IAtom atom) {
            if (id >= this.atomById.length) {
                this.atomById = this.grow(this.atomById, id);
            }
            this.atomById[id] = atom;
        }

        void addBond(int id, IBond bond) {
            if (id >= this.bondById.length) {
                this.bondById = this.grow(this.bondById, id);
            }
            this.bondById[id] = bond;
        }

        public IAtom getAtom(int i) {
            return this.atomById[i];
        }

        public IBond getBond(int i) {
            return this.bondById[i];
        }
    }
}

