/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import org.openscience.cdk.BondRef;
import org.openscience.cdk.config.Elements;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IPseudoAtom;
import org.openscience.cdk.interfaces.IStereoElement;
import org.openscience.cdk.interfaces.ITetrahedralChirality;
import org.openscience.cdk.io.DefaultChemObjectWriter;
import org.openscience.cdk.io.MDLV2000Writer;
import org.openscience.cdk.io.MDLV3000Reader;
import org.openscience.cdk.io.MDLValence;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.io.formats.MDLV3000Format;
import org.openscience.cdk.io.setting.BooleanIOSetting;
import org.openscience.cdk.io.setting.IOSetting;
import org.openscience.cdk.io.setting.StringIOSetting;
import org.openscience.cdk.isomorphism.matchers.Expr;
import org.openscience.cdk.isomorphism.matchers.IQueryBond;
import org.openscience.cdk.isomorphism.matchers.QueryBond;
import org.openscience.cdk.sgroup.Sgroup;
import org.openscience.cdk.sgroup.SgroupBracket;
import org.openscience.cdk.sgroup.SgroupKey;
import org.openscience.cdk.sgroup.SgroupType;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

public final class MDLV3000Writer
extends DefaultChemObjectWriter {
    private static final ILoggingTool logger = LoggingToolFactory.createLoggingTool(MDLV3000Reader.class);
    private static final Pattern R_GRP_NUM = Pattern.compile("R(\\d+)");
    private static final int ATOM_PART_OF_QUERY_BOND_EXPLICIT_VALENCE = -38271;
    private V30LineWriter writer;
    private StringIOSetting programNameOpt;
    private BooleanIOSetting writeDataOpt;
    private BooleanIOSetting truncateDataOpt;
    private Set<String> acceptedSdTags;

    public MDLV3000Writer(Writer writer) {
        this();
        this.writer = new V30LineWriter(writer);
    }

    public MDLV3000Writer(OutputStream out) throws CDKException {
        this();
        this.setWriter(out);
    }

    public MDLV3000Writer() {
        this.initIOSettings();
    }

    void setAcceptedSdTags(Set<String> acceptedSdTags) {
        this.acceptedSdTags = acceptedSdTags;
    }

    private static int nullAsZero(Integer x) {
        return x == null ? 0 : x;
    }

    private static <T> Integer findIdx(Map<T, Integer> idxs, T obj) {
        Integer idx = idxs.get(obj);
        if (idx == null) {
            return -1;
        }
        return idx;
    }

    private String getProgName() {
        String progname = this.programNameOpt.getSetting();
        if (progname == null) {
            return "        ";
        }
        if (progname.length() > 8) {
            return progname.substring(0, 8);
        }
        if (progname.length() < 8) {
            return String.format("%-8s", progname);
        }
        return progname;
    }

    private void writeHeader(IAtomContainer mol) throws IOException {
        String title = mol.getTitle();
        if (title != null) {
            this.writer.writeDirect(title.substring(0, Math.min(80, title.length())));
        }
        this.writer.writeDirect('\n');
        this.writer.writeDirect("  ");
        this.writer.writeDirect(this.getProgName());
        this.writer.writeDirect(new SimpleDateFormat("MMddyyHHmm").format(System.currentTimeMillis()));
        int dim = this.getNumberOfDimensions(mol);
        if (dim != 0) {
            this.writer.writeDirect(Integer.toString(dim));
            this.writer.writeDirect('D');
        }
        this.writer.writeDirect('\n');
        String comment = (String)mol.getProperty((Object)"cdk:Remark");
        if (comment != null) {
            this.writer.writeDirect(comment.substring(0, Math.min(80, comment.length())));
        }
        this.writer.writeDirect('\n');
        this.writer.writeDirect("  0  0  0     0  0            999 V3000\n");
    }

    private static ITetrahedralChirality.Stereo getLocalParity(Map<IChemObject, Integer> idxs, ITetrahedralChirality stereo) {
        IAtom[] neighbours = stereo.getLigands();
        int[] neighbourIdx = new int[neighbours.length];
        if (neighbours.length != 4) {
            throw new AssertionError((Object)("The number of neighbours must be 4 but is " + neighbours.length + "."));
        }
        for (int i = 0; i < 4; ++i) {
            neighbourIdx[i] = stereo.getChiralAtom().equals(neighbours[i]) ? Integer.MAX_VALUE : idxs.get(neighbours[i]);
        }
        boolean inverted = false;
        for (int i = 0; i < 4; ++i) {
            for (int j = i + 1; j < 4; ++j) {
                if (neighbourIdx[i] <= neighbourIdx[j]) continue;
                inverted = !inverted;
            }
        }
        return inverted ? stereo.getStereo() : stereo.getStereo().invert();
    }

    private void writeAtomBlock(IAtomContainer mol, IAtom[] atoms, Map<IChemObject, Integer> idxs, Map<IAtom, ITetrahedralChirality> atomToStereo) throws IOException, CDKException {
        if (mol.getAtomCount() == 0) {
            return;
        }
        int dim = this.getNumberOfDimensions(mol);
        this.writer.write("BEGIN ATOM\n");
        int atomIdx = 0;
        for (IAtom atom : atoms) {
            ITetrahedralChirality stereo;
            Matcher matcher;
            int elem = MDLV3000Writer.nullAsZero(atom.getAtomicNumber());
            int chg = MDLV3000Writer.nullAsZero(atom.getFormalCharge());
            int mass = MDLV3000Writer.nullAsZero(atom.getMassNumber());
            int hcnt = MDLV3000Writer.nullAsZero(atom.getImplicitHydrogenCount());
            int elec = mol.getConnectedSingleElectronsCount(atom);
            int rad = 0;
            switch (elec) {
                case 1: {
                    rad = MDLV2000Writer.SPIN_MULTIPLICITY.Monovalent.getValue();
                    break;
                }
                case 2: {
                    MDLV2000Writer.SPIN_MULTIPLICITY spinMultiplicity = (MDLV2000Writer.SPIN_MULTIPLICITY)((Object)atom.getProperty((Object)"cdk:SpinMultiplicity"));
                    rad = spinMultiplicity != null ? spinMultiplicity.getValue() : MDLV2000Writer.SPIN_MULTIPLICITY.DivalentSinglet.getValue();
                }
            }
            int expVal = 0;
            for (IBond bond : mol.getConnectedBondsList(atom)) {
                if (bond instanceof IQueryBond) {
                    expVal = -38271;
                    break;
                }
                if (bond.getOrder() == null) {
                    throw new CDKException("Unsupported bond order: " + bond.getOrder());
                }
                expVal += bond.getOrder().numeric().intValue();
            }
            String symbol = this.getSymbol(atom, elem);
            int rnum = -1;
            if (symbol.charAt(0) == 'R' && (matcher = R_GRP_NUM.matcher(symbol)).matches()) {
                symbol = "R#";
                rnum = Integer.parseInt(matcher.group(1));
            }
            this.writer.write(++atomIdx).write(' ').write(symbol).write(' ');
            Point2d p2d = atom.getPoint2d();
            Point3d p3d = atom.getPoint3d();
            switch (dim) {
                case 0: {
                    this.writer.write("0 0 0 ");
                    break;
                }
                case 2: {
                    if (p2d != null) {
                        this.writer.write(p2d.x).writeDirect(' ').write(p2d.y).writeDirect(' ').write("0 ");
                        break;
                    }
                    this.writer.write("0 0 0 ");
                    break;
                }
                case 3: {
                    if (p3d != null) {
                        this.writer.write(p3d.x).writeDirect(' ').write(p3d.y).writeDirect(' ').write(p3d.z).writeDirect(' ');
                        break;
                    }
                    this.writer.write("0 0 0 ");
                }
            }
            this.writer.write(MDLV3000Writer.nullAsZero((Integer)atom.getProperty((Object)"cdk:AtomAtomMapping", Integer.class)));
            if (chg != 0 && chg >= -15 && chg <= 15) {
                this.writer.write(" CHG=").write(chg);
            }
            if (mass != 0) {
                this.writer.write(" MASS=").write(mass);
            }
            if (rad > 0 && rad < 4) {
                this.writer.write(" RAD=").write(rad);
            }
            if (rnum >= 0) {
                this.writer.write(" RGROUPS=(1 ").write(rnum).write(")");
            }
            if (expVal != -38271 && MDLValence.implicitValence(elem, chg, expVal) - expVal != hcnt) {
                int val = expVal + hcnt;
                if (val <= 0 || val > 14) {
                    val = -1;
                }
                this.writer.write(" VAL=").write(val);
            }
            if ((stereo = atomToStereo.get(atom)) != null) {
                switch (MDLV3000Writer.getLocalParity(idxs, stereo)) {
                    case CLOCKWISE: {
                        this.writer.write(" CFG=1");
                        break;
                    }
                    case ANTI_CLOCKWISE: {
                        this.writer.write(" CFG=2");
                        break;
                    }
                }
            }
            this.writer.write('\n');
        }
        this.writer.write("END ATOM\n");
    }

    private String getSymbol(IAtom atom, int elem) {
        if (atom instanceof IPseudoAtom) {
            return ((IPseudoAtom)atom).getLabel();
        }
        String symbol = Elements.ofNumber((int)elem).symbol();
        if (symbol.isEmpty()) {
            symbol = atom.getSymbol();
        }
        if (symbol == null) {
            symbol = "*";
        }
        if (symbol.length() > 3) {
            symbol = symbol.substring(0, 3);
        }
        return symbol;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeBondBlock(IAtomContainer mol, Map<IChemObject, Integer> idxs) throws IOException, CDKException {
        if (mol.getBondCount() == 0) {
            return;
        }
        List sgroups = (List)mol.getProperty((Object)"cdk:CtabSgroups");
        HashMap<IBond, Sgroup> multicenterSgroups = new HashMap<IBond, Sgroup>();
        if (sgroups != null) {
            for (Sgroup sgroup : sgroups) {
                if (sgroup.getType() != SgroupType.ExtMulticenter) continue;
                for (IBond bond : sgroup.getBonds()) {
                    multicenterSgroups.put(bond, sgroup);
                }
            }
        }
        this.writer.write("BEGIN BOND\n");
        int bondIdx = 0;
        for (IBond bond : mol.bonds()) {
            Sgroup sgroup;
            IAtom beg = bond.getBegin();
            IAtom end = bond.getEnd();
            if (beg == null || end == null) {
                throw new IllegalStateException("Bond " + bondIdx + " had one or more atoms.");
            }
            int begIdx = MDLV3000Writer.findIdx(idxs, beg);
            int endIdx = MDLV3000Writer.findIdx(idxs, end);
            if (begIdx < 0 || endIdx < 0) {
                throw new IllegalStateException("Bond " + bondIdx + " has atoms not present in the molecule.");
            }
            IBond.Stereo stereo = bond.getStereo();
            if (stereo == IBond.Stereo.UP_INVERTED || stereo == IBond.Stereo.DOWN_INVERTED || stereo == IBond.Stereo.UP_OR_DOWN_INVERTED) {
                int tmp = begIdx;
                begIdx = endIdx;
                endIdx = tmp;
            }
            int order = bond.getOrder() == null ? 0 : bond.getOrder().numeric();
            int bondType = -1;
            MDLQueryProperty queryProperty = MDLQueryProperty.getDefaultValue();
            if (order == 0) {
                if (bond.getOrder() == IBond.Order.UNSET) {
                    if (!bond.getFlag(32)) throw new CDKException("Bond with bond order " + bond.getOrder() + " that isn't flagged as aromatic cannot be written to V3000");
                    bondType = 4;
                } else if (bond instanceof IQueryBond) {
                    IQueryBond dereferencedBond = (IQueryBond)BondRef.deref((IBond)bond);
                    if (!(dereferencedBond instanceof QueryBond)) {
                        throw new CDKException("Query bond of type " + dereferencedBond.getClass() + " cannot be written to V3000");
                    }
                    Expr expression = ((QueryBond)dereferencedBond).getExpression();
                    ExpressionConverter converter = new ExpressionConverter(expression);
                    bondType = converter.toMDLBondType().getValue();
                    queryProperty = converter.toMDLQueryProperty();
                }
            } else {
                if (order <= 0 || order > 3) throw new CDKException("Bond order " + bond.getOrder() + " cannot be written to V3000");
                bondType = order;
            }
            this.writer.write(++bondIdx).write(' ').write(bondType).write(' ').write(begIdx).write(' ').write(endIdx);
            switch (stereo) {
                case UP: 
                case UP_INVERTED: {
                    this.writer.write(" CFG=1");
                    break;
                }
                case UP_OR_DOWN: 
                case UP_OR_DOWN_INVERTED: {
                    this.writer.write(" CFG=2");
                    break;
                }
                case DOWN: 
                case DOWN_INVERTED: {
                    this.writer.write(" CFG=3");
                    break;
                }
                case NONE: {
                    break;
                }
            }
            if (queryProperty != MDLQueryProperty.getDefaultValue()) {
                this.writer.write(" TOPO=").write(queryProperty.getValue());
            }
            if ((sgroup = (Sgroup)multicenterSgroups.get(bond)) != null) {
                ArrayList atoms = new ArrayList(sgroup.getAtoms());
                atoms.remove(bond.getBegin());
                atoms.remove(bond.getEnd());
                this.writer.write(" ATTACH=ANY ENDPTS=(").write(atoms, idxs).write(')');
            }
            this.writer.write('\n');
        }
        this.writer.write("END BOND\n");
    }

    private IAtom[] pushHydrogensToBack(IAtomContainer mol, Map<IChemObject, Integer> atomToIdx) {
        if (!atomToIdx.isEmpty()) {
            throw new AssertionError((Object)"Map atomToIdx must be empty.");
        }
        IAtom[] atoms = new IAtom[mol.getAtomCount()];
        int numberOfHydrogenAtoms = (int)StreamSupport.stream(mol.atoms().spliterator(), true).filter(atom -> atom.getAtomicNumber() == 1).count();
        int nonHydrogenIndex = 0;
        int hydrogenIndex = mol.getAtomCount() - numberOfHydrogenAtoms;
        for (IAtom atom2 : mol.atoms()) {
            if (atom2.getAtomicNumber() == 1) {
                atoms[hydrogenIndex++] = atom2;
                continue;
            }
            atoms[nonHydrogenIndex++] = atom2;
        }
        IntStream.range(0, atoms.length).forEachOrdered(index -> atomToIdx.put((IChemObject)atoms[index], index + 1));
        return atoms;
    }

    private List<Sgroup> getSgroups(IAtomContainer mol) {
        ArrayList sgroups = (ArrayList)mol.getProperty((Object)"cdk:CtabSgroups");
        if (sgroups == null) {
            sgroups = new ArrayList(0);
        }
        return sgroups;
    }

    private int getNumberOfDimensions(IAtomContainer mol) {
        for (IAtom atom : mol.atoms()) {
            if (atom.getPoint3d() != null) {
                return 3;
            }
            if (atom.getPoint2d() == null) continue;
            return 2;
        }
        return 0;
    }

    private void writeSgroupBlock(List<Sgroup> sgroups, Map<IChemObject, Integer> idxs) throws IOException, CDKException {
        ArrayList<Sgroup> copyOfSgroups = new ArrayList<Sgroup>(sgroups);
        copyOfSgroups.removeIf(sgroup -> !sgroup.getType().isCtabStandard());
        if (copyOfSgroups.isEmpty()) {
            return;
        }
        this.writer.write("BEGIN SGROUP\n");
        copyOfSgroups.sort((o1, o2) -> {
            int cmp = -Boolean.compare(o1.getParents().isEmpty(), o2.getParents().isEmpty());
            if (cmp != 0 || o1.getParents().isEmpty()) {
                return cmp;
            }
            if (o1.getParents().contains(o2)) {
                return 1;
            }
            if (o2.getParents().contains(o1)) {
                return -1;
            }
            return 0;
        });
        int sgroupIdx = 0;
        for (Sgroup sgroup2 : copyOfSgroups) {
            SgroupType type = sgroup2.getType();
            this.writer.write(++sgroupIdx).write(' ').write(type.getKey()).write(" 0");
            if (!sgroup2.getAtoms().isEmpty()) {
                this.writer.write(" ATOMS=(").write(sgroup2.getAtoms(), idxs).write(")");
            }
            if (!sgroup2.getBonds().isEmpty()) {
                if (type == SgroupType.CtabData) {
                    this.writer.write(" CBONDS=(");
                } else {
                    this.writer.write(" XBONDS=(");
                }
                this.writer.write(sgroup2.getBonds(), idxs);
                this.writer.write(")");
            }
            if (!sgroup2.getParents().isEmpty()) {
                Set parents = sgroup2.getParents();
                if (parents.size() > 1) {
                    throw new CDKException("Cannot write Sgroup with multiple parents");
                }
                this.writer.write(" PARENT=").write(1 + copyOfSgroups.indexOf(parents.iterator().next()));
            }
            for (SgroupKey key : sgroup2.getAttributeKeys()) {
                switch (key) {
                    case CtabSubType: {
                        this.writer.write(" SUBTYPE=").write(sgroup2.getValue(key).toString());
                        break;
                    }
                    case CtabConnectivity: {
                        this.writer.write(" CONNECT=").write(sgroup2.getValue(key).toString().toUpperCase(Locale.ROOT));
                        break;
                    }
                    case CtabSubScript: {
                        if (type == SgroupType.CtabMultipleGroup) {
                            this.writer.write(" MULT=").write(sgroup2.getValue(key).toString());
                            break;
                        }
                        this.writer.write(" LABEL=").write(sgroup2.getValue(key).toString());
                        break;
                    }
                    case CtabBracketStyle: {
                        Integer btype = (Integer)sgroup2.getValue(key);
                        if (!btype.equals(1)) break;
                        this.writer.write(" BRKTYP=PAREN");
                        break;
                    }
                    case CtabParentAtomList: {
                        Collection parentAtoms = (Collection)sgroup2.getValue(key);
                        this.writer.write(" PATOMS=(").write(parentAtoms, idxs).write(')');
                        break;
                    }
                    case CtabComponentNumber: {
                        Integer number = (Integer)sgroup2.getValue(key);
                        if (number <= 0) break;
                        this.writer.write(" COMPNO=").write(number);
                        break;
                    }
                    case CtabExpansion: {
                        boolean expanded = (Boolean)sgroup2.getValue(key);
                        if (!expanded) break;
                        this.writer.write(" ESTATE=E");
                        break;
                    }
                    case CtabBracket: {
                        Collection brackets = (Collection)sgroup2.getValue(key);
                        for (SgroupBracket bracket : brackets) {
                            this.writer.write(" BRKXYZ=(");
                            Point2d p1 = bracket.getFirstPoint();
                            Point2d p2 = bracket.getSecondPoint();
                            this.writer.write("9");
                            this.writer.write(' ').write(p1.x).write(' ').write(p1.y).write(" 0");
                            this.writer.write(' ').write(p2.x).write(' ').write(p2.y).write(" 0");
                            this.writer.write(" 0 0 0");
                            this.writer.write(")");
                        }
                        break;
                    }
                }
            }
            this.writer.write('\n');
        }
        this.writer.write("END SGROUP\n");
    }

    private void writeMol(IAtomContainer mol) throws IOException, CDKException {
        this.writeHeader(mol);
        List<Sgroup> sgroups = this.getSgroups(mol);
        int numSgroups = 0;
        for (Sgroup sgroup : sgroups) {
            if (!sgroup.getType().isCtabStandard()) continue;
            ++numSgroups;
        }
        int chiralFlag = MDLV3000Writer.getChiralFlag(mol.stereoElements());
        this.writer.write("BEGIN CTAB\n");
        this.writer.write("COUNTS ").write(mol.getAtomCount()).write(' ').write(mol.getBondCount()).write(' ').write(numSgroups).write(" 0").write(chiralFlag == 1 ? " 1" : " 0").write("\n");
        HashMap<IChemObject, Integer> idxs = new HashMap<IChemObject, Integer>();
        HashMap<IAtom, ITetrahedralChirality> atomToStereo = new HashMap<IAtom, ITetrahedralChirality>();
        IAtom[] atoms = this.pushHydrogensToBack(mol, idxs);
        for (IBond bond : mol.bonds()) {
            idxs.put((IChemObject)bond, 1 + idxs.size() - mol.getAtomCount());
        }
        for (IStereoElement se : mol.stereoElements()) {
            if (!(se instanceof ITetrahedralChirality)) continue;
            atomToStereo.put(((ITetrahedralChirality)se).getChiralAtom(), (ITetrahedralChirality)se);
        }
        this.writeAtomBlock(mol, atoms, idxs, atomToStereo);
        this.writeBondBlock(mol, idxs);
        this.writeSgroupBlock(sgroups, idxs);
        if (chiralFlag > 1) {
            this.writeEnhancedStereo(mol, idxs);
        }
        this.writer.write("END CTAB\n");
        this.writer.writeDirect("M  END\n");
        if (this.writeDataOpt.isSet()) {
            MDLV2000Writer.writeNonStructuralData(this.writer.writer, mol, MDLV2000Writer.SD_TAGS_TO_IGNORE, this.acceptedSdTags, this.truncateDataOpt.isSet());
        }
        this.writer.writer.flush();
    }

    private void writeEnhancedStereo(IAtomContainer mol, Map<IChemObject, Integer> idxs) throws IOException {
        TreeMap<Integer, List> groups = new TreeMap<Integer, List>();
        for (IStereoElement se : mol.stereoElements()) {
            if (se.getConfigClass() != 16896) continue;
            groups.computeIfAbsent(se.getGroupInfo(), e -> new ArrayList()).add((IAtom)se.getFocus());
        }
        this.writer.write("BEGIN COLLECTION\n");
        int numRel = 0;
        int numRac = 0;
        for (Map.Entry e2 : groups.entrySet()) {
            int grpInfo = (Integer)e2.getKey();
            List atoms = (List)e2.getValue();
            this.writer.write("MDLV30/STE");
            switch (grpInfo & 0x30000) {
                case 0: {
                    this.writer.write("ABS");
                    break;
                }
                case 65536: {
                    this.writer.write("RAC");
                    this.writer.write(++numRac);
                    break;
                }
                case 131072: {
                    this.writer.write("REL");
                    this.writer.write(++numRel);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected ");
                }
            }
            this.writer.write(" ATOMS=(");
            this.writer.write(idxs.get(atoms.get(0)));
            for (int i = 1; i < atoms.size(); ++i) {
                this.writer.write(' ');
                this.writer.write(idxs.get(atoms.get(i)));
            }
            this.writer.write(")\n");
        }
        this.writer.write("END COLLECTION\n");
    }

    public void write(IChemObject object) throws CDKException {
        try {
            if (!(object instanceof IAtomContainer)) {
                throw new CDKException("Unsupported ChemObject " + object.getClass());
            }
            this.writeMol((IAtomContainer)object);
        }
        catch (IOException ex) {
            throw new CDKException("Could not write V3000 format", (Throwable)ex);
        }
    }

    public void setWriter(Writer writer) throws CDKException {
        this.writer = new V30LineWriter(writer);
    }

    public void setWriter(OutputStream writer) throws CDKException {
        this.setWriter(new OutputStreamWriter(writer, StandardCharsets.UTF_8));
    }

    public IResourceFormat getFormat() {
        return MDLV3000Format.getInstance();
    }

    public boolean accepts(Class<? extends IChemObject> c) {
        return c.isInstance(IAtomContainer.class);
    }

    public void close() throws IOException {
        if (this.writer != null) {
            this.writer.close();
        }
    }

    private void initIOSettings() {
        this.programNameOpt = (StringIOSetting)this.addSetting((IOSetting)new StringIOSetting("ProgramName", IOSetting.Importance.LOW, "Program name to write at the top of the molfile header, should be exactly 8 characters long", "CDK"));
        this.writeDataOpt = (BooleanIOSetting)this.addSetting((IOSetting)new BooleanIOSetting("writeProperties", IOSetting.Importance.LOW, "Should molecule properties be written as non-structural data", "false"));
        this.truncateDataOpt = (BooleanIOSetting)this.addSetting((IOSetting)new BooleanIOSetting("TruncateLongData", IOSetting.Importance.LOW, "Truncate long data files >200 characters", "false"));
    }

    public void customizeJob() {
        for (IOSetting setting : this.getSettings()) {
            this.fireIOSettingQuestion(setting);
        }
    }

    static int getChiralFlag(Iterable<? extends IStereoElement> stereo) {
        boolean init = false;
        int grp = 0;
        for (IStereoElement iStereoElement : stereo) {
            if (iStereoElement.getConfigClass() != 16896) continue;
            if (!init) {
                init = true;
                grp = iStereoElement.getGroupInfo();
                continue;
            }
            if (grp == iStereoElement.getGroupInfo()) continue;
            return 2;
        }
        if (!init) {
            return 0;
        }
        if (grp == 0) {
            return 1;
        }
        return 2;
    }

    private static final class V30LineWriter
    implements Closeable {
        private final DecimalFormat decimalFmt = new DecimalFormat("#.#####", DecimalFormatSymbols.getInstance(Locale.ROOT));
        private static final String PREFIX = "M  V30 ";
        private static final int LIMIT = 78;
        private final BufferedWriter writer;
        private int currLength = 0;

        V30LineWriter(Writer writer) {
            this.writer = writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer);
        }

        V30LineWriter writeDirect(String str) throws IOException {
            this.writer.write(str);
            return this;
        }

        V30LineWriter writeDirect(char c) throws IOException {
            this.writer.write(c);
            return this;
        }

        private void writeUnbroken(String str) throws IOException {
            this.newLineIfNeeded();
            this.writePrefixIfNeeded();
            int len = str.length();
            if (this.currLength + len < 78) {
                this.writer.write(str);
                this.currLength += len;
            } else {
                for (int i = 0; i < len; ++i) {
                    this.write(str.charAt(i));
                }
            }
        }

        private void newLineIfNeeded() throws IOException {
            if (this.currLength == 78) {
                this.writer.write(45);
                this.writer.write(10);
                this.currLength = 0;
            }
        }

        private void writePrefixIfNeeded() throws IOException {
            if (this.currLength == 0) {
                this.writer.write(PREFIX);
                this.currLength = PREFIX.length();
            }
        }

        V30LineWriter write(double num) throws IOException {
            return this.write(this.decimalFmt.format(num));
        }

        V30LineWriter write(int num) throws IOException {
            return this.write(Integer.toString(num));
        }

        V30LineWriter write(String str) throws IOException {
            int i = str.indexOf(10);
            if (i < 0) {
                this.writeUnbroken(str);
            } else if (i == str.length() - 1) {
                this.writeUnbroken(str);
                this.currLength = 0;
            } else {
                throw new UnsupportedOperationException();
            }
            return this;
        }

        V30LineWriter write(char c) throws IOException {
            if (c == '\n' && this.currLength == PREFIX.length()) {
                return this;
            }
            if (c != '\n') {
                this.newLineIfNeeded();
            }
            this.writePrefixIfNeeded();
            this.writer.write(c);
            ++this.currLength;
            if (c == '\n') {
                this.currLength = 0;
            }
            return this;
        }

        V30LineWriter write(Collection<? extends IChemObject> chemObjects, Map<IChemObject, Integer> idxs) throws IOException {
            this.write(chemObjects.size());
            ArrayList<Integer> integers = new ArrayList<Integer>();
            for (IChemObject iChemObject : chemObjects) {
                integers.add(idxs.get(iChemObject));
            }
            Collections.sort(integers);
            for (Integer n : integers) {
                this.write(' ').write(n);
            }
            return this;
        }

        @Override
        public void close() throws IOException {
            this.writer.close();
        }
    }

    static enum MDLQueryProperty {
        NOT_SPECIFIED(0),
        RING(1),
        CHAIN(2);

        private final int value;

        private MDLQueryProperty(int value) {
            this.value = value;
        }

        static MDLQueryProperty getDefaultValue() {
            return NOT_SPECIFIED;
        }

        int getValue() {
            return this.value;
        }
    }

    static final class ExpressionConverter {
        private static final int UNSPEC_SING = 1;
        private static final int UNSPEC_DOUB = 2;
        private static final int UNSPEC_TRIP = 4;
        private static final int UNSPEC_QUAD = 8;
        private static final int UNSPEC_AROM = 16;
        private static final int CHAIN_SING = 32;
        private static final int CHAIN_DOUB = 64;
        private static final int CHAIN_TRIP = 128;
        private static final int CHAIN_QUAD = 256;
        private static final int CHAIN_AROM = 512;
        private static final int RING_SING = 1024;
        private static final int RING_DOUB = 2048;
        private static final int RING_TRIP = 4096;
        private static final int RING_QUAD = 8192;
        private static final int RING_AROM = 16384;
        private static final int SINGLE_MASK = 1057;
        private static final int DOUBLE_MASK = 2114;
        private static final int TRIPLE_MASK = 4228;
        private static final int QUADRUPLE_MASK = 8456;
        private static final int UNSPECIFIED_MASK = 31;
        private static final int CHAIN_MASK = 992;
        private static final int RING_MASK = 31744;
        private static final int AROMATIC_MASK = 16912;
        private static final int ALIPHATIC_MASK = 15855;
        private static final int ALL_MASK = Short.MAX_VALUE;
        private final Expr expression;
        private final int bondCode;

        ExpressionConverter(Expr expression) {
            this.expression = expression;
            this.bondCode = ExpressionConverter.getBondCode(expression);
        }

        MDLBondType toMDLBondType() throws CDKException {
            if ((this.bondCode & Short.MAX_VALUE) == Short.MAX_VALUE) {
                return MDLBondType.ANY;
            }
            if ((this.bondCode & 0x421) > 0) {
                if ((this.bondCode & 0x842) > 0) {
                    return MDLBondType.SINGLE_OR_DOUBLE;
                }
                if ((this.bondCode & 0x4210) > 0) {
                    return MDLBondType.SINGLE_OR_AROMATIC;
                }
                if ((this.bondCode & 0x1084) == 0 && (this.bondCode & 0x2108) == 0) {
                    return MDLBondType.SINGLE;
                }
            }
            if ((this.bondCode & 0x842) > 0) {
                if ((this.bondCode & 0x4210) > 0) {
                    return MDLBondType.DOUBLE_OR_AROMATIC;
                }
                if ((this.bondCode & 0x421) == 0 && (this.bondCode & 0x1084) == 0 && (this.bondCode & 0x2108) == 0) {
                    return MDLBondType.DOUBLE;
                }
            }
            if ((this.bondCode & 0x1084) > 0 && (this.bondCode & 0x421) == 0 && (this.bondCode & 0x842) == 0 && (this.bondCode & 0x2108) == 0) {
                return MDLBondType.TRIPLE;
            }
            if ((this.bondCode & 0x4210) > 0 && (this.bondCode & 0x421) == 0 && (this.bondCode & 0x842) == 0 && (this.bondCode & 0x1084) == 0 && (this.bondCode & 0x2108) == 0) {
                return MDLBondType.AROMATIC;
            }
            throw new CDKException("Query bond with expression " + this.expression + " cannot be written to V3000");
        }

        MDLQueryProperty toMDLQueryProperty() {
            if ((this.bondCode & 0x1F) > 0) {
                return MDLQueryProperty.NOT_SPECIFIED;
            }
            if ((this.bondCode & 0x3E0) > 0) {
                return MDLQueryProperty.CHAIN;
            }
            if ((this.bondCode & 0x7C00) > 0) {
                return MDLQueryProperty.RING;
            }
            return MDLQueryProperty.NOT_SPECIFIED;
        }

        static int getBondCode(Expr expression) {
            switch (expression.type()) {
                case NOT: {
                    return ~ExpressionConverter.getBondCode(expression.left());
                }
                case OR: {
                    return ExpressionConverter.getBondCode(expression.left()) | ExpressionConverter.getBondCode(expression.right());
                }
                case AND: {
                    return ExpressionConverter.getBondCode(expression.left()) & ExpressionConverter.getBondCode(expression.right());
                }
                case TRUE: 
                case STEREOCHEMISTRY: {
                    return Short.MAX_VALUE;
                }
                case SINGLE_OR_AROMATIC: {
                    return 17969;
                }
                case DOUBLE_OR_AROMATIC: {
                    return 19026;
                }
                case SINGLE_OR_DOUBLE: {
                    return 3171;
                }
                case IS_AROMATIC: {
                    return 16912;
                }
                case IS_ALIPHATIC: {
                    return 15855;
                }
                case IS_IN_RING: {
                    return 31744;
                }
                case IS_IN_CHAIN: {
                    return 992;
                }
                case ORDER: {
                    switch (expression.value()) {
                        case 1: {
                            return 1057;
                        }
                        case 2: {
                            return 2114;
                        }
                        case 3: {
                            return 4228;
                        }
                        case 4: {
                            return 8456;
                        }
                    }
                    logger.warn((Object)("Unexpected bond order expression value: " + expression.value()));
                    return 0;
                }
                case ALIPHATIC_ORDER: {
                    switch (expression.value()) {
                        case 1: {
                            return 1057;
                        }
                        case 2: {
                            return 2114;
                        }
                        case 3: {
                            return 4228;
                        }
                        case 4: {
                            return 8456;
                        }
                    }
                    logger.warn((Object)("Unexpected aliphatic bond order expression value: " + expression.value()));
                    return 0;
                }
                case FALSE: {
                    return 0;
                }
            }
            logger.warn((Object)("Unexpected expression: " + expression));
            return 0;
        }
    }

    static enum MDLBondType {
        SINGLE(1),
        DOUBLE(2),
        TRIPLE(3),
        AROMATIC(4),
        SINGLE_OR_DOUBLE(5),
        SINGLE_OR_AROMATIC(6),
        DOUBLE_OR_AROMATIC(7),
        ANY(8),
        COORDINATION(9),
        HYDROGEN(10);

        private final int value;

        private MDLBondType(int value) {
            this.value = value;
        }

        int getValue() {
            return this.value;
        }
    }
}

