/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IReaction;

public final class RdfileRecord {
    private final String internalRegistryNumber;
    private final String externalRegistryNumber;
    private final boolean isRxnFile;
    private String content = "";
    private CTAB_VERSION ctabVersion;
    private Map<Object, Object> data = new LinkedHashMap<Object, Object>();
    private IChemObject chemObject;

    RdfileRecord(String internalRegistryNumber, String externalRegistryNumber, boolean isRxnFile) {
        this.internalRegistryNumber = internalRegistryNumber;
        this.externalRegistryNumber = externalRegistryNumber;
        this.isRxnFile = isRxnFile;
    }

    public String getInternalRegistryNumber() {
        return this.internalRegistryNumber;
    }

    public String getExternalRegistryNumber() {
        return this.externalRegistryNumber;
    }

    void setData(Map<Object, Object> data) {
        this.data = data;
    }

    Map<Object, Object> getData() {
        return Collections.unmodifiableMap(this.data);
    }

    public boolean isRxnFile() {
        return this.isRxnFile;
    }

    public boolean isMolfile() {
        return !this.isRxnFile;
    }

    void setContent(String content) {
        this.content = content;
    }

    String getContent() {
        return this.content;
    }

    CTAB_VERSION getCtabVersion() {
        return this.ctabVersion;
    }

    void setCtabVersion(CTAB_VERSION ctabVersion) {
        this.ctabVersion = ctabVersion;
    }

    void setChemObject(IChemObject chemObject) {
        this.chemObject = chemObject;
    }

    public IAtomContainer getAtomContainer() {
        if (this.chemObject instanceof IAtomContainer) {
            return (IAtomContainer)this.chemObject;
        }
        return null;
    }

    public IReaction getReaction() {
        if (this.chemObject instanceof IReaction) {
            return (IReaction)this.chemObject;
        }
        return null;
    }

    static enum CTAB_VERSION {
        V2000,
        V3000;

    }
}

