/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Set;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IChemFile;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IStereoElement;
import org.openscience.cdk.io.DefaultChemObjectWriter;
import org.openscience.cdk.io.MDLV2000Writer;
import org.openscience.cdk.io.MDLV3000Writer;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.io.formats.SDFFormat;
import org.openscience.cdk.io.setting.BooleanIOSetting;
import org.openscience.cdk.io.setting.IOSetting;
import org.openscience.cdk.sgroup.Sgroup;
import org.openscience.cdk.sgroup.SgroupType;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.ChemFileManipulator;
import org.openscience.cdk.tools.manipulator.ChemModelManipulator;

public class SDFWriter
extends DefaultChemObjectWriter {
    private static final ILoggingTool logger = LoggingToolFactory.createLoggingTool(SDFWriter.class);
    public static final String OptAlwaysV3000 = "writeV3000";
    public static final String OptWriteData = "writeProperties";
    public static final String OptTruncateLongData = "TruncateLongData";
    public static final String SD_RECORD_DELIM = "$$$$";
    private BufferedWriter writer;
    private BooleanIOSetting paramWriteV3000;
    private Set<String> acceptedSdTags;

    public SDFWriter(BufferedWriter wtr) {
        this.writer = wtr;
        this.initIOSettings();
    }

    public SDFWriter(Writer wtr) {
        this(SDFWriter.ensureBuffered(wtr));
        this.initIOSettings();
    }

    public SDFWriter(OutputStream output) {
        this(new OutputStreamWriter(output, StandardCharsets.UTF_8));
    }

    public SDFWriter() {
        this(new StringWriter());
    }

    public SDFWriter(Writer out, Set<String> acceptedSdTags) {
        this(out);
        this.initIOSettings();
        this.acceptedSdTags = acceptedSdTags;
    }

    public SDFWriter(OutputStream output, Set<String> acceptedSdTags) {
        this(new OutputStreamWriter(output), acceptedSdTags);
    }

    public SDFWriter(Set<String> acceptedSdTags) {
        this(new StringWriter(), acceptedSdTags);
    }

    private static BufferedWriter ensureBuffered(Writer wtr) {
        if (wtr == null) {
            throw new NullPointerException("Provided writer was null");
        }
        return wtr instanceof BufferedWriter ? (BufferedWriter)wtr : new BufferedWriter(wtr);
    }

    public IResourceFormat getFormat() {
        return SDFFormat.getInstance();
    }

    public void setWriter(Writer out) throws CDKException {
        this.writer = out instanceof BufferedWriter ? (BufferedWriter)out : new BufferedWriter(out);
    }

    public void setWriter(OutputStream output) throws CDKException {
        this.setWriter(new OutputStreamWriter(output));
    }

    public void close() throws IOException {
        this.writer.close();
    }

    public boolean accepts(Class<? extends IChemObject> classObject) {
        Class<?>[] interfaces;
        for (Class<?> anInterface : interfaces = classObject.getInterfaces()) {
            if (IAtomContainer.class.equals(anInterface)) {
                return true;
            }
            if (IChemFile.class.equals(anInterface)) {
                return true;
            }
            if (IChemModel.class.equals(anInterface)) {
                return true;
            }
            if (!IAtomContainerSet.class.equals(anInterface)) continue;
            return true;
        }
        if (IAtomContainer.class.equals(classObject)) {
            return true;
        }
        if (IChemFile.class.equals(classObject)) {
            return true;
        }
        if (IChemModel.class.equals(classObject)) {
            return true;
        }
        if (IAtomContainerSet.class.equals(classObject)) {
            return true;
        }
        Class<? extends IChemObject> superClass = classObject.getSuperclass();
        if (superClass != null) {
            return this.accepts(superClass);
        }
        return false;
    }

    public void write(IChemObject object) throws CDKException {
        try {
            if (object instanceof IAtomContainerSet) {
                this.writeMoleculeSet((IAtomContainerSet)object);
                return;
            }
            if (object instanceof IChemFile) {
                this.writeChemFile((IChemFile)object);
                return;
            }
            if (object instanceof IChemModel) {
                this.writeChemModel((IChemModel)object);
                return;
            }
            if (object instanceof IAtomContainer) {
                this.writeMolecule((IAtomContainer)object);
                return;
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage());
            logger.debug((Object)ex);
            throw new CDKException("Exception while writing MDL file: " + ex.getMessage(), (Throwable)ex);
        }
        throw new CDKException("Only supported is writing of ChemFile, MoleculeSet, AtomContainer and Molecule objects.");
    }

    private void writeMoleculeSet(IAtomContainerSet som) throws Exception {
        for (IAtomContainer mol : som.atomContainers()) {
            this.writeMolecule(mol);
        }
    }

    private void writeChemFile(IChemFile file) throws Exception {
        for (IAtomContainer container : ChemFileManipulator.getAllAtomContainers((IChemFile)file)) {
            this.writeMolecule(container);
        }
    }

    private void writeChemModel(IChemModel model) throws Exception {
        for (IAtomContainer container : ChemModelManipulator.getAllAtomContainers((IChemModel)model)) {
            this.writeMolecule(container);
        }
    }

    private void writeMolecule(IAtomContainer container) throws CDKException {
        try {
            DefaultChemObjectWriter mdlWriter;
            StringWriter stringWriter = new StringWriter();
            if (this.writeV3000(container)) {
                mdlWriter = new MDLV3000Writer(stringWriter);
                mdlWriter.addSettings(this.getSettings());
                ((MDLV3000Writer)mdlWriter).customizeJob();
                ((MDLV3000Writer)mdlWriter).setAcceptedSdTags(this.acceptedSdTags);
            } else {
                mdlWriter = new MDLV2000Writer(stringWriter);
                mdlWriter.addSettings(this.getSettings());
                ((MDLV2000Writer)mdlWriter).customizeJob();
                ((MDLV2000Writer)mdlWriter).setAcceptedSdTags(this.acceptedSdTags);
            }
            mdlWriter.write((IChemObject)container);
            mdlWriter.close();
            stringWriter.append(SD_RECORD_DELIM).append('\n');
            this.writer.write(stringWriter.toString());
        }
        catch (IOException exception) {
            throw new CDKException("Error while writing a SD file entry: " + exception.getMessage(), (Throwable)exception);
        }
    }

    private boolean writeV3000(IAtomContainer container) {
        if (this.paramWriteV3000.isSet()) {
            return true;
        }
        if (container.getAtomCount() > 999) {
            return true;
        }
        if (container.getBondCount() > 999) {
            return true;
        }
        boolean init = false;
        int grp = 0;
        for (IStereoElement se : container.stereoElements()) {
            if (se.getConfigClass() != 16896) continue;
            if (!init) {
                init = true;
                grp = se.getGroupInfo();
                continue;
            }
            if (grp == se.getGroupInfo()) continue;
            return true;
        }
        if ((grp & 0x30000) == 131072) {
            return true;
        }
        List sgroups = (List)container.getProperty((Object)"cdk:CtabSgroups");
        if (sgroups != null) {
            for (Sgroup sgroup : sgroups) {
                if (sgroup.getType() != SgroupType.ExtMulticenter) continue;
                return true;
            }
        }
        return false;
    }

    private void initIOSettings() {
        try (MDLV2000Writer mdlv2 = new MDLV2000Writer();
             MDLV3000Writer mdlv3 = new MDLV3000Writer();){
            this.addSettings(mdlv2.getSettings());
            this.addSettings(mdlv3.getSettings());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.addSetting((IOSetting)new BooleanIOSetting(OptWriteData, IOSetting.Importance.LOW, "Should molecule properties be written as non-structural data", "true"));
        this.addSetting((IOSetting)new BooleanIOSetting(OptTruncateLongData, IOSetting.Importance.LOW, "Truncate long data files >200 characters", "false"));
        this.paramWriteV3000 = (BooleanIOSetting)this.addSetting((IOSetting)new BooleanIOSetting(OptAlwaysV3000, IOSetting.Importance.LOW, "Write all records as V3000", "false"));
    }

    public void setAlwaysV3000(boolean val) {
        try {
            this.paramWriteV3000.setSetting(Boolean.toString(val));
        }
        catch (CDKException e) {
            throw new InternalError(e.getMessage());
        }
    }

    public void customizeJob() {
        for (IOSetting setting : this.getSettings()) {
            this.fireIOSettingQuestion(setting);
        }
    }

    public void flush() throws IOException {
        this.writer.flush();
    }
}

