/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io.iterator;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.io.DefaultChemObjectReader;
import org.openscience.cdk.io.ISimpleChemObjectReader;
import org.openscience.cdk.io.MDLReader;
import org.openscience.cdk.io.MDLV2000Reader;
import org.openscience.cdk.io.MDLV3000Reader;
import org.openscience.cdk.io.formats.IChemFormat;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.io.formats.MDLFormat;
import org.openscience.cdk.io.formats.MDLV2000Format;
import org.openscience.cdk.io.formats.MDLV3000Format;
import org.openscience.cdk.io.iterator.DefaultIteratingChemObjectReader;
import org.openscience.cdk.io.setting.BooleanIOSetting;
import org.openscience.cdk.io.setting.IOSetting;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

public class IteratingSDFReader
extends DefaultIteratingChemObjectReader<IAtomContainer> {
    private BufferedReader input;
    private static final ILoggingTool logger = LoggingToolFactory.createLoggingTool(IteratingSDFReader.class);
    private String currentLine;
    private IChemFormat currentFormat;
    private boolean nextAvailableIsKnown;
    private boolean hasNext;
    private final IChemObjectBuilder builder;
    private IAtomContainer nextMolecule;
    private BooleanIOSetting forceReadAs3DCoords;
    private boolean skip = false;
    private final StringBuilder buffer = new StringBuilder(10000);
    private static final String LINE_SEPARATOR = "\n";
    private static final Pattern MDL_VERSION = Pattern.compile("[vV](2000|3000)");
    private static final String SDF_RECORD_SEPARATOR = "$$$$";
    private static final String SDF_DATA_HEADER = "> ";
    private final Map<IChemFormat, ISimpleChemObjectReader> readerMap = new HashMap<IChemFormat, ISimpleChemObjectReader>(5);

    public IteratingSDFReader(Reader in, IChemObjectBuilder builder) {
        this(in, builder, false);
    }

    public IteratingSDFReader(InputStream in, IChemObjectBuilder builder) {
        this(new InputStreamReader(in), builder);
    }

    public IteratingSDFReader(InputStream in, IChemObjectBuilder builder, boolean skip) {
        this(new InputStreamReader(in), builder, skip);
    }

    public IteratingSDFReader(Reader in, IChemObjectBuilder builder, boolean skip) {
        this.builder = builder;
        this.setReader(in);
        this.initIOSettings();
        this.setSkip(skip);
    }

    public IResourceFormat getFormat() {
        return this.currentFormat;
    }

    private ISimpleChemObjectReader getReader(IChemFormat format) {
        if (!this.readerMap.containsKey(format)) {
            DefaultChemObjectReader reader;
            if (format instanceof MDLV2000Format) {
                reader = new MDLV2000Reader();
            } else if (format instanceof MDLV3000Format) {
                reader = new MDLV3000Reader();
            } else if (format instanceof MDLFormat) {
                reader = new MDLReader();
            } else {
                throw new IllegalArgumentException("Unexpected format: " + format);
            }
            reader.setErrorHandler(this.errorHandler);
            reader.setReaderMode(this.mode);
            if (this.currentFormat instanceof MDLV2000Format) {
                reader.addSettings(this.getSettings());
            }
            this.readerMap.put(format, (ISimpleChemObjectReader)reader);
        }
        return this.readerMap.get(format);
    }

    public boolean hasNext() {
        if (this.nextAvailableIsKnown) {
            return this.hasNext;
        }
        this.hasNext = false;
        this.nextMolecule = null;
        try {
            do {
                this.currentFormat = (IChemFormat)MDLFormat.getInstance();
                int lineNum = 0;
                this.buffer.setLength(0);
                while ((this.currentLine = this.input.readLine()) != null) {
                    Matcher versionMatcher;
                    this.buffer.append(this.currentLine).append(LINE_SEPARATOR);
                    if (++lineNum == 4 && (versionMatcher = MDL_VERSION.matcher(this.currentLine)).find()) {
                        IChemFormat iChemFormat = this.currentFormat = "2000".equals(versionMatcher.group(1)) ? (IChemFormat)MDLV2000Format.getInstance() : (IChemFormat)MDLV3000Format.getInstance();
                    }
                    if (!this.currentLine.startsWith(SDF_RECORD_SEPARATOR)) continue;
                }
                logger.debug((Object)"MDL file part read: ", new Object[]{this.buffer});
                IAtomContainer molecule = null;
                try {
                    ISimpleChemObjectReader reader = this.getReader(this.currentFormat);
                    reader.setReader((Reader)new StringReader(this.buffer.toString()));
                    molecule = (IAtomContainer)reader.read((IChemObject)this.builder.newAtomContainer());
                }
                catch (Exception exception) {
                    logger.error((Object)("Error while reading next molecule: " + exception.getMessage()));
                    logger.debug((Object)exception);
                }
                if (molecule != null) {
                    this.hasNext = true;
                    this.nextAvailableIsKnown = true;
                    this.nextMolecule = molecule;
                    return true;
                }
                if (this.skip) continue;
                return false;
            } while (this.currentLine != null || this.buffer.length() != 0);
            return false;
        }
        catch (IOException exception) {
            logger.error((Object)("Error while reading next molecule: " + exception.getMessage()));
            logger.debug((Object)exception);
            return false;
        }
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    public IAtomContainer next() {
        if (!this.nextAvailableIsKnown) {
            this.hasNext = this.hasNext();
        }
        this.nextAvailableIsKnown = false;
        if (!this.hasNext) {
            throw new NoSuchElementException();
        }
        return this.nextMolecule;
    }

    public void close() throws IOException {
        this.input.close();
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void setReader(Reader reader) {
        this.input = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        this.nextMolecule = null;
        this.nextAvailableIsKnown = false;
        this.hasNext = false;
    }

    public void setReader(InputStream reader) {
        this.setReader(new InputStreamReader(reader));
    }

    private void initIOSettings() {
        this.forceReadAs3DCoords = new BooleanIOSetting("ForceReadAs3DCoordinates", IOSetting.Importance.LOW, "Should coordinates always be read as 3D?", "false");
        this.addSetting((IOSetting)this.forceReadAs3DCoords);
    }

    public void customizeJob() {
        this.fireIOSettingQuestion((IOSetting)this.forceReadAs3DCoords);
    }
}

