/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.debug;

import java.util.Map;
import org.openscience.cdk.Reaction;
import org.openscience.cdk.debug.DebugChemObjectBuilder;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IChemObjectChangeEvent;
import org.openscience.cdk.interfaces.IChemObjectListener;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

public class DebugReaction
extends Reaction
implements IReaction {
    private static final long serialVersionUID = -8958358842308217875L;
    final ILoggingTool logger = LoggingToolFactory.createLoggingTool(DebugReaction.class);

    public void addListener(IChemObjectListener col) {
        this.logger.debug((Object)"Adding listener: ", new Object[]{col});
        super.addListener(col);
    }

    public int getListenerCount() {
        this.logger.debug((Object)"Getting listener count: ", new Object[]{super.getListenerCount()});
        return super.getListenerCount();
    }

    public void removeListener(IChemObjectListener col) {
        this.logger.debug((Object)"Removing listener: ", new Object[]{col});
        super.removeListener(col);
    }

    public void notifyChanged() {
        this.logger.debug((Object)"Notifying changed");
        super.notifyChanged();
    }

    public void notifyChanged(IChemObjectChangeEvent evt) {
        this.logger.debug((Object)"Notifying changed event: ", new Object[]{evt});
        super.notifyChanged(evt);
    }

    public void setProperty(Object description, Object property) {
        this.logger.debug((Object)"Setting property: ", new Object[]{description + "=" + property});
        super.setProperty(description, property);
    }

    public void removeProperty(Object description) {
        this.logger.debug((Object)"Removing property: ", new Object[]{description});
        super.removeProperty(description);
    }

    public <T> T getProperty(Object description) {
        this.logger.debug((Object)"Getting property: ", new Object[]{description + "=" + super.getProperty(description)});
        return (T)super.getProperty(description);
    }

    public Map<Object, Object> getProperties() {
        this.logger.debug((Object)"Getting properties");
        return super.getProperties();
    }

    public String getID() {
        this.logger.debug((Object)"Getting ID: ", new Object[]{super.getID()});
        return super.getID();
    }

    public void setID(String identifier) {
        this.logger.debug((Object)"Setting ID: ", new Object[]{identifier});
        super.setID(identifier);
    }

    public void setFlag(int flagType, boolean flagValue) {
        this.logger.debug((Object)"Setting flag: ", new Object[]{flagType + "=" + flagValue});
        super.setFlag(flagType, flagValue);
    }

    public boolean getFlag(int flagType) {
        this.logger.debug((Object)"Setting flag: ", new Object[]{flagType + "=" + super.getFlag(flagType)});
        return super.getFlag(flagType);
    }

    public void addProperties(Map<Object, Object> properties) {
        this.logger.debug((Object)"Setting properties: ", new Object[]{properties});
        super.addProperties(properties);
    }

    public void setFlags(boolean[] flagsNew) {
        this.logger.debug((Object)"Setting flags:", new Object[]{flagsNew.length});
        super.setFlags(flagsNew);
    }

    public boolean[] getFlags() {
        this.logger.debug((Object)"Getting flags:", new Object[]{super.getFlags().length});
        return super.getFlags();
    }

    public Object clone() throws CloneNotSupportedException {
        Object clone = null;
        try {
            clone = super.clone();
        }
        catch (Exception exception) {
            this.logger.error((Object)("Could not clone DebugAtom: " + exception.getMessage()), new Object[]{exception});
            this.logger.debug((Object)exception);
        }
        return clone;
    }

    public IChemObjectBuilder getBuilder() {
        return DebugChemObjectBuilder.getInstance();
    }

    public int getReactantCount() {
        this.logger.debug((Object)"Getting reactant count: ", new Object[]{super.getReactantCount()});
        return super.getReactantCount();
    }

    public int getProductCount() {
        this.logger.debug((Object)"Getting product count: ", new Object[]{super.getProductCount()});
        return super.getProductCount();
    }

    public int getAgentCount() {
        this.logger.debug((Object)"Getting agent count: ", new Object[]{super.getAgentCount()});
        return super.getAgentCount();
    }

    public IAtomContainerSet getReactants() {
        this.logger.debug((Object)"Getting reactants: ", new Object[]{super.getReactants()});
        return super.getReactants();
    }

    public void setReactants(IAtomContainerSet reactants) {
        this.logger.debug((Object)"Setting reactants: ", new Object[]{reactants});
        super.setReactants(reactants);
    }

    public IAtomContainerSet getProducts() {
        this.logger.debug((Object)"Getting products: ", new Object[]{super.getProducts()});
        return super.getProducts();
    }

    public void setProducts(IAtomContainerSet products) {
        this.logger.debug((Object)"Setting products: ", new Object[]{products});
        super.setProducts(products);
    }

    public IAtomContainerSet getAgents() {
        this.logger.debug((Object)"Getting agents: ", new Object[]{super.getAgents()});
        return super.getAgents();
    }

    public void addReactant(IAtomContainer reactant) {
        this.logger.debug((Object)"Adding reactant: ", new Object[]{reactant});
        super.addReactant(reactant);
    }

    public void addAgent(IAtomContainer agent) {
        this.logger.debug((Object)"Adding agent: ", new Object[]{agent});
        super.addAgent(agent);
    }

    public void addReactant(IAtomContainer reactant, Double coefficient) {
        this.logger.debug((Object)"Adding reactant with coefficient: ", new Object[]{reactant, "" + coefficient});
        super.addReactant(reactant, coefficient);
    }

    public void addProduct(IAtomContainer product) {
        this.logger.debug((Object)"Adding product: ", new Object[]{product});
        super.addProduct(product);
    }

    public void addProduct(IAtomContainer product, Double coefficient) {
        this.logger.debug((Object)"Adding product with coefficient: ", new Object[]{product, "" + coefficient});
        super.addProduct(product, coefficient);
    }

    public Double getReactantCoefficient(IAtomContainer reactant) {
        this.logger.debug((Object)"Setting reactant coefficient: ", new Object[]{reactant, "" + super.getReactantCoefficient(reactant)});
        return super.getReactantCoefficient(reactant);
    }

    public Double getProductCoefficient(IAtomContainer product) {
        this.logger.debug((Object)"Setting product coefficient: ", new Object[]{product, "" + super.getProductCoefficient(product)});
        return super.getProductCoefficient(product);
    }

    public boolean setReactantCoefficient(IAtomContainer reactant, Double coefficient) {
        this.logger.debug((Object)"Setting reactant coefficient: ", new Object[]{reactant, "" + coefficient});
        return super.setReactantCoefficient(reactant, coefficient);
    }

    public boolean setProductCoefficient(IAtomContainer product, Double coefficient) {
        this.logger.debug((Object)"Setting product coefficient: ", new Object[]{product, "" + coefficient});
        return super.setProductCoefficient(product, coefficient);
    }

    public Double[] getReactantCoefficients() {
        this.logger.debug((Object)"Getting reactant coefficients: ", new Object[]{super.getReactantCoefficients().length});
        return super.getReactantCoefficients();
    }

    public Double[] getProductCoefficients() {
        this.logger.debug((Object)"Getting product coefficients: ", new Object[]{super.getProductCoefficients().length});
        return super.getProductCoefficients();
    }

    public boolean setReactantCoefficients(Double[] coefficients) {
        this.logger.debug((Object)"Setting reactant coefficients: ", new Object[]{coefficients.length});
        return super.setReactantCoefficients(coefficients);
    }

    public boolean setProductCoefficients(Double[] coefficients) {
        this.logger.debug((Object)"Setting product coefficients: ", new Object[]{coefficients.length});
        return super.setProductCoefficients(coefficients);
    }

    public void setDirection(IReaction.Direction direction) {
        this.logger.debug((Object)"Setting direction: ", new Object[]{direction});
        super.setDirection(direction);
    }

    public IReaction.Direction getDirection() {
        this.logger.debug((Object)"Getting direction: ", new Object[]{super.getDirection()});
        return super.getDirection();
    }
}

