/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.debug;

import java.util.List;
import java.util.Map;
import org.openscience.cdk.Ring;
import org.openscience.cdk.debug.DebugChemObjectBuilder;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IChemObjectChangeEvent;
import org.openscience.cdk.interfaces.IChemObjectListener;
import org.openscience.cdk.interfaces.IElectronContainer;
import org.openscience.cdk.interfaces.ILonePair;
import org.openscience.cdk.interfaces.IRing;
import org.openscience.cdk.interfaces.ISingleElectron;
import org.openscience.cdk.interfaces.IStereoElement;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

public class DebugRing
extends Ring
implements IRing {
    private static final long serialVersionUID = -6420813246421544803L;
    static final ILoggingTool logger = LoggingToolFactory.createLoggingTool(DebugRing.class);

    public DebugRing() {
    }

    public DebugRing(int ringSize, String elementSymbol) {
        super(ringSize, elementSymbol);
    }

    public DebugRing(int ringSize) {
        super(ringSize);
    }

    public DebugRing(IAtomContainer container) {
        super(container);
    }

    public void addStereoElement(IStereoElement parity) {
        logger.debug((Object)"Adding stereo element: ", new Object[]{parity});
        super.addStereoElement(parity);
    }

    public Iterable<IStereoElement> stereoElements() {
        logger.debug((Object)"Getting stereo elements.");
        return super.stereoElements();
    }

    public void setAtoms(IAtom[] atoms) {
        logger.debug((Object)"Setting atoms: ", new Object[]{atoms.length});
        super.setAtoms(atoms);
    }

    public void setAtom(int number, IAtom atom) {
        logger.debug((Object)("Setting atom at: pos=" + number), new Object[]{" atom=" + atom});
        super.setAtom(number, atom);
    }

    public IAtom getAtom(int idx) {
        logger.debug((Object)"Getting atom at: ", new Object[]{idx});
        return super.getAtom(idx);
    }

    public IBond getBond(int idx) {
        logger.debug((Object)"Getting bond at: ", new Object[]{idx});
        return super.getBond(idx);
    }

    public ILonePair getLonePair(int idx) {
        logger.debug((Object)"Getting lone pair at: ", new Object[]{idx});
        return super.getLonePair(idx);
    }

    public ISingleElectron getSingleElectron(int idx) {
        logger.debug((Object)"Getting single electron at: ", new Object[]{idx});
        return super.getSingleElectron(idx);
    }

    public Iterable<IAtom> atoms() {
        logger.debug((Object)"Getting atoms iterator");
        return super.atoms();
    }

    public Iterable<IBond> bonds() {
        logger.debug((Object)"Getting bonds iterator");
        return super.bonds();
    }

    public Iterable<ILonePair> lonePairs() {
        logger.debug((Object)"Getting lone pairs iterator");
        return super.lonePairs();
    }

    public Iterable<ISingleElectron> singleElectrons() {
        logger.debug((Object)"Getting single electrons iterator");
        return super.singleElectrons();
    }

    public Iterable<IElectronContainer> electronContainers() {
        logger.debug((Object)"Getting electron containers iterator");
        return super.electronContainers();
    }

    public IAtom getFirstAtom() {
        logger.debug((Object)"Getting first atom: ", new Object[]{super.getFirstAtom()});
        return super.getFirstAtom();
    }

    public IAtom getLastAtom() {
        logger.debug((Object)"Getting last atom: ", new Object[]{super.getLastAtom()});
        return super.getLastAtom();
    }

    public int getAtomNumber(IAtom atom) {
        logger.debug((Object)"Getting atom number: ", new Object[]{atom});
        return super.indexOf(atom);
    }

    public int getBondNumber(IAtom atom1, IAtom atom2) {
        logger.debug((Object)("Getting bond number: atom1=" + atom1), new Object[]{" atom2=" + atom2});
        return super.indexOf(super.getBond(atom1, atom2));
    }

    public int getBondNumber(IBond bond) {
        logger.debug((Object)"Getting bond number: ", new Object[]{bond});
        return super.indexOf(bond);
    }

    public int getLonePairNumber(ILonePair bond) {
        logger.debug((Object)"Getting lone pair number: ", new Object[]{bond});
        return super.indexOf(bond);
    }

    public int getSingleElectronNumber(ISingleElectron bond) {
        logger.debug((Object)"Getting single electron number: ", new Object[]{bond});
        return super.indexOf(bond);
    }

    public IElectronContainer getElectronContainer(int number) {
        logger.debug((Object)"Getting electron container at: ", new Object[]{number});
        return super.getElectronContainer(number);
    }

    public IBond getBond(IAtom atom1, IAtom atom2) {
        logger.debug((Object)("Getting bond for atoms: atom1=" + atom1), new Object[]{" atom2=" + atom2});
        return super.getBond(atom1, atom2);
    }

    public int getAtomCount() {
        logger.debug((Object)"Getting atom count");
        return super.getAtomCount();
    }

    public int getBondCount() {
        logger.debug((Object)"Getting bond count");
        return super.getBondCount();
    }

    public int getLonePairCount() {
        logger.debug((Object)"Getting lone pair count");
        return super.getLonePairCount();
    }

    public int getSingleElectronCount() {
        logger.debug((Object)"Getting single electron count");
        return super.getSingleElectronCount();
    }

    public int getElectronContainerCount() {
        logger.debug((Object)"Getting electron container count");
        return super.getElectronContainerCount();
    }

    public List<IAtom> getConnectedAtomsList(IAtom atom) {
        logger.debug((Object)"Getting connecting atoms vector for atom: ", new Object[]{atom});
        return super.getConnectedAtomsList(atom);
    }

    public List<IBond> getConnectedBondsList(IAtom atom) {
        logger.debug((Object)"Getting connected bonds vector for atom: ", new Object[]{atom});
        return super.getConnectedBondsList(atom);
    }

    public List<ILonePair> getConnectedLonePairsList(IAtom atom) {
        logger.debug((Object)("Getting lone pairs at atom: atom=" + atom), new Object[]{" lone pairs=" + super.getConnectedLonePairsCount(atom)});
        return super.getConnectedLonePairsList(atom);
    }

    public List<ISingleElectron> getConnectedSingleElectronsList(IAtom atom) {
        logger.debug((Object)("Getting single electrons at atom: atom=" + atom), new Object[]{" single electrons=" + super.getConnectedSingleElectronsCount(atom)});
        return super.getConnectedSingleElectronsList(atom);
    }

    public List<IElectronContainer> getConnectedElectronContainersList(IAtom atom) {
        logger.debug((Object)"Getting connected electron containers for atom: ", new Object[]{atom});
        return super.getConnectedElectronContainersList(atom);
    }

    public int getConnectedAtomsCount(IAtom atom) {
        logger.debug((Object)"Getting connected atoms count for atom: ", new Object[]{atom});
        return super.getConnectedAtomsCount(atom);
    }

    public int getConnectedBondsCount(IAtom atom) {
        logger.debug((Object)"Getting connected bonds count for atom: ", new Object[]{atom});
        return super.getConnectedBondsCount(atom);
    }

    public int getConnectedLonePairsCount(IAtom atom) {
        logger.debug((Object)"Getting connected lone pairs count for atom: ", new Object[]{atom});
        return super.getConnectedLonePairsCount(atom);
    }

    public int getConnectedSingleElectronsCount(IAtom atom) {
        logger.debug((Object)"Getting connected single electrons count for atom: ", new Object[]{atom});
        return super.getConnectedSingleElectronsCount(atom);
    }

    public double getBondOrderSum(IAtom atom) {
        logger.debug((Object)"Getting bond order sum for atom: ", new Object[]{atom});
        return super.getBondOrderSum(atom);
    }

    public IBond.Order getMaximumBondOrder(IAtom atom) {
        logger.debug((Object)"Getting maximum bond order for atom: ", new Object[]{atom});
        return super.getMaximumBondOrder(atom);
    }

    public IBond.Order getMinimumBondOrder(IAtom atom) {
        logger.debug((Object)"Getting minimum bond order for atom: ", new Object[]{atom});
        return super.getMinimumBondOrder(atom);
    }

    public void add(IAtomContainer atomContainer) {
        logger.debug((Object)"Adding atom container: ", new Object[]{atomContainer});
        super.add(atomContainer);
    }

    public void addAtom(IAtom atom) {
        logger.debug((Object)"Adding atom: ", new Object[]{atom});
        super.addAtom(atom);
    }

    public void addBond(IBond bond) {
        logger.debug((Object)"Adding bond: ", new Object[]{bond});
        super.addBond(bond);
    }

    public void addLonePair(ILonePair ec) {
        logger.debug((Object)"Adding lone pair: ", new Object[]{ec});
        super.addLonePair(ec);
    }

    public void addSingleElectron(ISingleElectron ec) {
        logger.debug((Object)"Adding single electron: ", new Object[]{ec});
        super.addSingleElectron(ec);
    }

    public void addElectronContainer(IElectronContainer electronContainer) {
        logger.debug((Object)"Adding electron container: ", new Object[]{electronContainer});
        super.addElectronContainer(electronContainer);
    }

    public void remove(IAtomContainer atomContainer) {
        logger.debug((Object)"Removing atom container: ", new Object[]{atomContainer});
        super.remove(atomContainer);
    }

    public IElectronContainer removeElectronContainer(int position) {
        logger.debug((Object)"Removing electronContainer: ", new Object[]{position});
        return super.removeElectronContainer(position);
    }

    public void removeElectronContainer(IElectronContainer electronContainer) {
        logger.debug((Object)"Removing electron container: ", new Object[]{electronContainer});
        super.removeElectronContainer(electronContainer);
    }

    public void removeAtomOnly(int position) {
        logger.debug((Object)"Removing atom: ", new Object[]{position});
        super.removeAtomOnly(position);
    }

    public void removeAtomOnly(IAtom atom) {
        logger.debug((Object)"Removing atom: ", new Object[]{atom});
        super.removeAtomOnly(atom);
    }

    public IBond removeBond(int pos) {
        logger.debug((Object)("Removing bond at " + pos));
        return super.removeBond(pos);
    }

    public IBond removeBond(IAtom atom1, IAtom atom2) {
        logger.debug((Object)("Removing bond: atom1=" + atom1 + " atom2=" + atom2));
        return super.removeBond(atom1, atom2);
    }

    public void removeBond(IBond bond) {
        logger.debug((Object)("Removing bond=" + bond));
        super.removeBond(bond);
    }

    public ILonePair removeLonePair(int pos) {
        logger.debug((Object)("Removing bond at " + pos));
        return super.removeLonePair(pos);
    }

    public void removeLonePair(ILonePair ec) {
        logger.debug((Object)("Removing bond=" + ec));
        super.removeLonePair(ec);
    }

    public ISingleElectron removeSingleElectron(int pos) {
        logger.debug((Object)("Removing bond at " + pos));
        return super.removeSingleElectron(pos);
    }

    public void removeSingleElectron(ISingleElectron ec) {
        logger.debug((Object)("Removing bond=" + ec));
        super.removeSingleElectron(ec);
    }

    public void removeAtom(IAtom atom) {
        logger.debug((Object)"Removing atom and connected electron containers: ", new Object[]{atom});
        super.removeAtom(atom);
    }

    public void removeAllElements() {
        logger.debug((Object)"Removing all elements");
        super.removeAllElements();
    }

    public void removeAllElectronContainers() {
        logger.debug((Object)"Removing all electron containers");
        super.removeAllElectronContainers();
    }

    public void removeAllBonds() {
        logger.debug((Object)"Removing all bonds");
        super.removeAllBonds();
    }

    public void addBond(int atom1, int atom2, IBond.Order order, IBond.Stereo stereo) {
        logger.debug((Object)("Adding bond: atom1=" + atom1 + " atom2=" + atom2), new Object[]{" order=" + order + " stereo=" + stereo});
        super.addBond(atom1, atom2, order, stereo);
    }

    public void addBond(int atom1, int atom2, IBond.Order order) {
        logger.debug((Object)("Adding bond: atom1=" + atom1 + " atom2=" + atom2), new Object[]{" order=" + order});
        super.addBond(atom1, atom2, order);
    }

    public void addLonePair(int atomID) {
        logger.debug((Object)"Adding lone pair: ", new Object[]{atomID});
        super.addLonePair(atomID);
    }

    public void addSingleElectron(int atomID) {
        logger.debug((Object)"Adding single electron: ", new Object[]{atomID});
        super.addSingleElectron(atomID);
    }

    public boolean contains(IAtom atom) {
        logger.debug((Object)"Contains atom: ", new Object[]{atom});
        return super.contains(atom);
    }

    public boolean contains(IBond bond) {
        logger.debug((Object)"Contains bond: ", new Object[]{bond});
        return super.contains(bond);
    }

    public boolean contains(ILonePair ec) {
        logger.debug((Object)"Contains lone pair: ", new Object[]{ec});
        return super.contains(ec);
    }

    public boolean contains(ISingleElectron ec) {
        logger.debug((Object)"Contains single electron: ", new Object[]{ec});
        return super.contains(ec);
    }

    public boolean contains(IElectronContainer electronContainer) {
        logger.debug((Object)"Contains electron container: ", new Object[]{electronContainer});
        return super.contains(electronContainer);
    }

    public void addListener(IChemObjectListener col) {
        logger.debug((Object)"Adding listener: ", new Object[]{col});
        super.addListener(col);
    }

    public int getListenerCount() {
        logger.debug((Object)"Getting listener count: ", new Object[]{super.getListenerCount()});
        return super.getListenerCount();
    }

    public void removeListener(IChemObjectListener col) {
        logger.debug((Object)"Removing listener: ", new Object[]{col});
        super.removeListener(col);
    }

    public void notifyChanged() {
        logger.debug((Object)"Notifying changed");
        super.notifyChanged();
    }

    public void notifyChanged(IChemObjectChangeEvent evt) {
        logger.debug((Object)"Notifying changed event: ", new Object[]{evt});
        super.notifyChanged(evt);
    }

    public void setProperty(Object description, Object property) {
        logger.debug((Object)"Setting property: ", new Object[]{description + "=" + property});
        super.setProperty(description, property);
    }

    public void removeProperty(Object description) {
        logger.debug((Object)"Removing property: ", new Object[]{description});
        super.removeProperty(description);
    }

    public <T> T getProperty(Object description) {
        logger.debug((Object)"Getting property: ", new Object[]{description + "=" + super.getProperty(description)});
        return (T)super.getProperty(description);
    }

    public Map<Object, Object> getProperties() {
        logger.debug((Object)"Getting properties");
        return super.getProperties();
    }

    public String getID() {
        logger.debug((Object)"Getting ID: ", new Object[]{super.getID()});
        return super.getID();
    }

    public void setID(String identifier) {
        logger.debug((Object)"Setting ID: ", new Object[]{identifier});
        super.setID(identifier);
    }

    public void setFlag(int flagType, boolean flagValue) {
        logger.debug((Object)"Setting flag: ", new Object[]{flagType + "=" + flagValue});
        super.setFlag(flagType, flagValue);
    }

    public boolean getFlag(int flagType) {
        logger.debug((Object)"Setting flag: ", new Object[]{flagType + "=" + super.getFlag(flagType)});
        return super.getFlag(flagType);
    }

    public void addProperties(Map<Object, Object> properties) {
        logger.debug((Object)"Setting properties: ", new Object[]{properties});
        super.addProperties(properties);
    }

    public void setFlags(boolean[] flagsNew) {
        logger.debug((Object)"Setting flags:", new Object[]{flagsNew.length});
        super.setFlags(flagsNew);
    }

    public boolean[] getFlags() {
        logger.debug((Object)"Getting flags:", new Object[]{super.getFlags().length});
        return super.getFlags();
    }

    public IRing clone() throws CloneNotSupportedException {
        IRing clone = null;
        try {
            clone = super.clone();
        }
        catch (Exception exception) {
            logger.error((Object)("Could not clone DebugAtom: " + exception.getMessage()), new Object[]{exception});
            logger.debug((Object)exception);
        }
        return clone;
    }

    public IChemObjectBuilder getBuilder() {
        return DebugChemObjectBuilder.getInstance();
    }

    public int getRingSize() {
        logger.debug((Object)"Getting Ring size:", new Object[]{super.getRingSize()});
        return super.getRingSize();
    }

    public IBond getNextBond(IBond bond, IAtom atom) {
        logger.debug((Object)"Getting next bond: ", new Object[]{super.getNextBond(bond, atom)});
        return super.getNextBond(bond, atom);
    }

    public int getBondOrderSum() {
        logger.debug((Object)"Getting order sum: ", new Object[]{super.getBondOrderSum()});
        return super.getBondOrderSum();
    }

    public void stateChanged(IChemObjectChangeEvent event) {
        logger.debug((Object)"State changed: ", new Object[]{event});
        super.stateChanged(event);
    }
}

