/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.depict;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import org.openscience.cdk.depict.Depiction;
import org.openscience.cdk.depict.DepictionGenerator;
import org.openscience.cdk.depict.Dimensions;
import org.openscience.cdk.depict.FreeHepWrapper;
import org.openscience.cdk.depict.SvgDrawVisitor;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.renderer.RendererModel;
import org.openscience.cdk.renderer.elements.Bounds;
import org.openscience.cdk.renderer.elements.GeneralPath;
import org.openscience.cdk.renderer.elements.IRenderingElement;
import org.openscience.cdk.renderer.elements.LineElement;
import org.openscience.cdk.renderer.elements.RectangleElement;
import org.openscience.cdk.renderer.generators.BasicSceneGenerator;
import org.openscience.cdk.renderer.visitor.AWTDrawVisitor;
import org.openscience.cdk.renderer.visitor.IDrawVisitor;

final class ReactionDepiction
extends Depiction {
    private final RendererModel model;
    private final Dimensions dimensions;
    private final List<Bounds> mainComp = new ArrayList<Bounds>();
    private final List<Bounds> sideComps = new ArrayList<Bounds>();
    private final Bounds conditions;
    private final Bounds title;
    private final int arrowIdx;
    private final IReaction.Direction direction;
    private final double arrowHeight;
    private final double minArrowWidth;
    private final Dimensions sideDim;
    private final Dimensions mainDim;
    private final Dimensions condDim;
    private final double[] xOffsets;
    private final double[] yOffsets;
    private final double[] xOffsetSide;
    private final double[] yOffsetSide;
    private final int nRow;
    private final int nCol;
    private final Color fgcol;

    public ReactionDepiction(RendererModel model, List<Bounds> reactants, List<Bounds> products, List<Bounds> agents, Bounds plus, IReaction.Direction direction, Dimensions dimensions, List<Bounds> reactantTitles, List<Bounds> productTitles, Bounds title, Bounds conditions, Color fgcol) {
        super(model);
        this.model = model;
        this.dimensions = dimensions;
        this.title = title;
        this.fgcol = fgcol;
        this.sideComps.addAll(agents);
        Dimension sideGrid = Dimensions.determineGrid(this.sideComps.size());
        this.yOffsetSide = new double[sideGrid.width + 1];
        this.xOffsetSide = new double[sideGrid.height + 1];
        Dimensions prelimSideDim = Dimensions.ofGrid(this.sideComps, this.yOffsetSide, this.xOffsetSide);
        for (Bounds reactant : reactants) {
            this.mainComp.add(reactant);
            this.mainComp.add(plus);
        }
        if (reactants.isEmpty()) {
            this.mainComp.add(new Bounds());
        } else {
            this.mainComp.set(this.mainComp.size() - 1, new Bounds());
        }
        for (Bounds product : products) {
            this.mainComp.add(product);
            this.mainComp.add(plus);
        }
        if (!products.isEmpty()) {
            this.mainComp.remove(this.mainComp.size() - 1);
        }
        if (!reactantTitles.isEmpty() || !productTitles.isEmpty()) {
            if (!reactantTitles.isEmpty() && reactantTitles.size() != reactants.size()) {
                throw new IllegalArgumentException("Number of reactant titles differed from number of reactants");
            }
            if (!productTitles.isEmpty() && productTitles.size() != products.size()) {
                throw new IllegalArgumentException("Number of product titles differed from number of products");
            }
            ArrayList<Bounds> mainTitles = new ArrayList<Bounds>();
            for (Bounds reactantTitle : reactantTitles) {
                mainTitles.add(reactantTitle);
                mainTitles.add(new Bounds());
            }
            if (reactants.isEmpty()) {
                mainTitles.add(new Bounds());
            }
            for (Bounds productTitle : productTitles) {
                mainTitles.add(productTitle);
                mainTitles.add(new Bounds());
            }
            if (!products.isEmpty()) {
                mainTitles.remove(mainTitles.size() - 1);
            }
            assert (mainTitles.size() == this.mainComp.size());
            this.mainComp.addAll(mainTitles);
            this.nRow = 2;
            this.nCol = this.mainComp.size() / 2;
        } else {
            this.nRow = 1;
            this.nCol = this.mainComp.size();
        }
        this.conditions = conditions;
        this.arrowIdx = Math.max(reactants.size() + reactants.size() - 1, 0);
        this.direction = direction;
        this.arrowHeight = plus.height();
        this.minArrowWidth = 4.0 * this.arrowHeight;
        this.yOffsets = new double[this.nRow + 1];
        this.xOffsets = new double[this.nCol + 1];
        this.mainDim = Dimensions.ofGrid(this.mainComp, this.yOffsets, this.xOffsets);
        double middleRequired = Math.max(prelimSideDim.w, conditions.width());
        if (middleRequired < this.minArrowWidth - this.arrowHeight - this.arrowHeight) {
            double xAdjust = (this.minArrowWidth - middleRequired) / 2.0;
            int i = 0;
            while (i < this.xOffsetSide.length) {
                int n = i++;
                this.xOffsetSide[n] = this.xOffsetSide[n] + xAdjust;
            }
            if (conditions.width() > prelimSideDim.w) {
                i = 0;
                while (i < this.xOffsetSide.length) {
                    int n = i++;
                    this.xOffsetSide[n] = this.xOffsetSide[n] + (conditions.width() - prelimSideDim.w) / 2.0;
                }
            }
            this.sideDim = new Dimensions(this.minArrowWidth, prelimSideDim.h);
            this.condDim = new Dimensions(this.minArrowWidth, conditions.height());
        } else {
            int i = 0;
            while (i < this.xOffsetSide.length) {
                int n = i++;
                this.xOffsetSide[n] = this.xOffsetSide[n] + this.arrowHeight;
            }
            if (conditions.width() > prelimSideDim.w) {
                i = 0;
                while (i < this.xOffsetSide.length) {
                    int n = i++;
                    this.xOffsetSide[n] = this.xOffsetSide[n] + (conditions.width() - prelimSideDim.w) / 2.0;
                }
            }
            this.sideDim = new Dimensions(2.0 * this.arrowHeight + middleRequired, prelimSideDim.h);
            this.condDim = new Dimensions(2.0 * this.arrowHeight + middleRequired, conditions.height());
        }
    }

    @Override
    public BufferedImage toImg() {
        double h;
        double w;
        double y;
        double x;
        int row;
        int i;
        double scale = (Double)this.model.get(BasicSceneGenerator.Scale.class);
        double zoom = (Double)this.model.get(BasicSceneGenerator.ZoomFactor.class);
        double margin = this.getMarginValue(DepictionGenerator.DEFAULT_PX_MARGIN);
        double padding = this.getPaddingValue(2.0 * margin);
        int nSideCol = this.xOffsetSide.length - 1;
        int nSideRow = this.yOffsetSide.length - 1;
        Dimensions sideRequired = this.sideDim.scale(scale * zoom);
        Dimensions mainRequired = this.mainDim.scale(scale * zoom);
        Dimensions condRequired = this.condDim.scale(scale * zoom);
        Dimensions titleRequired = new Dimensions(this.title.width(), this.title.height()).scale(scale * zoom);
        double firstRowHeight = scale * zoom * this.yOffsets[1];
        Dimensions total = this.calcTotalDimensions(margin, padding, mainRequired, sideRequired, titleRequired, firstRowHeight, null);
        double fitting = this.calcFitting(margin, padding, mainRequired, sideRequired, titleRequired, firstRowHeight, null);
        BufferedImage img = new BufferedImage((int)Math.ceil(total.w), (int)Math.ceil(total.h), 6);
        Graphics2D g2 = img.createGraphics();
        AWTDrawVisitor visitor = AWTDrawVisitor.forVectorGraphics((Graphics2D)g2);
        visitor.setTransform(AffineTransform.getScaleInstance(1.0, -1.0));
        visitor.visit((IRenderingElement)new RectangleElement(0.0, (double)(-((int)Math.ceil(total.h))), (double)((int)Math.ceil(total.w)), (double)((int)Math.ceil(total.h)), true, (Color)this.model.get(BasicSceneGenerator.BackgroundColor.class)));
        double rescale = zoom * fitting * scale;
        double mainCompOffset = 0.0;
        mainCompOffset = fitting * sideRequired.h + (double)nSideRow * padding - fitting * firstRowHeight / 2.0;
        int i2 = this.arrowIdx + 1;
        while (i2 < this.xOffsets.length) {
            int n = i2++;
            this.xOffsets[n] = this.xOffsets[n] + sideRequired.w * 1.0 / (scale * zoom);
        }
        double totalRequiredWidth = 2.0 * margin + (double)Math.max(0, this.nCol - 1) * padding + (double)Math.max(0, nSideCol - 1) * padding + rescale * this.xOffsets[this.nCol];
        double totalRequiredHeight = 2.0 * margin + (double)Math.max(0, this.nRow - 1) * padding + (!this.title.isEmpty() ? padding : 0.0) + Math.max(mainCompOffset, 0.0) + fitting * mainRequired.h + fitting * Math.max(0.0, titleRequired.h);
        double xBase = margin + (total.w - totalRequiredWidth) / 2.0;
        double yBase = margin + Math.max(mainCompOffset, 0.0) + (total.h - totalRequiredHeight) / 2.0;
        for (i = 0; i < this.mainComp.size(); ++i) {
            Bounds bounds;
            row = i / this.nCol;
            int col = i % this.nCol;
            x = xBase + (double)col * padding + rescale * this.xOffsets[col];
            y = yBase + (double)row * padding + rescale * this.yOffsets[row];
            w = rescale * (this.xOffsets[col + 1] - this.xOffsets[col]);
            h = rescale * (this.yOffsets[row + 1] - this.yOffsets[row]);
            if (i == this.arrowIdx) {
                w = rescale * (this.xOffsets[i + 1] - this.xOffsets[i]) + (double)Math.max(0, nSideCol - 1) * padding;
                this.draw((IDrawVisitor)visitor, 1.0, this.createArrow(w, this.arrowHeight * rescale), this.rect(x, y, w, h));
                continue;
            }
            if (i > this.arrowIdx) {
                x += (double)Math.max(0, nSideCol - 1) * padding;
            }
            if ((bounds = this.mainComp.get(i)).isEmpty()) continue;
            this.draw((IDrawVisitor)visitor, zoom, bounds, this.rect(x, y, w, h));
        }
        if (!this.title.isEmpty()) {
            double y2 = yBase + (double)this.nRow * padding + rescale * this.yOffsets[this.nRow];
            double h2 = rescale * this.title.height();
            this.draw((IDrawVisitor)visitor, zoom, this.title, this.rect(0.0, y2, total.w, h2));
        }
        xBase += (double)this.arrowIdx * padding + rescale * this.xOffsets[this.arrowIdx];
        yBase -= mainCompOffset;
        for (i = 0; i < this.sideComps.size(); ++i) {
            row = i / nSideCol;
            int col = i % nSideCol;
            x = xBase + (double)col * padding + rescale * this.xOffsetSide[col];
            y = yBase + (double)row * padding + rescale * this.yOffsetSide[row];
            w = rescale * (this.xOffsetSide[col + 1] - this.xOffsetSide[col]);
            h = rescale * (this.yOffsetSide[row + 1] - this.yOffsetSide[row]);
            this.draw((IDrawVisitor)visitor, zoom, this.sideComps.get(i), this.rect(x, y, w, h));
        }
        if (!this.conditions.isEmpty()) {
            yBase += mainCompOffset;
            yBase += fitting * mainRequired.h / 2.0;
            this.draw((IDrawVisitor)visitor, zoom, this.conditions, this.rect(xBase, yBase += this.arrowHeight, fitting * condRequired.w, fitting * condRequired.h));
        }
        if (!this.sideComps.isEmpty()) {
            i = this.arrowIdx + 1;
            while (i < this.xOffsets.length) {
                int n = i++;
                this.xOffsets[n] = this.xOffsets[n] - sideRequired.w * 1.0 / (scale * zoom);
            }
        }
        g2.dispose();
        return img;
    }

    @Override
    String toVecStr(String fmt) {
        double h;
        double w;
        double y;
        double x;
        int row;
        int i;
        SvgDrawVisitor visitor;
        double scale = (Double)this.model.get(BasicSceneGenerator.Scale.class);
        double margin = this.getMarginValue(DepictionGenerator.DEFAULT_MM_MARGIN);
        double padding = this.getPaddingValue(2.0 * margin);
        double zoom = (Double)this.model.get(BasicSceneGenerator.ZoomFactor.class) * this.rescaleForBondLength(5.08);
        if (fmt.equals("pdf") || fmt.equals("ps")) {
            zoom *= 2.83464566751;
            margin *= 2.83464566751;
            padding *= 2.83464566751;
        }
        int nSideCol = this.xOffsetSide.length - 1;
        int nSideRow = this.yOffsetSide.length - 1;
        Dimensions sideRequired = this.sideDim.scale(scale * zoom);
        Dimensions mainRequired = this.mainDim.scale(scale * zoom);
        Dimensions condRequired = this.condDim.scale(scale * zoom);
        Dimensions titleRequired = new Dimensions(this.title.width(), this.title.height()).scale(scale * zoom);
        double firstRowHeight = scale * zoom * this.yOffsets[1];
        Dimensions total = this.calcTotalDimensions(margin, padding, mainRequired, sideRequired, titleRequired, firstRowHeight, fmt);
        double fitting = this.calcFitting(margin, padding, mainRequired, sideRequired, titleRequired, firstRowHeight, fmt);
        FreeHepWrapper wrapper = null;
        if (!fmt.equals("svg")) {
            wrapper = new FreeHepWrapper(fmt, total.w, total.h);
        }
        SvgDrawVisitor svgDrawVisitor = visitor = fmt.equals("svg") ? new SvgDrawVisitor(total.w, total.h) : AWTDrawVisitor.forVectorGraphics((Graphics2D)wrapper.g2);
        if (fmt.equals("svg")) {
            this.svgPrevisit(fmt, scale * zoom * fitting, visitor, this.mainComp);
        } else {
            ((AWTDrawVisitor)visitor).setRounding(false);
        }
        visitor.setTransform(AffineTransform.getScaleInstance(1.0, -1.0));
        visitor.visit((IRenderingElement)new RectangleElement(0.0, (double)(-((int)Math.ceil(total.h))), (double)((int)Math.ceil(total.w)), (double)((int)Math.ceil(total.h)), true, (Color)this.model.get(BasicSceneGenerator.BackgroundColor.class)));
        double rescale = zoom * fitting * scale;
        double mainCompOffset = 0.0;
        mainCompOffset = fitting * sideRequired.h + (double)nSideRow * padding - fitting * firstRowHeight / 2.0;
        int i2 = this.arrowIdx + 1;
        while (i2 < this.xOffsets.length) {
            int n = i2++;
            this.xOffsets[n] = this.xOffsets[n] + sideRequired.w * 1.0 / (scale * zoom);
        }
        double totalRequiredWidth = 2.0 * margin + (double)Math.max(0, this.nCol - 1) * padding + (double)Math.max(0, nSideCol - 1) * padding + rescale * this.xOffsets[this.nCol];
        double totalRequiredHeight = 2.0 * margin + (double)Math.max(0, this.nRow - 1) * padding + (!this.title.isEmpty() ? padding : 0.0) + Math.max(mainCompOffset, 0.0) + fitting * mainRequired.h + fitting * Math.max(0.0, titleRequired.h);
        double xBase = margin + (total.w - totalRequiredWidth) / 2.0;
        double yBase = margin + Math.max(mainCompOffset, 0.0) + (total.h - totalRequiredHeight) / 2.0;
        for (i = 0; i < this.mainComp.size(); ++i) {
            Bounds bounds;
            row = i / this.nCol;
            int col = i % this.nCol;
            x = xBase + (double)col * padding + rescale * this.xOffsets[col];
            y = yBase + (double)row * padding + rescale * this.yOffsets[row];
            w = rescale * (this.xOffsets[col + 1] - this.xOffsets[col]);
            h = rescale * (this.yOffsets[row + 1] - this.yOffsets[row]);
            if (i == this.arrowIdx) {
                w = rescale * (this.xOffsets[i + 1] - this.xOffsets[i]) + (double)Math.max(0, nSideCol - 1) * padding;
                this.draw(visitor, 1.0, this.createArrow(w, this.arrowHeight * rescale), this.rect(x, y, w, h));
                continue;
            }
            if (i > this.arrowIdx) {
                x += (double)Math.max(0, nSideCol - 1) * padding;
            }
            if ((bounds = this.mainComp.get(i)).isEmpty()) continue;
            this.draw(visitor, zoom, bounds, this.rect(x, y, w, h));
        }
        if (!this.title.isEmpty()) {
            double y2 = yBase + (double)this.nRow * padding + rescale * this.yOffsets[this.nRow];
            double h2 = rescale * this.title.height();
            this.draw(visitor, zoom, this.title, this.rect(0.0, y2, total.w, h2));
        }
        xBase += (double)this.arrowIdx * padding + rescale * this.xOffsets[this.arrowIdx];
        yBase -= mainCompOffset;
        for (i = 0; i < this.sideComps.size(); ++i) {
            row = i / nSideCol;
            int col = i % nSideCol;
            x = xBase + (double)col * padding + rescale * this.xOffsetSide[col];
            y = yBase + (double)row * padding + rescale * this.yOffsetSide[row];
            w = rescale * (this.xOffsetSide[col + 1] - this.xOffsetSide[col]);
            h = rescale * (this.yOffsetSide[row + 1] - this.yOffsetSide[row]);
            this.draw(visitor, zoom, this.sideComps.get(i), this.rect(x, y, w, h));
        }
        if (!this.conditions.isEmpty()) {
            yBase += mainCompOffset;
            yBase += fitting * mainRequired.h / 2.0;
            this.draw(visitor, zoom, this.conditions, this.rect(xBase, yBase += this.arrowHeight, fitting * condRequired.w, fitting * condRequired.h));
        }
        if (!this.sideComps.isEmpty()) {
            i = this.arrowIdx + 1;
            while (i < this.xOffsets.length) {
                int n = i++;
                this.xOffsets[n] = this.xOffsets[n] - sideRequired.w * 1.0 / (scale * zoom);
            }
        }
        if (wrapper != null) {
            wrapper.dispose();
            return wrapper.toString();
        }
        return ((Object)visitor).toString();
    }

    private double calcFitting(double margin, double padding, Dimensions mainRequired, Dimensions sideRequired, Dimensions titleRequired, double firstRowHeight, String fmt) {
        double resize;
        double mainCompOffset;
        if (this.dimensions == Dimensions.AUTOMATIC) {
            return 1.0;
        }
        int nSideCol = this.xOffsetSide.length - 1;
        int nSideRow = this.yOffsetSide.length - 1;
        double d = mainCompOffset = sideRequired.h > 0.0 ? sideRequired.h + (double)nSideRow * padding - firstRowHeight / 2.0 : 0.0;
        if (mainCompOffset < 0.0) {
            mainCompOffset = 0.0;
        }
        Dimensions required = mainRequired.add(sideRequired.w, mainCompOffset).add(0.0, Math.max(0.0, titleRequired.h));
        Dimensions targetDim = this.dimensions;
        targetDim = targetDim.add(-2.0 * margin, -2.0 * margin).add(-((double)(this.nCol - 1) * padding), -((double)(this.nRow - 1) * padding)).add((double)(-(nSideCol - 1)) * padding, (double)(-(nSideRow - 1)) * padding).add(0.0, titleRequired.h > 0.0 ? -padding : 0.0);
        if ("pdf".equals(fmt) || "ps".equals(fmt)) {
            targetDim = targetDim.scale(2.83464566751);
        }
        if ((resize = Math.min(targetDim.w / required.w, targetDim.h / required.h)) > 1.0 && !((Boolean)this.model.get(BasicSceneGenerator.FitToScreen.class)).booleanValue()) {
            resize = 1.0;
        }
        return resize;
    }

    private Dimensions calcTotalDimensions(double margin, double padding, Dimensions mainRequired, Dimensions sideRequired, Dimensions titleRequired, double firstRowHeight, String fmt) {
        if (this.dimensions == Dimensions.AUTOMATIC) {
            double titleExtra;
            int nSideCol = this.xOffsetSide.length - 1;
            int nSideRow = this.yOffsetSide.length - 1;
            double mainCompOffset = sideRequired.h + (double)nSideRow * padding - firstRowHeight / 2.0;
            if (mainCompOffset < 0.0) {
                mainCompOffset = 0.0;
            }
            if ((titleExtra = Math.max(0.0, titleRequired.h)) > 0.0) {
                titleExtra += padding;
            }
            return mainRequired.add(2.0 * margin, 2.0 * margin).add((double)Math.max(0, this.nCol - 1) * padding, (double)(this.nRow - 1) * padding).add(Math.max(0.0, sideRequired.w), 0.0).add((double)Math.max(0, nSideCol - 1) * padding, 0.0).add(0.0, mainCompOffset).add(0.0, titleExtra);
        }
        if ("pdf".equals(fmt) || "ps".equals(fmt)) {
            return this.dimensions.scale(2.83464566751);
        }
        return this.dimensions;
    }

    private Rectangle2D.Double rect(double x, double y, double w, double h) {
        return new Rectangle2D.Double(x, y, w, h);
    }

    private Bounds createArrow(double minWidth, double minHeight) {
        Bounds arrow = new Bounds();
        Path2D.Double path = new Path2D.Double();
        double headThickness = minHeight / 3.0;
        double inset = 0.8;
        double headLength = minHeight;
        switch (this.direction) {
            case FORWARD: {
                arrow.add((IRenderingElement)new LineElement(0.0, 0.0, minWidth - 0.5 * headLength, 0.0, minHeight / 14.0, this.fgcol));
                ((Path2D)path).moveTo(minWidth, 0.0);
                ((Path2D)path).lineTo(minWidth - headLength, headThickness);
                ((Path2D)path).lineTo(minWidth - 0.8 * headLength, 0.0);
                ((Path2D)path).lineTo(minWidth - headLength, -headThickness);
                path.closePath();
                arrow.add((IRenderingElement)GeneralPath.shapeOf((Shape)path, (Color)this.fgcol));
                break;
            }
            case BACKWARD: {
                arrow.add((IRenderingElement)new LineElement(0.5 * headLength, 0.0, minWidth, 0.0, minHeight / 14.0, this.fgcol));
                ((Path2D)path).moveTo(0.0, 0.0);
                ((Path2D)path).lineTo(minHeight, headThickness);
                ((Path2D)path).lineTo(minHeight - 0.19999999999999996 * minHeight, 0.0);
                ((Path2D)path).lineTo(minHeight, -headThickness);
                path.closePath();
                arrow.add((IRenderingElement)GeneralPath.shapeOf((Shape)path, (Color)this.fgcol));
                break;
            }
            case BIDIRECTIONAL: {
                ((Path2D)path).moveTo(0.0, 0.5 * headThickness);
                ((Path2D)path).lineTo(minWidth + minHeight + minHeight, 0.5 * headThickness);
                ((Path2D)path).lineTo(minWidth + minHeight, 1.5 * headThickness);
                ((Path2D)path).moveTo(minWidth + minHeight + minHeight, 0.5 * -headThickness);
                ((Path2D)path).lineTo(0.0, 0.5 * -headThickness);
                ((Path2D)path).lineTo(minHeight, 1.5 * -headThickness);
                arrow.add((IRenderingElement)GeneralPath.outlineOf((Shape)path, (double)(minHeight / 14.0), (Color)this.fgcol));
            }
        }
        return arrow;
    }
}

