/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.depict;

import com.google.common.base.Joiner;
import com.google.common.xml.XmlEscapers;
import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.openscience.cdk.renderer.RendererModel;
import org.openscience.cdk.renderer.elements.Bounds;
import org.openscience.cdk.renderer.elements.ElementGroup;
import org.openscience.cdk.renderer.elements.GeneralPath;
import org.openscience.cdk.renderer.elements.IRenderingElement;
import org.openscience.cdk.renderer.elements.LineElement;
import org.openscience.cdk.renderer.elements.MarkedElement;
import org.openscience.cdk.renderer.elements.OvalElement;
import org.openscience.cdk.renderer.elements.RectangleElement;
import org.openscience.cdk.renderer.elements.TextElement;
import org.openscience.cdk.renderer.elements.path.PathElement;
import org.openscience.cdk.renderer.font.IFontManager;
import org.openscience.cdk.renderer.visitor.IDrawVisitor;

final class SvgDrawVisitor
implements IDrawVisitor {
    private final StringBuilder sb = new StringBuilder(5000);
    private int indentLvl = 0;
    private AffineTransform transform = null;
    private RendererModel model = null;
    private NumberFormat decimalFormat = new DecimalFormat(".##", new DecimalFormatSymbols(Locale.ROOT));
    private boolean defaultsWritten = false;
    private Color defaultStroke = null;
    private Color defaultFill = null;
    private String defaultStrokeWidth = null;

    SvgDrawVisitor(double w, double h) {
        this.writeHeader(w, h);
    }

    private void writeHeader(double w, double h) {
        this.sb.append("<?xml version='1.0' encoding='UTF-8'?>\n").append("<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 1.1//EN\" \"http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd\">\n");
        this.sb.append("<svg").append(" version='1.2'").append(" xmlns='http://www.w3.org/2000/svg'").append(" xmlns:xlink='http://www.w3.org/1999/xlink'").append(" width='").append(this.toStr(w)).append("mm'").append(" height='").append(this.toStr(h)).append("mm'").append(" viewBox='0 0 ").append(this.toStr(w)).append(" ").append(this.toStr(h)).append("'").append(">\n");
        this.indentLvl += 2;
        this.appendIdent();
        this.sb.append("<desc>Generated by the Chemistry Development Kit (http://github.com/cdk)</desc>\n");
    }

    private void appendIdent() {
        for (int i = 0; i < this.indentLvl; ++i) {
            this.sb.append(' ');
        }
    }

    private double scaled(double num) {
        if (this.transform == null) {
            return num;
        }
        return this.transform.getScaleX() * num;
    }

    private void transform(double[] points, int numPoints) {
        if (this.transform != null) {
            this.transform.transform(points, 0, points, 0, numPoints);
        }
    }

    private String toStr(double num) {
        return this.decimalFormat.format(num);
    }

    private void appendPoints(StringBuilder sb, double[] points, int numPoints) {
        switch (numPoints) {
            case 1: {
                sb.append(this.decimalFormat.format(points[0]));
                sb.append(' ');
                sb.append(this.decimalFormat.format(points[1]));
                break;
            }
            case 2: {
                sb.append(this.decimalFormat.format(points[0]));
                sb.append(' ');
                sb.append(this.decimalFormat.format(points[1]));
                sb.append(' ');
                sb.append(this.decimalFormat.format(points[2]));
                sb.append(' ');
                sb.append(this.decimalFormat.format(points[3]));
                break;
            }
            case 3: {
                sb.append(this.decimalFormat.format(points[0]));
                sb.append(' ');
                sb.append(this.decimalFormat.format(points[1]));
                sb.append(' ');
                sb.append(this.decimalFormat.format(points[2]));
                sb.append(' ');
                sb.append(this.decimalFormat.format(points[3]));
                sb.append(' ');
                sb.append(this.decimalFormat.format(points[4]));
                sb.append(' ');
                sb.append(this.decimalFormat.format(points[5]));
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    private void appendRelativePoints(StringBuilder sb, double[] points, double xBase, double yBase, int numPoints) {
        switch (numPoints) {
            case 1: {
                sb.append(this.decimalFormat.format(points[0] - xBase));
                sb.append(' ');
                sb.append(this.decimalFormat.format(points[1] - yBase));
                break;
            }
            case 2: {
                sb.append(this.decimalFormat.format(points[0] - xBase));
                sb.append(' ');
                sb.append(this.decimalFormat.format(points[1] - yBase));
                sb.append(' ');
                sb.append(this.decimalFormat.format(points[2] - xBase));
                sb.append(' ');
                sb.append(this.decimalFormat.format(points[3] - yBase));
                break;
            }
            case 3: {
                sb.append(this.decimalFormat.format(points[0] - xBase));
                sb.append(' ');
                sb.append(this.decimalFormat.format(points[1] - yBase));
                sb.append(' ');
                sb.append(this.decimalFormat.format(points[2] - xBase));
                sb.append(' ');
                sb.append(this.decimalFormat.format(points[3] - yBase));
                sb.append(' ');
                sb.append(this.decimalFormat.format(points[4] - xBase));
                sb.append(' ');
                sb.append(this.decimalFormat.format(points[5] - yBase));
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    String toStr(Color col) {
        if (col.getAlpha() == 255) {
            return String.format("#%06X", 0xFFFFFF & col.getRGB());
        }
        return String.format("rgba(%d,%d,%d,%.2f)", col.getRed(), col.getGreen(), col.getBlue(), (double)col.getAlpha() / 255.0);
    }

    public void setFontManager(IFontManager fontManager) {
    }

    public void setRendererModel(RendererModel model) {
        this.model = model;
    }

    public void previsit(Collection<? extends IRenderingElement> elements) {
        ArrayDeque<Object> queue = new ArrayDeque<Object>(2 * elements.size());
        queue.addAll(elements);
        FreqMap<Color> strokeFreq = new FreqMap<Color>();
        FreqMap<Color> fillFreq = new FreqMap<Color>();
        FreqMap<Double> strokeWidthFreq = new FreqMap<Double>();
        while (!queue.isEmpty()) {
            IRenderingElement element = (IRenderingElement)queue.poll();
            if (element instanceof Bounds) {
                queue.add(((Bounds)element).root());
                continue;
            }
            if (element instanceof MarkedElement) {
                queue.add(((MarkedElement)element).element());
                continue;
            }
            if (element instanceof ElementGroup) {
                for (IRenderingElement child : (ElementGroup)element) {
                    queue.add(child);
                }
                continue;
            }
            if (element instanceof LineElement) {
                strokeFreq.add(((LineElement)element).color);
                strokeWidthFreq.add(this.scaled(((LineElement)element).width));
                continue;
            }
            if (!(element instanceof GeneralPath) || !((GeneralPath)element).fill) continue;
            fillFreq.add(((GeneralPath)element).color);
        }
        if (!this.defaultsWritten) {
            this.defaultFill = (Color)fillFreq.getMostFrequent();
            this.defaultStroke = (Color)strokeFreq.getMostFrequent();
            Double strokeWidth = (Double)strokeWidthFreq.getMostFrequent();
            if (strokeWidth != null) {
                this.defaultStrokeWidth = this.toStr(strokeWidth);
            }
        }
    }

    private void visit(GeneralPath elem) {
        this.visit(null, null, elem);
    }

    private void visit(String id, String cls, GeneralPath elem) {
        this.appendIdent();
        this.sb.append("<path");
        if (id != null) {
            this.sb.append(" id='").append(id).append("'");
        }
        if (cls != null) {
            this.sb.append(" class='").append(cls).append("'");
        }
        this.sb.append(" d='");
        double[] points = new double[6];
        double xCurr = 0.0;
        double yCurr = 0.0;
        for (PathElement pelem : elem.elements) {
            pelem.points(points);
            switch (pelem.type) {
                case Close: {
                    this.sb.append("z");
                    yCurr = 0.0;
                    xCurr = 0.0;
                    break;
                }
                case LineTo: {
                    this.transform(points, 1);
                    double dx = points[0] - xCurr;
                    double dy = points[1] - yCurr;
                    if (Math.abs(dx) < 0.01) {
                        this.sb.append("v").append(this.toStr(dy));
                    } else if (Math.abs(dy) < 0.01) {
                        this.sb.append("h").append(this.toStr(dx));
                    } else {
                        this.sb.append("l");
                        this.appendRelativePoints(this.sb, points, xCurr, yCurr, 1);
                    }
                    xCurr = points[0];
                    yCurr = points[1];
                    break;
                }
                case MoveTo: {
                    this.sb.append("M");
                    this.transform(points, 1);
                    this.appendPoints(this.sb, points, 1);
                    xCurr = points[0];
                    yCurr = points[1];
                    break;
                }
                case QuadTo: {
                    this.sb.append("q");
                    this.transform(points, 2);
                    this.appendRelativePoints(this.sb, points, xCurr, yCurr, 2);
                    xCurr = points[2];
                    yCurr = points[3];
                    break;
                }
                case CubicTo: {
                    this.sb.append("c");
                    this.transform(points, 3);
                    this.appendRelativePoints(this.sb, points, xCurr, yCurr, 3);
                    xCurr = points[4];
                    yCurr = points[5];
                }
            }
        }
        this.sb.append("'");
        if (elem.fill) {
            this.sb.append(" stroke='none'");
            if (this.defaultFill == null || !this.defaultFill.equals(elem.color)) {
                this.sb.append(" fill='").append(this.toStr(elem.color)).append("'");
            }
        } else {
            this.sb.append(" fill='none'");
            this.sb.append(" stroke='").append(this.toStr(elem.color)).append("'");
            this.sb.append(" stroke-width='").append(this.toStr(this.scaled(elem.stroke))).append("'");
        }
        this.sb.append("/>\n");
    }

    private void visit(LineElement elem) {
        this.visit(null, null, elem);
    }

    private void visit(String id, String cls, LineElement elem) {
        double[] points = new double[]{elem.firstPointX, elem.firstPointY, elem.secondPointX, elem.secondPointY};
        this.transform(points, 2);
        this.appendIdent();
        this.sb.append("<line");
        if (id != null) {
            this.sb.append(" id='").append(id).append("'");
        }
        if (cls != null) {
            this.sb.append(" class='").append(cls).append("'");
        }
        this.sb.append(" x1='").append(this.toStr(points[0])).append("'").append(" y1='").append(this.toStr(points[1])).append("'").append(" x2='").append(this.toStr(points[2])).append("'").append(" y2='").append(this.toStr(points[3])).append("'");
        if (this.defaultStroke == null || !this.defaultStroke.equals(elem.color)) {
            this.sb.append(" stroke='").append(this.toStr(elem.color)).append("'");
        }
        if (this.defaultStroke == null || !this.defaultStrokeWidth.equals(this.toStr(this.scaled(elem.width)))) {
            this.sb.append(" stroke-width='").append(this.toStr(this.scaled(elem.width))).append("'");
        }
        this.sb.append("/>\n");
    }

    private void visit(MarkedElement elem) {
        String id = elem.getId();
        List classes = elem.getClasses();
        String cls = classes.isEmpty() ? null : Joiner.on((String)" ").join((Iterable)classes);
        Object marked = elem.element();
        while (marked instanceof ElementGroup) {
            Iterator iter = ((ElementGroup)marked).iterator();
            marked = iter.hasNext() ? (IRenderingElement)iter.next() : null;
            if (!iter.hasNext()) continue;
            marked = null;
        }
        if (marked == null) {
            marked = elem.element();
        }
        if (marked instanceof LineElement) {
            this.visit(id, cls, (LineElement)marked);
        } else if (marked instanceof GeneralPath) {
            this.visit(id, cls, (GeneralPath)marked);
        } else {
            this.appendIdent();
            this.sb.append("<g");
            if (id != null) {
                this.sb.append(" id='").append(elem.getId()).append("'");
            }
            if (cls != null) {
                this.sb.append(" class='").append(cls).append("'");
            }
            this.sb.append(">\n");
            this.indentLvl += 2;
            this.visit((IRenderingElement)marked);
            this.indentLvl -= 2;
            this.appendIdent();
            this.sb.append("</g>\n");
        }
    }

    private void visit(RectangleElement elem) {
        this.appendIdent();
        double[] points = new double[]{elem.xCoord, elem.yCoord};
        this.transform(points, 1);
        this.sb.append("<rect");
        this.sb.append(" x='").append(this.toStr(points[0])).append("'");
        this.sb.append(" y='").append(this.toStr(points[1] - elem.height)).append("'");
        this.sb.append(" width='").append(this.toStr(this.scaled(elem.width))).append("'");
        this.sb.append(" height='").append(this.toStr(this.scaled(elem.height))).append("'");
        if (elem.filled) {
            this.sb.append(" fill='").append(this.toStr(elem.color)).append("'");
            this.sb.append(" stroke='none'");
        } else {
            this.sb.append(" fill='none'");
            this.sb.append(" stroke='").append(this.toStr(elem.color)).append("'");
        }
        this.sb.append("/>\n");
    }

    private void visit(OvalElement elem) {
        this.appendIdent();
        double[] points = new double[]{elem.xCoord, elem.yCoord};
        this.transform(points, 1);
        this.sb.append("<ellipse");
        this.sb.append(" cx='").append(this.toStr(points[0])).append("'");
        this.sb.append(" cy='").append(this.toStr(points[1])).append("'");
        this.sb.append(" rx='").append(this.toStr(this.scaled(elem.radius))).append("'");
        this.sb.append(" ry='").append(this.toStr(this.scaled(elem.radius))).append("'");
        if (elem.fill) {
            this.sb.append(" fill='").append(this.toStr(elem.color)).append("'");
            this.sb.append(" stroke='none'");
        } else {
            this.sb.append(" fill='none'");
            this.sb.append(" stroke='").append(this.toStr(elem.color)).append("'");
        }
        this.sb.append("/>\n");
    }

    private void visit(TextElement elem) {
        this.appendIdent();
        double[] points = new double[]{elem.xCoord, elem.yCoord};
        this.transform(points, 1);
        this.sb.append("<text ");
        this.sb.append(" x='").append(this.toStr(points[0])).append("'");
        this.sb.append(" y='").append(this.toStr(points[1])).append("'");
        this.sb.append(" fill='").append(this.toStr(elem.color)).append("'");
        this.sb.append(" text-anchor='middle'");
        this.sb.append(">");
        this.sb.append(XmlEscapers.xmlContentEscaper().escape(elem.text));
        this.sb.append("</text>\n");
    }

    public void visit(IRenderingElement root) {
        if (!this.defaultsWritten) {
            this.appendIdent();
            this.sb.append("<g").append(" stroke-linecap='round'").append(" stroke-linejoin='round'");
            if (this.defaultStroke != null) {
                this.sb.append(" stroke='").append(this.toStr(this.defaultStroke)).append("'");
            }
            if (this.defaultStrokeWidth != null) {
                this.sb.append(" stroke-width='").append(this.defaultStrokeWidth).append("'");
            }
            if (this.defaultFill != null) {
                this.sb.append(" fill='").append(this.toStr(this.defaultFill)).append("'");
            }
            this.sb.append(">\n");
            this.indentLvl += 2;
            this.defaultsWritten = true;
        }
        ArrayDeque<IRenderingElement> queue = new ArrayDeque<IRenderingElement>();
        queue.add(root);
        while (!queue.isEmpty()) {
            IRenderingElement elem = (IRenderingElement)queue.poll();
            if (elem instanceof ElementGroup) {
                for (IRenderingElement child : (ElementGroup)elem) {
                    queue.add(child);
                }
                continue;
            }
            if (elem instanceof Bounds) {
                queue.add(((Bounds)elem).root());
                continue;
            }
            if (elem instanceof MarkedElement) {
                if (this.model != null && ((Boolean)this.model.get(RendererModel.MarkedOutput.class)).booleanValue()) {
                    this.visit((MarkedElement)elem);
                    continue;
                }
                this.visit(((MarkedElement)elem).element());
                continue;
            }
            if (elem instanceof LineElement) {
                this.visit((LineElement)elem);
                continue;
            }
            if (elem instanceof GeneralPath) {
                this.visit((GeneralPath)elem);
                continue;
            }
            if (elem instanceof RectangleElement) {
                this.visit((RectangleElement)elem);
                continue;
            }
            if (elem instanceof OvalElement) {
                this.visit((OvalElement)elem);
                continue;
            }
            if (elem instanceof TextElement) {
                this.visit((TextElement)elem);
                continue;
            }
            System.err.println(elem.getClass() + " rendering element is not supported by this visitor, parts of the depiction may missing!");
        }
    }

    public void setTransform(AffineTransform transform) {
        this.transform = transform;
    }

    public String toString() {
        if (this.defaultsWritten) {
            return this.sb.toString() + "  </g>\n</svg>\n";
        }
        return this.sb.toString() + "</svg>\n";
    }

    private static final class FreqMap<T> {
        Map<T, Counter> map = new HashMap<T, Counter>();

        void add(T obj) {
            Counter counter = this.map.get(obj);
            if (counter == null) {
                this.map.put(obj, new Counter());
            } else {
                counter.count++;
            }
        }

        T getMostFrequent() {
            if (this.map.isEmpty()) {
                return null;
            }
            T maxKey = null;
            for (Map.Entry<T, Counter> e : this.map.entrySet()) {
                if (maxKey != null && e.getValue().count <= this.map.get(maxKey).count) continue;
                maxKey = e.getKey();
            }
            return maxKey;
        }
    }

    private static final class Counter {
        private int count = 1;

        private Counter() {
        }
    }
}

