/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.depict;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openscience.cdk.config.Elements;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.exception.InvalidSmilesException;
import org.openscience.cdk.graph.ConnectivityChecker;
import org.openscience.cdk.graph.Cycles;
import org.openscience.cdk.graph.GraphUtil;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IPseudoAtom;
import org.openscience.cdk.isomorphism.matchers.Expr;
import org.openscience.cdk.isomorphism.matchers.IQueryAtom;
import org.openscience.cdk.isomorphism.matchers.IQueryAtomContainer;
import org.openscience.cdk.isomorphism.matchers.QueryAtom;
import org.openscience.cdk.isomorphism.matchers.QueryAtomContainer;
import org.openscience.cdk.isomorphism.matchers.QueryBond;
import org.openscience.cdk.sgroup.Sgroup;
import org.openscience.cdk.sgroup.SgroupType;
import org.openscience.cdk.silent.SilentChemObjectBuilder;
import org.openscience.cdk.smiles.SmilesGenerator;
import org.openscience.cdk.smiles.SmilesParser;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

public class Abbreviations
implements Iterable<String> {
    private static final int MAX_FRAG = 256;
    private static final String INTERPUNCT = "\u00b7";
    private final Map<String, String> connectedAbbreviations = new LinkedHashMap<String, String>();
    private final Map<String, String> disconnectedAbbreviations = new LinkedHashMap<String, String>();
    private final Set<String> labels = new LinkedHashSet<String>();
    private final Set<String> disabled = new HashSet<String>();
    private final SmilesGenerator usmigen = SmilesGenerator.unique();
    private final SmilesParser smipar = new SmilesParser(SilentChemObjectBuilder.getInstance());
    private final Set<Option> options = EnumSet.of(Option.AUTO_CONTRACT_HETERO);
    private final Comparator<AdjacentGroup> CARBON_COMPARATOR = (a, b) -> {
        int cmp = -Boolean.compare(((AdjacentGroup)a).allCarbon, ((AdjacentGroup)b).allCarbon);
        if (cmp != 0) {
            return cmp;
        }
        cmp = -Boolean.compare(((AdjacentGroup)a).isTrivial, ((AdjacentGroup)b).isTrivial);
        if (cmp != 0) {
            return cmp;
        }
        cmp = -Integer.compare(((AdjacentGroup)a).count, ((AdjacentGroup)b).count);
        if (cmp != 0) {
            return cmp;
        }
        cmp = Integer.compare(((AdjacentGroup)a).symbol.length(), ((AdjacentGroup)b).symbol.length());
        if (cmp != 0) {
            return cmp;
        }
        return ((AdjacentGroup)a).symbol.compareTo(((AdjacentGroup)b).symbol);
    };
    private static final String CUT_BOND = "cutbond";

    @Override
    public Iterator<String> iterator() {
        return Collections.unmodifiableSet(this.labels).iterator();
    }

    public boolean isEnabled(String label) {
        return this.labels.contains(label) && !this.disabled.contains(label);
    }

    public boolean setEnabled(String label, boolean enabled) {
        return enabled ? this.labels.contains(label) && this.disabled.remove(label) : this.labels.contains(label) && this.disabled.add(label);
    }

    public Abbreviations with(Option option) {
        this.options.add(option);
        return this;
    }

    public Abbreviations without(Option option) {
        this.options.remove((Object)option);
        return this;
    }

    public void setContractOnHetero(boolean val) {
        if (val) {
            this.options.add(Option.AUTO_CONTRACT_HETERO);
        } else {
            this.options.remove((Object)Option.AUTO_CONTRACT_HETERO);
        }
    }

    public void setContractToSingleLabel(boolean val) {
        if (val) {
            this.options.add(Option.ALLOW_SINGLETON);
        } else {
            this.options.remove((Object)Option.ALLOW_SINGLETON);
        }
    }

    private static Set<IBond> findCutBonds(IAtomContainer mol, GraphUtil.EdgeToBondMap bmap, int[][] adjlist) {
        HashSet<IBond> cuts = new HashSet<IBond>();
        int numAtoms = mol.getAtomCount();
        for (int i = 0; i < numAtoms; ++i) {
            IAtom atom = mol.getAtom(i);
            int deg = adjlist[i].length;
            int elem = atom.getAtomicNumber();
            if (elem == 6 && deg <= 2) continue;
            for (int w : adjlist[i]) {
                IBond bond = bmap.get(i, w);
                if (adjlist[w].length < 2 || bond.isInRing()) continue;
                cuts.add(bond);
            }
        }
        return cuts;
    }

    private static List<IAtomContainer> makeCut(IBond cut, IAtomContainer mol, Map<IAtom, Integer> idx, int[][] adjlist) {
        IAtom nbr;
        IAtom atom;
        IAtom beg = cut.getBegin();
        IAtom end = cut.getEnd();
        LinkedHashSet<IAtom> bvisit = new LinkedHashSet<IAtom>();
        LinkedHashSet<IAtom> evisit = new LinkedHashSet<IAtom>();
        ArrayDeque<IAtom> queue = new ArrayDeque<IAtom>();
        bvisit.add(beg);
        evisit.add(end);
        queue.add(beg);
        bvisit.add(end);
        while (!queue.isEmpty()) {
            atom = (IAtom)queue.poll();
            bvisit.add(atom);
            for (int w : adjlist[idx.get(atom)]) {
                nbr = mol.getAtom(w);
                if (bvisit.contains(nbr)) continue;
                queue.add(nbr);
            }
        }
        bvisit.remove(end);
        queue.add(end);
        evisit.add(beg);
        while (!queue.isEmpty()) {
            atom = (IAtom)queue.poll();
            evisit.add(atom);
            for (int w : adjlist[idx.get(atom)]) {
                nbr = mol.getAtom(w);
                if (evisit.contains(nbr)) continue;
                queue.add(nbr);
            }
        }
        evisit.remove(beg);
        IChemObjectBuilder bldr = mol.getBuilder();
        IAtomContainer bfrag = (IAtomContainer)bldr.newInstance(IAtomContainer.class, new Object[0]);
        IAtomContainer efrag = (IAtomContainer)bldr.newInstance(IAtomContainer.class, new Object[0]);
        int diff = bvisit.size() - evisit.size();
        if (diff < -10) {
            evisit.clear();
        } else if (diff > 10) {
            bvisit.clear();
        }
        if (!bvisit.isEmpty()) {
            bfrag.addAtom((IAtom)bldr.newInstance(IPseudoAtom.class, new Object[0]));
            for (IAtom atom2 : bvisit) {
                bfrag.addAtom(atom2);
            }
            bfrag.addBond(0, 1, cut.getOrder());
            bfrag.getBond(0).setProperty((Object)CUT_BOND, (Object)cut);
        }
        if (!evisit.isEmpty()) {
            efrag.addAtom((IAtom)bldr.newInstance(IPseudoAtom.class, new Object[0]));
            for (IAtom atom2 : evisit) {
                efrag.addAtom(atom2);
            }
            efrag.addBond(0, 1, cut.getOrder());
            efrag.getBond(0).setProperty((Object)CUT_BOND, (Object)cut);
        }
        for (IBond bond : mol.bonds()) {
            IAtom a1 = bond.getBegin();
            IAtom a2 = bond.getEnd();
            if (bvisit.contains(a1) && bvisit.contains(a2)) {
                bfrag.addBond(bond);
                continue;
            }
            if (!evisit.contains(a1) || !evisit.contains(a2)) continue;
            efrag.addBond(bond);
        }
        ArrayList<IAtomContainer> res = new ArrayList<IAtomContainer>();
        if (bfrag.getAtomCount() > 1) {
            res.add(bfrag);
        }
        if (efrag.getAtomCount() > 1) {
            res.add(efrag);
        }
        return res;
    }

    private static List<IAtomContainer> generateFragments(IAtomContainer mol) {
        GraphUtil.EdgeToBondMap bmap = GraphUtil.EdgeToBondMap.withSpaceFor((IAtomContainer)mol);
        int[][] adjlist = GraphUtil.toAdjList((IAtomContainer)mol, (GraphUtil.EdgeToBondMap)bmap);
        Cycles.markRingAtomsAndBonds((IAtomContainer)mol);
        Set<IBond> cuts = Abbreviations.findCutBonds(mol, bmap, adjlist);
        HashMap<IAtom, Integer> atmidx = new HashMap<IAtom, Integer>();
        for (IAtom atom : mol.atoms()) {
            atmidx.put(atom, atmidx.size());
        }
        ArrayList<IAtomContainer> frags = new ArrayList<IAtomContainer>();
        for (IBond cut : cuts) {
            if (frags.size() >= 256) break;
            frags.addAll(Abbreviations.makeCut(cut, mol, atmidx, adjlist));
        }
        frags.sort((a, b) -> -Integer.compare(a.getBondCount(), b.getBondCount()));
        return frags;
    }

    private Map<IAtom, List<Sgroup>> getSgroupAdjacency(List<Sgroup> sgroups) {
        HashMap<IAtom, List<Sgroup>> sgroupAdjs = new HashMap<IAtom, List<Sgroup>>();
        for (Sgroup sgroup : sgroups) {
            IAtom attachAtom;
            if (Abbreviations.nonTerminal(sgroup)) continue;
            IBond attachBond = (IBond)sgroup.getBonds().iterator().next();
            Set atoms = sgroup.getAtoms();
            if (!atoms.contains(attachBond.getBegin()) && atoms.contains(attachBond.getEnd())) {
                attachAtom = attachBond.getBegin();
            } else {
                if (!atoms.contains(attachBond.getBegin()) || atoms.contains(attachBond.getEnd())) continue;
                attachAtom = attachBond.getEnd();
            }
            sgroupAdjs.computeIfAbsent(attachAtom, k -> new ArrayList()).add(sgroup);
        }
        return sgroupAdjs;
    }

    private Set<IBond> getCrossingBonds(List<Sgroup> sgroups) {
        HashSet<IBond> xbonds = new HashSet<IBond>();
        for (Sgroup sgroup : sgroups) {
            if (sgroup.getBonds().size() != 1) continue;
            xbonds.addAll(sgroup.getBonds());
        }
        return xbonds;
    }

    public List<Sgroup> generate(IAtomContainer mol) {
        return this.generate(mol, Collections.emptyMap());
    }

    public List<Sgroup> generate(IAtomContainer mol, Map<IAtom, Integer> atomSets) {
        HashSet<Object> usedAtoms = new HashSet<Object>();
        List sgroups = (List)mol.getProperty((Object)"cdk:CtabSgroups");
        if (sgroups != null) {
            for (Sgroup sgroup : sgroups) {
                usedAtoms.addAll(sgroup.getAtoms());
            }
        }
        ArrayList<Sgroup> newSgroups = new ArrayList<Sgroup>();
        ArrayList<Sgroup> allSgroups = new ArrayList<Sgroup>();
        if (usedAtoms.isEmpty()) {
            try {
                IAtomContainer copy = AtomContainerManipulator.copyAndSuppressedHydrogens((IAtomContainer)mol);
                String cansmi = this.usmigen.create(copy);
                String label = this.disconnectedAbbreviations.get(cansmi);
                if (label != null && !this.disabled.contains(label) && this.options.contains((Object)Option.ALLOW_SINGLETON)) {
                    Sgroup sgroup = new Sgroup();
                    sgroup.setType(SgroupType.CtabAbbreviation);
                    sgroup.setSubscript(label);
                    for (IAtom atom : mol.atoms()) {
                        sgroup.addAtom(atom);
                    }
                    if (!Abbreviations.isAcceptableSet(atomSets, sgroup)) {
                        return Collections.emptyList();
                    }
                    return Collections.singletonList(sgroup);
                }
                if (cansmi.contains(".")) {
                    IAtomContainerSet parts = ConnectivityChecker.partitionIntoMolecules((IAtomContainer)mol);
                    Sgroup best = null;
                    for (int i = 0; i < parts.getAtomContainerCount(); ++i) {
                        IAtomContainer a = parts.getAtomContainer(i);
                        IAtomContainer b = a.getBuilder().newAtomContainer();
                        for (int j = 0; j < parts.getAtomContainerCount(); ++j) {
                            if (j == i) continue;
                            b.add(parts.getAtomContainer(j));
                        }
                        Sgroup sgroup1 = this.getAbbr(a);
                        Sgroup sgroup2 = this.getAbbr(b);
                        if (!Abbreviations.isAcceptableSet(atomSets, sgroup1)) {
                            sgroup1 = null;
                        }
                        if (!Abbreviations.isAcceptableSet(atomSets, sgroup2)) {
                            sgroup2 = null;
                        }
                        if (sgroup1 != null && sgroup2 != null && this.options.contains((Object)Option.ALLOW_SINGLETON)) {
                            Sgroup combined = new Sgroup();
                            label = null;
                            for (IAtom atom : sgroup1.getAtoms()) {
                                combined.addAtom(atom);
                            }
                            for (IAtom atom : sgroup2.getAtoms()) {
                                combined.addAtom(atom);
                            }
                            if (sgroup1.getSubscript().length() > sgroup2.getSubscript().length()) {
                                combined.setSubscript(sgroup1.getSubscript() + INTERPUNCT + sgroup2.getSubscript());
                            } else {
                                combined.setSubscript(sgroup2.getSubscript() + INTERPUNCT + sgroup1.getSubscript());
                            }
                            combined.setType(SgroupType.CtabAbbreviation);
                            return Collections.singletonList(combined);
                        }
                        if (sgroup1 != null && (best == null || sgroup1.getAtoms().size() > best.getAtoms().size())) {
                            best = sgroup1;
                        }
                        if (sgroup2 == null || best != null && sgroup2.getAtoms().size() >= best.getAtoms().size()) continue;
                        best = sgroup2;
                    }
                    if (best != null) {
                        newSgroups.add(best);
                        usedAtoms.addAll(best.getAtoms());
                    }
                }
            }
            catch (CDKException copy) {
                // empty catch block
            }
        }
        for (Object se : mol.stereoElements()) {
            IChemObject chemObject = se.getFocus();
            if (chemObject instanceof IAtom) {
                usedAtoms.add((IAtom)chemObject);
                continue;
            }
            if (!(chemObject instanceof IBond)) continue;
            usedAtoms.add(((IBond)chemObject).getBegin());
            usedAtoms.add(((IBond)chemObject).getEnd());
        }
        List<IAtomContainer> fragments = Abbreviations.generateFragments(mol);
        for (IAtomContainer frag : fragments) {
            try {
                String smi;
                String label;
                boolean okay = true;
                for (IAtom atom : frag.atoms()) {
                    if (atom.getMassNumber() == null || atom.getMassNumber() == 0) continue;
                    okay = false;
                    break;
                }
                if (!okay || (label = this.connectedAbbreviations.get(smi = this.usmigen.create(AtomContainerManipulator.copyAndSuppressedHydrogens((IAtomContainer)frag)))) == null || this.disabled.contains(label)) continue;
                boolean overlap = false;
                int numAtoms = frag.getAtomCount();
                int numBonds = frag.getBondCount();
                for (int i = 1; i < numAtoms; ++i) {
                    if (!usedAtoms.contains(frag.getAtom(i))) continue;
                    overlap = true;
                    break;
                }
                if (overlap) continue;
                Sgroup sgroup = new Sgroup();
                sgroup.setType(SgroupType.CtabAbbreviation);
                sgroup.setSubscript(label);
                IBond attachBond = (IBond)frag.getBond(0).getProperty((Object)CUT_BOND, IBond.class);
                sgroup.addBond(attachBond);
                for (int i = 1; i < numAtoms; ++i) {
                    sgroup.addAtom(frag.getAtom(i));
                }
                if (!Abbreviations.isAcceptableSet(atomSets, sgroup)) continue;
                usedAtoms.addAll(sgroup.getAtoms());
                newSgroups.add(sgroup);
                allSgroups.add(sgroup);
            }
            catch (CDKException cDKException) {}
        }
        if (!this.options.contains((Object)Option.AUTO_CONTRACT_HETERO) && !this.options.contains((Object)Option.AUTO_CONTRACT_TERMINAL)) {
            return newSgroups;
        }
        Map<IAtom, List<Sgroup>> sgroupAdjs = this.getSgroupAdjacency(allSgroups);
        Set<IBond> allCrossingBonds = this.getCrossingBonds(allSgroups);
        for (IAtom attach : mol.atoms()) {
            if (usedAtoms.contains(attach) || attach.getFormalCharge() != null && attach.getFormalCharge() != 0 || attach.getMassNumber() != null || attach.getAtomicNumber() <= 2) continue;
            boolean okay = false;
            if (attach.getAtomicNumber() != 6 && attach.getAtomicNumber() != 1 && attach.getAtomicNumber() != 0 && this.options.contains((Object)Option.AUTO_CONTRACT_HETERO)) {
                okay = true;
            } else if (this.effectiveDegree(attach, allCrossingBonds) <= 1 && this.options.contains((Object)Option.AUTO_CONTRACT_TERMINAL)) {
                okay = true;
            }
            if (!okay) continue;
            int hcount = attach.getImplicitHydrogenCount();
            HashSet<IAtom> xatoms = new HashSet<IAtom>();
            HashSet<IBond> xbonds = new HashSet<IBond>();
            HashSet<Object> newbonds = new HashSet<Object>();
            xatoms.add(attach);
            LinkedHashMap<String, AdjacentGroup> adjGroupMap = new LinkedHashMap<String, AdjacentGroup>();
            for (Sgroup sgroup : sgroupAdjs.getOrDefault(attach, Collections.emptyList())) {
                if (this.containsChargeChar(sgroup.getSubscript()) || Abbreviations.nonTerminal(sgroup)) continue;
                IBond xbond = (IBond)sgroup.getBonds().iterator().next();
                xbonds.add(xbond);
                xatoms.addAll(sgroup.getAtoms());
                adjGroupMap.computeIfAbsent(sgroup.getSubscript(), k -> new AdjacentGroup(sgroup)).add(sgroup);
            }
            for (Object bond : mol.getConnectedBondsList(attach)) {
                if (xbonds.contains(bond)) continue;
                IAtom nbr = bond.getOther(attach);
                if (!usedAtoms.contains(nbr) && mol.getConnectedBondsCount(nbr) == 1) {
                    if (nbr.getAtomicNumber() == 0 || nbr.getMassNumber() != null || nbr.getFormalCharge() != null && nbr.getFormalCharge() != 0 || Abbreviations.isNonMethylTerminalCarbon(nbr)) {
                        newbonds.add(bond);
                        continue;
                    }
                    if (nbr.getAtomicNumber() == 1) {
                        ++hcount;
                        xatoms.add(nbr);
                        continue;
                    }
                    if (nbr.getAtomicNumber() <= 0) continue;
                    String symbol = this.newSymbol(nbr.getAtomicNumber(), nbr.getImplicitHydrogenCount(), false);
                    adjGroupMap.computeIfAbsent(symbol, k -> new AdjacentGroup((String)k, nbr)).add();
                    xatoms.add(nbr);
                    continue;
                }
                newbonds.add(bond);
            }
            if (newbonds.size() < 1 && adjGroupMap.size() > 1 && !this.options.contains((Object)Option.ALLOW_SINGLETON)) {
                Object bond;
                AdjacentGroup bestMultiGroup = null;
                bond = adjGroupMap.values().iterator();
                while (bond.hasNext()) {
                    AdjacentGroup group = (AdjacentGroup)bond.next();
                    if (group.count <= 1 || bestMultiGroup != null && group.count <= bestMultiGroup.count) continue;
                    bestMultiGroup = group;
                }
                if (bestMultiGroup != null) {
                    xatoms.clear();
                    xbonds.clear();
                    xatoms.add(attach);
                    for (Sgroup sgroup : bestMultiGroup.sgroups) {
                        xatoms.addAll(sgroup.getAtoms());
                        xbonds.addAll(sgroup.getBonds());
                    }
                    bond = mol.getConnectedBondsList(attach).iterator();
                    while (bond.hasNext()) {
                        IBond bond2 = (IBond)bond.next();
                        if (xbonds.contains(bond2)) continue;
                        newbonds.add(bond2);
                    }
                    adjGroupMap.clear();
                    adjGroupMap.put(bestMultiGroup.symbol, bestMultiGroup);
                }
            }
            if (adjGroupMap.isEmpty() || newbonds.size() < 1 && !this.options.contains((Object)Option.ALLOW_SINGLETON) || newbonds.size() > 1 && !this.options.contains((Object)Option.AUTO_CONTRACT_LINKERS) || newbonds.size() > 2 || newbonds.size() == 1 && ((IBond)newbonds.iterator().next()).getOrder() != IBond.Order.SINGLE || Abbreviations.isCC(attach, xbonds, adjGroupMap) || newbonds.size() == 0 && !this.options.contains((Object)Option.ALLOW_SINGLETON)) continue;
            StringBuilder sb = new StringBuilder();
            String prev = "{!no_match!}";
            ArrayList adjGroupsAll = new ArrayList(adjGroupMap.values());
            ArrayList adjGroups = new ArrayList(adjGroupsAll);
            adjGroups.sort(this.CARBON_COMPARATOR);
            boolean hasPrefix = false;
            if (newbonds.size() == 0 && ((AdjacentGroup)adjGroups.get(0)).allCarbon) {
                AdjacentGroup group = (AdjacentGroup)adjGroups.remove(0);
                this.appendGroup(sb, group.symbol, group.count, false);
                hasPrefix = true;
            }
            Collections.sort(adjGroups);
            sb.append(this.newSymbol(attach.getAtomicNumber(), hcount, newbonds.size() == 0 && !hasPrefix));
            if (!hasPrefix && adjGroups.size() == 1 && ((AdjacentGroup)adjGroups.get(0)).count == 1 && Abbreviations.isAccidentalElement(sb, ((AdjacentGroup)adjGroups.get(0)).symbol)) continue;
            for (int i = 0; i < adjGroups.size(); ++i) {
                AdjacentGroup group = (AdjacentGroup)adjGroups.get(i);
                boolean bl = group.count > 1 && !group.isTrivial || !group.isTrivial || group.symbol.startsWith(prev) || !Abbreviations.hasStandardValence(attach);
                boolean isLast = i + 1 == adjGroups.size();
                this.appendGroup(sb, group.symbol, group.count, bl && !isLast);
                prev = group.symbol;
            }
            Sgroup newSgroup = new Sgroup();
            newSgroup.setType(SgroupType.CtabAbbreviation);
            newSgroup.setSubscript(sb.toString());
            for (IBond iBond : newbonds) {
                newSgroup.addBond(iBond);
            }
            for (IAtom iAtom : xatoms) {
                newSgroup.addAtom(iAtom);
            }
            if (Abbreviations.isAcceptableSet(atomSets, newSgroup)) {
                for (AdjacentGroup adjacentGroup : adjGroupsAll) {
                    newSgroups.removeAll(adjacentGroup.sgroups);
                }
                newSgroups.add(newSgroup);
            }
            for (AdjacentGroup adjacentGroup : adjGroupsAll) {
                allSgroups.removeAll(adjacentGroup.sgroups);
            }
            allSgroups.add(newSgroup);
            usedAtoms.addAll(xatoms);
        }
        if (this.options.contains((Object)Option.ALLOW_SINGLETON) && this.options.contains((Object)Option.AUTO_CONTRACT_TERMINAL)) {
            sgroupAdjs = this.getSgroupAdjacency(allSgroups);
            allCrossingBonds = this.getCrossingBonds(allSgroups);
            for (IBond bond : allCrossingBonds) {
                List<Sgroup> endAbbrs;
                List<Sgroup> begAbbrs = sgroupAdjs.get(bond.getBegin());
                if (Abbreviations.symmetricSgroups(begAbbrs, endAbbrs = sgroupAdjs.get(bond.getEnd()))) {
                    Sgroup newSgroup = new Sgroup();
                    newSgroup.setType(SgroupType.CtabAbbreviation);
                    String label = begAbbrs.get(0).getSubscript();
                    if (Abbreviations.isTrivial(label)) {
                        newSgroup.setSubscript(label + "2");
                    } else {
                        newSgroup.setSubscript("(" + label + ")2");
                    }
                    for (IAtom atom : begAbbrs.get(0).getAtoms()) {
                        newSgroup.addAtom(atom);
                    }
                    for (IAtom atom : endAbbrs.get(0).getAtoms()) {
                        newSgroup.addAtom(atom);
                    }
                    if (!Abbreviations.isAcceptableSet(atomSets, newSgroup)) continue;
                    newSgroups.removeAll(begAbbrs);
                    newSgroups.removeAll(endAbbrs);
                    newSgroups.add(newSgroup);
                    continue;
                }
                if (!this.hasTrivial(begAbbrs, endAbbrs)) continue;
                String begLabel = begAbbrs.get(0).getSubscript();
                String endLabel = endAbbrs.get(0).getSubscript();
                Sgroup newSgroup = new Sgroup();
                newSgroup.setType(SgroupType.CtabAbbreviation);
                String label = begAbbrs.get(0).getSubscript();
                if (Abbreviations.isTrivial(begLabel)) {
                    newSgroup.setSubscript(begLabel + endLabel);
                } else if (Abbreviations.isTrivial(endLabel)) {
                    newSgroup.setSubscript(endLabel + begLabel);
                } else {
                    throw new IllegalStateException();
                }
                for (IAtom atom : begAbbrs.get(0).getAtoms()) {
                    newSgroup.addAtom(atom);
                }
                for (IAtom atom : endAbbrs.get(0).getAtoms()) {
                    newSgroup.addAtom(atom);
                }
                if (!Abbreviations.isAcceptableSet(atomSets, newSgroup)) continue;
                newSgroups.removeAll(begAbbrs);
                newSgroups.removeAll(endAbbrs);
                newSgroups.add(newSgroup);
            }
        }
        return newSgroups;
    }

    private static boolean isAcceptableSet(Map<IAtom, Integer> atomSets, Sgroup sgroup) {
        if (sgroup == null) {
            return false;
        }
        if (atomSets.isEmpty()) {
            return true;
        }
        HashSet<Integer> visitSets = new HashSet<Integer>();
        for (IAtom atom : sgroup.getAtoms()) {
            visitSets.add(atomSets.getOrDefault(atom, -1));
        }
        return visitSets.size() == 1;
    }

    private static boolean isNonMethylTerminalCarbon(IAtom nbr) {
        return nbr.getAtomicNumber() == 6 && nbr.getImplicitHydrogenCount() != 3;
    }

    private static boolean hasStandardValence(IAtom attach) {
        switch (attach.getAtomicNumber()) {
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 15: 
            case 16: 
            case 17: 
            case 35: 
            case 53: {
                return true;
            }
        }
        return false;
    }

    private static boolean nonTerminal(Sgroup sgroup) {
        return sgroup.getBonds().size() != 1;
    }

    private static boolean isTrivial(String label) {
        int numCaps = 0;
        for (int i = 0; i < label.length(); ++i) {
            if (Character.isUpperCase(label.charAt(i))) {
                ++numCaps;
                continue;
            }
            if (Character.isDigit(label.charAt(i))) {
                return false;
            }
            if (label.charAt(i) != '(') continue;
            return false;
        }
        return numCaps == 1;
    }

    private static boolean symmetricSgroups(List<Sgroup> begAbbr, List<Sgroup> endAbbr) {
        return begAbbr != null && endAbbr != null && begAbbr.size() == 1 && endAbbr.size() == 1 && begAbbr.get(0) != endAbbr.get(0) && begAbbr.get(0).getSubscript().equalsIgnoreCase(endAbbr.get(0).getSubscript());
    }

    private boolean hasTrivial(List<Sgroup> begAbbr, List<Sgroup> endAbbr) {
        return begAbbr != null && endAbbr != null && begAbbr.size() == 1 && endAbbr.size() == 1 && begAbbr.get(0) != endAbbr.get(0) && (Abbreviations.isTrivial(begAbbr.get(0).getSubscript()) || Abbreviations.isTrivial(endAbbr.get(0).getSubscript()));
    }

    private static boolean isCC(IAtom attach, Set<IBond> xbonds, Map<String, AdjacentGroup> nbrSymbols) {
        return attach.getAtomicNumber() == 6 && nbrSymbols.size() == 1 && (nbrSymbols.values().iterator().next().symbol.equals("Me") || nbrSymbols.values().iterator().next().symbol.equals("CH"));
    }

    private int effectiveDegree(IAtom attach, Set<IBond> xbonds) {
        int degree = 0;
        for (IBond bond : attach.bonds()) {
            IAtom nbor = bond.getOther(attach);
            if (nbor.getBondCount() == 1 || xbonds.contains(bond)) continue;
            ++degree;
        }
        return degree;
    }

    private Sgroup getAbbr(IAtomContainer part) throws CDKException {
        if (part.getAtomCount() == 1) {
            IAtom atom = part.getAtom(0);
            String label = Abbreviations.getBasicElementSymbol(atom);
            if (label != null) {
                Sgroup sgroup = new Sgroup();
                sgroup.setType(SgroupType.CtabAbbreviation);
                sgroup.setSubscript(label);
                sgroup.addAtom(atom);
                return sgroup;
            }
        } else {
            String cansmi = this.usmigen.create(part);
            String label = this.disconnectedAbbreviations.get(cansmi);
            if (label != null && !this.disabled.contains(label)) {
                Sgroup sgroup = new Sgroup();
                sgroup.setType(SgroupType.CtabAbbreviation);
                sgroup.setSubscript(label);
                for (IAtom atom : part.atoms()) {
                    sgroup.addAtom(atom);
                }
                return sgroup;
            }
        }
        return null;
    }

    private boolean containsChargeChar(String str) {
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c != '-' && c != '+') continue;
            return true;
        }
        return false;
    }

    private boolean digitAtEnd(String str) {
        return Character.isDigit(str.charAt(str.length() - 1));
    }

    private String newSymbol(int atomnum, int hcount, boolean prefix) {
        StringBuilder sb = new StringBuilder();
        Elements elem = Elements.ofNumber((int)atomnum);
        if (elem == Elements.Carbon && hcount == 3) {
            return "Me";
        }
        if (prefix && elem != Elements.Carbon) {
            if (hcount > 0) {
                sb.append('H');
                if (hcount > 1) {
                    sb.append(hcount);
                }
            }
            sb.append(elem.symbol());
        } else {
            sb.append(elem.symbol());
            if (hcount > 0) {
                sb.append('H');
                if (hcount > 1) {
                    sb.append(hcount);
                }
            }
        }
        return sb.toString();
    }

    private void appendGroup(StringBuilder sb, String group, int coef, boolean useParen) {
        if (coef <= 0 || group == null || group.isEmpty()) {
            return;
        }
        if (!useParen) {
            boolean bl = useParen = coef > 1 && (!Abbreviations.isTrivial(group) || this.digitAtEnd(group));
        }
        if (!useParen && Abbreviations.isAccidentalElement(sb, group)) {
            useParen = true;
        }
        if (useParen) {
            sb.append('(');
        }
        sb.append(group);
        if (useParen) {
            sb.append(')');
        }
        if (coef > 1) {
            sb.append(coef);
        }
    }

    private static boolean isAccidentalElement(char fst, char snd) {
        return Character.isUpperCase(fst) && Character.isLowerCase(snd) && Elements.ofString((String)(String.valueOf(fst) + snd)) != Elements.Unknown;
    }

    private static boolean isAccidentalElement(StringBuilder sb, String group) {
        if (sb.length() == 0 || group.length() == 0) {
            return false;
        }
        return Abbreviations.isAccidentalElement(sb.charAt(sb.length() - 1), group.charAt(0));
    }

    public int apply(IAtomContainer mol) {
        return this.apply(mol, Collections.emptyMap());
    }

    public int apply(IAtomContainer mol, Map<IAtom, Integer> atomSets) {
        List<Sgroup> newSgroups = this.generate(mol, atomSets);
        ArrayList<Object> sgroups = (ArrayList<Sgroup>)mol.getProperty((Object)"cdk:CtabSgroups");
        sgroups = sgroups == null ? new ArrayList<Sgroup>() : new ArrayList(sgroups);
        int numAtoms = mol.getAtomCount();
        int numRingAtoms = Abbreviations.countRingAtoms(mol);
        int prev = sgroups.size();
        for (Sgroup sgroup : newSgroups) {
            if (!this.shouldContract(sgroup, numAtoms, numRingAtoms)) continue;
            sgroups.add(sgroup);
        }
        mol.setProperty((Object)"cdk:CtabSgroups", Collections.unmodifiableList(sgroups));
        return sgroups.size() - prev;
    }

    private static int countRingAtoms(IAtomContainer mol) {
        int numRingAtoms = 0;
        for (IAtom atom : mol.atoms()) {
            if (!atom.isInRing()) continue;
            ++numRingAtoms;
        }
        return numRingAtoms;
    }

    private boolean shouldContract(Sgroup sgroup, int nAtoms, int nRingAtoms) {
        if (sgroup.getBonds().isEmpty()) {
            return true;
        }
        int nAbbrRingAtoms = 0;
        for (IAtom atom : sgroup.getAtoms()) {
            if (!atom.isInRing()) continue;
            ++nAbbrRingAtoms;
        }
        int nOtherRingAtoms = nRingAtoms - nAbbrRingAtoms;
        if (nAbbrRingAtoms != 0) {
            return nOtherRingAtoms > nAbbrRingAtoms;
        }
        int nOtherAtoms = nAtoms - sgroup.getAtoms().size();
        return nOtherAtoms > sgroup.getAtoms().size();
    }

    private IQueryAtom matchExact(IAtomContainer mol, IAtom atom) {
        int hcnt;
        IChemObjectBuilder bldr = atom.getBuilder();
        int elem = atom.getAtomicNumber();
        if (elem == 0) {
            return null;
        }
        int val = hcnt = atom.getImplicitHydrogenCount().intValue();
        int con = hcnt;
        for (IBond bond : mol.getConnectedBondsList(atom)) {
            val += bond.getOrder().numeric().intValue();
            ++con;
            if (bond.getOther(atom).getAtomicNumber() != 1) continue;
            ++hcnt;
        }
        Expr expr = new Expr(Expr.Type.ELEMENT, elem).and(new Expr(Expr.Type.TOTAL_DEGREE, con)).and(new Expr(Expr.Type.TOTAL_H_COUNT, hcnt)).and(new Expr(Expr.Type.VALENCE, val));
        return new QueryAtom(expr);
    }

    private IQueryAtomContainer matchExact(IAtomContainer mol) {
        IChemObjectBuilder bldr = mol.getBuilder();
        QueryAtomContainer qry = new QueryAtomContainer(mol.getBuilder());
        HashMap<IAtom, IQueryAtom> atmmap = new HashMap<IAtom, IQueryAtom>();
        for (IAtom atom : mol.atoms()) {
            IQueryAtom qatom = this.matchExact(mol, atom);
            if (qatom == null) continue;
            atmmap.put(atom, qatom);
            qry.addAtom((IAtom)qatom);
        }
        for (IBond bond : mol.bonds()) {
            IAtom beg = (IAtom)atmmap.get(bond.getBegin());
            IAtom end = (IAtom)atmmap.get(bond.getEnd());
            if (beg == null || end == null) continue;
            QueryBond qbond = new QueryBond(beg, end, Expr.Type.TRUE);
            qry.addBond((IBond)qbond);
        }
        return qry;
    }

    private boolean addDisconnectedAbbreviation(IAtomContainer mol, String label) {
        try {
            String cansmi = SmilesGenerator.unique().create(mol);
            this.disconnectedAbbreviations.put(cansmi, label);
            this.labels.add(label);
            return true;
        }
        catch (CDKException e) {
            return false;
        }
    }

    private boolean addConnectedAbbreviation(IAtomContainer mol, String label) {
        try {
            this.connectedAbbreviations.put(this.usmigen.create(mol), label);
            this.labels.add(label);
            return true;
        }
        catch (CDKException e) {
            return false;
        }
    }

    public boolean add(String line) throws InvalidSmilesException {
        return this.add(this.smipar.parseSmiles(line), Abbreviations.getSmilesSuffix(line));
    }

    public boolean add(IAtomContainer mol, String label) {
        if (label == null || label.isEmpty()) {
            return false;
        }
        int numAttach = 0;
        for (IAtom atom : mol.atoms()) {
            if (atom.getImplicitHydrogenCount() == null || atom.getAtomicNumber() == null) {
                throw new IllegalArgumentException("Implicit hydrogen count or atomic number is null");
            }
            if (atom.getAtomicNumber() != 0) continue;
            ++numAttach;
        }
        switch (numAttach) {
            case 0: {
                return this.addDisconnectedAbbreviation(mol, label);
            }
            case 1: {
                return this.addConnectedAbbreviation(mol, label);
            }
        }
        return false;
    }

    private static String getSmilesSuffix(String line) {
        int last = line.length() - 1;
        for (int i = 0; i < last; ++i) {
            if (line.charAt(i) != ' ' && line.charAt(i) != '\t') continue;
            return line.substring(i + 1).trim();
        }
        return "";
    }

    private static String getBasicElementSymbol(IAtom atom) {
        if (atom.getFormalCharge() != null && atom.getFormalCharge() != 0) {
            return null;
        }
        if (atom.getMassNumber() != null && atom.getMassNumber() != 0) {
            return null;
        }
        if (atom.getAtomicNumber() == null || atom.getAtomicNumber() < 1) {
            return null;
        }
        Integer hcnt = atom.getImplicitHydrogenCount();
        if (hcnt == null) {
            return null;
        }
        Elements elem = Elements.ofNumber((int)atom.getAtomicNumber());
        String hsym = hcnt > 0 ? (hcnt > 1 ? "H" + hcnt : "H") : "";
        switch (elem) {
            case Oxygen: 
            case Sulfur: 
            case Selenium: 
            case Tellurium: 
            case Fluorine: 
            case Chlorine: 
            case Bromine: 
            case Iodine: {
                return hsym + elem.symbol();
            }
        }
        return elem.symbol() + hsym;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int loadSmiles(InputStream in) throws IOException {
        int count = 0;
        try (BufferedReader brdr = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));){
            String line;
            while ((line = brdr.readLine()) != null) {
                if (line.isEmpty() || line.charAt(0) == '#') continue;
                try {
                    if (!this.add(line)) continue;
                    ++count;
                }
                catch (InvalidSmilesException e) {
                    LoggingToolFactory.createLoggingTool(Abbreviations.class).warn((Object)"Ignored Invalid SMILES", new Object[]{e});
                }
            }
            return count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int loadFromFile(String path) throws IOException {
        try (InputStream in = null;){
            in = this.getClass().getResourceAsStream(path);
            if (in != null) {
                int n = this.loadSmiles(in);
                return n;
            }
            File file = new File(path);
            if (file.exists() && file.canRead()) {
                int n = this.loadSmiles(new FileInputStream(file));
                return n;
            }
        }
        return 0;
    }

    public static enum Option {
        ALLOW_SINGLETON,
        AUTO_CONTRACT_HETERO,
        AUTO_CONTRACT_TERMINAL,
        AUTO_CONTRACT_LINKERS;

    }

    private static final class AdjacentGroup
    implements Comparable<AdjacentGroup> {
        private final List<Sgroup> sgroups = new ArrayList<Sgroup>();
        private final String symbol;
        private final boolean allCarbon;
        private final boolean isTrivial;
        private int count = 0;

        private AdjacentGroup(Sgroup sgroup) {
            this.symbol = sgroup.getSubscript();
            this.allCarbon = sgroup.getAtoms().stream().noneMatch(AdjacentGroup::isNonCarbon);
            this.isTrivial = Abbreviations.isTrivial(sgroup.getSubscript());
        }

        private AdjacentGroup(String symbol, IAtom nbr) {
            this.symbol = symbol;
            this.allCarbon = !AdjacentGroup.isNonCarbon(nbr);
            this.isTrivial = Abbreviations.isTrivial(symbol);
        }

        private static boolean isNonCarbon(IAtom a) {
            return a.getAtomicNumber() != 6;
        }

        private void add() {
            ++this.count;
        }

        private void add(Sgroup sgroup) {
            this.sgroups.add(sgroup);
            ++this.count;
        }

        @Override
        public int compareTo(AdjacentGroup o) {
            int cmp = -Boolean.compare(this.symbol.length() == 1, o.symbol.length() == 1);
            if (cmp != 0) {
                return cmp;
            }
            cmp = -Boolean.compare(this.allCarbon, o.allCarbon);
            if (cmp != 0) {
                return cmp;
            }
            cmp = -Boolean.compare(this.isTrivial, o.isTrivial);
            if (cmp != 0) {
                return cmp;
            }
            cmp = Integer.compare(this.count, o.count);
            if (cmp != 0) {
                return cmp;
            }
            cmp = Integer.compare(this.symbol.length(), o.symbol.length());
            if (cmp != 0) {
                return cmp;
            }
            return this.symbol.compareTo(o.symbol);
        }

        public String toString() {
            return "AdjacentGroup{, symbol='" + this.symbol + '\'' + ", count=" + this.count + '}';
        }
    }
}

