/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.depict;

import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.imageio.ImageIO;
import org.openscience.cdk.depict.Dimensions;
import org.openscience.cdk.depict.SvgDrawVisitor;
import org.openscience.cdk.renderer.RendererModel;
import org.openscience.cdk.renderer.elements.Bounds;
import org.openscience.cdk.renderer.elements.IRenderingElement;
import org.openscience.cdk.renderer.font.AWTFontManager;
import org.openscience.cdk.renderer.font.IFontManager;
import org.openscience.cdk.renderer.generators.BasicSceneGenerator;
import org.openscience.cdk.renderer.visitor.IDrawVisitor;

public abstract class Depiction {
    protected static final double MM_TO_POINT = 2.83464566751;
    protected static final double DEFAULT_PADDING_FACTOR = 2.5;
    public static final String SVG_FMT = "svg";
    public static final String PS_FMT = "ps";
    public static final String EPS_FMT = "eps";
    public static final String PDF_FMT = "pdf";
    public static final String JPG_FMT = "jpg";
    public static final String PNG_FMT = "png";
    public static final String GIF_FMT = "gif";
    public static final String UNITS_MM = "mm";
    public static final String UNITS_PX = "px";
    static final double ACS_1996_BOND_LENGTH_MM = 5.08;
    private static final char DOT = '.';
    protected final RendererModel model;

    Depiction(RendererModel model) {
        this.model = model;
    }

    public abstract BufferedImage toImg();

    public final String toSvgStr() {
        return this.toSvgStr(UNITS_MM);
    }

    public final String toSvgStr(String units) {
        if (!units.equals(UNITS_MM) && !units.equals(UNITS_PX)) {
            throw new IllegalArgumentException("Units must be 'px' or 'mm'!");
        }
        return this.toVecStr(SVG_FMT, units);
    }

    public final String toPsStr() {
        return this.toVecStr(PS_FMT, UNITS_MM);
    }

    public final String toEpsStr() {
        return this.toVecStr(EPS_FMT, UNITS_MM);
    }

    public final String toPdfStr() {
        return this.toVecStr(PDF_FMT, UNITS_MM);
    }

    public final byte[] toPdf() {
        return this.toVecBytes(PDF_FMT, UNITS_MM);
    }

    double getPaddingValue(double defaultPadding) {
        double padding = (Double)this.model.get(RendererModel.Padding.class);
        if (padding == -1.0) {
            padding = defaultPadding;
        }
        return padding;
    }

    double getMarginValue(double defaultMargin) {
        double margin = (Double)this.model.get(BasicSceneGenerator.Margin.class);
        if (margin == -1.0) {
            margin = defaultMargin;
        }
        return margin;
    }

    private final String toVecStr(String fmt, String units) {
        return new String(this.toVecBytes(fmt, units));
    }

    abstract byte[] toVecBytes(String var1, String var2);

    public final List<String> listFormats() {
        ArrayList<String> formats = new ArrayList<String>();
        formats.add(SVG_FMT);
        formats.add(SVG_FMT.toUpperCase(Locale.ROOT));
        formats.add(PS_FMT);
        formats.add(PS_FMT.toUpperCase(Locale.ROOT));
        formats.add(EPS_FMT);
        formats.add(EPS_FMT.toUpperCase(Locale.ROOT));
        formats.add(PDF_FMT);
        formats.add(PDF_FMT.toUpperCase(Locale.ROOT));
        formats.addAll(Arrays.asList(ImageIO.getWriterFormatNames()));
        return formats;
    }

    public final void writeTo(String fmt, OutputStream out) throws IOException {
        if (fmt.equalsIgnoreCase(SVG_FMT)) {
            out.write(this.toSvgStr().getBytes(StandardCharsets.UTF_8));
        } else if (fmt.equalsIgnoreCase(PS_FMT)) {
            out.write(this.toEpsStr().getBytes(StandardCharsets.UTF_8));
        } else if (fmt.equalsIgnoreCase(PDF_FMT)) {
            out.write(this.toPdf());
        } else {
            ImageIO.write((RenderedImage)this.toImg(), fmt, out);
        }
    }

    public final void writeTo(String fmt, File file) throws IOException {
        try (FileOutputStream out = new FileOutputStream(file);){
            this.writeTo(fmt, out);
        }
    }

    public final void writeTo(String fmt, String path) throws IOException {
        this.writeTo(fmt, new File(Depiction.replaceTildeWithHomeDir(Depiction.ensureSuffix(path, fmt))));
    }

    public final void writeTo(String path) throws IOException {
        int i = path.lastIndexOf(46);
        if (i < 0 || i + 1 == path.length()) {
            throw new IOException("Cannot find suffix in provided path: " + path);
        }
        String fmt = path.substring(i + 1);
        this.writeTo(fmt, path);
    }

    private static String replaceTildeWithHomeDir(String path) {
        if (path.startsWith("~/")) {
            return System.getProperty("user.home") + path.substring(1);
        }
        return path;
    }

    private static String ensureSuffix(String path, String suffix) {
        if (path.endsWith('.' + suffix)) {
            return path;
        }
        return path + '.' + suffix;
    }

    protected final void draw(IDrawVisitor visitor, double zoom, Bounds bounds, Rectangle2D viewBounds) {
        double modelScale = zoom * (Double)this.model.get(BasicSceneGenerator.Scale.class);
        double zoomToFit = Math.min(viewBounds.getWidth() / (bounds.width() * modelScale), viewBounds.getHeight() / (bounds.height() * modelScale));
        AffineTransform transform = new AffineTransform();
        transform.translate(viewBounds.getCenterX(), viewBounds.getCenterY());
        transform.scale(modelScale, -modelScale);
        if (((Boolean)this.model.get(BasicSceneGenerator.FitToScreen.class)).booleanValue() || zoomToFit < 1.0) {
            transform.scale(zoomToFit, zoomToFit);
        }
        transform.translate(-(bounds.minX + bounds.maxX) / 2.0, -(bounds.minY + bounds.maxY) / 2.0);
        AWTFontManager fontManager = new AWTFontManager();
        fontManager.setFontForZoom(zoomToFit);
        visitor.setRendererModel(this.model);
        visitor.setFontManager((IFontManager)fontManager);
        visitor.setTransform(transform);
        visitor.visit(bounds.root());
    }

    final double rescaleForBondLength(double bondLength) {
        return bondLength / (Double)this.model.get(BasicSceneGenerator.BondLength.class);
    }

    protected void svgStyleCache(String fmt, double rescale, SvgDrawVisitor visitor, List<? extends IRenderingElement> elements) {
        visitor.setTransform(AffineTransform.getScaleInstance(rescale, rescale));
        visitor.previsit(elements);
        visitor.setTransform(null);
    }

    protected double calcFitting(Dimensions srcDim, Dimensions dstDim, double margin) {
        if (dstDim == Dimensions.AUTOMATIC) {
            return 1.0;
        }
        dstDim = dstDim.add(2.0 * -margin, 2.0 * -margin);
        double resize = Math.min(dstDim.w / srcDim.w, dstDim.h / srcDim.h);
        if (resize > 1.0 && !((Boolean)this.model.get(BasicSceneGenerator.FitToScreen.class)).booleanValue()) {
            resize = 1.0;
        }
        return resize;
    }
}

