/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.depict;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openscience.cdk.depict.Dimensions;
import org.openscience.cdk.depict.ReactionDimensions;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.renderer.RendererModel;
import org.openscience.cdk.renderer.elements.Bounds;

final class ReactionBounds {
    RendererModel model;
    List<Bounds> reactants = new ArrayList<Bounds>();
    List<Bounds> products = new ArrayList<Bounds>();
    List<Bounds> reactantLabels = new ArrayList<Bounds>();
    List<Bounds> productLabels = new ArrayList<Bounds>();
    List<Bounds> aboveArrow = new ArrayList<Bounds>();
    List<Bounds> belowArrow = new ArrayList<Bounds>();
    IReaction.Direction direction = IReaction.Direction.FORWARD;
    Bounds plus = null;
    Bounds title = null;

    ReactionBounds() {
    }

    List<Bounds> getMainRow() {
        int i;
        ArrayList<Bounds> mainRow = new ArrayList<Bounds>();
        for (i = 0; i < this.reactants.size(); ++i) {
            if (i != 0) {
                mainRow.add(this.plus);
            }
            mainRow.add(this.reactants.get(i));
        }
        if (this.direction != null) {
            mainRow.add(new Bounds());
        }
        for (i = 0; i < this.products.size(); ++i) {
            if (i != 0) {
                mainRow.add(this.plus);
            }
            mainRow.add(this.products.get(i));
        }
        return mainRow;
    }

    boolean hasMainRowLabels() {
        return !this.reactantLabels.isEmpty() || !this.productLabels.isEmpty();
    }

    List<Bounds> getMainRowLabels() {
        int i;
        if (!this.hasMainRowLabels()) {
            return Collections.emptyList();
        }
        ArrayList<Bounds> labels = new ArrayList<Bounds>();
        for (i = 0; i < this.reactants.size(); ++i) {
            if (i != 0) {
                labels.add(new Bounds());
            }
            if (i < this.reactantLabels.size()) {
                labels.add(this.reactantLabels.get(i));
                continue;
            }
            labels.add(new Bounds());
        }
        if (this.direction != null) {
            labels.add(new Bounds());
        }
        for (i = 0; i < this.productLabels.size(); ++i) {
            if (i != 0) {
                labels.add(new Bounds());
            }
            labels.add(this.productLabels.get(i));
        }
        return labels;
    }

    List<Bounds> getMainComponents() {
        ArrayList<Bounds> bounds = new ArrayList<Bounds>(this.getMainRow());
        if (this.hasMainRowLabels()) {
            bounds.addAll(this.getMainRowLabels());
        }
        return bounds;
    }

    int getArrowIndex() {
        int numGaps = Math.max(0, this.reactants.size() - 1);
        return this.reactants.size() + numGaps;
    }

    ReactionDimensions getDimensions(double padding) {
        ReactionDimensions result;
        int nCol;
        int nRow;
        double minArrowWidth;
        List<Bounds> mainComp = this.getMainComponents();
        double arrowHeight = this.plus.height();
        double arrowHeadLength = this.plus.height();
        double d = minArrowWidth = this.direction != null && this.direction != IReaction.Direction.UNDIRECTED ? 5.0 * arrowHeight : arrowHeight;
        if (this.hasMainRowLabels()) {
            nRow = 2;
            nCol = mainComp.size() / 2;
        } else {
            nRow = 1;
            nCol = mainComp.size();
        }
        double[] yOffsets = new double[nRow + 1];
        double[] xOffsets = new double[nCol + 1];
        Dimensions mainDim = Dimensions.ofGrid(mainComp, yOffsets, xOffsets);
        Dimension sideGrid = Dimensions.determineGrid(this.aboveArrow.size());
        double[] yOffsetSide = new double[sideGrid.width + 1];
        double[] xOffsetSide = new double[sideGrid.height + 1];
        Dimensions prelimSideDim = Dimensions.ofGrid(this.aboveArrow, yOffsetSide, xOffsetSide);
        Bounds conditions = this.belowArrow.isEmpty() ? new Bounds() : this.belowArrow.get(0);
        double middleRequired = 2.0 * padding + arrowHeadLength + Math.max(prelimSideDim.w + (double)Math.max(0, xOffsetSide.length - 2) * padding, conditions.width());
        if (middleRequired < minArrowWidth) {
            double xAdjust = (minArrowWidth - middleRequired) / 2.0;
            int i = 0;
            while (i < xOffsetSide.length) {
                int n = i++;
                xOffsetSide[n] = xOffsetSide[n] + xAdjust;
            }
            if (conditions.width() > prelimSideDim.w) {
                i = 0;
                while (i < xOffsetSide.length) {
                    int n = i++;
                    xOffsetSide[n] = xOffsetSide[n] + (conditions.width() - prelimSideDim.w) / 2.0;
                }
            }
            Dimensions sideDim = new Dimensions(minArrowWidth, prelimSideDim.h);
            Dimensions condDim = new Dimensions(minArrowWidth, conditions.height());
            Dimensions titleDim = new Dimensions(this.title.width(), this.title.height());
            int j = this.getArrowIndex() + 1;
            while (j < xOffsets.length) {
                int n = j++;
                xOffsets[n] = xOffsets[n] + minArrowWidth;
            }
            result = new ReactionDimensions(sideDim, mainDim, condDim, titleDim, padding);
        } else {
            if (conditions.width() > prelimSideDim.w) {
                int i = 0;
                while (i < xOffsetSide.length) {
                    int n = i++;
                    xOffsetSide[n] = xOffsetSide[n] + (conditions.width() - prelimSideDim.w) / 2.0;
                }
            }
            int j = this.getArrowIndex() + 1;
            while (j < xOffsets.length) {
                int n = j++;
                xOffsets[n] = xOffsets[n] + middleRequired;
            }
            Dimensions sideDim = new Dimensions(prelimSideDim.w, prelimSideDim.h);
            Dimensions condDim = new Dimensions(middleRequired, conditions.height());
            Dimensions titleDim = new Dimensions(this.title.width(), this.title.height());
            result = new ReactionDimensions(sideDim, mainDim, condDim, titleDim, padding);
        }
        result.xOffsets = xOffsets;
        result.yOffsets = yOffsets;
        result.xOffsetSide = xOffsetSide;
        result.yOffsetSide = yOffsetSide;
        return result;
    }
}

