/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.depict;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.openscience.cdk.depict.Depiction;
import org.openscience.cdk.depict.Dimensions;
import org.openscience.cdk.depict.FreeHepWrapper;
import org.openscience.cdk.depict.ReactionBounds;
import org.openscience.cdk.depict.ReactionDimensions;
import org.openscience.cdk.depict.SvgDrawVisitor;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.renderer.elements.Bounds;
import org.openscience.cdk.renderer.elements.GeneralPath;
import org.openscience.cdk.renderer.elements.IRenderingElement;
import org.openscience.cdk.renderer.elements.LineElement;
import org.openscience.cdk.renderer.elements.RectangleElement;
import org.openscience.cdk.renderer.generators.BasicSceneGenerator;
import org.openscience.cdk.renderer.visitor.AWTDrawVisitor;
import org.openscience.cdk.renderer.visitor.IDrawVisitor;

final class ReactionDepiction
extends Depiction {
    private Dimensions dimensions;
    private final ReactionBounds reactionBounds;
    private final Color fgcol;

    ReactionDepiction(ReactionBounds reactionBounds, Dimensions dimensions, Color fgcol) {
        super(reactionBounds.model);
        this.dimensions = dimensions;
        this.fgcol = fgcol;
        this.reactionBounds = reactionBounds;
    }

    void draw(IDrawVisitor visitor, ReactionDimensions required, Rectangle2D viewBounds, String fmt) {
        double h;
        double w;
        double y;
        double x;
        int row;
        int i;
        double scale = (Double)this.model.get(BasicSceneGenerator.Scale.class);
        double zoom = (Double)this.model.get(BasicSceneGenerator.ZoomFactor.class);
        double padding = required.padding;
        List<Bounds> mainComp = this.reactionBounds.getMainComponents();
        List<Bounds> sideComps = this.reactionBounds.aboveArrow;
        int arrowIdx = this.reactionBounds.getArrowIndex();
        double arrowHeight = this.reactionBounds.plus.height() * required.scale;
        int nSideCol = required.xOffsetSide.length - 1;
        int nSideRow = required.yOffsetSide.length - 1;
        double mainCompOffset = required.sideDim.h + (double)nSideRow * padding - required.mainRowHeight() / 2.0;
        int nCol = required.xOffsets.length - 1;
        int nRow = required.yOffsets.length - 1;
        double totalRequiredWidth = (double)Math.max(0, nCol - 1) * padding + required.xOffsets[nCol];
        double totalRequiredHeight = (double)Math.max(0, nRow - 1) * padding + (!this.reactionBounds.title.isEmpty() ? padding : 0.0) + Math.max(mainCompOffset, 0.0) + required.mainDim.h + Math.max(0.0, required.titleDim.h);
        double xBase = viewBounds.getX() + (viewBounds.getWidth() - totalRequiredWidth) / 2.0;
        double yBase = viewBounds.getY() + Math.max(mainCompOffset, 0.0) + (viewBounds.getHeight() - totalRequiredHeight) / 2.0;
        for (i = 0; i < mainComp.size(); ++i) {
            row = i / nCol;
            int col = i % nCol;
            x = xBase + (double)col * padding + required.xOffsets[col];
            y = yBase + (double)row * padding + required.yOffsets[row];
            w = required.xOffsets[col + 1] - required.xOffsets[col];
            h = required.yOffsets[row + 1] - required.yOffsets[row];
            if (i == arrowIdx && this.reactionBounds.direction != null) {
                w = required.xOffsets[i + 1] - required.xOffsets[i];
                this.draw(visitor, 1.0, ReactionDepiction.createArrow(this.reactionBounds.direction, this.fgcol, w, arrowHeight), ReactionDepiction.rect(x, y, w, h));
                continue;
            }
            Bounds bounds = mainComp.get(i);
            if (bounds.isEmpty()) continue;
            this.draw(visitor, zoom, bounds, ReactionDepiction.rect(x, y, w, h));
        }
        if (!this.reactionBounds.title.isEmpty()) {
            double y2 = yBase + (double)nRow * padding + required.yOffsets[nRow];
            double h2 = required.scale * this.reactionBounds.title.height();
            this.draw(visitor, zoom, this.reactionBounds.title, ReactionDepiction.rect(0.0, y2, viewBounds.getWidth(), h2));
        }
        xBase += (double)arrowIdx * padding + required.xOffsets[arrowIdx];
        yBase -= mainCompOffset;
        for (i = 0; i < sideComps.size(); ++i) {
            row = i / nSideCol;
            int col = i % nSideCol;
            x = xBase + (double)(col + 1) * padding + required.xOffsetSide[col];
            y = yBase + (double)row * padding + required.yOffsetSide[row];
            w = required.xOffsetSide[col + 1] - required.xOffsetSide[col];
            h = required.yOffsetSide[row + 1] - required.yOffsetSide[row];
            this.draw(visitor, zoom, sideComps.get(i), ReactionDepiction.rect(x, y, w, h));
        }
        if (!this.reactionBounds.belowArrow.isEmpty()) {
            yBase += mainCompOffset;
            this.draw(visitor, zoom, this.reactionBounds.belowArrow.get(0), ReactionDepiction.rect(xBase, yBase += 2.0 * padding + arrowHeight, required.condDim.w, required.condDim.h));
        }
    }

    @Override
    public BufferedImage toImg() {
        double scale = (Double)this.model.get(BasicSceneGenerator.Scale.class);
        double zoom = (Double)this.model.get(BasicSceneGenerator.ZoomFactor.class);
        double margin = this.getMarginValue(4.0);
        double padding = this.getPaddingValue(2.5 * margin) / (scale * zoom);
        ReactionDimensions reactionDimensions = this.reactionBounds.getDimensions(padding);
        ReactionDimensions required = this.reactionBounds.getDimensions(padding).resize(scale * zoom);
        Dimensions total = required.calcTotalDimensions(null);
        Dimensions totalWithMargin = total.add(2.0 * margin, 2.0 * margin);
        double fitting = this.calcFitting(total, this.dimensions, margin);
        if (Math.abs(1.0 - fitting) >= 0.01) {
            total = total.scale(fitting);
            totalWithMargin = total.add(2.0 * margin, 2.0 * margin);
            required = required.resize(fitting);
        }
        Dimensions canvasSize = totalWithMargin;
        if (this.dimensions != Dimensions.AUTOMATIC) {
            canvasSize = this.dimensions;
        }
        BufferedImage img = new BufferedImage((int)Math.ceil(canvasSize.w), (int)Math.ceil(canvasSize.h), 6);
        Graphics2D g2 = img.createGraphics();
        AWTDrawVisitor visitor = AWTDrawVisitor.forVectorGraphics((Graphics2D)g2);
        visitor.setTransform(AffineTransform.getScaleInstance(1.0, -1.0));
        visitor.visit((IRenderingElement)new RectangleElement(0.0, (double)(-((int)Math.ceil(total.h))), (double)((int)Math.ceil(total.w)), (double)((int)Math.ceil(total.h)), true, (Color)this.model.get(BasicSceneGenerator.BackgroundColor.class)));
        double xOffset = margin;
        double yOffset = margin;
        if (this.dimensions != Dimensions.AUTOMATIC) {
            if (this.dimensions.w > totalWithMargin.w) {
                xOffset += (this.dimensions.w - totalWithMargin.w) / 2.0;
            }
            if (this.dimensions.h > totalWithMargin.h) {
                yOffset += (this.dimensions.h - totalWithMargin.h) / 2.0;
            }
        }
        this.draw((IDrawVisitor)visitor, required, ReactionDepiction.rect(xOffset, yOffset, total.w, total.h), null);
        g2.dispose();
        return img;
    }

    @Override
    byte[] toVecBytes(String fmt, String units) {
        SvgDrawVisitor visitor;
        double zoom;
        double scale = (Double)this.model.get(BasicSceneGenerator.Scale.class);
        double margin = this.getMarginValue(units.equals("mm") ? 0.56 : 4.0);
        double zoomBackup = zoom = ((Double)this.model.get(BasicSceneGenerator.ZoomFactor.class)).doubleValue();
        if (units.equals("mm")) {
            zoom *= this.rescaleForBondLength(5.08);
        }
        double padding = this.getPaddingValue(2.5 * margin) / (zoom * scale);
        if (fmt.equals("pdf") || fmt.equals("ps")) {
            zoom *= 2.83464566751;
            margin *= 2.83464566751;
            padding *= 2.83464566751;
            this.dimensions = this.dimensions.scale(2.83464566751);
        }
        this.model.set(BasicSceneGenerator.ZoomFactor.class, (Object)zoom);
        ReactionDimensions required = this.reactionBounds.getDimensions(padding).resize(scale * zoom);
        Dimensions total = required.calcTotalDimensions(fmt);
        Dimensions totalWithMargin = total.add(2.0 * margin, 2.0 * margin);
        double fitting = this.calcFitting(total, this.dimensions, margin);
        if (Math.abs(1.0 - fitting) >= 0.01) {
            total = total.scale(fitting);
            totalWithMargin = total.add(2.0 * margin, 2.0 * margin);
            required = required.resize(fitting);
        }
        Dimensions canvasSize = totalWithMargin;
        if (this.dimensions != Dimensions.AUTOMATIC) {
            canvasSize = this.dimensions;
        }
        FreeHepWrapper wrapper = null;
        if (fmt.equals("svg")) {
            visitor = new SvgDrawVisitor(canvasSize.w, canvasSize.h, units);
            this.svgStyleCache(fmt, scale * zoom * fitting, visitor, this.reactionBounds.getMainComponents());
        } else {
            wrapper = new FreeHepWrapper(fmt, canvasSize.w, canvasSize.h);
            visitor = AWTDrawVisitor.forVectorGraphics((Graphics2D)wrapper.g2);
            ((AWTDrawVisitor)visitor).setRounding(false);
        }
        visitor.setTransform(AffineTransform.getScaleInstance(1.0, -1.0));
        visitor.visit((IRenderingElement)new RectangleElement(0.0, (double)(-((int)Math.ceil(totalWithMargin.h))), (double)((int)Math.ceil(totalWithMargin.w)), (double)((int)Math.ceil(totalWithMargin.h)), true, (Color)this.model.get(BasicSceneGenerator.BackgroundColor.class)));
        double xOffset = margin;
        double yOffset = margin;
        if (this.dimensions != Dimensions.AUTOMATIC) {
            if (this.dimensions.w > totalWithMargin.w) {
                xOffset += (this.dimensions.w - totalWithMargin.w) / 2.0;
            }
            if (this.dimensions.h > totalWithMargin.h) {
                yOffset += (this.dimensions.h - totalWithMargin.h) / 2.0;
            }
        }
        this.draw((IDrawVisitor)visitor, required, ReactionDepiction.rect(xOffset, yOffset, total.w, total.h), fmt);
        this.model.set(BasicSceneGenerator.ZoomFactor.class, (Object)zoomBackup);
        if (wrapper != null) {
            wrapper.dispose();
            return wrapper.getBytes();
        }
        return ((Object)visitor).toString().getBytes(StandardCharsets.UTF_8);
    }

    private double calcFitting(ReactionDimensions srcDim, Dimensions dstDim, String fmt) {
        double resize;
        double mainCompOffset;
        if (dstDim == Dimensions.AUTOMATIC) {
            return 1.0;
        }
        double zoom = (Double)this.model.get(BasicSceneGenerator.ZoomFactor.class);
        double padding = srcDim.padding;
        double firstRowHeight = srcDim.yOffsets[1];
        int nSideCol = srcDim.xOffsetSide.length - 1;
        int nSideRow = srcDim.yOffsetSide.length - 1;
        double d = mainCompOffset = srcDim.sideDim.h > 0.0 ? srcDim.sideDim.h + (double)nSideRow * padding - firstRowHeight / 2.0 : 0.0;
        if (mainCompOffset < 0.0) {
            mainCompOffset = 0.0;
        }
        Dimensions required = srcDim.mainDim.add(srcDim.sideDim.w, mainCompOffset).add(0.0, Math.max(0.0, srcDim.titleDim.h));
        Dimensions targetDim = dstDim;
        int nCol = srcDim.xOffsets.length - 1;
        int nRow = srcDim.yOffsets.length - 1;
        targetDim = targetDim.add(-((double)(nCol - 1) * padding), -((double)(nRow - 1) * padding)).add(0.0, srcDim.titleDim.h > 0.0 ? -padding : 0.0);
        if ("pdf".equals(fmt) || "ps".equals(fmt)) {
            targetDim = targetDim.scale(2.83464566751);
        }
        if ((resize = Math.min(targetDim.w / required.w, targetDim.h / required.h)) > 1.0 && !((Boolean)this.model.get(BasicSceneGenerator.FitToScreen.class)).booleanValue()) {
            resize = 1.0;
        }
        return resize;
    }

    static Rectangle2D.Double rect(double x, double y, double w, double h) {
        return new Rectangle2D.Double(x, y, w, h);
    }

    static Bounds createArrow(IReaction.Direction direction, Color color, double length, double minHeight) {
        if (direction == null) {
            return new Bounds();
        }
        Path2D.Double path = new Path2D.Double();
        double headThickness = minHeight / 3.0;
        double inset = 0.8;
        double headLength = minHeight;
        double strokeWidth = minHeight / 14.0;
        Bounds arrow = new Bounds(0.0, -headThickness, length, headThickness);
        switch (direction) {
            case FORWARD: {
                arrow.add((IRenderingElement)new LineElement(0.0, 0.0, length - 0.5 * headLength, 0.0, strokeWidth, color));
                ((Path2D)path).moveTo(length, 0.0);
                ((Path2D)path).lineTo(length - headLength, headThickness);
                ((Path2D)path).lineTo(length - 0.8 * headLength, 0.0);
                ((Path2D)path).lineTo(length - headLength, -headThickness);
                path.closePath();
                arrow.add((IRenderingElement)GeneralPath.shapeOf((Shape)path, (Color)color));
                break;
            }
            case BACKWARD: {
                arrow.add((IRenderingElement)new LineElement(0.5 * headLength, 0.0, length, 0.0, strokeWidth, color));
                ((Path2D)path).moveTo(0.0, 0.0);
                ((Path2D)path).lineTo(minHeight, headThickness);
                ((Path2D)path).lineTo(minHeight - 0.19999999999999996 * minHeight, 0.0);
                ((Path2D)path).lineTo(minHeight, -headThickness);
                path.closePath();
                arrow.add((IRenderingElement)GeneralPath.shapeOf((Shape)path, (Color)color));
                break;
            }
            case UNDIRECTED: {
                double x1 = headThickness;
                double x2 = length - 2.0 * headThickness;
                double y = 0.5 * headThickness;
                arrow.add((IRenderingElement)new LineElement(x1, -y, x2, -y, strokeWidth, color));
                arrow.add((IRenderingElement)new LineElement(x1, y, x2, y, strokeWidth, color));
                break;
            }
            case BIDIRECTIONAL: {
                arrow.add((IRenderingElement)new LineElement(0.0, 0.5 * headThickness, length - 0.5 * headLength, 0.5 * headThickness, strokeWidth, color));
                ((Path2D)path).moveTo(length, 0.5 * headThickness - 0.5 * strokeWidth);
                ((Path2D)path).lineTo(length - headLength, 1.5 * headThickness);
                ((Path2D)path).lineTo(length - 0.8 * headLength, 0.5 * headThickness - 0.5 * strokeWidth);
                path.closePath();
                arrow.add((IRenderingElement)new LineElement(0.5 * headLength, -0.5 * headThickness, length, -0.5 * headThickness, strokeWidth, color));
                ((Path2D)path).moveTo(0.0, -0.5 * headThickness + 0.5 * strokeWidth);
                ((Path2D)path).lineTo(headLength, -1.5 * headThickness);
                ((Path2D)path).lineTo(0.8 * headLength, -0.5 * headThickness + 0.5 * strokeWidth);
                path.closePath();
                arrow.add((IRenderingElement)GeneralPath.shapeOf((Shape)path, (Color)color));
                break;
            }
            case NO_GO: {
                arrow.add((IRenderingElement)new LineElement(0.0, 0.0, length - 0.5 * headLength, 0.0, strokeWidth, color));
                ((Path2D)path).moveTo(length, 0.0);
                ((Path2D)path).lineTo(length - headLength, headThickness);
                ((Path2D)path).lineTo(length - 0.8 * headLength, 0.0);
                ((Path2D)path).lineTo(length - headLength, -headThickness);
                path.closePath();
                arrow.add((IRenderingElement)GeneralPath.shapeOf((Shape)path, (Color)color));
                double cx = length / 2.0;
                arrow.add((IRenderingElement)new LineElement(cx - headThickness, -headThickness, cx + headThickness, headThickness, strokeWidth, color));
                arrow.add((IRenderingElement)new LineElement(cx - headThickness, headThickness, cx + headThickness, -headThickness, strokeWidth, color));
                break;
            }
            case RETRO_SYNTHETIC: {
                arrow.add((IRenderingElement)new LineElement(0.0, -headThickness, length - 0.5 * headLength, -headThickness, strokeWidth, color));
                arrow.add((IRenderingElement)new LineElement(0.0, headThickness, length - 0.5 * headLength, headThickness, strokeWidth, color));
                ((Path2D)path).moveTo(length - headLength, -2.0 * headThickness);
                ((Path2D)path).lineTo(length, 0.0);
                ((Path2D)path).lineTo(length - headLength, 2.0 * headThickness);
                arrow.add((IRenderingElement)GeneralPath.outlineOf((Shape)path, (double)strokeWidth, (Color)color));
                break;
            }
            case RESONANCE: {
                arrow.add((IRenderingElement)new LineElement(0.5 * headLength, 0.0, length - 0.5 * headLength, 0.0, strokeWidth, color));
                ((Path2D)path).moveTo(length, 0.0);
                ((Path2D)path).lineTo(length - headLength, headThickness);
                ((Path2D)path).lineTo(length - 0.8 * headLength, 0.0);
                ((Path2D)path).lineTo(length - headLength, -headThickness);
                path.closePath();
                ((Path2D)path).moveTo(0.0, 0.0);
                ((Path2D)path).lineTo(minHeight, headThickness);
                ((Path2D)path).lineTo(minHeight - 0.19999999999999996 * minHeight, 0.0);
                ((Path2D)path).lineTo(minHeight, -headThickness);
                path.closePath();
                arrow.add((IRenderingElement)GeneralPath.shapeOf((Shape)path, (Color)color));
            }
        }
        return arrow;
    }
}

