/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.depict;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.openscience.cdk.depict.Depiction;
import org.openscience.cdk.depict.Dimensions;
import org.openscience.cdk.depict.FreeHepWrapper;
import org.openscience.cdk.depict.ReactionBounds;
import org.openscience.cdk.depict.ReactionDepiction;
import org.openscience.cdk.depict.ReactionDimensions;
import org.openscience.cdk.depict.SvgDrawVisitor;
import org.openscience.cdk.renderer.RendererModel;
import org.openscience.cdk.renderer.elements.Bounds;
import org.openscience.cdk.renderer.elements.IRenderingElement;
import org.openscience.cdk.renderer.elements.RectangleElement;
import org.openscience.cdk.renderer.generators.BasicSceneGenerator;
import org.openscience.cdk.renderer.visitor.AWTDrawVisitor;
import org.openscience.cdk.renderer.visitor.IDrawVisitor;

final class ReactionSetDepiction
extends Depiction {
    private final RendererModel model;
    private Dimensions dimensions;
    private final List<ReactionBounds> reactions;
    private final Color fgcol;
    private final boolean isSequence;

    ReactionSetDepiction(RendererModel model, List<ReactionBounds> reactions, Dimensions dimensions, boolean isSequence, Color fgcol) {
        super(model);
        this.model = model;
        this.dimensions = dimensions;
        this.reactions = reactions;
        this.isSequence = isSequence;
        this.fgcol = fgcol;
        if (isSequence) {
            ReactionBounds duped = new ReactionBounds();
            ReactionBounds last = reactions.get(reactions.size() - 1);
            duped.model = last.model;
            duped.direction = null;
            duped.plus = last.plus;
            duped.title = new Bounds();
            duped.reactants.addAll(last.products);
            duped.reactantLabels.addAll(last.productLabels);
            for (ReactionBounds reaction : reactions) {
                reaction.products.clear();
                reaction.productLabels.clear();
            }
            reactions.add(duped);
        }
    }

    private Dimensions getRequiredSize(List<ReactionDimensions> dimensions, String fmt, double spacing) {
        if (dimensions.isEmpty()) {
            throw new IllegalArgumentException();
        }
        Dimensions total = dimensions.get(0).calcTotalDimensions(fmt);
        double padding = dimensions.get((int)0).padding;
        for (int i = 1; i < dimensions.size(); ++i) {
            Dimensions part = dimensions.get(i).calcTotalDimensions(fmt);
            total = total.add(Math.max(part.w - total.w, 0.0), spacing + part.h);
        }
        return total;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public BufferedImage toImg() {
        double scale = (Double)this.model.get(BasicSceneGenerator.Scale.class);
        double zoom = (Double)this.model.get(BasicSceneGenerator.ZoomFactor.class);
        double margin = this.getMarginValue(4.0);
        double padding = this.getPaddingValue(2.5 * margin) / (zoom * scale);
        double spacing = padding * zoom * scale;
        for (ReactionBounds reactionBounds : this.reactions) {
            reactionBounds.model.set(BasicSceneGenerator.ZoomFactor.class, (Object)zoom);
        }
        this.model.set(BasicSceneGenerator.ZoomFactor.class, (Object)zoom);
        ArrayList<ReactionDimensions> reactionSetDimensions = new ArrayList<ReactionDimensions>();
        for (ReactionBounds bounds : this.reactions) {
            reactionSetDimensions.add(bounds.getDimensions(padding).resize(zoom * scale));
        }
        Dimensions dimensions = this.getRequiredSize(reactionSetDimensions, null, spacing);
        Dimensions totalWithMargin = dimensions.add(2.0 * margin, 2.0 * margin);
        double fitting = this.calcFitting(dimensions, this.dimensions, margin);
        if (Math.abs(1.0 - fitting) >= 0.01) {
            spacing *= fitting;
            Dimensions dimensions2 = dimensions.scale(fitting);
            totalWithMargin = dimensions2.add(2.0 * margin, 2.0 * margin);
            reactionSetDimensions.replaceAll(reactionDimensions -> reactionDimensions.resize(fitting));
        }
        Dimensions canvasSize = totalWithMargin;
        if (this.dimensions != Dimensions.AUTOMATIC) {
            canvasSize = this.dimensions;
        }
        BufferedImage img = new BufferedImage((int)Math.ceil(canvasSize.w), (int)Math.ceil(canvasSize.h), 6);
        Graphics2D g2 = img.createGraphics();
        AWTDrawVisitor visitor = AWTDrawVisitor.forVectorGraphics((Graphics2D)g2);
        visitor.setTransform(AffineTransform.getScaleInstance(1.0, -1.0));
        visitor.visit((IRenderingElement)new RectangleElement(0.0, (double)(-((int)Math.ceil(canvasSize.h))), (double)((int)Math.ceil(canvasSize.w)), (double)((int)Math.ceil(canvasSize.h)), true, (Color)this.model.get(BasicSceneGenerator.BackgroundColor.class)));
        double xOffset = margin;
        double yOffset = margin;
        if (this.dimensions != Dimensions.AUTOMATIC) {
            if (this.dimensions.w > totalWithMargin.w) {
                xOffset += (this.dimensions.w - totalWithMargin.w) / 2.0;
            }
            if (this.dimensions.h > totalWithMargin.h) {
                yOffset += (this.dimensions.h - totalWithMargin.h) / 2.0;
            }
        }
        for (int i = 0; i < this.reactions.size(); ++i) {
            void var12_11;
            ReactionBounds reactionBounds = this.reactions.get(i);
            ReactionDimensions reactionDimensions2 = (ReactionDimensions)reactionSetDimensions.get(i);
            Dimensions partDims = reactionDimensions2.calcTotalDimensions(null);
            ReactionDepiction reactionDepiction = new ReactionDepiction(reactionBounds, null, this.fgcol);
            reactionDepiction.draw((IDrawVisitor)visitor, reactionDimensions2, ReactionDepiction.rect(xOffset, yOffset, var12_11.w, partDims.h), null);
            yOffset += spacing + partDims.h;
        }
        g2.dispose();
        return img;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    byte[] toVecBytes(String fmt, String units) {
        SvgDrawVisitor visitor;
        double zoom;
        double scale = (Double)this.model.get(BasicSceneGenerator.Scale.class);
        double margin = this.getMarginValue(units.equals("mm") ? 0.56 : 4.0);
        double zoomBackup = zoom = ((Double)this.model.get(BasicSceneGenerator.ZoomFactor.class)).doubleValue();
        if (units.equals("mm")) {
            double rescale = this.rescaleForBondLength(5.08);
            zoom *= rescale;
        }
        double padding = this.getPaddingValue(2.5 * margin) / (zoom * scale);
        if (fmt.equals("pdf") || fmt.equals("ps")) {
            zoom *= 2.83464566751;
            margin *= 2.83464566751;
            padding *= 2.83464566751;
            this.dimensions = this.dimensions.scale(2.83464566751);
        }
        double spacing = padding * zoom * scale;
        for (ReactionBounds reactionBounds : this.reactions) {
            reactionBounds.model.set(BasicSceneGenerator.ZoomFactor.class, (Object)zoom);
        }
        this.model.set(BasicSceneGenerator.ZoomFactor.class, (Object)zoom);
        ArrayList<ReactionDimensions> reactionSetDimensions = new ArrayList<ReactionDimensions>();
        for (ReactionBounds bounds : this.reactions) {
            reactionSetDimensions.add(bounds.getDimensions(padding).resize(zoom * scale));
        }
        Dimensions dimensions = this.getRequiredSize(reactionSetDimensions, fmt, spacing);
        Dimensions totalWithMargin = dimensions.add(2.0 * margin, 2.0 * margin);
        double fitting = this.calcFitting(dimensions, this.dimensions, margin);
        if (Math.abs(1.0 - fitting) >= 0.01) {
            spacing *= fitting;
            Dimensions dimensions2 = dimensions.scale(fitting);
            totalWithMargin = dimensions2.add(2.0 * margin, 2.0 * margin);
            reactionSetDimensions.replaceAll(reactionDimensions -> reactionDimensions.resize(fitting));
        }
        Dimensions canvasSize = totalWithMargin;
        if (this.dimensions != Dimensions.AUTOMATIC) {
            canvasSize = this.dimensions;
        }
        FreeHepWrapper wrapper = null;
        if (fmt.equals("svg")) {
            visitor = new SvgDrawVisitor(canvasSize.w, canvasSize.h, units);
            this.svgStyleCache(fmt, scale, zoom, fitting, visitor);
        } else {
            wrapper = new FreeHepWrapper(fmt, canvasSize.w, canvasSize.h);
            visitor = AWTDrawVisitor.forVectorGraphics((Graphics2D)wrapper.g2);
            ((AWTDrawVisitor)visitor).setRounding(false);
        }
        visitor.setTransform(AffineTransform.getScaleInstance(1.0, -1.0));
        visitor.visit((IRenderingElement)new RectangleElement(0.0, (double)(-((int)Math.ceil(canvasSize.h))), (double)((int)Math.ceil(canvasSize.w)), (double)((int)Math.ceil(canvasSize.h)), true, (Color)this.model.get(BasicSceneGenerator.BackgroundColor.class)));
        double xOffset = margin;
        double yOffset = margin;
        if (this.dimensions != Dimensions.AUTOMATIC) {
            if (this.dimensions.w > totalWithMargin.w) {
                xOffset += (this.dimensions.w - totalWithMargin.w) / 2.0;
            }
            if (this.dimensions.h > totalWithMargin.h) {
                yOffset += (this.dimensions.h - totalWithMargin.h) / 2.0;
            }
        }
        for (int i = 0; i < this.reactions.size(); ++i) {
            void var16_14;
            ReactionBounds reactionBounds = this.reactions.get(i);
            ReactionDimensions reactionDimensions2 = (ReactionDimensions)reactionSetDimensions.get(i);
            Dimensions partDims = reactionDimensions2.calcTotalDimensions(null);
            ReactionDepiction reactionDepiction = new ReactionDepiction(reactionBounds, null, this.fgcol);
            reactionDepiction.draw((IDrawVisitor)visitor, reactionDimensions2, ReactionDepiction.rect(xOffset, yOffset, var16_14.w, partDims.h), fmt);
            yOffset += spacing + partDims.h;
        }
        for (ReactionBounds bounds : this.reactions) {
            bounds.model.set(BasicSceneGenerator.ZoomFactor.class, (Object)zoomBackup);
        }
        this.model.set(BasicSceneGenerator.ZoomFactor.class, (Object)zoomBackup);
        if (wrapper != null) {
            wrapper.dispose();
            return wrapper.getBytes();
        }
        return ((Object)visitor).toString().getBytes(StandardCharsets.UTF_8);
    }

    private void svgStyleCache(String fmt, double scale, double zoom, double fitting, SvgDrawVisitor visitor) {
        for (ReactionBounds rbounds : this.reactions) {
            this.svgStyleCache(fmt, zoom * scale * fitting, visitor, rbounds.getMainRow());
        }
    }
}

