/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.geometry.CrystalGeometryTools;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IChemFile;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemSequence;
import org.openscience.cdk.interfaces.ICrystal;
import org.openscience.cdk.io.DefaultChemObjectReader;
import org.openscience.cdk.io.formats.CrystClustFormat;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.math.FortranFormat;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

public class CrystClustReader
extends DefaultChemObjectReader {
    private BufferedReader input;
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(CrystClustReader.class);

    public CrystClustReader() {
    }

    public CrystClustReader(Reader input) {
        this();
        this.input = input instanceof BufferedReader ? (BufferedReader)input : new BufferedReader(input);
    }

    public CrystClustReader(InputStream input) {
        this(new InputStreamReader(input));
    }

    public IResourceFormat getFormat() {
        return CrystClustFormat.getInstance();
    }

    public void setReader(Reader reader) throws CDKException {
        this.input = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
    }

    public void setReader(InputStream input) throws CDKException {
        this.setReader(new InputStreamReader(input));
    }

    public boolean accepts(Class<? extends IChemObject> classObject) {
        if (IChemFile.class.equals(classObject)) {
            return true;
        }
        Class<?>[] interfaces = classObject.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (!IChemFile.class.equals(interfaces[i])) continue;
            return true;
        }
        Class<? extends IChemObject> superClass = classObject.getSuperclass();
        if (superClass != null) {
            return this.accepts(superClass);
        }
        return false;
    }

    public <T extends IChemObject> T read(T object) throws CDKException {
        if (object instanceof IChemFile) {
            IChemFile cf = this.readChemFile((IChemFile)object);
            return (T)cf;
        }
        throw new CDKException("Only supported is reading of ChemFile.");
    }

    private IChemFile readChemFile(IChemFile file) throws CDKException {
        IChemSequence seq = (IChemSequence)file.getBuilder().newInstance(IChemSequence.class, new Object[0]);
        IChemModel model = (IChemModel)file.getBuilder().newInstance(IChemModel.class, new Object[0]);
        ICrystal crystal = null;
        int lineNumber = 0;
        try {
            String line = this.input.readLine();
            while (this.input.ready() && line != null) {
                logger.debug((Object)(lineNumber++ + ": "), new Object[]{line});
                if (line.startsWith("frame:")) {
                    logger.debug((Object)"found new frame");
                    model = (IChemModel)file.getBuilder().newInstance(IChemModel.class, new Object[0]);
                    crystal = (ICrystal)file.getBuilder().newInstance(ICrystal.class, new Object[0]);
                    logger.debug((Object)"reading spacegroup");
                    line = this.input.readLine();
                    logger.debug((Object)(lineNumber++ + ": "), new Object[]{line});
                    crystal.setSpaceGroup(line);
                    logger.debug((Object)"reading unit cell axes");
                    Vector3d axis = new Vector3d();
                    logger.debug((Object)"parsing A: ");
                    line = this.input.readLine();
                    logger.debug((Object)(lineNumber++ + ": "), new Object[]{line});
                    axis.x = FortranFormat.atof((String)line);
                    line = this.input.readLine();
                    logger.debug((Object)(lineNumber++ + ": "), new Object[]{line});
                    axis.y = FortranFormat.atof((String)line);
                    line = this.input.readLine();
                    logger.debug((Object)(lineNumber++ + ": "), new Object[]{line});
                    axis.z = FortranFormat.atof((String)line);
                    crystal.setA(axis);
                    axis = new Vector3d();
                    logger.debug((Object)"parsing B: ");
                    line = this.input.readLine();
                    logger.debug((Object)(lineNumber++ + ": "), new Object[]{line});
                    axis.x = FortranFormat.atof((String)line);
                    line = this.input.readLine();
                    logger.debug((Object)(lineNumber++ + ": "), new Object[]{line});
                    axis.y = FortranFormat.atof((String)line);
                    line = this.input.readLine();
                    logger.debug((Object)(lineNumber++ + ": "), new Object[]{line});
                    axis.z = FortranFormat.atof((String)line);
                    crystal.setB(axis);
                    axis = new Vector3d();
                    logger.debug((Object)"parsing C: ");
                    line = this.input.readLine();
                    logger.debug((Object)(lineNumber++ + ": "), new Object[]{line});
                    axis.x = FortranFormat.atof((String)line);
                    line = this.input.readLine();
                    logger.debug((Object)(lineNumber++ + ": "), new Object[]{line});
                    axis.y = FortranFormat.atof((String)line);
                    line = this.input.readLine();
                    logger.debug((Object)(lineNumber++ + ": "), new Object[]{line});
                    axis.z = FortranFormat.atof((String)line);
                    crystal.setC(axis);
                    logger.debug((Object)"Crystal: ", new Object[]{crystal});
                    Vector3d a = crystal.getA();
                    Vector3d b = crystal.getB();
                    Vector3d c = crystal.getC();
                    logger.debug((Object)"Reading number of atoms");
                    line = this.input.readLine();
                    logger.debug((Object)(lineNumber++ + ": "), new Object[]{line});
                    int atomsToRead = Integer.parseInt(line);
                    logger.debug((Object)"Reading no molecules in assym unit cell");
                    line = this.input.readLine();
                    logger.debug((Object)(lineNumber++ + ": "), new Object[]{line});
                    int Z = Integer.parseInt(line);
                    crystal.setZ(Integer.valueOf(Z));
                    for (int i = 1; i <= atomsToRead; ++i) {
                        Point3d cart = new Point3d();
                        line = this.input.readLine();
                        logger.debug((Object)(lineNumber++ + ": "), new Object[]{line});
                        String symbol = line.substring(0, line.indexOf(58));
                        double charge = Double.parseDouble(line.substring(line.indexOf(58) + 1));
                        line = this.input.readLine();
                        logger.debug((Object)(lineNumber++ + ": "), new Object[]{line});
                        cart.x = Double.parseDouble(line);
                        line = this.input.readLine();
                        logger.debug((Object)(lineNumber++ + ": "), new Object[]{line});
                        cart.y = Double.parseDouble(line);
                        line = this.input.readLine();
                        logger.debug((Object)(lineNumber++ + ": "), new Object[]{line});
                        cart.z = Double.parseDouble(line);
                        IAtom atom = (IAtom)file.getBuilder().newInstance(IAtom.class, new Object[]{symbol});
                        atom.setCharge(Double.valueOf(charge));
                        Point3d frac = CrystalGeometryTools.cartesianToFractional((Vector3d)a, (Vector3d)b, (Vector3d)c, (Point3d)cart);
                        atom.setFractionalPoint3d(frac);
                        crystal.addAtom(atom);
                        logger.debug((Object)"Added atom: ", new Object[]{atom});
                    }
                    model.setCrystal(crystal);
                    seq.addChemModel(model);
                    continue;
                }
                logger.debug((Object)"Format seems broken. Skipping these lines:");
                while (!line.startsWith("frame:") && this.input.ready() && line != null) {
                    line = this.input.readLine();
                    logger.debug((Object)(lineNumber++ + ": "), new Object[]{line});
                }
                logger.debug((Object)"Ok, resynched: found new frame");
            }
            file.addChemSequence(seq);
        }
        catch (IOException | IllegalArgumentException exception) {
            String message = "Error while parsing CrystClust file: " + exception.getMessage();
            logger.error((Object)message);
            logger.debug((Object)exception);
            throw new CDKException(message, (Throwable)exception);
        }
        return file;
    }

    public void close() throws IOException {
        this.input.close();
    }
}

