/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IChemObjectChangeEvent;
import org.openscience.cdk.interfaces.IChemObjectListener;
import org.openscience.cdk.interfaces.IElectronContainer;

public class Association
implements IElectronContainer,
Serializable,
Cloneable {
    private static final long serialVersionUID = -9138919895942850167L;
    protected final int electronCount = 0;
    protected IAtom[] atoms = new IAtom[2];
    protected int atomCount;
    private Map<Object, Object> properties;
    private int flags;
    private String identifier;
    private boolean doNotification = true;

    public Association(IAtom atom1, IAtom atom2) {
        this.atoms[0] = atom1;
        this.atoms[1] = atom2;
        this.atomCount = 2;
    }

    public Association() {
        this.atomCount = 0;
    }

    public IAtom[] getAtoms() {
        IAtom[] returnAtoms = new IAtom[this.atomCount];
        System.arraycopy(this.atoms, 0, returnAtoms, 0, returnAtoms.length);
        return returnAtoms;
    }

    public void setAtoms(IAtom[] atoms) {
        this.atoms = atoms;
        this.atomCount = atoms.length;
        this.notifyChanged();
    }

    public int getAtomCount() {
        return this.atomCount;
    }

    public Integer getElectronCount() {
        return 0;
    }

    public IAtom getAtomAt(int position) {
        return this.atoms[position];
    }

    public boolean contains(IAtom atom) {
        for (int i = 0; i < this.atomCount; ++i) {
            if (!this.atoms[i].equals(atom)) continue;
            return true;
        }
        return false;
    }

    public void setAtomAt(IAtom atom, int position) {
        this.atoms[position] = atom;
        this.notifyChanged();
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("Association(");
        s.append(this.hashCode());
        for (int i = 0; i < this.atomCount; ++i) {
            s.append(", ").append(this.atoms[i].toString());
        }
        s.append(')');
        return s.toString();
    }

    public void setElectronCount(Integer electronCount) {
    }

    public void addListener(IChemObjectListener col) {
    }

    public int getListenerCount() {
        return 0;
    }

    public void removeListener(IChemObjectListener col) {
    }

    public void notifyChanged() {
    }

    public void notifyChanged(IChemObjectChangeEvent evt) {
    }

    private Map<Object, Object> lazyProperties() {
        if (this.properties == null) {
            this.properties = new LinkedHashMap<Object, Object>(4);
        }
        return this.properties;
    }

    public void setProperty(Object description, Object property) {
        this.lazyProperties().put(description, property);
    }

    public void removeProperty(Object description) {
        if (this.properties != null) {
            this.properties.remove(description);
            if (this.properties.isEmpty()) {
                this.properties = null;
            }
        }
    }

    public <T> T getProperty(Object description) {
        if (this.properties == null) {
            return null;
        }
        Object value = this.lazyProperties().get(description);
        return (T)value;
    }

    public <T> T getProperty(Object description, Class<T> c) {
        Object value = this.lazyProperties().get(description);
        if (c.isInstance(value)) {
            Object typed = value;
            return (T)typed;
        }
        if (value != null) {
            throw new IllegalArgumentException("attempted to access a property of incorrect type, expected " + c.getSimpleName() + " got " + value.getClass().getSimpleName());
        }
        return null;
    }

    public Map<Object, Object> getProperties() {
        return this.properties == null ? Collections.emptyMap() : Collections.unmodifiableMap(this.properties);
    }

    public Object clone() throws CloneNotSupportedException {
        Association clone = (Association)super.clone();
        clone.flags = this.getFlagValue();
        if (this.properties != null) {
            clone.properties = new HashMap<Object, Object>(this.getProperties());
        }
        return clone;
    }

    public boolean compare(Object object) {
        if (!(object instanceof Association)) {
            return false;
        }
        Association chemObj = (Association)object;
        return Objects.equals(this.identifier, chemObj.identifier);
    }

    public String getID() {
        return this.identifier;
    }

    public void setID(String identifier) {
        this.identifier = identifier;
    }

    private boolean isPowerOfTwo(int num) {
        return num == 1 || (num & num - 1) == 0;
    }

    public void setFlag(int mask, boolean value) {
        if (mask > Short.MAX_VALUE || !this.isPowerOfTwo(mask)) {
            throw new IllegalArgumentException("setFlag() must be provided a valid CDKConstant and not used for custom properties");
        }
        this.flags = value ? (this.flags |= mask) : (this.flags &= ~mask);
    }

    public boolean getFlag(int mask) {
        return (this.flags & mask) != 0;
    }

    public Integer getFlagValue() {
        return this.flags;
    }

    public void set(int flags) {
        this.flags |= flags;
    }

    public void clear(int flags) {
        this.flags &= ~flags;
    }

    public boolean is(int flags) {
        return (this.flags & flags) == flags;
    }

    public int flags() {
        return this.flags;
    }

    public void setProperties(Map<Object, Object> properties) {
        this.properties = null;
        if (properties != null) {
            this.addProperties(properties);
        }
    }

    public void addProperties(Map<Object, Object> properties) {
        if (properties == null) {
            return;
        }
        this.lazyProperties().putAll(properties);
    }

    public void setFlags(boolean[] flagsNew) {
        for (int i = 0; i < flagsNew.length; ++i) {
            this.setFlag(CDKConstants.FLAG_MASKS[i], flagsNew[i]);
        }
    }

    public boolean[] getFlags() {
        boolean[] flagArray = new boolean[14];
        for (int i = 0; i < CDKConstants.FLAG_MASKS.length; ++i) {
            int mask = CDKConstants.FLAG_MASKS[i];
            flagArray[i] = this.getFlag(mask);
        }
        return flagArray;
    }

    public Object shallowCopy() {
        Object copy = null;
        try {
            copy = super.clone();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return copy;
    }

    public IChemObjectBuilder getBuilder() {
        return null;
    }

    public void setNotification(boolean bool) {
        this.doNotification = bool;
    }

    public boolean getNotification() {
        return this.doNotification;
    }
}

