/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.geometry.CrystalGeometryTools;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.ICrystal;
import org.openscience.cdk.interfaces.IElement;
import org.openscience.cdk.interfaces.IMolecularFormula;
import org.openscience.cdk.io.DefaultChemObjectWriter;
import org.openscience.cdk.io.FormatStringBuilder;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.io.formats.ShelXFormat;
import org.openscience.cdk.tools.manipulator.MolecularFormulaManipulator;

public class ShelXWriter
extends DefaultChemObjectWriter {
    private BufferedWriter writer;

    public ShelXWriter(Writer out) {
        try {
            this.writer = out instanceof BufferedWriter ? (BufferedWriter)out : new BufferedWriter(out);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ShelXWriter(OutputStream output) {
        this(new OutputStreamWriter(output));
    }

    public ShelXWriter() {
        this(new StringWriter());
    }

    public IResourceFormat getFormat() {
        return ShelXFormat.getInstance();
    }

    public void setWriter(Writer out) {
        this.writer = out instanceof BufferedWriter ? (BufferedWriter)out : new BufferedWriter(out);
    }

    public void setWriter(OutputStream output) {
        this.setWriter(new OutputStreamWriter(output));
    }

    public void close() throws IOException {
        this.writer.close();
    }

    public boolean accepts(Class<? extends IChemObject> classObject) {
        Class<?>[] interfaces;
        for (Class<?> anInterface : interfaces = classObject.getInterfaces()) {
            if (!ICrystal.class.equals(anInterface)) continue;
            return true;
        }
        return false;
    }

    public void write(IChemObject object) throws CDKException {
        if (!(object instanceof ICrystal)) {
            throw new CDKException("Only Crystal objects can be read.");
        }
        this.writeCrystal((ICrystal)object);
    }

    private void writeCrystal(ICrystal crystal) {
        String title = crystal.getTitle();
        if (title != null && !title.toString().trim().isEmpty()) {
            this.writeln("TITL " + title.toString().trim());
        } else {
            this.writeln("TITL Produced with CDK (http://cdk.sf.net/)");
        }
        Vector3d a = crystal.getA();
        Vector3d b = crystal.getB();
        Vector3d c = crystal.getC();
        double alength = a.length();
        double blength = b.length();
        double clength = c.length();
        double alpha = Math.toDegrees(b.angle(c));
        double beta = Math.toDegrees(a.angle(c));
        double gamma = Math.toDegrees(a.angle(b));
        FormatStringBuilder format = new FormatStringBuilder("%7.5lf");
        this.write("CELL " + format.reset("%7.5f").format(1.54184).toString() + "   ");
        this.write(format.reset("%8.5f").format(alength) + "  ");
        this.write(format.reset("%8.5f").format(blength) + "  ");
        this.write(format.reset("%8.5f").format(clength) + " ");
        this.write(format.reset("%8.4f").format(alpha) + " ");
        this.write(format.reset("%8.4f").format(beta) + " ");
        this.writeln(format.reset("%8.4f").format(gamma) + "");
        this.writeln("ZERR " + format.reset("%1.5f").format((double)crystal.getZ().intValue()) + "    0.01000  0.01000   0.01000   0.0100   0.0100   0.0100");
        String spaceGroup = crystal.getSpaceGroup();
        if ("P1".equals(spaceGroup)) {
            this.writeln("LATT  -1");
        } else if ("P 2_1 2_1 2_1".equals(spaceGroup)) {
            this.writeln("LATT  -1");
            this.writeln("SYMM  1/2+X   , 1/2-Y   ,    -Z");
            this.writeln("SYMM     -X   , 1/2+Y   , 1/2-Z");
            this.writeln("SYMM  1/2-X   ,    -Y   , 1/2+Z");
        }
        StringBuilder elemNames = new StringBuilder();
        StringBuilder elemCounts = new StringBuilder();
        IMolecularFormula formula = MolecularFormulaManipulator.getMolecularFormula((IAtomContainer)crystal);
        List asortedElements = MolecularFormulaManipulator.elements((IMolecularFormula)formula);
        for (IElement element : asortedElements) {
            String symbol = element.getSymbol();
            elemNames.append(symbol).append("    ".substring(symbol.length()));
            String countS = Integer.valueOf(MolecularFormulaManipulator.getElementCount((IMolecularFormula)formula, (IElement)element)).toString();
            elemCounts.append(countS).append("    ".substring(countS.length()));
        }
        this.writeln("SFAC  " + elemNames);
        this.writeln("UNIT  " + elemCounts);
        for (int i = 0; i < crystal.getAtomCount(); ++i) {
            IAtom atom = crystal.getAtom(i);
            Point3d cartCoord = atom.getPoint3d();
            Point3d fracCoord = CrystalGeometryTools.cartesianToFractional((Vector3d)a, (Vector3d)b, (Vector3d)c, (Point3d)cartCoord);
            String symbol = atom.getSymbol();
            String output = symbol + (i + 1);
            this.write(output);
            for (int j = 1; j < 5 - output.length(); ++j) {
                this.write(" ");
            }
            this.write("     ");
            String elemID = "?";
            for (int elemidx = 0; elemidx < asortedElements.size(); ++elemidx) {
                IElement elem = (IElement)asortedElements.get(elemidx);
                if (!elem.getSymbol().equals(symbol)) continue;
                elemID = Integer.toString(elemidx + 1);
                break;
            }
            this.write(elemID);
            this.write("    ".substring(elemID.length()));
            this.write(format.reset("%7.5f").format(fracCoord.x) + "   ");
            this.write(format.reset("%7.5f").format(fracCoord.y) + "   ");
            this.writeln(format.reset("%7.5f").format(fracCoord.z) + "    11.00000    0.05000");
        }
        this.writeln("END");
    }

    private void write(String s) {
        try {
            this.writer.write(s);
        }
        catch (IOException e) {
            System.err.println("CMLWriter IOException while printing \"" + s + "\":" + e);
        }
    }

    private void writeln(String s) {
        try {
            this.writer.write(s);
            this.writer.write(10);
        }
        catch (IOException e) {
            System.err.println("CMLWriter IOException while printing \"" + s + "\":" + e);
        }
    }
}

