/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.modeling.builder3d;

import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openscience.cdk.aromaticity.Aromaticity;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.exception.NoSuchAtomTypeException;
import org.openscience.cdk.graph.Cycles;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IPseudoAtom;
import org.openscience.cdk.interfaces.IRing;
import org.openscience.cdk.interfaces.IRingSet;
import org.openscience.cdk.modeling.builder3d.MM2BasedAtomTypePattern;
import org.openscience.cdk.modeling.builder3d.MM2BasedParameterSetReader;
import org.openscience.cdk.modeling.builder3d.MMFF94BasedAtomTypePattern;
import org.openscience.cdk.modeling.builder3d.MMFF94BasedParameterSetReader;
import org.openscience.cdk.tools.HOSECodeGenerator;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;
import org.openscience.cdk.tools.manipulator.RingSetManipulator;

public class ForceFieldConfigurator {
    private String ffName = "mmff94";
    private List<IAtomType> atomTypes;
    private Map<String, Object> parameterSet = null;
    private MM2BasedParameterSetReader mm2 = null;
    private MMFF94BasedParameterSetReader mmff94 = null;
    private InputStream ins = null;
    private final String[] fftypes = new String[]{"mm2", "mmff94"};

    public void setInputStream(InputStream ins) {
        this.ins = ins;
    }

    public String[] getFfTypes() {
        return this.fftypes;
    }

    public boolean checkForceFieldType(String ffname) {
        boolean check = false;
        for (String fftype : this.fftypes) {
            if (!fftype.equals(ffname)) continue;
            check = true;
            break;
        }
        return check;
    }

    public void setForceFieldConfigurator(String ffname, IChemObjectBuilder builder) throws CDKException {
        if (!(ffname = ffname.toLowerCase()).equals(this.ffName) || this.parameterSet == null) {
            boolean check = this.checkForceFieldType(ffname);
            this.ffName = ffname;
            if (this.ffName.equals("mm2")) {
                this.ins = this.getClass().getClassLoader().getResourceAsStream("org/openscience/cdk/modeling/forcefield/data/mm2.prm");
                this.mm2 = new MM2BasedParameterSetReader();
                this.mm2.setInputStream(this.ins);
                try {
                    this.setMM2Parameters(builder);
                }
                catch (Exception ex1) {
                    throw new CDKException("Problems with set MM2Parameters due to " + ex1, (Throwable)ex1);
                }
            }
            if (this.ffName.equals("mmff94") || !check) {
                this.ins = this.getClass().getClassLoader().getResourceAsStream("org/openscience/cdk/modeling/forcefield/data/mmff94.prm");
                this.mmff94 = new MMFF94BasedParameterSetReader();
                this.mmff94.setInputStream(this.ins);
                try {
                    this.setMMFF94Parameters(builder);
                }
                catch (Exception ex2) {
                    throw new CDKException("Problems with set MM2Parameters due to" + ex2, (Throwable)ex2);
                }
            }
        }
    }

    public void setAtomTypes(List<IAtomType> atomtypes) {
        this.atomTypes = atomtypes;
    }

    public void setParameters(Map<String, Object> parameterset) {
        this.parameterSet = parameterset;
    }

    public void setMM2Parameters(IChemObjectBuilder builder) throws CDKException {
        try {
            if (this.mm2 == null) {
                this.mm2 = new MM2BasedParameterSetReader();
            }
            this.mm2.readParameterSets(builder);
        }
        catch (Exception ex1) {
            throw new CDKException("Problem within readParameterSets due to:" + ex1, (Throwable)ex1);
        }
        this.parameterSet = this.mm2.getParamterSet();
        this.atomTypes = this.mm2.getAtomTypes();
    }

    public void setMMFF94Parameters(IChemObjectBuilder builder) throws Exception {
        if (this.mmff94 == null) {
            this.mmff94 = new MMFF94BasedParameterSetReader();
        }
        this.mmff94.readParameterSets(builder);
        this.parameterSet = this.mmff94.getParamterSet();
        this.atomTypes = this.mmff94.getAtomTypes();
    }

    public List<IAtomType> getAtomTypes() {
        return this.atomTypes;
    }

    public Map<String, Object> getParameterSet() {
        return this.parameterSet;
    }

    private IAtomType getAtomType(String ID) throws NoSuchAtomTypeException {
        for (IAtomType atomType : this.atomTypes) {
            IAtomType at = atomType;
            if (!at.getAtomTypeName().equals(ID)) continue;
            return at;
        }
        throw new NoSuchAtomTypeException("AtomType " + ID + " could not be found");
    }

    public IRingSet assignAtomTyps(IAtomContainer molecule) throws CDKException {
        HOSECodeGenerator hcg = new HOSECodeGenerator(1);
        int NumberOfRingAtoms = 0;
        IRingSet ringSetMolecule = Cycles.sssr((IAtomContainer)molecule).toRingSet();
        try {
            AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms((IAtomContainer)molecule);
            Aromaticity.cdkLegacy().apply(molecule);
        }
        catch (Exception cdk1) {
            throw new CDKException("AROMATICITYError: Cannot determine aromaticity due to: " + cdk1.getMessage(), (Throwable)cdk1);
        }
        for (int i = 0; i < molecule.getAtomCount(); ++i) {
            String hoseCode;
            boolean isInHeteroRing;
            IAtom atom = molecule.getAtom(i);
            if (ringSetMolecule.contains(atom)) {
                ++NumberOfRingAtoms;
                atom.setFlag(2, true);
                atom.setFlag(8, false);
                IRingSet ringSetA = ringSetMolecule.getRings(atom);
                RingSetManipulator.sort((IRingSet)ringSetA);
                IRing sring = (IRing)ringSetA.getAtomContainer(ringSetA.getAtomContainerCount() - 1);
                atom.setProperty((Object)"RING_SIZE", (Object)sring.getRingSize());
                isInHeteroRing = false;
                Iterator containers = RingSetManipulator.getAllAtomContainers((IRingSet)ringSetA).iterator();
                while (!isInHeteroRing && containers.hasNext()) {
                    isInHeteroRing = this.isHeteroRingSystem((IAtomContainer)containers.next());
                }
            } else {
                atom.setFlag(8, true);
                atom.setFlag(2, false);
                isInHeteroRing = false;
            }
            atom.setProperty((Object)"MAX_BOND_ORDER", (Object)molecule.getMaximumBondOrder(atom).numeric());
            try {
                hoseCode = hcg.getHOSECode(molecule, atom, 3);
            }
            catch (CDKException ex1) {
                System.out.println("Could not build HOSECode from atom " + i + " due to " + (Object)((Object)ex1));
                throw new CDKException("Could not build HOSECode from atom " + i + " due to " + (Object)((Object)ex1), (Throwable)ex1);
            }
            try {
                this.configureAtom(atom, hoseCode, isInHeteroRing);
                continue;
            }
            catch (CDKException ex2) {
                System.out.println("Could not final configure atom " + i + " due to " + (Object)((Object)ex2));
                throw new CDKException("Could not final configure atom due to problems with force field", (Throwable)ex2);
            }
        }
        for (IBond bond : molecule.bonds()) {
            String bondType = "0";
            if (bond.getOrder() == IBond.Order.SINGLE) {
                if (bond.getBegin().getAtomTypeName().equals("Csp2") && (bond.getEnd().getAtomTypeName().equals("Csp2") || bond.getEnd().getAtomTypeName().equals("C="))) {
                    bondType = "1";
                }
                if (bond.getBegin().getAtomTypeName().equals("C=") && (bond.getEnd().getAtomTypeName().equals("Csp2") || bond.getEnd().getAtomTypeName().equals("C="))) {
                    bondType = "1";
                }
                if (bond.getBegin().getAtomTypeName().equals("Csp") && bond.getEnd().getAtomTypeName().equals("Csp")) {
                    bondType = "1";
                }
            }
            bond.setProperty((Object)"MMFF94 bond type", (Object)bondType);
        }
        return ringSetMolecule;
    }

    private boolean isHeteroRingSystem(IAtomContainer ac) {
        if (ac != null) {
            for (int i = 0; i < ac.getAtomCount(); ++i) {
                if (ac.getAtom(i).getSymbol().equals("H") || ac.getAtom(i).getSymbol().equals("C")) continue;
                return true;
            }
        }
        return false;
    }

    private IAtom setAtom(IAtom atom, String ID) throws NoSuchAtomTypeException {
        Object color;
        IAtomType at = this.getAtomType(ID);
        if (atom.getSymbol() == null) {
            atom.setSymbol(at.getSymbol());
        }
        atom.setAtomTypeName(at.getAtomTypeName());
        atom.setFormalNeighbourCount(at.getFormalNeighbourCount());
        String key = "vdw" + ID;
        List data = (List)this.parameterSet.get(key);
        Double value = (Double)data.get(0);
        key = "charge" + ID;
        if (this.parameterSet.containsKey(key)) {
            data = (List)this.parameterSet.get(key);
            value = (Double)data.get(0);
            atom.setCharge(value);
        }
        if ((color = at.getProperty((Object)"org.openscience.cdk.renderer.color")) != null) {
            atom.setProperty((Object)"org.openscience.cdk.renderer.color", color);
        }
        if (at.getAtomicNumber() != 0) {
            atom.setAtomicNumber(at.getAtomicNumber());
        }
        if (at.getExactMass() > 0.0) {
            atom.setExactMass(at.getExactMass());
        }
        return atom;
    }

    public IAtom configureAtom(IAtom atom, String hoseCode, boolean _boolean) throws CDKException {
        if (this.ffName.equals("mm2")) {
            return this.configureMM2BasedAtom(atom, hoseCode, _boolean);
        }
        if (this.ffName.equals("mmff94")) {
            return this.configureMMFF94BasedAtom(atom, hoseCode, _boolean);
        }
        return atom;
    }

    public IAtom configureMM2BasedAtom(IAtom atom, String hoseCode, boolean hetRing) throws NoSuchAtomTypeException {
        MM2BasedAtomTypePattern atp = new MM2BasedAtomTypePattern();
        List<Pattern> atomTypePattern = atp.getAtomTypePatterns();
        String ID = "";
        boolean atomTypeFlag = false;
        if (atom instanceof IPseudoAtom) {
            return atom;
        }
        hoseCode = this.removeAromaticityFlagsFromHoseCode(hoseCode);
        String[] ids = new String[]{"C", "Csp2", "C=", "Csp", "HC", "O", "O=", "N", "Nsp2", "Nsp", "F", "CL", "BR", "I", "S", "S+", ">SN", "SO2", "SI", "LP", "HO", "CR3R", "HN", "HOCO", "P", "B", "BTET", "HN2", "C.", "C+", "GE", "SN", "PB", "SE", "TE", "D", "NPYD", "CE3R", "N+", "NPYL", "Oar", "Sthi", "N2OX", "HS", "=N=", "NO3", "OM", "HN+", "OR", "Car", "HE", "NE", "AR", "KR", "XE", "", "", "", "MG", "PTET", "FE", "FE", "NI", "NI", "CO", "CO", "", "", "OX", "OK", "C++", "N=C", "NPD+", "N+=", "N2OX"};
        for (int j = 0; j < atomTypePattern.size(); ++j) {
            Pattern p = atomTypePattern.get(j);
            Matcher mat = p.matcher(hoseCode);
            if (!mat.matches()) continue;
            ID = ids[j];
            if (j == 0) {
                if (atom.getFlag(2)) {
                    if (atom.getProperty((Object)"RING_SIZE").equals(3)) {
                        ID = ids[21];
                    } else if (atom.getProperty((Object)"RING_SIZE").equals(6) && atom.getFlag(32)) {
                        ID = ids[1];
                    } else if (atom.getFlag(32)) {
                        ID = ids[1];
                    }
                }
            } else if (j == 1) {
                if (!(!atom.getFlag(2) || atom.getProperty((Object)"RING_SIZE").equals(6) && atom.getFlag(32))) {
                    ID = atom.getProperty((Object)"RING_SIZE").equals(3) ? ids[37] : ids[1];
                }
                if ((mat = (p = atomTypePattern.get(2)).matcher(hoseCode)).matches() && !atom.getFlag(2)) {
                    ID = ids[2];
                }
            } else if (j == 5) {
                if (atom.getFlag(2)) {
                    ID = atom.getProperty((Object)"RING_SIZE").equals(3) ? ids[48] : (atom.getProperty((Object)"RING_SIZE").equals(5) && atom.getFlag(32) ? ids[40] : ids[5]);
                }
            } else if (j == 7) {
                if (atom.getFlag(2) && atom.getFlag(32) && atom.getProperty((Object)"RING_SIZE").equals(5)) {
                    ID = ids[39];
                }
                if ((mat = (p = atomTypePattern.get(77)).matcher(hoseCode)).matches() && !atom.getFlag(2)) {
                    ID = ids[8];
                }
            } else if (j == 8) {
                if (atom.getFlag(2) && atom.getProperty((Object)"RING_SIZE").equals(6)) {
                    ID = ids[36];
                }
                if ((mat = (p = atomTypePattern.get(36)).matcher(hoseCode)).matches() && !atom.getFlag(2)) {
                    ID = ids[36];
                }
            } else if (j == 43) {
                Double d_tmp = (Double)atom.getProperty((Object)"MAX_BOND_ORDER");
                if (d_tmp > 1.0) {
                    ID = ids[4];
                }
            } else if (j == 20) {
                p = atomTypePattern.get(76);
                mat = p.matcher(hoseCode);
                if (mat.matches() && !atom.getFlag(2)) {
                    ID = ids[27];
                }
                if ((mat = (p = atomTypePattern.get(23)).matcher(hoseCode)).matches() && !atom.getFlag(2)) {
                    ID = ids[23];
                }
            } else if (j == 22 && (mat = (p = atomTypePattern.get(75)).matcher(hoseCode)).matches()) {
                ID = ids[27];
            }
            atomTypeFlag = true;
            break;
        }
        if (atomTypeFlag) {
            atomTypeFlag = false;
            return this.setAtom(atom, ID);
        }
        throw new NoSuchAtomTypeException("Atom is unkown: Symbol:" + atom.getSymbol() + " does not MATCH AtomType. HoseCode:" + hoseCode);
    }

    public String removeAromaticityFlagsFromHoseCode(String hoseCode) {
        String hosecode = "";
        for (int i = 0; i < hoseCode.length(); ++i) {
            if (hoseCode.charAt(i) == '*') continue;
            hosecode = hosecode + hoseCode.charAt(i);
        }
        return hosecode;
    }

    public IAtom configureMMFF94BasedAtom(IAtom atom, String hoseCode, boolean isInHetRing) throws NoSuchAtomTypeException {
        MMFF94BasedAtomTypePattern atp = new MMFF94BasedAtomTypePattern();
        List<Pattern> atomTypePattern = atp.getAtomTypePatterns();
        String ID = "";
        boolean atomTypeFlag = false;
        hoseCode = this.removeAromaticityFlagsFromHoseCode(hoseCode);
        String[] ids = new String[]{"C", "Csp2", "C=", "Csp", "CO2M", "CNN+", "C%", "CIM+", "CR4R", "CR3R", "CE4R", "Car", "C5A", "C5B", "C5", "HC", "HO", "HN", "HOCO", "HN=C", "HN2", "HOCC", "HOH", "HOS", "HN+", "HO+", "HO=+", "HP", "O", "O=", "OX", "OM", "O+", "O=+", "OH2", "Oar", "N", "N=C", "NC=C", "NSP", "=N=", "NAZT", "N+", "N2OX", "N3OX", "NC#N", "NO3", "N=O", "NC=O", "NSO", "N+=", "NCN+", "NGD+", "NR%", "NM", "N5M", "NPYD", "NPYL", "NPD+", "N5A", "N5B", "NPOX", "N5OX", "N5+", "N5", "S", "S=C", ">SN", "SO2", "SX", "SO2M", "=SO", "Sthi", "PTET", "P", "-P=C", "F", "CL", "BR", "I", "SI", "CL04", "FE+2", "FE+3", "F-", "CL-", "BR-", "LI+", "NA+", "K+", "ZN+2", "CA+2", "CU+1", "CU+2", "MG+2", "Du"};
        if (atom instanceof IPseudoAtom) {
            return atom;
        }
        for (int j = 0; j < atomTypePattern.size(); ++j) {
            Pattern p = atomTypePattern.get(j);
            Matcher mat = p.matcher(hoseCode);
            if (!mat.matches()) continue;
            ID = ids[j];
            if (j == 0) {
                if (atom.getFlag(2)) {
                    p = atomTypePattern.get(13);
                    mat = p.matcher(hoseCode);
                    Pattern p2 = atomTypePattern.get(12);
                    Matcher mat2 = p2.matcher(hoseCode);
                    if (mat.matches() && isInHetRing && atom.getFlag(32) && atom.getProperty((Object)"RING_SIZE").equals(5)) {
                        ID = ids[13];
                    } else if (mat2.matches() && isInHetRing && atom.getFlag(32) && atom.getProperty((Object)"RING_SIZE").equals(5)) {
                        ID = ids[12];
                    } else if (atom.getProperty((Object)"RING_SIZE").equals(3) && !atom.getFlag(32)) {
                        ID = ids[9];
                    } else if (atom.getProperty((Object)"RING_SIZE").equals(4) && !atom.getFlag(32)) {
                        ID = ids[8];
                    } else if (atom.getFlag(32) && isInHetRing && atom.getProperty((Object)"RING_SIZE").equals(5)) {
                        ID = ids[14];
                    } else if (atom.getFlag(32)) {
                        ID = ids[11];
                    }
                } else {
                    p = atomTypePattern.get(66);
                    mat = p.matcher(hoseCode);
                    if (mat.matches()) {
                        ID = ids[66];
                    }
                }
            } else if (j == 1) {
                if (atom.getFlag(2) && atom.getProperty((Object)"RING_SIZE").equals(4) && !atom.getFlag(32) && !isInHetRing) {
                    ID = ids[29];
                }
            } else if (j == 2) {
                if (atom.getFlag(2) && isInHetRing && atom.getFlag(32)) {
                    ID = ids[12];
                }
            } else if (j == 36) {
                p = atomTypePattern.get(48);
                mat = p.matcher(hoseCode);
                if (mat.matches() && !atom.getFlag(2)) {
                    ID = ids[48];
                }
                if ((mat = (p = atomTypePattern.get(44)).matcher(hoseCode)).matches()) {
                    ID = ids[44];
                }
                p = atomTypePattern.get(56);
                mat = p.matcher(hoseCode);
                if (atom.getFlag(32)) {
                    ID = atom.getProperty((Object)"RING_SIZE").equals(6) && mat.matches() ? ids[56] : (atom.getProperty((Object)"RING_SIZE").equals(5) && mat.matches() ? ids[57] : ids[64]);
                }
                p = atomTypePattern.get(61);
                mat = p.matcher(hoseCode);
                if (atom.getFlag(32)) {
                    ID = atom.getProperty((Object)"RING_SIZE").equals(6) && mat.matches() ? ids[61] : (atom.getProperty((Object)"RING_SIZE").equals(5) && mat.matches() ? ids[62] : ids[43]);
                }
                if ((mat = (p = atomTypePattern.get(45)).matcher(hoseCode)).matches()) {
                    ID = ids[45];
                }
            } else if (j == 37) {
                p = atomTypePattern.get(59);
                mat = p.matcher(hoseCode);
                if (atom.getFlag(2)) {
                    if (mat.matches() && isInHetRing && atom.getFlag(32) && atom.getProperty((Object)"RING_SIZE").equals(5)) {
                        ID = ids[59];
                    } else if (atom.getFlag(32) && atom.getProperty((Object)"RING_SIZE").equals(6)) {
                        ID = ids[56];
                    } else if (atom.getFlag(32) && atom.getProperty((Object)"RING_SIZE").equals(5)) {
                        ID = ids[57];
                    }
                }
                if ((mat = (p = atomTypePattern.get(43)).matcher(hoseCode)).matches()) {
                    ID = atom.getFlag(32) && atom.getProperty((Object)"RING_SIZE").equals(6) ? ids[61] : (mat.matches() && atom.getFlag(32) && atom.getProperty((Object)"RING_SIZE").equals(5) ? ids[62] : ids[43]);
                }
            } else if (j == 43) {
                if (atom.getFlag(2) && atom.getFlag(32) && atom.getProperty((Object)"RING_SIZE").equals(5)) {
                    ID = ids[62];
                } else if (atom.getFlag(2) && atom.getFlag(32) && atom.getProperty((Object)"RING_SIZE").equals(6)) {
                    ID = ids[61];
                }
            } else if (j == 40 || j == 41) {
                if (atom.getFlag(2) && atom.getFlag(32) && atom.getProperty((Object)"RING_SIZE").equals(5)) {
                    ID = ids[59];
                }
            } else if (j == 50) {
                if (atom.getFlag(2) && atom.getFlag(32) && atom.getProperty((Object)"RING_SIZE").equals(5)) {
                    ID = ids[63];
                } else if (atom.getFlag(2) && atom.getFlag(32) && atom.getProperty((Object)"RING_SIZE").equals(6)) {
                    ID = ids[58];
                }
            } else if (j == 28) {
                if (atom.getFlag(2) && atom.getFlag(32) && atom.getProperty((Object)"RING_SIZE").equals(5)) {
                    ID = ids[35];
                }
            } else if (j == 16) {
                p = atomTypePattern.get(21);
                mat = p.matcher(hoseCode);
                if (mat.matches()) {
                    ID = ids[21];
                }
                if ((mat = (p = atomTypePattern.get(18)).matcher(hoseCode)).matches()) {
                    ID = ids[18];
                }
            } else if (j == 74 && (mat = (p = atomTypePattern.get(75)).matcher(hoseCode)).matches()) {
                ID = ids[75];
            }
            atomTypeFlag = true;
            break;
        }
        if (atomTypeFlag) {
            atomTypeFlag = false;
            return this.setAtom(atom, ID);
        }
        throw new NoSuchAtomTypeException("Atom is unkown: Symbol:" + atom.getSymbol() + " does not MATCH AtomType. HoseCode:" + hoseCode);
    }
}

