/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.graph.invariant;

import java.util.Arrays;
import java.util.List;
import net.sf.jniinchi.INCHI_OPTION;
import net.sf.jniinchi.INCHI_RET;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.inchi.InChIGenerator;
import org.openscience.cdk.inchi.InChIGeneratorFactory;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;

public class InChINumbersTools {
    public static long[] getNumbers(IAtomContainer atomContainer) throws CDKException {
        String aux = InChINumbersTools.auxInfo(atomContainer, new INCHI_OPTION[0]);
        long[] numbers = new long[atomContainer.getAtomCount()];
        InChINumbersTools.parseAuxInfo(aux, numbers);
        return numbers;
    }

    public static void parseAuxInfo(String aux, long[] numbers) {
        aux = aux.substring(aux.indexOf("/N:") + 3);
        String numberStringAux = aux.substring(0, aux.indexOf(47));
        int i = 1;
        for (String numberString : numberStringAux.split("[,;]")) {
            numbers[Integer.valueOf((String)numberString).intValue() - 1] = i++;
        }
    }

    public static long[] getUSmilesNumbers(IAtomContainer container) throws CDKException {
        String aux = InChINumbersTools.auxInfo(container, INCHI_OPTION.RecMet, INCHI_OPTION.FixedH);
        return InChINumbersTools.parseUSmilesNumbers(aux, container);
    }

    static long[] parseUSmilesNumbers(String aux, IAtomContainer container) {
        long[] numbers = new long[container.getAtomCount()];
        int[] first = null;
        int label = 1;
        int index = aux.indexOf("/R:");
        if (index >= 0) {
            int endIndex = aux.indexOf(47, index + 8);
            if (endIndex < 0) {
                endIndex = aux.length();
            }
            String[] baseNumbers = aux.substring(index + 8, endIndex).split(";");
            first = new int[baseNumbers.length];
            Arrays.fill(first, -1);
            for (int i = 0; i < baseNumbers.length; ++i) {
                String[] numbering = baseNumbers[i].split(",");
                first[i] = Integer.parseInt(numbering[0]) - 1;
                for (String number : numbering) {
                    numbers[Integer.parseInt((String)number) - 1] = label++;
                }
            }
        } else {
            index = aux.indexOf("/N:");
            if (index >= 0) {
                String[] baseNumbers = aux.substring(index + 3, aux.indexOf(47, index + 3)).split(";");
                first = new int[baseNumbers.length];
                Arrays.fill(first, -1);
                index = aux.indexOf("/F:");
                if (index >= 0) {
                    String[] fixedHNumbers = aux.substring(index + 3, aux.indexOf(47, index + 3)).split(";");
                    for (int i = 0; i < fixedHNumbers.length; ++i) {
                        String[] numbering;
                        String component = fixedHNumbers[i];
                        if (component.charAt(component.length() - 1) == 'm') {
                            int n = component.length() > 1 ? Integer.parseInt(component.substring(0, component.length() - 1)) : 1;
                            for (int j = 0; j < n; ++j) {
                                String[] numbering2 = baseNumbers[i + j].split(",");
                                first[i + j] = Integer.parseInt(numbering2[0]) - 1;
                                for (String number : numbering2) {
                                    numbers[Integer.parseInt((String)number) - 1] = label++;
                                }
                            }
                            continue;
                        }
                        for (String number : numbering = component.split(",")) {
                            numbers[Integer.parseInt((String)number) - 1] = label++;
                        }
                    }
                } else {
                    for (int i = 0; i < baseNumbers.length; ++i) {
                        String[] numbering = baseNumbers[i].split(",");
                        first[i] = Integer.parseInt(numbering[0]) - 1;
                        for (String number : numbering) {
                            numbers[Integer.parseInt((String)number) - 1] = label++;
                        }
                    }
                }
            } else {
                throw new IllegalArgumentException("AuxInfo did not contain extractable base numbers (/N: or /R:).");
            }
        }
        for (int v : first) {
            IAtom correctedStart;
            List neighbors;
            IAtom atom;
            if (v < 0 || (atom = container.getAtom(v)).getFormalCharge() == null || atom.getAtomicNumber() != 8 || atom.getFormalCharge() != -1 || (neighbors = container.getConnectedAtomsList(atom)).size() != 1 || (correctedStart = InChINumbersTools.findPiBondedOxygen(container, (IAtom)neighbors.get(0))) == null) continue;
            InChINumbersTools.exch(numbers, v, container.indexOf(correctedStart));
        }
        for (int i = 0; i < numbers.length; ++i) {
            if (numbers[i] != 0L) continue;
            numbers[i] = label++;
        }
        return numbers;
    }

    private static void exch(long[] values, int i, int j) {
        long k = values[i];
        values[i] = values[j];
        values[j] = k;
    }

    private static IAtom findPiBondedOxygen(IAtomContainer container, IAtom atom) {
        for (IBond bond : container.getConnectedBondsList(atom)) {
            int charge;
            if (bond.getOrder() != IBond.Order.DOUBLE) continue;
            IAtom neighbor = bond.getOther(atom);
            int n = charge = neighbor.getFormalCharge() == null ? 0 : neighbor.getFormalCharge();
            if (neighbor.getAtomicNumber() != 8 || charge != 0) continue;
            return neighbor;
        }
        return null;
    }

    static String auxInfo(IAtomContainer container, INCHI_OPTION ... options) throws CDKException {
        InChIGeneratorFactory factory = InChIGeneratorFactory.getInstance();
        boolean org = factory.getIgnoreAromaticBonds();
        factory.setIgnoreAromaticBonds(true);
        InChIGenerator gen = factory.getInChIGenerator(container, Arrays.asList(options));
        factory.setIgnoreAromaticBonds(org);
        if (gen.getReturnStatus() != INCHI_RET.OKAY && gen.getReturnStatus() != INCHI_RET.WARNING) {
            throw new CDKException("Could not generate InChI Numbers: " + gen.getMessage());
        }
        return gen.getAuxInfo();
    }
}

