/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.StringTokenizer;
import javax.vecmath.Point3d;
import org.openscience.cdk.config.Isotopes;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemFile;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemSequence;
import org.openscience.cdk.io.DefaultChemObjectReader;
import org.openscience.cdk.io.formats.GhemicalMMFormat;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

public class GhemicalMMReader
extends DefaultChemObjectReader {
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(GhemicalMMReader.class);
    private BufferedReader input = null;

    public GhemicalMMReader(Reader input) {
        this.input = new BufferedReader(input);
    }

    public GhemicalMMReader(InputStream input) {
        this(new InputStreamReader(input));
    }

    public GhemicalMMReader() {
        this(new StringReader(""));
    }

    public IResourceFormat getFormat() {
        return GhemicalMMFormat.getInstance();
    }

    public void setReader(Reader input) throws CDKException {
        this.input = input instanceof BufferedReader ? (BufferedReader)input : new BufferedReader(input);
    }

    public void setReader(InputStream input) throws CDKException {
        this.setReader(new InputStreamReader(input));
    }

    public void close() {
    }

    public boolean accepts(Class<? extends IChemObject> classObject) {
        if (IChemFile.class.equals(classObject)) {
            return true;
        }
        if (IChemModel.class.equals(classObject)) {
            return true;
        }
        Class<?>[] interfaces = classObject.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (IChemModel.class.equals(interfaces[i])) {
                return true;
            }
            if (!IChemFile.class.equals(interfaces[i])) continue;
            return true;
        }
        Class<? extends IChemObject> superClass = classObject.getSuperclass();
        if (superClass != null) {
            return this.accepts(superClass);
        }
        return false;
    }

    public <T extends IChemObject> T read(T object) throws CDKException {
        if (object instanceof IChemModel) {
            return (T)this.readChemModel((IChemModel)object);
        }
        if (object instanceof IChemFile) {
            IChemSequence sequence = (IChemSequence)object.getBuilder().newInstance(IChemSequence.class, new Object[0]);
            sequence.addChemModel(this.readChemModel((IChemModel)object.getBuilder().newInstance(IChemModel.class, new Object[0])));
            ((IChemFile)object).addChemSequence(sequence);
            return object;
        }
        throw new CDKException("Only supported is ChemModel.");
    }

    private IChemModel readChemModel(IChemModel model) throws CDKException {
        int[] atoms = new int[1];
        double[] atomxs = new double[1];
        double[] atomys = new double[1];
        double[] atomzs = new double[1];
        double[] atomcharges = new double[1];
        int[] bondatomid1 = new int[1];
        int[] bondatomid2 = new int[1];
        IBond.Order[] bondorder = new IBond.Order[1];
        int numberOfAtoms = 0;
        int numberOfBonds = 0;
        try {
            String line = this.input.readLine();
            while (line != null) {
                int atomID;
                StringTokenizer atomInfoFields;
                StringTokenizer st = new StringTokenizer(line);
                String command = st.nextToken();
                if ("!Header".equals(command)) {
                    logger.warn((Object)"Ignoring header");
                } else if ("!Info".equals(command)) {
                    logger.warn((Object)"Ignoring info");
                } else if ("!Atoms".equals(command)) {
                    logger.info((Object)"Reading atom block");
                    try {
                        numberOfAtoms = Integer.parseInt(st.nextToken());
                        logger.debug((Object)("  #atoms: " + numberOfAtoms));
                        atoms = new int[numberOfAtoms];
                        atomxs = new double[numberOfAtoms];
                        atomys = new double[numberOfAtoms];
                        atomzs = new double[numberOfAtoms];
                        atomcharges = new double[numberOfAtoms];
                        for (int i = 0; i < numberOfAtoms; ++i) {
                            line = this.input.readLine();
                            atomInfoFields = new StringTokenizer(line);
                            atomID = Integer.parseInt(atomInfoFields.nextToken());
                            atoms[atomID] = Integer.parseInt(atomInfoFields.nextToken());
                            logger.debug((Object)("Set atomic number of atom (" + atomID + ") to: " + atoms[atomID]));
                        }
                    }
                    catch (IOException | NumberFormatException exception) {
                        logger.error((Object)"Error while reading Atoms block");
                        logger.debug((Object)exception);
                    }
                } else if ("!Bonds".equals(command)) {
                    logger.info((Object)"Reading bond block");
                    try {
                        numberOfBonds = Integer.parseInt(st.nextToken());
                        bondatomid1 = new int[numberOfAtoms];
                        bondatomid2 = new int[numberOfAtoms];
                        bondorder = new IBond.Order[numberOfAtoms];
                        for (int i = 0; i < numberOfBonds; ++i) {
                            line = this.input.readLine();
                            StringTokenizer bondInfoFields = new StringTokenizer(line);
                            bondatomid1[i] = Integer.parseInt(bondInfoFields.nextToken());
                            bondatomid2[i] = Integer.parseInt(bondInfoFields.nextToken());
                            String order = bondInfoFields.nextToken();
                            if ("D".equals(order)) {
                                bondorder[i] = IBond.Order.DOUBLE;
                                continue;
                            }
                            if ("S".equals(order)) {
                                bondorder[i] = IBond.Order.SINGLE;
                                continue;
                            }
                            if ("T".equals(order)) {
                                bondorder[i] = IBond.Order.TRIPLE;
                                continue;
                            }
                            logger.warn((Object)("Unrecognized bond order, using single bond instead. Found: " + order));
                            bondorder[i] = IBond.Order.SINGLE;
                        }
                    }
                    catch (IOException | NumberFormatException exception) {
                        logger.error((Object)"Error while reading Bonds block");
                        logger.debug((Object)exception);
                    }
                } else if ("!Coord".equals(command)) {
                    logger.info((Object)"Reading coordinate block");
                    try {
                        for (int i = 0; i < numberOfAtoms; ++i) {
                            line = this.input.readLine();
                            atomInfoFields = new StringTokenizer(line);
                            atomID = Integer.parseInt(atomInfoFields.nextToken());
                            double x = Double.valueOf(atomInfoFields.nextToken());
                            double y = Double.valueOf(atomInfoFields.nextToken());
                            double z = Double.valueOf(atomInfoFields.nextToken());
                            atomxs[atomID] = x;
                            atomys[atomID] = y;
                            atomzs[atomID] = z;
                        }
                    }
                    catch (IOException | NumberFormatException exception) {
                        logger.error((Object)"Error while reading Coord block");
                        logger.debug((Object)exception);
                    }
                } else if ("!Charges".equals(command)) {
                    logger.info((Object)"Reading charges block");
                    try {
                        for (int i = 0; i < numberOfAtoms; ++i) {
                            double charge;
                            line = this.input.readLine();
                            atomInfoFields = new StringTokenizer(line);
                            atomID = Integer.parseInt(atomInfoFields.nextToken());
                            atomcharges[atomID] = charge = Double.valueOf(atomInfoFields.nextToken()).doubleValue();
                        }
                    }
                    catch (IOException | NumberFormatException exception) {
                        logger.error((Object)"Error while reading Charges block");
                        logger.debug((Object)exception);
                    }
                } else {
                    if ("!End".equals(command)) {
                        int i;
                        logger.info((Object)"Found end of file");
                        IAtomContainer container = (IAtomContainer)model.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
                        for (i = 0; i < numberOfAtoms; ++i) {
                            try {
                                IAtom atom = (IAtom)model.getBuilder().newInstance(IAtom.class, new Object[]{Isotopes.getInstance().getElementSymbol(atoms[i])});
                                atom.setAtomicNumber(Integer.valueOf(atoms[i]));
                                atom.setPoint3d(new Point3d(atomxs[i], atomys[i], atomzs[i]));
                                atom.setCharge(Double.valueOf(atomcharges[i]));
                                container.addAtom(atom);
                                logger.debug((Object)("Stored atom: " + atom));
                                continue;
                            }
                            catch (IOException | IllegalArgumentException exception) {
                                logger.error((Object)("Cannot create an atom with atomic number: " + atoms[i]));
                                logger.debug((Object)exception);
                            }
                        }
                        for (i = 0; i < numberOfBonds; ++i) {
                            container.addBond(bondatomid1[i], bondatomid2[i], bondorder[i]);
                        }
                        IAtomContainerSet moleculeSet = (IAtomContainerSet)model.getBuilder().newInstance(IAtomContainerSet.class, new Object[0]);
                        moleculeSet.addAtomContainer((IAtomContainer)model.getBuilder().newInstance(IAtomContainer.class, new Object[]{container}));
                        model.setMoleculeSet(moleculeSet);
                        return model;
                    }
                    logger.warn((Object)("Skipping line: " + line));
                }
                line = this.input.readLine();
            }
        }
        catch (IOException | IllegalArgumentException exception) {
            logger.error((Object)"Error while reading file");
            logger.debug((Object)exception);
        }
        return null;
    }
}

