/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import javax.vecmath.Point3d;
import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.io.DefaultChemObjectWriter;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.io.formats.XYZFormat;
import org.openscience.cdk.tools.FormatStringBuffer;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

public class XYZWriter
extends DefaultChemObjectWriter {
    private BufferedWriter writer;
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(XYZWriter.class);
    private FormatStringBuffer fsb = new FormatStringBuffer("%-8.6f");

    public XYZWriter(Writer out) {
        try {
            this.writer = out instanceof BufferedWriter ? (BufferedWriter)out : new BufferedWriter(out);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public XYZWriter(OutputStream output) {
        this(new OutputStreamWriter(output));
    }

    public XYZWriter() {
        this(new StringWriter());
    }

    public IResourceFormat getFormat() {
        return XYZFormat.getInstance();
    }

    public void setWriter(Writer out) throws CDKException {
        this.writer = out instanceof BufferedWriter ? (BufferedWriter)out : new BufferedWriter(out);
    }

    public void setWriter(OutputStream output) throws CDKException {
        this.setWriter(new OutputStreamWriter(output));
    }

    public void close() throws IOException {
        this.writer.close();
    }

    public boolean accepts(Class<? extends IChemObject> classObject) {
        if (IAtomContainer.class.equals(classObject)) {
            return true;
        }
        Class<?>[] interfaces = classObject.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (!IAtomContainer.class.equals(interfaces[i])) continue;
            return true;
        }
        Class<? extends IChemObject> superClass = classObject.getSuperclass();
        if (superClass != null) {
            return this.accepts(superClass);
        }
        return false;
    }

    public void write(IChemObject object) throws CDKException {
        if (object instanceof IAtomContainer) {
            try {
                this.writeMolecule((IAtomContainer)object);
            }
            catch (Exception ex) {
                throw new CDKException("Error while writing XYZ file: " + ex.getMessage(), (Throwable)ex);
            }
        } else {
            throw new CDKException("XYZWriter only supports output of Molecule classes.");
        }
    }

    public void writeMolecule(IAtomContainer mol) throws IOException {
        String st = "";
        boolean writecharge = true;
        try {
            String s1 = "" + mol.getAtomCount();
            this.writer.write(s1, 0, s1.length());
            this.writer.newLine();
            String s2 = null;
            if (s2 != null) {
                this.writer.write(s2, 0, s2.length());
            }
            this.writer.newLine();
            for (IAtom a : mol.atoms()) {
                st = a.getSymbol();
                Point3d p3 = a.getPoint3d();
                st = p3 != null ? st + "\t" + (p3.x < 0.0 ? "" : " ") + this.fsb.format(p3.x) + "\t" + (p3.y < 0.0 ? "" : " ") + this.fsb.format(p3.y) + "\t" + (p3.z < 0.0 ? "" : " ") + this.fsb.format(p3.z) : st + "\t " + this.fsb.format(0.0) + "\t " + this.fsb.format(0.0) + "\t " + this.fsb.format(0.0);
                if (writecharge) {
                    double ct = a.getCharge() == CDKConstants.UNSET ? 0.0 : a.getCharge();
                    st = st + "\t" + ct;
                }
                this.writer.write(st, 0, st.length());
                this.writer.newLine();
            }
        }
        catch (IOException e) {
            logger.error((Object)"Error while writing file: ", new Object[]{e.getMessage()});
            logger.debug((Object)e);
        }
    }
}

