/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.StringTokenizer;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.geometry.CrystalGeometryTools;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IChemFile;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemSequence;
import org.openscience.cdk.interfaces.ICrystal;
import org.openscience.cdk.io.DefaultChemObjectReader;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.io.formats.ShelXFormat;
import org.openscience.cdk.math.FortranFormat;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

public class ShelXReader
extends DefaultChemObjectReader {
    private BufferedReader input;
    private static final ILoggingTool logger = LoggingToolFactory.createLoggingTool(ShelXReader.class);

    public ShelXReader(Reader input) {
        this.input = new BufferedReader(input);
    }

    public ShelXReader(InputStream input) {
        this(new InputStreamReader(input));
    }

    public ShelXReader() {
        this(new StringReader(""));
    }

    public IResourceFormat getFormat() {
        return ShelXFormat.getInstance();
    }

    public void setReader(Reader input) throws CDKException {
        this.input = input instanceof BufferedReader ? (BufferedReader)input : new BufferedReader(input);
    }

    public void setReader(InputStream input) throws CDKException {
        this.setReader(new InputStreamReader(input));
    }

    public boolean accepts(Class<? extends IChemObject> classObject) {
        Class<?>[] interfaces;
        if (IChemFile.class.equals(classObject)) {
            return true;
        }
        if (ICrystal.class.equals(classObject)) {
            return true;
        }
        for (Class<?> anInterface : interfaces = classObject.getInterfaces()) {
            if (ICrystal.class.equals(anInterface)) {
                return true;
            }
            if (!IChemFile.class.equals(anInterface)) continue;
            return true;
        }
        Class<? extends IChemObject> superClass = classObject.getSuperclass();
        if (superClass != null) {
            return this.accepts(superClass);
        }
        return false;
    }

    public <T extends IChemObject> T read(T object) throws CDKException {
        if (object instanceof IChemFile) {
            try {
                return (T)this.readChemFile((IChemFile)object);
            }
            catch (IOException e) {
                logger.error((Object)("Input/Output error while reading from input: " + e.getMessage()));
                throw new CDKException(e.getMessage(), (Throwable)e);
            }
        }
        if (object instanceof ICrystal) {
            try {
                return (T)this.readCrystal((ICrystal)object);
            }
            catch (IOException e) {
                logger.error((Object)("Input/Output error while reading from input: " + e.getMessage()));
                throw new CDKException(e.getMessage(), (Throwable)e);
            }
        }
        throw new CDKException("Only supported is reading of ChemFile.");
    }

    private IChemFile readChemFile(IChemFile file) throws IOException {
        IChemSequence seq = (IChemSequence)file.getBuilder().newInstance(IChemSequence.class, new Object[0]);
        IChemModel model = (IChemModel)file.getBuilder().newInstance(IChemModel.class, new Object[0]);
        ICrystal crystal = this.readCrystal((ICrystal)file.getBuilder().newInstance(ICrystal.class, new Object[0]));
        model.setCrystal(crystal);
        seq.addChemModel(model);
        file.addChemSequence(seq);
        return file;
    }

    private boolean isDigit(char ch) {
        return ch >= '0' && ch <= '9';
    }

    private ICrystal readCrystal(ICrystal crystal) throws IOException {
        String line = this.input.readLine();
        boolean end_found = false;
        while (this.input.ready() && line != null && !end_found) {
            String command;
            if (line.length() > 0 && line.substring(line.length() - 1).equals("=")) {
                line = line + this.input.readLine();
            }
            try {
                command = line.substring(0, 4);
            }
            catch (StringIndexOutOfBoundsException sioobe) {
                break;
            }
            logger.debug((Object)("command: " + command));
            if (!command.substring(0, 3).equalsIgnoreCase("REM")) {
                if (command.substring(0, 3).equalsIgnoreCase("END")) {
                    end_found = true;
                } else if (!command.equalsIgnoreCase("TITL")) {
                    StringTokenizer st;
                    if (command.equalsIgnoreCase("CELL")) {
                        st = new StringTokenizer(line);
                        st.nextToken();
                        st.nextToken();
                        String sa = st.nextToken();
                        String sb = st.nextToken();
                        String sc = st.nextToken();
                        String salpha = st.nextToken();
                        String sbeta = st.nextToken();
                        String sgamma = st.nextToken();
                        logger.debug((Object)("a: " + sa));
                        logger.debug((Object)("b: " + sb));
                        logger.debug((Object)("c: " + sc));
                        logger.debug((Object)("alpha: " + salpha));
                        logger.debug((Object)("beta : " + sbeta));
                        logger.debug((Object)("gamma: " + sgamma));
                        double a = FortranFormat.atof((String)sa);
                        double b = FortranFormat.atof((String)sb);
                        double c = FortranFormat.atof((String)sc);
                        double alpha = FortranFormat.atof((String)salpha);
                        double beta = FortranFormat.atof((String)sbeta);
                        double gamma = FortranFormat.atof((String)sgamma);
                        Vector3d[] axes = CrystalGeometryTools.notionalToCartesian((double)a, (double)b, (double)c, (double)alpha, (double)beta, (double)gamma);
                        crystal.setA(axes[0]);
                        crystal.setB(axes[1]);
                        crystal.setC(axes[2]);
                    } else if (!(command.equalsIgnoreCase("ZERR") || command.equalsIgnoreCase("LATT") || command.equalsIgnoreCase("SYMM") || command.equalsIgnoreCase("SFAC") || command.equalsIgnoreCase("DISP") || command.equalsIgnoreCase("UNIT") || command.equalsIgnoreCase("LAUE") || command.equalsIgnoreCase("REM ") || command.equalsIgnoreCase("MORE") || command.equalsIgnoreCase("TIME") || command.equalsIgnoreCase("HKLF") || command.equalsIgnoreCase("OMIT") || command.equalsIgnoreCase("SHEL") || command.equalsIgnoreCase("BASF") || command.equalsIgnoreCase("TWIN") || command.equalsIgnoreCase("EXTI") || command.equalsIgnoreCase("SWAT") || command.equalsIgnoreCase("HOPE") || command.equalsIgnoreCase("MERG") || command.equalsIgnoreCase("SPEC") || command.equalsIgnoreCase("RESI") || command.equalsIgnoreCase("MOVE") || command.equalsIgnoreCase("ANIS") || command.equalsIgnoreCase("AFIX") || command.equalsIgnoreCase("HFIX") || command.equalsIgnoreCase("FRAG") || command.equalsIgnoreCase("FEND") || command.equalsIgnoreCase("EXYZ") || command.equalsIgnoreCase("EADP") || command.equalsIgnoreCase("EQIV") || command.equalsIgnoreCase("CONN") || command.equalsIgnoreCase("PART") || command.equalsIgnoreCase("BIND") || command.equalsIgnoreCase("FREE") || command.equalsIgnoreCase("DFIX") || command.equalsIgnoreCase("DANG") || command.equalsIgnoreCase("BUMP") || command.equalsIgnoreCase("SAME") || command.equalsIgnoreCase("SADI") || command.equalsIgnoreCase("CHIV") || command.equalsIgnoreCase("FLAT") || command.equalsIgnoreCase("DELU") || command.equalsIgnoreCase("SIMU") || command.equalsIgnoreCase("DEFS") || command.equalsIgnoreCase("ISOR") || command.equalsIgnoreCase("NCSY") || command.equalsIgnoreCase("SUMP") || command.equalsIgnoreCase("L.S.") || command.equalsIgnoreCase("CGLS") || command.equalsIgnoreCase("BLOC") || command.equalsIgnoreCase("DAMP") || command.equalsIgnoreCase("STIR") || command.equalsIgnoreCase("WGHT") || command.equalsIgnoreCase("FVAR") || command.equalsIgnoreCase("BOND") || command.equalsIgnoreCase("CONF") || command.equalsIgnoreCase("MPLA") || command.equalsIgnoreCase("RTAB") || command.equalsIgnoreCase("HTAB") || command.equalsIgnoreCase("LIST") || command.equalsIgnoreCase("ACTA") || command.equalsIgnoreCase("SIZE") || command.equalsIgnoreCase("TEMP") || command.equalsIgnoreCase("WPDB") || command.equalsIgnoreCase("FMAP") || command.equalsIgnoreCase("GRID") || command.equalsIgnoreCase("PLAN") || command.equalsIgnoreCase("MOLE"))) {
                        if (command.equalsIgnoreCase("SPGR")) {
                            st = new StringTokenizer(line);
                            st.nextToken();
                            String spacegroup = st.nextToken();
                            crystal.setSpaceGroup(spacegroup);
                        } else if (command.equalsIgnoreCase("    ")) {
                            logger.debug((Object)("Disrgarding line assumed to be added by PLATON: " + line));
                        } else {
                            st = new StringTokenizer(line);
                            String atype = st.nextToken();
                            st.nextToken();
                            String sa = st.nextToken();
                            String sb = st.nextToken();
                            String sc = st.nextToken();
                            if (this.isDigit(atype.charAt(1))) {
                                atype = atype.substring(0, 1);
                            } else {
                                StringBuilder sb2 = new StringBuilder();
                                sb2.append(atype.charAt(1));
                                atype = atype.substring(0, 1) + sb2.toString().toLowerCase();
                            }
                            double[] frac = new double[]{FortranFormat.atof((String)sa), FortranFormat.atof((String)sb), FortranFormat.atof((String)sc)};
                            logger.debug((Object)("fa,fb,fc: " + frac[0] + ", " + frac[1] + ", " + frac[2]));
                            if (!atype.equalsIgnoreCase("Q")) {
                                logger.info((Object)("Adding atom: " + atype + ", " + frac[0] + ", " + frac[1] + ", " + frac[2]));
                                IAtom atom = (IAtom)crystal.getBuilder().newInstance(IAtom.class, new Object[]{atype});
                                atom.setFractionalPoint3d(new Point3d(frac[0], frac[1], frac[2]));
                                crystal.addAtom(atom);
                                logger.debug((Object)"Atom added: ", new Object[]{atom});
                            }
                        }
                    }
                }
            }
            line = this.input.readLine();
        }
        return crystal;
    }

    public void close() throws IOException {
        this.input.close();
    }
}

