/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IChemFile;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.io.DefaultChemObjectReader;
import org.openscience.cdk.io.cml.CMLErrorHandler;
import org.openscience.cdk.io.cml.CMLHandler;
import org.openscience.cdk.io.cml.CMLResolver;
import org.openscience.cdk.io.cml.ICMLModule;
import org.openscience.cdk.io.formats.CMLFormat;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class CMLReader
extends DefaultChemObjectReader {
    private XMLReader parser;
    private InputStream input;
    private String url;
    private Map<String, ICMLModule> userConventions = new HashMap<String, ICMLModule>();
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(CMLReader.class);

    public CMLReader(InputStream input) {
        this.input = input;
        this.init();
    }

    public CMLReader() {
        this(new ByteArrayInputStream(new byte[0]));
    }

    public void registerConvention(String convention, ICMLModule conv) {
        this.userConventions.put(convention, conv);
    }

    public CMLReader(String url) {
        this.init();
        this.url = url;
    }

    public IResourceFormat getFormat() {
        return CMLFormat.getInstance();
    }

    public void setReader(Reader reader) throws CDKException {
        throw new CDKException("Invalid method call; use SetReader(InputStream) instead.");
    }

    public void setReader(InputStream input) throws CDKException {
        this.input = input;
    }

    private void init() {
        this.url = "";
        boolean success = false;
        if (!success) {
            try {
                SAXParserFactory spf = SAXParserFactory.newInstance();
                spf.setNamespaceAware(true);
                SAXParser saxParser = spf.newSAXParser();
                this.parser = saxParser.getXMLReader();
                logger.info((Object)"Using JAXP/SAX XML parser.");
                success = true;
            }
            catch (ParserConfigurationException | SAXException e) {
                logger.warn((Object)"Could not instantiate JAXP/SAX XML reader: ", new Object[]{e.getMessage()});
                logger.debug((Object)e);
            }
        }
        if (!success) {
            try {
                this.parser = (XMLReader)((Object)((Object)this)).getClass().getClassLoader().loadClass("gnu.xml.aelfred2.XmlReader").newInstance();
                logger.info((Object)"Using Aelfred2 XML parser.");
                success = true;
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                logger.warn((Object)"Could not instantiate Aelfred2 XML reader!");
                logger.debug((Object)e);
            }
        }
        if (!success) {
            try {
                this.parser = (XMLReader)((Object)((Object)this)).getClass().getClassLoader().loadClass("org.apache.xerces.parsers.SAXParser").newInstance();
                logger.info((Object)"Using Xerces XML parser.");
                success = true;
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                logger.warn((Object)"Could not instantiate Xerces XML reader!");
                logger.debug((Object)e);
            }
        }
        if (!success) {
            logger.error((Object)"Could not instantiate any XML parser!");
        }
    }

    public boolean accepts(Class<? extends IChemObject> classObject) {
        Class<?>[] interfaces = classObject.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (!IChemFile.class.equals(interfaces[i])) continue;
            return true;
        }
        if (IChemFile.class.equals(classObject)) {
            return true;
        }
        Class<? extends IChemObject> superClass = classObject.getSuperclass();
        if (superClass != null) {
            return this.accepts(superClass);
        }
        return false;
    }

    public <T extends IChemObject> T read(T object) throws CDKException {
        if (object instanceof IChemFile) {
            return (T)this.readChemFile((IChemFile)object);
        }
        throw new CDKException("Only supported is reading of ChemFile objects.");
    }

    private IChemFile readChemFile(IChemFile file) throws CDKException {
        String error;
        logger.debug((Object)"Started parsing from input...");
        try {
            this.parser.setFeature("http://xml.org/sax/features/validation", false);
            logger.info((Object)"Deactivated validation");
        }
        catch (SAXException e) {
            logger.warn((Object)"Cannot deactivate validation.");
            return null;
        }
        CMLHandler handler = new CMLHandler(file);
        for (String conv : this.userConventions.keySet()) {
            handler.registerConvention(conv, this.userConventions.get(conv));
        }
        this.parser.setContentHandler(handler);
        this.parser.setEntityResolver(new CMLResolver());
        this.parser.setErrorHandler(new CMLErrorHandler());
        try {
            if (this.input == null) {
                logger.debug((Object)"Parsing from URL: ", new Object[]{this.url});
                this.parser.parse(this.url);
            } else {
                logger.debug((Object)"Parsing from Reader");
                this.parser.parse(new InputSource(this.input));
            }
        }
        catch (IOException e) {
            error = "Error while reading file: " + e.getMessage();
            logger.error((Object)error);
            logger.debug((Object)e);
            throw new CDKException(error, (Throwable)e);
        }
        catch (SAXParseException saxe) {
            SAXParseException spe = saxe;
            String error2 = "Found well-formedness error in line " + spe.getLineNumber();
            logger.error((Object)error2);
            logger.debug((Object)saxe);
            throw new CDKException(error2, (Throwable)saxe);
        }
        catch (SAXException saxe) {
            error = "Error while parsing XML: " + saxe.getMessage();
            logger.error((Object)error);
            logger.debug((Object)saxe);
            throw new CDKException(error, (Throwable)saxe);
        }
        return file;
    }

    public void close() throws IOException {
        if (this.input != null) {
            this.input.close();
        }
    }
}

