/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import com.google.common.io.CharStreams;
import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ServiceLoader;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.openscience.cdk.io.formats.IChemFormat;
import org.openscience.cdk.io.formats.IChemFormatMatcher;
import org.openscience.cdk.io.formats.XYZFormat;

public class FormatFactory {
    private int headerLength;
    private List<IChemFormatMatcher> formats = new ArrayList<IChemFormatMatcher>(100);

    public FormatFactory() {
        this(65536);
    }

    public FormatFactory(int headerLength) {
        this.headerLength = headerLength;
        this.loadFormats();
    }

    private void loadFormats() {
        for (IChemFormatMatcher format : ServiceLoader.load(IChemFormatMatcher.class)) {
            this.formats.add(format);
        }
    }

    public void registerFormat(IChemFormatMatcher format) {
        this.formats.add(format);
    }

    public List<IChemFormatMatcher> getFormats() {
        return this.formats;
    }

    public IChemFormat guessFormat(Reader input) throws IOException {
        IChemFormatMatcher.MatchResult best;
        if (input == null) {
            throw new IllegalArgumentException("input cannot be null");
        }
        char[] header = new char[this.headerLength];
        if (!input.markSupported()) {
            throw new IllegalArgumentException("input must support mark");
        }
        input.mark(this.headerLength);
        input.read(header, 0, this.headerLength);
        input.reset();
        BufferedReader buffer = new BufferedReader(new CharArrayReader(header));
        List lines = Collections.unmodifiableList(CharStreams.readLines((Readable)buffer));
        TreeSet<IChemFormatMatcher.MatchResult> results = new TreeSet<IChemFormatMatcher.MatchResult>();
        for (IChemFormatMatcher format : this.formats) {
            results.add(format.matches(lines));
        }
        if (results.size() > 1 && (best = (IChemFormatMatcher.MatchResult)results.iterator().next()).matched()) {
            return best.format();
        }
        buffer = new BufferedReader(new CharArrayReader(header));
        String line = buffer.readLine();
        StringTokenizer tokenizer = new StringTokenizer(line.trim());
        try {
            int tokenCount = tokenizer.countTokens();
            if (tokenCount == 1) {
                Integer.parseInt(tokenizer.nextToken());
                return (IChemFormat)XYZFormat.getInstance();
            }
            if (tokenCount == 2) {
                Integer.parseInt(tokenizer.nextToken());
                if ("Bohr".equalsIgnoreCase(tokenizer.nextToken())) {
                    return (IChemFormat)XYZFormat.getInstance();
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    public IChemFormat guessFormat(InputStream input) throws IOException {
        IChemFormatMatcher.MatchResult best;
        if (input == null) {
            throw new IllegalArgumentException("input cannot be null");
        }
        byte[] header = new byte[this.headerLength];
        if (!input.markSupported()) {
            throw new IllegalArgumentException("input must support mark");
        }
        input.mark(this.headerLength);
        input.read(header, 0, this.headerLength);
        input.reset();
        BufferedReader buffer = new BufferedReader(new StringReader(new String(header)));
        List lines = Collections.unmodifiableList(CharStreams.readLines((Readable)buffer));
        TreeSet<IChemFormatMatcher.MatchResult> results = new TreeSet<IChemFormatMatcher.MatchResult>();
        for (IChemFormatMatcher format : this.formats) {
            results.add(format.matches(lines));
        }
        if (results.size() > 1 && (best = (IChemFormatMatcher.MatchResult)results.iterator().next()).matched()) {
            return best.format();
        }
        buffer = new BufferedReader(new StringReader(new String(header)));
        String line = buffer.readLine();
        StringTokenizer tokenizer = new StringTokenizer(line.trim());
        try {
            int tokenCount = tokenizer.countTokens();
            if (tokenCount == 1) {
                Integer.parseInt(tokenizer.nextToken());
                return (IChemFormat)XYZFormat.getInstance();
            }
            if (tokenCount == 2) {
                Integer.parseInt(tokenizer.nextToken());
                if ("Bohr".equalsIgnoreCase(tokenizer.nextToken())) {
                    return (IChemFormat)XYZFormat.getInstance();
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }
}

