/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io.rdf;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.io.DefaultChemObjectReader;
import org.openscience.cdk.io.formats.CDKOWLFormat;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.libio.jena.Convertor;

public class CDKOWLReader
extends DefaultChemObjectReader {
    private Reader input;

    public CDKOWLReader(Reader input) {
        this.input = input;
    }

    public CDKOWLReader() {
        this.input = null;
    }

    public IResourceFormat getFormat() {
        return CDKOWLFormat.getInstance();
    }

    public void setReader(Reader reader) throws CDKException {
        this.input = reader;
    }

    public void setReader(InputStream input) throws CDKException {
        this.input = new InputStreamReader(input);
    }

    public boolean accepts(Class<? extends IChemObject> classObject) {
        if (IAtomContainer.class.equals(classObject)) {
            return true;
        }
        Class<?>[] interfaces = classObject.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (!IAtomContainer.class.equals(interfaces[i])) continue;
            return true;
        }
        Class<? extends IChemObject> superClass = classObject.getSuperclass();
        if (superClass != null) {
            return this.accepts(superClass);
        }
        return false;
    }

    public <T extends IChemObject> T read(T object) throws CDKException {
        if (!(object instanceof IAtomContainer)) {
            throw new CDKException("Only supported is reading of IAtomCOntainer objects.");
        }
        IAtomContainer result = (IAtomContainer)object;
        Model model = ModelFactory.createDefaultModel();
        model.read(this.input, "", "N3");
        IAtomContainer mol = Convertor.model2Molecule(model, object.getBuilder());
        result.add(mol);
        return (T)result;
    }

    public void close() throws IOException {
        this.input.close();
    }
}

