/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io.rdf;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.io.DefaultChemObjectWriter;
import org.openscience.cdk.io.formats.CDKOWLFormat;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.libio.jena.Convertor;

public class CDKOWLWriter
extends DefaultChemObjectWriter {
    private Writer output;

    public CDKOWLWriter(Writer output) {
        this.output = output;
    }

    public CDKOWLWriter() {
        this.output = null;
    }

    public IResourceFormat getFormat() {
        return CDKOWLFormat.getInstance();
    }

    public void setWriter(Writer out) throws CDKException {
        this.output = out;
    }

    public void setWriter(OutputStream output) throws CDKException {
        this.output = new OutputStreamWriter(output);
    }

    public void close() throws IOException {
        if (this.output != null) {
            this.output.close();
        }
    }

    public boolean accepts(Class<? extends IChemObject> classObject) {
        Class<?>[] interfaces;
        if (IAtomContainer.class.equals(classObject)) {
            return true;
        }
        for (Class<?> anInterface : interfaces = classObject.getInterfaces()) {
            if (!IAtomContainer.class.equals(anInterface)) continue;
            return true;
        }
        Class<? extends IChemObject> superClass = classObject.getSuperclass();
        if (superClass != null) {
            return this.accepts(superClass);
        }
        return false;
    }

    public void write(IChemObject object) throws CDKException {
        if (object instanceof IAtomContainer) {
            try {
                this.writeMolecule((IAtomContainer)object);
            }
            catch (Exception ex) {
                throw new CDKException("Error while writing CDK OWL file: " + ex.getMessage(), (Throwable)ex);
            }
        } else {
            throw new CDKException("CDKOWLWriter only supports output of IAtomContainer classes.");
        }
    }

    private void writeMolecule(IAtomContainer mol) {
        Model model = Convertor.molecule2Model(mol);
        RDFDataMgr.write((Writer)this.output, (Model)model, (Lang)Lang.RDFXML);
    }
}

