/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.templates;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.vecmath.Point2d;
import org.openscience.cdk.Atom;
import org.openscience.cdk.ChemFile;
import org.openscience.cdk.DefaultChemObjectBuilder;
import org.openscience.cdk.config.Isotopes;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemSequence;
import org.openscience.cdk.io.MDLReader;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

@Deprecated
public class MoleculeFactory {
    private static final ILoggingTool logger = LoggingToolFactory.createLoggingTool(MoleculeFactory.class);

    public static IAtomContainer makeAlphaPinene() {
        IAtomContainer mol = DefaultChemObjectBuilder.getInstance().newAtomContainer();
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addBond(0, 1, IBond.Order.DOUBLE);
        mol.addBond(1, 2, IBond.Order.SINGLE);
        mol.addBond(2, 3, IBond.Order.SINGLE);
        mol.addBond(3, 4, IBond.Order.SINGLE);
        mol.addBond(4, 5, IBond.Order.SINGLE);
        mol.addBond(5, 0, IBond.Order.SINGLE);
        mol.addBond(0, 6, IBond.Order.SINGLE);
        mol.addBond(3, 7, IBond.Order.SINGLE);
        mol.addBond(5, 7, IBond.Order.SINGLE);
        mol.addBond(7, 8, IBond.Order.SINGLE);
        mol.addBond(7, 9, IBond.Order.SINGLE);
        MoleculeFactory.configureAtoms(mol);
        return mol;
    }

    public static IAtomContainer makeAlkane(int chainLength) {
        IAtomContainer currentChain = DefaultChemObjectBuilder.getInstance().newAtomContainer();
        currentChain.addAtom((IAtom)new Atom("C"));
        for (int atomCount = 1; atomCount < chainLength; ++atomCount) {
            currentChain.addAtom((IAtom)new Atom("C"));
            currentChain.addBond(atomCount, atomCount - 1, IBond.Order.SINGLE);
        }
        return currentChain;
    }

    public static IAtomContainer makeEthylCyclohexane() {
        IAtomContainer mol = DefaultChemObjectBuilder.getInstance().newAtomContainer();
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addBond(0, 1, IBond.Order.SINGLE);
        mol.addBond(1, 2, IBond.Order.SINGLE);
        mol.addBond(2, 3, IBond.Order.SINGLE);
        mol.addBond(3, 4, IBond.Order.SINGLE);
        mol.addBond(4, 5, IBond.Order.SINGLE);
        mol.addBond(5, 0, IBond.Order.SINGLE);
        mol.addBond(0, 6, IBond.Order.SINGLE);
        mol.addBond(6, 7, IBond.Order.SINGLE);
        return mol;
    }

    public static IAtomContainer makeCyclohexene() {
        IAtomContainer mol = DefaultChemObjectBuilder.getInstance().newAtomContainer();
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addBond(0, 1, IBond.Order.SINGLE);
        mol.addBond(1, 2, IBond.Order.SINGLE);
        mol.addBond(2, 3, IBond.Order.SINGLE);
        mol.addBond(3, 4, IBond.Order.SINGLE);
        mol.addBond(4, 5, IBond.Order.SINGLE);
        mol.addBond(5, 0, IBond.Order.DOUBLE);
        return mol;
    }

    public static IAtomContainer makeCyclohexane() {
        IAtomContainer mol = DefaultChemObjectBuilder.getInstance().newAtomContainer();
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addBond(0, 1, IBond.Order.SINGLE);
        mol.addBond(1, 2, IBond.Order.SINGLE);
        mol.addBond(2, 3, IBond.Order.SINGLE);
        mol.addBond(3, 4, IBond.Order.SINGLE);
        mol.addBond(4, 5, IBond.Order.SINGLE);
        mol.addBond(5, 0, IBond.Order.SINGLE);
        return mol;
    }

    public static IAtomContainer makeCyclopentane() {
        IAtomContainer mol = DefaultChemObjectBuilder.getInstance().newAtomContainer();
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addBond(0, 1, IBond.Order.SINGLE);
        mol.addBond(1, 2, IBond.Order.SINGLE);
        mol.addBond(2, 3, IBond.Order.SINGLE);
        mol.addBond(3, 4, IBond.Order.SINGLE);
        mol.addBond(4, 0, IBond.Order.SINGLE);
        return mol;
    }

    public static IAtomContainer makeCyclobutane() {
        IAtomContainer mol = DefaultChemObjectBuilder.getInstance().newAtomContainer();
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addBond(0, 1, IBond.Order.SINGLE);
        mol.addBond(1, 2, IBond.Order.SINGLE);
        mol.addBond(2, 3, IBond.Order.SINGLE);
        mol.addBond(3, 0, IBond.Order.SINGLE);
        return mol;
    }

    public static IAtomContainer makeCyclobutadiene() {
        IAtomContainer mol = DefaultChemObjectBuilder.getInstance().newAtomContainer();
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addBond(0, 1, IBond.Order.SINGLE);
        mol.addBond(1, 2, IBond.Order.DOUBLE);
        mol.addBond(2, 3, IBond.Order.SINGLE);
        mol.addBond(3, 0, IBond.Order.DOUBLE);
        return mol;
    }

    public static IAtomContainer makePropylCycloPropane() {
        IAtomContainer mol = DefaultChemObjectBuilder.getInstance().newAtomContainer();
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addBond(0, 1, IBond.Order.SINGLE);
        mol.addBond(1, 2, IBond.Order.SINGLE);
        mol.addBond(2, 0, IBond.Order.SINGLE);
        mol.addBond(2, 3, IBond.Order.SINGLE);
        mol.addBond(3, 4, IBond.Order.SINGLE);
        mol.addBond(4, 5, IBond.Order.SINGLE);
        return mol;
    }

    public static IAtomContainer makeBiphenyl() {
        IAtomContainer mol = DefaultChemObjectBuilder.getInstance().newAtomContainer();
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addBond(0, 1, IBond.Order.DOUBLE);
        mol.addBond(1, 2, IBond.Order.SINGLE);
        mol.addBond(2, 3, IBond.Order.DOUBLE);
        mol.addBond(3, 4, IBond.Order.SINGLE);
        mol.addBond(4, 5, IBond.Order.DOUBLE);
        mol.addBond(5, 0, IBond.Order.SINGLE);
        mol.addBond(0, 6, IBond.Order.SINGLE);
        mol.addBond(6, 7, IBond.Order.SINGLE);
        mol.addBond(7, 8, IBond.Order.DOUBLE);
        mol.addBond(8, 9, IBond.Order.SINGLE);
        mol.addBond(9, 10, IBond.Order.DOUBLE);
        mol.addBond(10, 11, IBond.Order.SINGLE);
        mol.addBond(11, 6, IBond.Order.DOUBLE);
        return mol;
    }

    public static IAtomContainer makePhenylEthylBenzene() {
        IAtomContainer mol = DefaultChemObjectBuilder.getInstance().newAtomContainer();
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addBond(0, 1, IBond.Order.DOUBLE);
        mol.addBond(1, 2, IBond.Order.SINGLE);
        mol.addBond(2, 3, IBond.Order.DOUBLE);
        mol.addBond(3, 4, IBond.Order.SINGLE);
        mol.addBond(4, 5, IBond.Order.DOUBLE);
        mol.addBond(5, 0, IBond.Order.SINGLE);
        mol.addBond(0, 6, IBond.Order.SINGLE);
        mol.addBond(6, 7, IBond.Order.SINGLE);
        mol.addBond(7, 8, IBond.Order.SINGLE);
        mol.addBond(8, 9, IBond.Order.SINGLE);
        mol.addBond(9, 10, IBond.Order.DOUBLE);
        mol.addBond(10, 11, IBond.Order.SINGLE);
        mol.addBond(11, 12, IBond.Order.DOUBLE);
        mol.addBond(12, 13, IBond.Order.SINGLE);
        mol.addBond(13, 8, IBond.Order.DOUBLE);
        return mol;
    }

    public static IAtomContainer makePhenylAmine() {
        IAtomContainer mol = DefaultChemObjectBuilder.getInstance().newAtomContainer();
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("N"));
        mol.addBond(0, 1, IBond.Order.DOUBLE);
        mol.addBond(1, 2, IBond.Order.SINGLE);
        mol.addBond(2, 3, IBond.Order.DOUBLE);
        mol.addBond(3, 4, IBond.Order.SINGLE);
        mol.addBond(4, 5, IBond.Order.DOUBLE);
        mol.addBond(5, 0, IBond.Order.SINGLE);
        mol.addBond(0, 6, IBond.Order.SINGLE);
        return mol;
    }

    public static IAtomContainer make4x3CondensedRings() {
        IAtomContainer mol = DefaultChemObjectBuilder.getInstance().newAtomContainer();
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addBond(0, 1, IBond.Order.SINGLE);
        mol.addBond(1, 2, IBond.Order.SINGLE);
        mol.addBond(2, 0, IBond.Order.SINGLE);
        mol.addBond(2, 3, IBond.Order.SINGLE);
        mol.addBond(1, 3, IBond.Order.SINGLE);
        mol.addBond(3, 4, IBond.Order.SINGLE);
        mol.addBond(4, 2, IBond.Order.SINGLE);
        mol.addBond(4, 5, IBond.Order.SINGLE);
        mol.addBond(5, 3, IBond.Order.SINGLE);
        return mol;
    }

    public static IAtomContainer makeSpiroRings() {
        IAtomContainer mol = DefaultChemObjectBuilder.getInstance().newAtomContainer();
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addBond(0, 1, IBond.Order.SINGLE);
        mol.addBond(1, 2, IBond.Order.SINGLE);
        mol.addBond(2, 3, IBond.Order.SINGLE);
        mol.addBond(3, 4, IBond.Order.SINGLE);
        mol.addBond(4, 5, IBond.Order.SINGLE);
        mol.addBond(5, 6, IBond.Order.SINGLE);
        mol.addBond(6, 0, IBond.Order.SINGLE);
        mol.addBond(6, 7, IBond.Order.SINGLE);
        mol.addBond(7, 8, IBond.Order.SINGLE);
        mol.addBond(8, 9, IBond.Order.SINGLE);
        mol.addBond(9, 6, IBond.Order.SINGLE);
        return mol;
    }

    public static IAtomContainer makeBicycloRings() {
        IAtomContainer mol = DefaultChemObjectBuilder.getInstance().newAtomContainer();
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addBond(0, 1, IBond.Order.SINGLE);
        mol.addBond(1, 2, IBond.Order.SINGLE);
        mol.addBond(2, 3, IBond.Order.SINGLE);
        mol.addBond(3, 4, IBond.Order.SINGLE);
        mol.addBond(4, 5, IBond.Order.SINGLE);
        mol.addBond(5, 0, IBond.Order.SINGLE);
        mol.addBond(6, 0, IBond.Order.SINGLE);
        mol.addBond(6, 7, IBond.Order.SINGLE);
        mol.addBond(7, 3, IBond.Order.SINGLE);
        return mol;
    }

    public static IAtomContainer makeFusedRings() {
        IAtomContainer mol = DefaultChemObjectBuilder.getInstance().newAtomContainer();
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addBond(0, 1, IBond.Order.SINGLE);
        mol.addBond(1, 2, IBond.Order.SINGLE);
        mol.addBond(2, 3, IBond.Order.SINGLE);
        mol.addBond(3, 4, IBond.Order.SINGLE);
        mol.addBond(4, 5, IBond.Order.SINGLE);
        mol.addBond(5, 0, IBond.Order.SINGLE);
        mol.addBond(5, 6, IBond.Order.SINGLE);
        mol.addBond(6, 7, IBond.Order.SINGLE);
        mol.addBond(7, 4, IBond.Order.SINGLE);
        mol.addBond(8, 0, IBond.Order.SINGLE);
        mol.addBond(9, 1, IBond.Order.SINGLE);
        mol.addBond(9, 8, IBond.Order.SINGLE);
        return mol;
    }

    public static IAtomContainer makeMethylDecaline() {
        IAtomContainer mol = DefaultChemObjectBuilder.getInstance().newAtomContainer();
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addBond(0, 1, IBond.Order.SINGLE);
        mol.addBond(1, 2, IBond.Order.SINGLE);
        mol.addBond(2, 3, IBond.Order.SINGLE);
        mol.addBond(3, 4, IBond.Order.SINGLE);
        mol.addBond(4, 5, IBond.Order.SINGLE);
        mol.addBond(5, 0, IBond.Order.SINGLE);
        mol.addBond(5, 6, IBond.Order.SINGLE);
        mol.addBond(6, 7, IBond.Order.SINGLE);
        mol.addBond(7, 8, IBond.Order.SINGLE);
        mol.addBond(8, 9, IBond.Order.SINGLE);
        mol.addBond(9, 0, IBond.Order.SINGLE);
        mol.addBond(5, 10, IBond.Order.SINGLE);
        return mol;
    }

    public static IAtomContainer makeEthylPropylPhenantren() {
        IAtomContainer mol = DefaultChemObjectBuilder.getInstance().newAtomContainer();
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addBond(0, 1, IBond.Order.SINGLE);
        mol.addBond(1, 2, IBond.Order.DOUBLE);
        mol.addBond(2, 3, IBond.Order.SINGLE);
        mol.addBond(3, 4, IBond.Order.DOUBLE);
        mol.addBond(4, 5, IBond.Order.SINGLE);
        mol.addBond(5, 6, IBond.Order.DOUBLE);
        mol.addBond(6, 7, IBond.Order.SINGLE);
        mol.addBond(7, 8, IBond.Order.DOUBLE);
        mol.addBond(8, 9, IBond.Order.SINGLE);
        mol.addBond(9, 0, IBond.Order.DOUBLE);
        mol.addBond(9, 4, IBond.Order.SINGLE);
        mol.addBond(8, 10, IBond.Order.SINGLE);
        mol.addBond(10, 11, IBond.Order.DOUBLE);
        mol.addBond(11, 12, IBond.Order.SINGLE);
        mol.addBond(12, 13, IBond.Order.DOUBLE);
        mol.addBond(13, 7, IBond.Order.SINGLE);
        mol.addBond(3, 14, IBond.Order.SINGLE);
        mol.addBond(14, 15, IBond.Order.SINGLE);
        mol.addBond(12, 16, IBond.Order.SINGLE);
        mol.addBond(16, 17, IBond.Order.SINGLE);
        mol.addBond(17, 18, IBond.Order.SINGLE);
        MoleculeFactory.configureAtoms(mol);
        return mol;
    }

    public static IAtomContainer makeSteran() {
        IAtomContainer mol = DefaultChemObjectBuilder.getInstance().newAtomContainer();
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addBond(0, 1, IBond.Order.SINGLE);
        mol.addBond(1, 2, IBond.Order.SINGLE);
        mol.addBond(2, 3, IBond.Order.SINGLE);
        mol.addBond(3, 4, IBond.Order.SINGLE);
        mol.addBond(4, 5, IBond.Order.SINGLE);
        mol.addBond(5, 6, IBond.Order.SINGLE);
        mol.addBond(6, 7, IBond.Order.SINGLE);
        mol.addBond(7, 8, IBond.Order.SINGLE);
        mol.addBond(8, 9, IBond.Order.SINGLE);
        mol.addBond(9, 0, IBond.Order.SINGLE);
        mol.addBond(9, 4, IBond.Order.SINGLE);
        mol.addBond(8, 10, IBond.Order.SINGLE);
        mol.addBond(10, 11, IBond.Order.SINGLE);
        mol.addBond(11, 12, IBond.Order.SINGLE);
        mol.addBond(12, 13, IBond.Order.SINGLE);
        mol.addBond(13, 7, IBond.Order.SINGLE);
        mol.addBond(13, 14, IBond.Order.SINGLE);
        mol.addBond(14, 15, IBond.Order.SINGLE);
        mol.addBond(15, 16, IBond.Order.SINGLE);
        mol.addBond(16, 12, IBond.Order.SINGLE);
        MoleculeFactory.configureAtoms(mol);
        return mol;
    }

    public static IAtomContainer makeAzulene() {
        IAtomContainer mol = DefaultChemObjectBuilder.getInstance().newAtomContainer();
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addBond(0, 1, IBond.Order.DOUBLE);
        mol.addBond(1, 2, IBond.Order.SINGLE);
        mol.addBond(2, 3, IBond.Order.DOUBLE);
        mol.addBond(3, 4, IBond.Order.SINGLE);
        mol.addBond(4, 5, IBond.Order.DOUBLE);
        mol.addBond(5, 6, IBond.Order.SINGLE);
        mol.addBond(6, 7, IBond.Order.DOUBLE);
        mol.addBond(7, 8, IBond.Order.SINGLE);
        mol.addBond(8, 9, IBond.Order.DOUBLE);
        mol.addBond(9, 5, IBond.Order.SINGLE);
        mol.addBond(9, 0, IBond.Order.SINGLE);
        return mol;
    }

    public static IAtomContainer makeIndole() {
        IAtomContainer mol = DefaultChemObjectBuilder.getInstance().newAtomContainer();
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("N"));
        mol.addBond(0, 1, IBond.Order.DOUBLE);
        mol.addBond(1, 2, IBond.Order.SINGLE);
        mol.addBond(2, 3, IBond.Order.DOUBLE);
        mol.addBond(3, 4, IBond.Order.SINGLE);
        mol.addBond(4, 5, IBond.Order.DOUBLE);
        mol.addBond(5, 6, IBond.Order.SINGLE);
        mol.addBond(6, 7, IBond.Order.DOUBLE);
        mol.addBond(7, 8, IBond.Order.SINGLE);
        mol.addBond(0, 5, IBond.Order.SINGLE);
        mol.addBond(8, 0, IBond.Order.SINGLE);
        return mol;
    }

    public static IAtomContainer makePyrrole() {
        IAtomContainer mol = DefaultChemObjectBuilder.getInstance().newAtomContainer();
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("N"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addBond(0, 1, IBond.Order.SINGLE);
        mol.addBond(1, 2, IBond.Order.SINGLE);
        mol.addBond(2, 3, IBond.Order.DOUBLE);
        mol.addBond(3, 4, IBond.Order.SINGLE);
        mol.addBond(4, 0, IBond.Order.DOUBLE);
        return mol;
    }

    public static IAtomContainer makePyrroleAnion() {
        IAtomContainer mol = DefaultChemObjectBuilder.getInstance().newAtomContainer();
        Atom nitrogenAnion = new Atom("N");
        nitrogenAnion.setFormalCharge(Integer.valueOf(-1));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)nitrogenAnion);
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addBond(0, 1, IBond.Order.SINGLE);
        mol.addBond(1, 2, IBond.Order.SINGLE);
        mol.addBond(2, 3, IBond.Order.DOUBLE);
        mol.addBond(3, 4, IBond.Order.SINGLE);
        mol.addBond(4, 0, IBond.Order.DOUBLE);
        return mol;
    }

    public static IAtomContainer makeImidazole() {
        IAtomContainer mol = DefaultChemObjectBuilder.getInstance().newAtomContainer();
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("N"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("N"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addBond(0, 1, IBond.Order.SINGLE);
        mol.addBond(1, 2, IBond.Order.SINGLE);
        mol.addBond(2, 3, IBond.Order.DOUBLE);
        mol.addBond(3, 4, IBond.Order.SINGLE);
        mol.addBond(4, 0, IBond.Order.DOUBLE);
        return mol;
    }

    public static IAtomContainer makePyrazole() {
        IAtomContainer mol = DefaultChemObjectBuilder.getInstance().newAtomContainer();
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("N"));
        mol.addAtom((IAtom)new Atom("N"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addBond(0, 1, IBond.Order.SINGLE);
        mol.addBond(1, 2, IBond.Order.SINGLE);
        mol.addBond(2, 3, IBond.Order.DOUBLE);
        mol.addBond(3, 4, IBond.Order.SINGLE);
        mol.addBond(4, 0, IBond.Order.DOUBLE);
        return mol;
    }

    public static IAtomContainer make124Triazole() {
        IAtomContainer mol = DefaultChemObjectBuilder.getInstance().newAtomContainer();
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("N"));
        mol.addAtom((IAtom)new Atom("N"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("N"));
        mol.addBond(0, 1, IBond.Order.SINGLE);
        mol.addBond(1, 2, IBond.Order.SINGLE);
        mol.addBond(2, 3, IBond.Order.DOUBLE);
        mol.addBond(3, 4, IBond.Order.SINGLE);
        mol.addBond(4, 0, IBond.Order.DOUBLE);
        return mol;
    }

    public static IAtomContainer make123Triazole() {
        IAtomContainer mol = DefaultChemObjectBuilder.getInstance().newAtomContainer();
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("N"));
        mol.addAtom((IAtom)new Atom("N"));
        mol.addAtom((IAtom)new Atom("N"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addBond(0, 1, IBond.Order.SINGLE);
        mol.addBond(1, 2, IBond.Order.SINGLE);
        mol.addBond(2, 3, IBond.Order.DOUBLE);
        mol.addBond(3, 4, IBond.Order.SINGLE);
        mol.addBond(4, 0, IBond.Order.DOUBLE);
        return mol;
    }

    public static IAtomContainer makeTetrazole() {
        IAtomContainer mol = DefaultChemObjectBuilder.getInstance().newAtomContainer();
        mol.addAtom((IAtom)new Atom("N"));
        mol.addAtom((IAtom)new Atom("N"));
        mol.addAtom((IAtom)new Atom("N"));
        mol.addAtom((IAtom)new Atom("N"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addBond(0, 1, IBond.Order.SINGLE);
        mol.addBond(1, 2, IBond.Order.SINGLE);
        mol.addBond(2, 3, IBond.Order.DOUBLE);
        mol.addBond(3, 4, IBond.Order.SINGLE);
        mol.addBond(4, 0, IBond.Order.DOUBLE);
        return mol;
    }

    public static IAtomContainer makeOxazole() {
        IAtomContainer mol = DefaultChemObjectBuilder.getInstance().newAtomContainer();
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("O"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("N"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addBond(0, 1, IBond.Order.SINGLE);
        mol.addBond(1, 2, IBond.Order.SINGLE);
        mol.addBond(2, 3, IBond.Order.DOUBLE);
        mol.addBond(3, 4, IBond.Order.SINGLE);
        mol.addBond(4, 0, IBond.Order.DOUBLE);
        return mol;
    }

    public static IAtomContainer makeIsoxazole() {
        IAtomContainer mol = DefaultChemObjectBuilder.getInstance().newAtomContainer();
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("O"));
        mol.addAtom((IAtom)new Atom("N"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addBond(0, 1, IBond.Order.SINGLE);
        mol.addBond(1, 2, IBond.Order.SINGLE);
        mol.addBond(2, 3, IBond.Order.DOUBLE);
        mol.addBond(3, 4, IBond.Order.SINGLE);
        mol.addBond(4, 0, IBond.Order.DOUBLE);
        return mol;
    }

    public static IAtomContainer makeIsothiazole() {
        IAtomContainer mol = DefaultChemObjectBuilder.getInstance().newAtomContainer();
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("S"));
        mol.addAtom((IAtom)new Atom("N"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addBond(0, 1, IBond.Order.SINGLE);
        mol.addBond(1, 2, IBond.Order.SINGLE);
        mol.addBond(2, 3, IBond.Order.DOUBLE);
        mol.addBond(3, 4, IBond.Order.SINGLE);
        mol.addBond(4, 0, IBond.Order.DOUBLE);
        return mol;
    }

    public static IAtomContainer makeThiadiazole() {
        IAtomContainer mol = DefaultChemObjectBuilder.getInstance().newAtomContainer();
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("S"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("N"));
        mol.addAtom((IAtom)new Atom("N"));
        mol.addBond(0, 1, IBond.Order.SINGLE);
        mol.addBond(1, 2, IBond.Order.SINGLE);
        mol.addBond(2, 3, IBond.Order.DOUBLE);
        mol.addBond(3, 4, IBond.Order.SINGLE);
        mol.addBond(4, 0, IBond.Order.DOUBLE);
        return mol;
    }

    public static IAtomContainer makeOxadiazole() {
        IAtomContainer mol = DefaultChemObjectBuilder.getInstance().newAtomContainer();
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("O"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("N"));
        mol.addAtom((IAtom)new Atom("N"));
        mol.addBond(0, 1, IBond.Order.SINGLE);
        mol.addBond(1, 2, IBond.Order.SINGLE);
        mol.addBond(2, 3, IBond.Order.DOUBLE);
        mol.addBond(3, 4, IBond.Order.SINGLE);
        mol.addBond(4, 0, IBond.Order.DOUBLE);
        return mol;
    }

    public static IAtomContainer makePyridine() {
        IAtomContainer mol = DefaultChemObjectBuilder.getInstance().newAtomContainer();
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("N"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addBond(0, 1, IBond.Order.DOUBLE);
        mol.addBond(1, 2, IBond.Order.SINGLE);
        mol.addBond(2, 3, IBond.Order.DOUBLE);
        mol.addBond(3, 4, IBond.Order.SINGLE);
        mol.addBond(4, 5, IBond.Order.DOUBLE);
        mol.addBond(5, 0, IBond.Order.SINGLE);
        return mol;
    }

    public static IAtomContainer makePyridineOxide() {
        IAtomContainer mol = DefaultChemObjectBuilder.getInstance().newAtomContainer();
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("N"));
        mol.getAtom(1).setFormalCharge(Integer.valueOf(1));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("O"));
        mol.getAtom(6).setFormalCharge(Integer.valueOf(-1));
        mol.addBond(0, 1, IBond.Order.DOUBLE);
        mol.addBond(1, 2, IBond.Order.SINGLE);
        mol.addBond(2, 3, IBond.Order.DOUBLE);
        mol.addBond(3, 4, IBond.Order.SINGLE);
        mol.addBond(4, 5, IBond.Order.DOUBLE);
        mol.addBond(5, 0, IBond.Order.SINGLE);
        mol.addBond(1, 6, IBond.Order.SINGLE);
        return mol;
    }

    public static IAtomContainer makePyrimidine() {
        IAtomContainer mol = DefaultChemObjectBuilder.getInstance().newAtomContainer();
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("N"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("N"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addBond(0, 1, IBond.Order.DOUBLE);
        mol.addBond(1, 2, IBond.Order.SINGLE);
        mol.addBond(2, 3, IBond.Order.DOUBLE);
        mol.addBond(3, 4, IBond.Order.SINGLE);
        mol.addBond(4, 5, IBond.Order.DOUBLE);
        mol.addBond(5, 0, IBond.Order.SINGLE);
        return mol;
    }

    public static IAtomContainer makePyridazine() {
        IAtomContainer mol = DefaultChemObjectBuilder.getInstance().newAtomContainer();
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("N"));
        mol.addAtom((IAtom)new Atom("N"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addBond(0, 1, IBond.Order.DOUBLE);
        mol.addBond(1, 2, IBond.Order.SINGLE);
        mol.addBond(2, 3, IBond.Order.DOUBLE);
        mol.addBond(3, 4, IBond.Order.SINGLE);
        mol.addBond(4, 5, IBond.Order.DOUBLE);
        mol.addBond(5, 0, IBond.Order.SINGLE);
        return mol;
    }

    public static IAtomContainer makeTriazine() {
        IAtomContainer mol = DefaultChemObjectBuilder.getInstance().newAtomContainer();
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("N"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("N"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("N"));
        mol.addBond(0, 1, IBond.Order.DOUBLE);
        mol.addBond(1, 2, IBond.Order.SINGLE);
        mol.addBond(2, 3, IBond.Order.DOUBLE);
        mol.addBond(3, 4, IBond.Order.SINGLE);
        mol.addBond(4, 5, IBond.Order.DOUBLE);
        mol.addBond(5, 0, IBond.Order.SINGLE);
        return mol;
    }

    public static IAtomContainer makeThiazole() {
        IAtomContainer mol = DefaultChemObjectBuilder.getInstance().newAtomContainer();
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("N"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("S"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addBond(0, 1, IBond.Order.SINGLE);
        mol.addBond(1, 2, IBond.Order.DOUBLE);
        mol.addBond(2, 3, IBond.Order.SINGLE);
        mol.addBond(3, 4, IBond.Order.SINGLE);
        mol.addBond(4, 0, IBond.Order.DOUBLE);
        return mol;
    }

    public static IAtomContainer makeSingleRing() {
        IAtomContainer mol = DefaultChemObjectBuilder.getInstance().newAtomContainer();
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addBond(0, 1, IBond.Order.SINGLE);
        mol.addBond(1, 2, IBond.Order.SINGLE);
        mol.addBond(2, 3, IBond.Order.SINGLE);
        mol.addBond(3, 4, IBond.Order.SINGLE);
        mol.addBond(4, 5, IBond.Order.SINGLE);
        mol.addBond(5, 0, IBond.Order.SINGLE);
        return mol;
    }

    public static IAtomContainer makeDiamantane() {
        IAtomContainer mol = DefaultChemObjectBuilder.getInstance().newAtomContainer();
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addBond(0, 1, IBond.Order.SINGLE);
        mol.addBond(1, 2, IBond.Order.SINGLE);
        mol.addBond(2, 3, IBond.Order.SINGLE);
        mol.addBond(3, 4, IBond.Order.SINGLE);
        mol.addBond(4, 5, IBond.Order.SINGLE);
        mol.addBond(5, 0, IBond.Order.SINGLE);
        mol.addBond(5, 6, IBond.Order.SINGLE);
        mol.addBond(6, 9, IBond.Order.SINGLE);
        mol.addBond(1, 7, IBond.Order.SINGLE);
        mol.addBond(7, 9, IBond.Order.SINGLE);
        mol.addBond(3, 8, IBond.Order.SINGLE);
        mol.addBond(8, 9, IBond.Order.SINGLE);
        mol.addBond(0, 10, IBond.Order.SINGLE);
        mol.addBond(10, 13, IBond.Order.SINGLE);
        mol.addBond(2, 11, IBond.Order.SINGLE);
        mol.addBond(11, 13, IBond.Order.SINGLE);
        mol.addBond(4, 12, IBond.Order.SINGLE);
        mol.addBond(12, 13, IBond.Order.SINGLE);
        return mol;
    }

    public static IAtomContainer makeBranchedAliphatic() {
        IAtomContainer mol = DefaultChemObjectBuilder.getInstance().newAtomContainer();
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addBond(0, 1, IBond.Order.SINGLE);
        mol.addBond(1, 2, IBond.Order.SINGLE);
        mol.addBond(2, 3, IBond.Order.DOUBLE);
        mol.addBond(3, 4, IBond.Order.SINGLE);
        mol.addBond(4, 5, IBond.Order.SINGLE);
        mol.addBond(2, 6, IBond.Order.SINGLE);
        mol.addBond(6, 7, IBond.Order.SINGLE);
        mol.addBond(7, 8, IBond.Order.SINGLE);
        mol.addBond(6, 9, IBond.Order.SINGLE);
        mol.addBond(6, 10, IBond.Order.SINGLE);
        mol.addBond(10, 11, IBond.Order.SINGLE);
        mol.addBond(8, 12, IBond.Order.TRIPLE);
        mol.addBond(12, 13, IBond.Order.SINGLE);
        mol.addBond(11, 14, IBond.Order.SINGLE);
        mol.addBond(9, 15, IBond.Order.SINGLE);
        mol.addBond(15, 16, IBond.Order.DOUBLE);
        mol.addBond(16, 17, IBond.Order.DOUBLE);
        mol.addBond(17, 18, IBond.Order.SINGLE);
        return mol;
    }

    public static IAtomContainer makeBenzene() {
        IAtomContainer mol = DefaultChemObjectBuilder.getInstance().newAtomContainer();
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addBond(0, 1, IBond.Order.SINGLE);
        mol.addBond(1, 2, IBond.Order.DOUBLE);
        mol.addBond(2, 3, IBond.Order.SINGLE);
        mol.addBond(3, 4, IBond.Order.DOUBLE);
        mol.addBond(4, 5, IBond.Order.SINGLE);
        mol.addBond(5, 0, IBond.Order.DOUBLE);
        return mol;
    }

    public static IAtomContainer makeQuinone() {
        IAtomContainer mol = DefaultChemObjectBuilder.getInstance().newAtomContainer();
        mol.addAtom((IAtom)new Atom("O"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("O"));
        mol.addBond(0, 1, IBond.Order.DOUBLE);
        mol.addBond(1, 2, IBond.Order.SINGLE);
        mol.addBond(2, 3, IBond.Order.DOUBLE);
        mol.addBond(3, 4, IBond.Order.SINGLE);
        mol.addBond(4, 5, IBond.Order.SINGLE);
        mol.addBond(5, 6, IBond.Order.DOUBLE);
        mol.addBond(6, 1, IBond.Order.SINGLE);
        mol.addBond(4, 7, IBond.Order.DOUBLE);
        return mol;
    }

    public static IAtomContainer makePiperidine() {
        IAtomContainer mol = DefaultChemObjectBuilder.getInstance().newAtomContainer();
        mol.addAtom((IAtom)new Atom("N"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("H"));
        mol.addBond(0, 1, IBond.Order.SINGLE);
        mol.addBond(1, 2, IBond.Order.SINGLE);
        mol.addBond(2, 3, IBond.Order.SINGLE);
        mol.addBond(3, 4, IBond.Order.SINGLE);
        mol.addBond(4, 5, IBond.Order.SINGLE);
        mol.addBond(5, 0, IBond.Order.SINGLE);
        mol.addBond(0, 6, IBond.Order.SINGLE);
        return mol;
    }

    public static IAtomContainer makeTetrahydropyran() {
        IAtomContainer mol = DefaultChemObjectBuilder.getInstance().newAtomContainer();
        mol.addAtom((IAtom)new Atom("O"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addAtom((IAtom)new Atom("C"));
        mol.addBond(0, 1, IBond.Order.SINGLE);
        mol.addBond(1, 2, IBond.Order.SINGLE);
        mol.addBond(2, 3, IBond.Order.SINGLE);
        mol.addBond(3, 4, IBond.Order.SINGLE);
        mol.addBond(4, 5, IBond.Order.SINGLE);
        mol.addBond(5, 0, IBond.Order.SINGLE);
        return mol;
    }

    public static IAtomContainer loadMolecule(String inFile) {
        IAtomContainer molecule = null;
        try (FileInputStream fis = new FileInputStream(inFile);
             MDLReader mr = new MDLReader((InputStream)fis);){
            ChemFile chemFile = (ChemFile)mr.read((IChemObject)new ChemFile());
            mr.close();
            IChemSequence chemSequence = chemFile.getChemSequence(0);
            IChemModel chemModel = chemSequence.getChemModel(0);
            IAtomContainerSet setOfMolecules = chemModel.getMoleculeSet();
            molecule = setOfMolecules.getAtomContainer(0);
            for (int i = 0; i < molecule.getAtomCount(); ++i) {
                molecule.getAtom(i).setPoint2d(null);
            }
        }
        catch (IOException | CDKException exc) {
            logger.error((Object)("An exception occurred while loading a molecule: " + inFile));
            logger.debug((Object)exc);
        }
        return molecule;
    }

    public static IAtomContainer makeAdenine() {
        IAtomContainer mol = DefaultChemObjectBuilder.getInstance().newAtomContainer();
        IAtom a1 = (IAtom)mol.getBuilder().newInstance(IAtom.class, new Object[]{"C"});
        a1.setPoint2d(new Point2d(21.0223, -17.2946));
        mol.addAtom(a1);
        IAtom a2 = (IAtom)mol.getBuilder().newInstance(IAtom.class, new Object[]{"C"});
        a2.setPoint2d(new Point2d(21.0223, -18.8093));
        mol.addAtom(a2);
        IAtom a3 = (IAtom)mol.getBuilder().newInstance(IAtom.class, new Object[]{"C"});
        a3.setPoint2d(new Point2d(22.1861, -16.6103));
        mol.addAtom(a3);
        IAtom a4 = (IAtom)mol.getBuilder().newInstance(IAtom.class, new Object[]{"N"});
        a4.setPoint2d(new Point2d(19.8294, -16.8677));
        mol.addAtom(a4);
        IAtom a5 = (IAtom)mol.getBuilder().newInstance(IAtom.class, new Object[]{"N"});
        a5.setPoint2d(new Point2d(22.2212, -19.5285));
        mol.addAtom(a5);
        IAtom a6 = (IAtom)mol.getBuilder().newInstance(IAtom.class, new Object[]{"N"});
        a6.setPoint2d(new Point2d(19.8177, -19.2187));
        mol.addAtom(a6);
        IAtom a7 = (IAtom)mol.getBuilder().newInstance(IAtom.class, new Object[]{"N"});
        a7.setPoint2d(new Point2d(23.4669, -17.3531));
        mol.addAtom(a7);
        IAtom a8 = (IAtom)mol.getBuilder().newInstance(IAtom.class, new Object[]{"N"});
        a8.setPoint2d(new Point2d(22.1861, -15.2769));
        mol.addAtom(a8);
        IAtom a9 = (IAtom)mol.getBuilder().newInstance(IAtom.class, new Object[]{"C"});
        a9.setPoint2d(new Point2d(18.9871, -18.0139));
        mol.addAtom(a9);
        IAtom a10 = (IAtom)mol.getBuilder().newInstance(IAtom.class, new Object[]{"C"});
        a10.setPoint2d(new Point2d(23.4609, -18.8267));
        mol.addAtom(a10);
        IBond b1 = (IBond)mol.getBuilder().newInstance(IBond.class, new Object[]{a1, a2, IBond.Order.DOUBLE});
        mol.addBond(b1);
        IBond b2 = (IBond)mol.getBuilder().newInstance(IBond.class, new Object[]{a1, a3, IBond.Order.SINGLE});
        mol.addBond(b2);
        IBond b3 = (IBond)mol.getBuilder().newInstance(IBond.class, new Object[]{a1, a4, IBond.Order.SINGLE});
        mol.addBond(b3);
        IBond b4 = (IBond)mol.getBuilder().newInstance(IBond.class, new Object[]{a2, a5, IBond.Order.SINGLE});
        mol.addBond(b4);
        IBond b5 = (IBond)mol.getBuilder().newInstance(IBond.class, new Object[]{a2, a6, IBond.Order.SINGLE});
        mol.addBond(b5);
        IBond b6 = (IBond)mol.getBuilder().newInstance(IBond.class, new Object[]{a3, a7, IBond.Order.DOUBLE});
        mol.addBond(b6);
        IBond b7 = (IBond)mol.getBuilder().newInstance(IBond.class, new Object[]{a3, a8, IBond.Order.SINGLE});
        mol.addBond(b7);
        IBond b8 = (IBond)mol.getBuilder().newInstance(IBond.class, new Object[]{a4, a9, IBond.Order.DOUBLE});
        mol.addBond(b8);
        IBond b9 = (IBond)mol.getBuilder().newInstance(IBond.class, new Object[]{a5, a10, IBond.Order.DOUBLE});
        mol.addBond(b9);
        IBond b10 = (IBond)mol.getBuilder().newInstance(IBond.class, new Object[]{a6, a9, IBond.Order.SINGLE});
        mol.addBond(b10);
        IBond b11 = (IBond)mol.getBuilder().newInstance(IBond.class, new Object[]{a7, a10, IBond.Order.SINGLE});
        mol.addBond(b11);
        return mol;
    }

    private static void configureAtoms(IAtomContainer mol) {
        try {
            Isotopes.getInstance().configureAtoms(mol);
        }
        catch (Exception exc) {
            logger.error((Object)"Could not configure molecule!");
            logger.debug((Object)exc);
        }
    }
}

