/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.ringsearch.cyclebasis;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org._3pq.jgrapht.Edge;
import org._3pq.jgrapht.Graph;
import org._3pq.jgrapht.UndirectedGraph;
import org._3pq.jgrapht.alg.ConnectivityInspector;
import org._3pq.jgrapht.graph.SimpleGraph;
import org._3pq.jgrapht.graph.Subgraph;
import org.openscience.cdk.graph.BFSShortestPath;
import org.openscience.cdk.graph.MinimalPathIterator;
import org.openscience.cdk.ringsearch.cyclebasis.SimpleCycle;

@Deprecated
public class SimpleCycleBasis {
    private List edgeList;
    private List<SimpleCycle> cycles;
    private UndirectedGraph graph;
    private boolean isMinimized = false;
    private HashMap edgeIndexMap;

    public SimpleCycleBasis(List<SimpleCycle> cycles, List edgeList, UndirectedGraph graph) {
        this.edgeList = edgeList;
        this.cycles = cycles;
        this.graph = graph;
        this.edgeIndexMap = this.createEdgeIndexMap(edgeList);
    }

    public SimpleCycleBasis(UndirectedGraph graph) {
        this.cycles = new ArrayList<SimpleCycle>();
        this.edgeList = new ArrayList();
        this.graph = graph;
        this.createMinimumCycleBasis();
    }

    private void createMinimumCycleBasis() {
        Subgraph subgraph = new Subgraph((Graph)this.graph, null, null);
        HashSet remainingEdges = new HashSet(this.graph.edgeSet());
        HashSet<Edge> selectedEdges = new HashSet<Edge>();
        while (!remainingEdges.isEmpty()) {
            Edge edge = (Edge)remainingEdges.iterator().next();
            subgraph.removeEdge(edge);
            List<Edge> path = BFSShortestPath.findPathBetween((Graph)subgraph, edge.getSource(), edge.getTarget());
            path.add(edge);
            SimpleCycle cycle = new SimpleCycle(this.graph, path);
            subgraph.addEdge(edge);
            selectedEdges.add(edge);
            this.cycles.add(0, cycle);
            this.edgeList.add(0, edge);
            remainingEdges.removeAll(path);
        }
        subgraph.removeAllEdges(selectedEdges);
        int startIndex = this.cycles.size();
        Object currentVertex = this.graph.vertexSet().iterator().next();
        Subgraph spanningTree = new Subgraph((Graph)this.graph, new HashSet(), new HashSet());
        HashSet<Edge> visitedEdges = new HashSet<Edge>();
        LinkedList<Object> vertexQueue = new LinkedList<Object>();
        spanningTree.addVertex(currentVertex);
        vertexQueue.addLast(currentVertex);
        Vector<Edge> treeEdges = new Vector<Edge>();
        while (!vertexQueue.isEmpty()) {
            currentVertex = vertexQueue.removeFirst();
            for (Edge edge : subgraph.edgesOf(currentVertex)) {
                if (visitedEdges.contains(edge)) continue;
                visitedEdges.add(edge);
                Object nextVertex = edge.oppositeVertex(currentVertex);
                if (!spanningTree.containsVertex(nextVertex)) {
                    treeEdges.add(edge);
                    spanningTree.addVertex(nextVertex);
                    spanningTree.addEdge(currentVertex, nextVertex);
                    vertexQueue.addLast(nextVertex);
                    continue;
                }
                List<Edge> edgesOfCycle = BFSShortestPath.findPathBetween((Graph)spanningTree, edge.getSource(), edge.getTarget());
                edgesOfCycle.add(edge);
                this.edgeList.add(edge);
                SimpleCycle newCycle = new SimpleCycle(this.graph, edgesOfCycle);
                this.cycles.add(newCycle);
            }
        }
        this.edgeList.addAll(treeEdges);
        this.edgeIndexMap = this.createEdgeIndexMap(this.edgeList);
        this.minimize(startIndex);
    }

    boolean[][] getCycleEdgeIncidenceMatrix() {
        return this.getCycleEdgeIncidenceMatrix(this.cycles.toArray());
    }

    boolean[][] getCycleEdgeIncidenceMatrix(Object[] cycleArray) {
        boolean[][] result = new boolean[cycleArray.length][this.edgeList.size()];
        for (int i = 0; i < cycleArray.length; ++i) {
            SimpleCycle cycle = (SimpleCycle)((Object)cycleArray[i]);
            for (int j = 0; j < this.edgeList.size(); ++j) {
                Edge edge = (Edge)this.edgeList.get(j);
                result[i][j] = cycle.containsEdge(edge);
            }
        }
        return result;
    }

    private void minimize(int startIndex) {
        if (this.isMinimized) {
            return;
        }
        boolean[][] a = this.getCycleEdgeIncidenceMatrix();
        for (int i = startIndex; i < this.cycles.size(); ++i) {
            int j;
            boolean[] u = SimpleCycleBasis.constructKernelVector(this.edgeList.size(), a, i);
            AuxiliaryGraph gu = new AuxiliaryGraph((Graph)this.graph, u);
            SimpleCycle shortestCycle = this.cycles.get(i);
            for (Object vertex : this.graph.vertexSet()) {
                boolean shouldSearchCycle = false;
                List incidentEdges = this.graph.edgesOf(vertex);
                for (Edge edge : incidentEdges) {
                    int index = this.getEdgeIndex(edge);
                    if (!u[index]) continue;
                    shouldSearchCycle = true;
                    break;
                }
                if (!shouldSearchCycle) continue;
                Object auxVertex0 = gu.auxVertex0(vertex);
                Object auxVertex1 = gu.auxVertex1(vertex);
                List<Edge> auxPath = BFSShortestPath.findPathBetween((Graph)gu, auxVertex0, auxVertex1);
                Vector<Edge> edgesOfNewCycle = new Vector<Edge>();
                Object v = vertex;
                for (Edge auxEdge : auxPath) {
                    Edge e = (Edge)gu.edge(auxEdge);
                    if (edgesOfNewCycle.contains(e)) {
                        edgesOfNewCycle.remove(e);
                    } else {
                        edgesOfNewCycle.add(e);
                    }
                    v = e.oppositeVertex(v);
                }
                SimpleCycle newCycle = new SimpleCycle(this.graph, edgesOfNewCycle);
                if (!(newCycle.weight() < shortestCycle.weight())) continue;
                shortestCycle = newCycle;
            }
            this.cycles.set(i, shortestCycle);
            for (j = 0; j < this.edgeList.size(); ++j) {
                a[i][j] = shortestCycle.containsEdge((Edge)this.edgeList.get(j));
            }
            for (j = 0; j < i; ++j) {
                if (!a[i][j]) continue;
                for (int k = 0; k < this.edgeList.size(); ++k) {
                    a[i][k] = a[i][k] != a[j][k];
                }
            }
        }
        this.isMinimized = true;
    }

    static boolean[] constructKernelVector(int size, boolean[][] a, int i) {
        boolean[] u = new boolean[size];
        u[i] = true;
        for (int j = i - 1; j >= 0; --j) {
            u[j] = false;
            for (int k = i; k > j; --k) {
                u[j] = u[j] != (a[j][k] && u[k]);
            }
        }
        return u;
    }

    public int[] weightVector() {
        int[] result = new int[this.cycles.size()];
        for (int i = 0; i < this.cycles.size(); ++i) {
            SimpleCycle cycle = this.cycles.get(i);
            result[i] = (int)cycle.weight();
        }
        Arrays.sort(result);
        return result;
    }

    public List edges() {
        return this.edgeList;
    }

    public List cycles() {
        return this.cycles;
    }

    static boolean[][] inverseBinaryMatrix(boolean[][] m, int n) {
        int i;
        boolean[][] a = new boolean[n][n];
        for (int i2 = 0; i2 < n; ++i2) {
            for (int j = 0; j < n; ++j) {
                a[i2][j] = m[i2][j];
            }
        }
        boolean[][] r = new boolean[n][n];
        for (i = 0; i < n; ++i) {
            r[i][i] = true;
        }
        block3: for (i = 0; i < n; ++i) {
            for (int j = i; j < n; ++j) {
                if (!a[j][i]) continue;
                for (int k = 0; k < n; ++k) {
                    if (k == j || !a[k][i]) continue;
                    for (int l = 0; l < n; ++l) {
                        a[k][l] = a[k][l] != a[j][l];
                        r[k][l] = r[k][l] != r[j][l];
                    }
                }
                if (i == j) continue block3;
                boolean[] swap = a[i];
                a[i] = a[j];
                a[j] = swap;
                swap = r[i];
                r[i] = r[j];
                r[j] = swap;
                continue block3;
            }
        }
        return r;
    }

    public Collection essentialCycles() {
        HashSet<SimpleCycle> result = new HashSet<SimpleCycle>();
        boolean[][] a = this.getCycleEdgeIncidenceMatrix();
        boolean[][] ai = SimpleCycleBasis.inverseBinaryMatrix(a, this.cycles.size());
        for (int i = 0; i < this.cycles.size(); ++i) {
            boolean[] u = new boolean[this.edgeList.size()];
            for (int j = 0; j < this.cycles.size(); ++j) {
                u[j] = ai[j][i];
            }
            AuxiliaryGraph gu = new AuxiliaryGraph((Graph)this.graph, u);
            boolean isEssential = true;
            Iterator vertexIterator = this.graph.vertexSet().iterator();
            block2: while (isEssential && vertexIterator.hasNext()) {
                Object vertex = vertexIterator.next();
                List incidentEdges = this.graph.edgesOf(vertex);
                boolean shouldSearchCycle = false;
                for (Edge edge : incidentEdges) {
                    int index = this.getEdgeIndex(edge);
                    if (!u[index]) continue;
                    shouldSearchCycle = true;
                    break;
                }
                if (!shouldSearchCycle) continue;
                Object auxVertex0 = gu.auxVertex0(vertex);
                Object auxVertex1 = gu.auxVertex1(vertex);
                MinimalPathIterator minPaths = new MinimalPathIterator(gu, auxVertex0, auxVertex1);
                while (minPaths.hasNext()) {
                    List auxPath = (List)minPaths.next();
                    ArrayList<Edge> edgesOfNewCycle = new ArrayList<Edge>(auxPath.size());
                    for (Edge auxEdge : auxPath) {
                        Edge e = (Edge)gu.edge(auxEdge);
                        if (edgesOfNewCycle.contains(e)) {
                            edgesOfNewCycle.remove(e);
                            continue;
                        }
                        edgesOfNewCycle.add(e);
                    }
                    SimpleCycle cycle = new SimpleCycle(this.graph, edgesOfNewCycle);
                    if (cycle.weight() > this.cycles.get(i).weight()) continue block2;
                    if (cycle.equals((Object)this.cycles.get(i))) continue;
                    isEssential = false;
                    continue block2;
                }
            }
            if (!isEssential) continue;
            result.add(this.cycles.get(i));
        }
        return result;
    }

    public Map relevantCycles() {
        HashMap<SimpleCycle, SimpleCycle> result = new HashMap<SimpleCycle, SimpleCycle>();
        boolean[][] a = this.getCycleEdgeIncidenceMatrix();
        boolean[][] ai = SimpleCycleBasis.inverseBinaryMatrix(a, this.cycles.size());
        for (int i = 0; i < this.cycles.size(); ++i) {
            boolean[] u = new boolean[this.edgeList.size()];
            for (int j = 0; j < this.cycles.size(); ++j) {
                u[j] = ai[j][i];
            }
            AuxiliaryGraph gu = new AuxiliaryGraph((Graph)this.graph, u);
            block2: for (Object vertex : this.graph.vertexSet()) {
                List incidentEdges = this.graph.edgesOf(vertex);
                boolean shouldSearchCycle = false;
                for (Edge edge : incidentEdges) {
                    int index = this.getEdgeIndex(edge);
                    if (!u[index]) continue;
                    shouldSearchCycle = true;
                    break;
                }
                if (!shouldSearchCycle) continue;
                Object auxVertex0 = gu.auxVertex0(vertex);
                Object auxVertex1 = gu.auxVertex1(vertex);
                MinimalPathIterator minPaths = new MinimalPathIterator(gu, auxVertex0, auxVertex1);
                while (minPaths.hasNext()) {
                    List auxPath = (List)minPaths.next();
                    ArrayList<Edge> edgesOfNewCycle = new ArrayList<Edge>(auxPath.size());
                    for (Edge auxEdge : auxPath) {
                        Edge e = (Edge)gu.edge(auxEdge);
                        if (edgesOfNewCycle.contains(e)) {
                            edgesOfNewCycle.remove(e);
                            continue;
                        }
                        edgesOfNewCycle.add(e);
                    }
                    SimpleCycle cycle = new SimpleCycle(this.graph, edgesOfNewCycle);
                    if (cycle.weight() > this.cycles.get(i).weight()) continue block2;
                    result.put(cycle, this.cycles.get(i));
                }
            }
        }
        return result;
    }

    public List equivalenceClasses() {
        int[] weight = this.weightVector();
        SimpleCycle[] cyclesArray = this.cycles.toArray(new SimpleCycle[this.cycles.size()]);
        Arrays.sort(cyclesArray, new Comparator<SimpleCycle>(){

            @Override
            public int compare(SimpleCycle o1, SimpleCycle o2) {
                if (o1.weight() > o2.weight()) {
                    return 1;
                }
                if (o1.weight() < o2.weight()) {
                    return -1;
                }
                return 0;
            }
        });
        Collection essentialCycles = this.essentialCycles();
        boolean[][] u = new boolean[cyclesArray.length][this.edgeList.size()];
        boolean[][] a = this.getCycleEdgeIncidenceMatrix((Object[])cyclesArray);
        boolean[][] ai = SimpleCycleBasis.inverseBinaryMatrix(a, cyclesArray.length);
        for (int i = 0; i < cyclesArray.length; ++i) {
            for (int j = 0; j < cyclesArray.length; ++j) {
                u[i][j] = ai[j][i];
            }
        }
        SimpleGraph h = new SimpleGraph();
        h.addAllVertices(this.cycles);
        ConnectivityInspector connectivityInspector = new ConnectivityInspector((UndirectedGraph)h);
        int left = 0;
        for (int right = 0; right < weight.length; ++right) {
            boolean sameClass;
            int j;
            int i;
            if (right < weight.length - 1 && weight[right + 1] == weight[right]) continue;
            for (i = left; i <= right; ++i) {
                if (essentialCycles.contains((Object)cyclesArray[i])) continue;
                for (j = i + 1; j <= right; ++j) {
                    if (essentialCycles.contains((Object)cyclesArray[j]) || connectivityInspector.pathExists((Object)cyclesArray[i], (Object)cyclesArray[j])) continue;
                    sameClass = false;
                    AuxiliaryGraph2 auxGraph = new AuxiliaryGraph2((Graph)this.graph, u[i], u[j]);
                    for (Object vertex : this.graph.vertexSet()) {
                        Object auxVertex11;
                        Object auxVertex00;
                        List<Edge> auxPath;
                        double pathWeight;
                        boolean shouldSearchCycle = false;
                        List incidentEdges = this.graph.edgesOf(vertex);
                        for (Edge edge : incidentEdges) {
                            int index = this.getEdgeIndex(edge);
                            if (!u[i][index] && !u[j][index]) continue;
                            shouldSearchCycle = true;
                            break;
                        }
                        if (!shouldSearchCycle || (pathWeight = (double)(auxPath = BFSShortestPath.findPathBetween((Graph)auxGraph, auxVertex00 = auxGraph.auxVertex00(vertex), auxVertex11 = auxGraph.auxVertex11(vertex))).size()) != (double)weight[left]) continue;
                        sameClass = true;
                        break;
                    }
                    if (!sameClass) continue;
                    h.addEdge((Object)cyclesArray[i], (Object)cyclesArray[j]);
                }
            }
            for (i = left; i <= right; ++i) {
                if (essentialCycles.contains((Object)cyclesArray[i])) continue;
                for (j = i + 1; j <= right; ++j) {
                    if (essentialCycles.contains((Object)cyclesArray[j]) || connectivityInspector.pathExists((Object)cyclesArray[i], (Object)cyclesArray[j])) continue;
                    sameClass = false;
                    int k = 0;
                    while (cyclesArray[k].weight() < (double)weight[left]) {
                        double pathWeight;
                        List<Edge> auxPath;
                        Object auxVertex11;
                        Object auxVertex00;
                        AuxiliaryGraph2 auxGraph = new AuxiliaryGraph2((Graph)this.graph, u[i], u[k]);
                        boolean shortestPathFound = false;
                        for (Object vertex : this.graph.vertexSet()) {
                            auxVertex00 = auxGraph.auxVertex00(vertex);
                            auxPath = BFSShortestPath.findPathBetween((Graph)auxGraph, auxVertex00, auxVertex11 = auxGraph.auxVertex11(vertex));
                            pathWeight = auxPath.size();
                            if (pathWeight != (double)weight[left]) continue;
                            shortestPathFound = true;
                            break;
                        }
                        if (shortestPathFound) {
                            auxGraph = new AuxiliaryGraph2((Graph)this.graph, u[j], u[k]);
                            for (Object vertex : this.graph.vertexSet()) {
                                auxVertex00 = auxGraph.auxVertex00(vertex);
                                auxPath = BFSShortestPath.findPathBetween((Graph)auxGraph, auxVertex00, auxVertex11 = auxGraph.auxVertex11(vertex));
                                pathWeight = auxPath.size();
                                if (pathWeight != (double)weight[left]) continue;
                                sameClass = true;
                                break;
                            }
                            if (sameClass) break;
                        }
                        ++k;
                    }
                    if (!sameClass) continue;
                    h.addEdge((Object)cyclesArray[i], (Object)cyclesArray[j]);
                }
            }
            left = right + 1;
        }
        return connectivityInspector.connectedSets();
    }

    private HashMap createEdgeIndexMap(List edgeList) {
        HashMap map = new HashMap();
        for (int i = 0; i < edgeList.size(); ++i) {
            map.put(edgeList.get(i), i);
        }
        return map;
    }

    private int getEdgeIndex(Edge edge) {
        return (Integer)this.edgeIndexMap.get(edge);
    }

    public void printIncidenceMatrix() {
        boolean[][] incidMatr = this.getCycleEdgeIncidenceMatrix();
        for (int i = 0; i < incidMatr.length; ++i) {
            for (int j = 0; j < incidMatr[i].length; ++j) {
                System.out.print(incidMatr[i][j] ? 1 : 0);
            }
            System.out.println();
        }
    }

    private class AuxiliaryGraph2
    extends SimpleGraph {
        private static final long serialVersionUID = 5930876716644738726L;
        private HashMap vertexMap00 = new HashMap();
        private HashMap vertexMap01 = new HashMap();
        private HashMap vertexMap10 = new HashMap();
        private HashMap vertexMap11 = new HashMap();
        private HashMap auxVertexMap = new HashMap();
        private Map auxEdgeMap = new HashMap();
        private Graph g;
        private boolean[] ui;
        private boolean[] uj;

        AuxiliaryGraph2(Graph graph, boolean[] ui, boolean[] uj) {
            this.g = graph;
            this.ui = ui;
            this.uj = uj;
        }

        Object auxVertex00(Object vertex) {
            if (this.vertexMap00.get(vertex) == null) {
                String newVertex = vertex + "-00";
                this.vertexMap00.put(vertex, newVertex);
                this.addVertex(newVertex);
                this.auxVertexMap.put(newVertex, vertex);
                return newVertex;
            }
            return this.vertexMap00.get(vertex);
        }

        Object auxVertex01(Object vertex) {
            if (this.vertexMap01.get(vertex) == null) {
                String newVertex = vertex + "-01";
                this.vertexMap01.put(vertex, newVertex);
                this.addVertex(newVertex);
                this.auxVertexMap.put(newVertex, vertex);
                return newVertex;
            }
            return this.vertexMap01.get(vertex);
        }

        Object auxVertex10(Object vertex) {
            if (this.vertexMap10.get(vertex) == null) {
                String newVertex = vertex + "-10";
                this.vertexMap10.put(vertex, newVertex);
                this.addVertex(newVertex);
                this.auxVertexMap.put(newVertex, vertex);
                return newVertex;
            }
            return this.vertexMap10.get(vertex);
        }

        Object auxVertex11(Object vertex) {
            if (this.vertexMap11.get(vertex) == null) {
                String newVertex = vertex + "-11";
                this.vertexMap11.put(vertex, newVertex);
                this.addVertex(newVertex);
                this.auxVertexMap.put(newVertex, vertex);
                return newVertex;
            }
            return this.vertexMap11.get(vertex);
        }

        public List edgesOf(Object auxVertex) {
            Object vertex = this.auxVertexMap.get(auxVertex);
            for (Edge edge : this.g.edgesOf(vertex)) {
                Edge auxEdge;
                Object vertex2u;
                Object vertex1u;
                int k = SimpleCycleBasis.this.getEdgeIndex(edge);
                Object vertex1 = edge.getSource();
                Object vertex2 = edge.getTarget();
                if (!this.ui[k] && !this.uj[k]) {
                    vertex1u = this.auxVertex00(vertex1);
                    vertex2u = this.auxVertex00(vertex2);
                    auxEdge = this.addEdge(vertex1u, vertex2u);
                    this.auxEdgeMap.put(auxEdge, edge);
                    vertex1u = this.auxVertex01(vertex1);
                    vertex2u = this.auxVertex01(vertex2);
                    auxEdge = this.addEdge(vertex1u, vertex2u);
                    this.auxEdgeMap.put(auxEdge, edge);
                    vertex1u = this.auxVertex10(vertex1);
                    vertex2u = this.auxVertex10(vertex2);
                    auxEdge = this.addEdge(vertex1u, vertex2u);
                    this.auxEdgeMap.put(auxEdge, edge);
                    vertex1u = this.auxVertex11(vertex1);
                    vertex2u = this.auxVertex11(vertex2);
                    auxEdge = this.addEdge(vertex1u, vertex2u);
                    this.auxEdgeMap.put(auxEdge, edge);
                    continue;
                }
                if (this.ui[k] && !this.uj[k]) {
                    vertex1u = this.auxVertex00(vertex1);
                    vertex2u = this.auxVertex10(vertex2);
                    auxEdge = this.addEdge(vertex1u, vertex2u);
                    this.auxEdgeMap.put(auxEdge, edge);
                    vertex1u = this.auxVertex01(vertex1);
                    vertex2u = this.auxVertex11(vertex2);
                    auxEdge = this.addEdge(vertex1u, vertex2u);
                    this.auxEdgeMap.put(auxEdge, edge);
                    vertex1u = this.auxVertex10(vertex1);
                    vertex2u = this.auxVertex00(vertex2);
                    auxEdge = this.addEdge(vertex1u, vertex2u);
                    this.auxEdgeMap.put(auxEdge, edge);
                    vertex1u = this.auxVertex11(vertex1);
                    vertex2u = this.auxVertex01(vertex2);
                    auxEdge = this.addEdge(vertex1u, vertex2u);
                    this.auxEdgeMap.put(auxEdge, edge);
                    continue;
                }
                if (!this.ui[k] && this.uj[k]) {
                    vertex1u = this.auxVertex00(vertex1);
                    vertex2u = this.auxVertex01(vertex2);
                    auxEdge = this.addEdge(vertex1u, vertex2u);
                    this.auxEdgeMap.put(auxEdge, edge);
                    vertex1u = this.auxVertex01(vertex1);
                    vertex2u = this.auxVertex00(vertex2);
                    auxEdge = this.addEdge(vertex1u, vertex2u);
                    this.auxEdgeMap.put(auxEdge, edge);
                    vertex1u = this.auxVertex10(vertex1);
                    vertex2u = this.auxVertex11(vertex2);
                    auxEdge = this.addEdge(vertex1u, vertex2u);
                    this.auxEdgeMap.put(auxEdge, edge);
                    vertex1u = this.auxVertex11(vertex1);
                    vertex2u = this.auxVertex10(vertex2);
                    auxEdge = this.addEdge(vertex1u, vertex2u);
                    this.auxEdgeMap.put(auxEdge, edge);
                    continue;
                }
                if (!this.ui[k] || !this.uj[k]) continue;
                vertex1u = this.auxVertex00(vertex1);
                vertex2u = this.auxVertex11(vertex2);
                auxEdge = this.addEdge(vertex1u, vertex2u);
                this.auxEdgeMap.put(auxEdge, edge);
                vertex1u = this.auxVertex01(vertex1);
                vertex2u = this.auxVertex10(vertex2);
                auxEdge = this.addEdge(vertex1u, vertex2u);
                this.auxEdgeMap.put(auxEdge, edge);
                vertex1u = this.auxVertex10(vertex1);
                vertex2u = this.auxVertex01(vertex2);
                auxEdge = this.addEdge(vertex1u, vertex2u);
                this.auxEdgeMap.put(auxEdge, edge);
                vertex1u = this.auxVertex11(vertex1);
                vertex2u = this.auxVertex00(vertex2);
                auxEdge = this.addEdge(vertex1u, vertex2u);
                this.auxEdgeMap.put(auxEdge, edge);
            }
            return super.edgesOf(auxVertex);
        }
    }

    private class AuxiliaryGraph
    extends SimpleGraph {
        private static final long serialVersionUID = 857337988734567429L;
        HashMap vertexMap0 = new HashMap();
        HashMap vertexMap1 = new HashMap();
        HashMap auxVertexMap = new HashMap();
        Map auxEdgeMap = new HashMap();
        Graph g;
        boolean[] u;

        AuxiliaryGraph(Graph graph, boolean[] u) {
            this.g = graph;
            this.u = u;
        }

        public List edgesOf(Object auxVertex) {
            Object vertex = this.auxVertexMap.get(auxVertex);
            for (Edge edge : this.g.edgesOf(vertex)) {
                Edge auxEdge;
                Object vertex2u;
                Object vertex1u;
                int j = SimpleCycleBasis.this.getEdgeIndex(edge);
                Object vertex1 = edge.getSource();
                Object vertex2 = edge.getTarget();
                if (this.u[j]) {
                    vertex1u = this.auxVertex0(vertex1);
                    vertex2u = this.auxVertex1(vertex2);
                    auxEdge = this.addEdge(vertex1u, vertex2u);
                    this.auxEdgeMap.put(auxEdge, edge);
                    vertex1u = this.auxVertex1(vertex1);
                    vertex2u = this.auxVertex0(vertex2);
                    auxEdge = this.addEdge(vertex1u, vertex2u);
                    this.auxEdgeMap.put(auxEdge, edge);
                    continue;
                }
                vertex1u = this.auxVertex0(vertex1);
                vertex2u = this.auxVertex0(vertex2);
                auxEdge = this.addEdge(vertex1u, vertex2u);
                this.auxEdgeMap.put(auxEdge, edge);
                vertex1u = this.auxVertex1(vertex1);
                vertex2u = this.auxVertex1(vertex2);
                auxEdge = this.addEdge(vertex1u, vertex2u);
                this.auxEdgeMap.put(auxEdge, edge);
            }
            return super.edgesOf(auxVertex);
        }

        Object auxVertex0(Object vertex) {
            if (this.vertexMap0.get(vertex) == null) {
                String newVertex0 = vertex + "-0";
                this.vertexMap0.put(vertex, newVertex0);
                this.addVertex(newVertex0);
                this.auxVertexMap.put(newVertex0, vertex);
                return newVertex0;
            }
            return this.vertexMap0.get(vertex);
        }

        Object auxVertex1(Object vertex) {
            if (this.vertexMap1.get(vertex) == null) {
                String newVertex1 = vertex + "-1";
                this.vertexMap1.put(vertex, newVertex1);
                this.addVertex(newVertex1);
                this.auxVertexMap.put(newVertex1, vertex);
                return newVertex1;
            }
            return this.vertexMap1.get(vertex);
        }

        Object edge(Object auxEdge) {
            return this.auxEdgeMap.get(auxEdge);
        }
    }
}

