/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.atomic;

import org.openscience.cdk.charges.StabilizationCharges;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.qsar.AbstractAtomicDescriptor;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IAtomicDescriptor;
import org.openscience.cdk.qsar.result.DoubleResult;
import org.openscience.cdk.qsar.result.IDescriptorResult;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

public class StabilizationPlusChargeDescriptor
extends AbstractAtomicDescriptor
implements IAtomicDescriptor {
    private static final String[] NAMES = new String[]{"stabilPlusC"};
    private StabilizationCharges stabil = new StabilizationCharges();

    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#stabilizationPlusCharge", ((Object)((Object)this)).getClass().getName(), "The Chemistry Development Kit");
    }

    public void setParameters(Object[] params) throws CDKException {
    }

    public Object[] getParameters() {
        return null;
    }

    public String[] getDescriptorNames() {
        return NAMES;
    }

    public DescriptorValue calculate(IAtom atom, IAtomContainer container) {
        IAtom localAtom;
        IAtomContainer clone;
        try {
            clone = container.clone();
            localAtom = clone.getAtom(container.indexOf(atom));
            AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms((IAtomContainer)clone);
        }
        catch (CDKException e) {
            return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), (IDescriptorResult)new DoubleResult(Double.NaN), NAMES, (Exception)((Object)e));
        }
        catch (CloneNotSupportedException e) {
            return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), (IDescriptorResult)new DoubleResult(Double.NaN), NAMES, (Exception)e);
        }
        double result = this.stabil.calculatePositive(clone, localAtom);
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), (IDescriptorResult)new DoubleResult(result), NAMES);
    }

    public String[] getParameterNames() {
        return null;
    }

    public Object getParameterType(String name) {
        return null;
    }
}

