/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.bond;

import java.io.IOException;
import org.openscience.cdk.config.IsotopeFactory;
import org.openscience.cdk.config.Isotopes;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.qsar.AbstractBondDescriptor;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IBondDescriptor;
import org.openscience.cdk.qsar.result.DoubleResult;
import org.openscience.cdk.qsar.result.IDescriptorResult;
import org.openscience.cdk.tools.manipulator.BondManipulator;

public class AtomicNumberDifferenceDescriptor
extends AbstractBondDescriptor
implements IBondDescriptor {
    private static IsotopeFactory factory = null;
    private static final String[] NAMES = new String[]{"MNDiff"};

    private void ensureIsotopeFactory() {
        if (factory == null) {
            try {
                factory = Isotopes.getInstance();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#bondAtomicNumberImbalance", ((Object)((Object)this)).getClass().getName(), "The Chemistry Development Kit");
    }

    public void setParameters(Object[] params) throws CDKException {
    }

    public Object[] getParameters() {
        return null;
    }

    public String[] getDescriptorNames() {
        return NAMES;
    }

    public DescriptorValue calculate(IBond bond, IAtomContainer ac) {
        this.ensureIsotopeFactory();
        if (bond.getAtomCount() != 2) {
            return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), (IDescriptorResult)new DoubleResult(Double.NaN), NAMES, (Exception)new CDKException("Only 2-center bonds are considered"));
        }
        IAtom[] atoms = BondManipulator.getAtomArray((IBond)bond);
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), (IDescriptorResult)new DoubleResult((double)Math.abs(factory.getElement(atoms[0].getSymbol()).getAtomicNumber() - factory.getElement(atoms[1].getSymbol()).getAtomicNumber())), NAMES);
    }

    public String[] getParameterNames() {
        return new String[0];
    }

    public Object getParameterType(String name) {
        return null;
    }
}

