/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.molecular;

import java.util.ArrayList;
import java.util.List;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.graph.PathTools;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.qsar.AbstractMolecularDescriptor;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.qsar.result.DoubleArrayResult;
import org.openscience.cdk.qsar.result.DoubleArrayResultType;
import org.openscience.cdk.qsar.result.IDescriptorResult;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

public class WeightedPathDescriptor
extends AbstractMolecularDescriptor
implements IMolecularDescriptor {
    private static final String[] NAMES = new String[]{"WTPT-1", "WTPT-2", "WTPT-3", "WTPT-4", "WTPT-5"};

    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#weightedPath", ((Object)((Object)this)).getClass().getName(), "The Chemistry Development Kit");
    }

    public void setParameters(Object[] params) throws CDKException {
    }

    public Object[] getParameters() {
        return null;
    }

    public String[] getDescriptorNames() {
        return NAMES;
    }

    public String[] getParameterNames() {
        return null;
    }

    public Object getParameterType(String name) {
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public DescriptorValue calculate(IAtomContainer container) {
        void var9_18;
        int j;
        void var9_16;
        void var9_14;
        IAtomContainer local = AtomContainerManipulator.removeHydrogens((IAtomContainer)container);
        int natom = local.getAtomCount();
        DoubleArrayResult retval = new DoubleArrayResult();
        ArrayList pathList = new ArrayList();
        for (int i = 0; i < natom - 1; ++i) {
            IAtom a = local.getAtom(i);
            for (int j2 = i + 1; j2 < natom; ++j2) {
                IAtom iAtom = local.getAtom(j2);
                pathList.addAll(PathTools.getAllPaths((IAtomContainer)local, (IAtom)a, (IAtom)iAtom));
            }
        }
        double[] pathWts = this.getPathWeights(pathList, local);
        double mid = 0.0;
        for (double pathWt3 : pathWts) {
            mid += pathWt3;
        }
        retval.add(mid += (double)natom);
        retval.add(mid / (double)natom);
        pathList.clear();
        boolean bl = false;
        for (int i = 0; i < natom; ++i) {
            IAtom a = local.getAtom(i);
            if (a.getAtomicNumber() == 6) continue;
            ++var9_14;
            for (int j3 = 0; j3 < natom; ++j3) {
                IAtom b = local.getAtom(j3);
                if (a.equals(b)) continue;
                pathList.addAll(PathTools.getAllPaths((IAtomContainer)local, (IAtom)a, (IAtom)b));
            }
        }
        pathWts = this.getPathWeights(pathList, local);
        mid = 0.0;
        for (double pathWt2 : pathWts) {
            mid += pathWt2;
        }
        retval.add(mid += (double)var9_14);
        pathList.clear();
        boolean bl2 = false;
        for (int i2 = 0; i2 < natom; ++i2) {
            IAtom a2 = local.getAtom(i2);
            if (a2.getAtomicNumber() != 8) continue;
            ++var9_16;
            for (j = 0; j < natom; ++j) {
                IAtom b = local.getAtom(j);
                if (a2.equals(b)) continue;
                pathList.addAll(PathTools.getAllPaths((IAtomContainer)local, (IAtom)a2, (IAtom)b));
            }
        }
        pathWts = this.getPathWeights(pathList, local);
        mid = 0.0;
        double[] i2 = pathWts;
        int a2 = i2.length;
        for (j = 0; j < a2; ++j) {
            double pathWt1 = i2[j];
            mid += pathWt1;
        }
        retval.add(mid += (double)var9_16);
        pathList.clear();
        boolean bl3 = false;
        for (int i3 = 0; i3 < natom; ++i3) {
            IAtom a3 = local.getAtom(i3);
            if (a3.getAtomicNumber() != 7) continue;
            ++var9_18;
            for (j = 0; j < natom; ++j) {
                IAtom b = local.getAtom(j);
                if (a3.equals(b)) continue;
                pathList.addAll(PathTools.getAllPaths((IAtomContainer)local, (IAtom)a3, (IAtom)b));
            }
        }
        pathWts = this.getPathWeights(pathList, local);
        mid = 0.0;
        for (double pathWt : pathWts) {
            mid += pathWt;
        }
        retval.add(mid += (double)var9_18);
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), (IDescriptorResult)retval, this.getDescriptorNames());
    }

    public IDescriptorResult getDescriptorResultType() {
        return new DoubleArrayResultType(5);
    }

    private double[] getPathWeights(List<List<?>> pathList, IAtomContainer atomContainer) {
        double[] pathWts = new double[pathList.size()];
        for (int i = 0; i < pathList.size(); ++i) {
            List<?> p = pathList.get(i);
            pathWts[i] = 1.0;
            for (int j = 0; j < p.size() - 1; ++j) {
                IAtom a = (IAtom)p.get(j);
                IAtom b = (IAtom)p.get(j + 1);
                int n1 = atomContainer.getConnectedAtomsList(a).size();
                int n2 = atomContainer.getConnectedAtomsList(b).size();
                int n = i;
                pathWts[n] = pathWts[n] / Math.sqrt(n1 * n2);
            }
        }
        return pathWts;
    }
}

