/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.reaction.type;

import java.util.ArrayList;
import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.interfaces.IReactionSet;
import org.openscience.cdk.reaction.IReactionProcess;
import org.openscience.cdk.reaction.ReactionEngine;
import org.openscience.cdk.reaction.ReactionSpecification;
import org.openscience.cdk.reaction.type.parameters.IParameterReact;
import org.openscience.cdk.reaction.type.parameters.SetReactionCenter;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

public class HeterolyticCleavagePBReaction
extends ReactionEngine
implements IReactionProcess {
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(HeterolyticCleavagePBReaction.class);

    @Override
    public ReactionSpecification getSpecification() {
        return new ReactionSpecification("http://almost.cubic.uni-koeln.de/jrg/Members/mrc/reactionDict/reactionDict#HeterolyticCleavagePB", this.getClass().getName(), "$Id$", "The Chemistry Development Kit");
    }

    @Override
    public IReactionSet initiate(IAtomContainerSet reactants, IAtomContainerSet agents) throws CDKException {
        logger.debug((Object)"initiate reaction: HeterolyticCleavagePBReaction");
        if (reactants.getAtomContainerCount() != 1) {
            throw new CDKException("HeterolyticCleavagePBReaction only expects one reactant");
        }
        if (agents != null) {
            throw new CDKException("HeterolyticCleavagePBReaction don't expects agents");
        }
        IReactionSet setOfReactions = (IReactionSet)reactants.getBuilder().newInstance(IReactionSet.class, new Object[0]);
        IAtomContainer reactant = reactants.getAtomContainer(0);
        IParameterReact ipr = super.getParameterClass(SetReactionCenter.class);
        if (ipr != null && !ipr.isSetParameter()) {
            this.setActiveCenters(reactant);
        }
        for (IBond bondi : reactant.bonds()) {
            IAtom atom1 = bondi.getBegin();
            IAtom atom2 = bondi.getEnd();
            if (!bondi.getFlag(1024) || bondi.getOrder() == IBond.Order.SINGLE || !atom1.getFlag(1024) || !atom2.getFlag(1024) || (atom1.getFormalCharge() == CDKConstants.UNSET ? 0 : atom1.getFormalCharge()) != 0 || (atom2.getFormalCharge() == CDKConstants.UNSET ? 0 : atom2.getFormalCharge()) != 0 || reactant.getConnectedSingleElectronsCount(atom1) != 0 || reactant.getConnectedSingleElectronsCount(atom2) != 0) continue;
            for (int j = 0; j < 2; ++j) {
                ArrayList<IAtom> atomList = new ArrayList<IAtom>();
                if (j == 0) {
                    atomList.add(atom1);
                    atomList.add(atom2);
                } else {
                    atomList.add(atom2);
                    atomList.add(atom1);
                }
                ArrayList<IBond> bondList = new ArrayList<IBond>();
                bondList.add(bondi);
                IAtomContainerSet moleculeSet = (IAtomContainerSet)reactant.getBuilder().newInstance(IAtomContainerSet.class, new Object[0]);
                moleculeSet.addAtomContainer(reactant);
                IReaction reaction = this.mechanism.initiate(moleculeSet, atomList, bondList);
                if (reaction == null) continue;
                setOfReactions.addReaction(reaction);
            }
        }
        return setOfReactions;
    }

    private void setActiveCenters(IAtomContainer reactant) throws CDKException {
        for (IBond bond : reactant.bonds()) {
            IAtom atom1 = bond.getBegin();
            IAtom atom2 = bond.getEnd();
            if (bond.getOrder() == IBond.Order.SINGLE || (atom1.getFormalCharge() == CDKConstants.UNSET ? 0 : atom1.getFormalCharge()) != 0 || (atom2.getFormalCharge() == CDKConstants.UNSET ? 0 : atom2.getFormalCharge()) != 0 || reactant.getConnectedSingleElectronsCount(atom1) != 0 || reactant.getConnectedSingleElectronsCount(atom2) != 0) continue;
            atom1.setFlag(1024, true);
            atom2.setFlag(1024, true);
            bond.setFlag(1024, true);
        }
    }
}

