/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer.generators.standard;

import java.util.List;
import javax.vecmath.Point2d;
import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.graph.ConnectivityChecker;
import org.openscience.cdk.graph.GraphUtil;
import org.openscience.cdk.graph.invariant.Canon;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.sgroup.Sgroup;
import org.openscience.cdk.sgroup.SgroupType;

final class ZOrdering {
    ZOrdering() {
    }

    static void assign(IAtomContainer mol) {
        ZOrdering.raiseMultiattach(mol);
        for (IAtomContainer part : ConnectivityChecker.partitionIntoMolecules((IAtomContainer)mol)) {
            long[] z = ZOrdering.init(part);
            z = Canon.label((IAtomContainer)part, (int[][])GraphUtil.toAdjList((IAtomContainer)part), (long[])z);
            for (IBond bond : part.bonds()) {
                if (bond.getProperty(CDKConstants.Z_ORDER) != null) continue;
                bond.setProperty(CDKConstants.Z_ORDER, (Object)((int)Math.max(z[bond.getBegin().getIndex()], z[bond.getEnd().getIndex()])));
            }
        }
    }

    private static void raiseMultiattach(IAtomContainer mol) {
        List sgroups = (List)mol.getProperty((Object)"cdk:CtabSgroups");
        if (sgroups == null) {
            return;
        }
        for (Sgroup sgroup : sgroups) {
            if (sgroup.getType() != SgroupType.ExtMulticenter) continue;
            for (IBond bond : sgroup.getBonds()) {
                if (bond.getProperty(CDKConstants.Z_ORDER) != null) continue;
                bond.setProperty(CDKConstants.Z_ORDER, (Object)999999);
            }
        }
    }

    private static long[] init(IAtomContainer mol) {
        long[] z = new long[mol.getAtomCount()];
        if (ZOrdering.initUsingInternalWedges(mol, z)) {
            return z;
        }
        if (ZOrdering.initUsingExternalWedges(mol, z)) {
            return z;
        }
        IAtom low = null;
        for (IAtom atom : mol.atoms()) {
            Point2d p = atom.getPoint2d();
            assert (p != null);
            if (low != null && !(p.y < low.getPoint2d().y)) continue;
            low = atom;
        }
        if (low != null) {
            int n = low.getIndex();
            z[n] = z[n] + 10L;
        }
        return z;
    }

    private static boolean initUsingInternalWedges(IAtomContainer mol, long[] z) {
        boolean init = false;
        for (IBond bond : mol.bonds()) {
            IAtom bgn = bond.getBegin();
            IAtom end = bond.getEnd();
            if (bgn.getBondCount() == 1 || end.getBondCount() == 1) continue;
            switch (bond.getDisplay()) {
                case WedgedHashBegin: 
                case WedgeEnd: {
                    int n = bgn.getIndex();
                    z[n] = z[n] + 10L;
                    int n2 = end.getIndex();
                    z[n2] = z[n2] - 10L;
                    init = true;
                    break;
                }
                case WedgedHashEnd: 
                case WedgeBegin: {
                    int n = bgn.getIndex();
                    z[n] = z[n] - 10L;
                    int n3 = end.getIndex();
                    z[n3] = z[n3] + 10L;
                    init = true;
                    break;
                }
                case Bold: {
                    int n = bgn.getIndex();
                    z[n] = z[n] + 10L;
                    int n4 = end.getIndex();
                    z[n4] = z[n4] + 10L;
                    init = true;
                    break;
                }
                case Hash: {
                    int n = bgn.getIndex();
                    z[n] = z[n] - 10L;
                    int n5 = end.getIndex();
                    z[n5] = z[n5] - 10L;
                    init = true;
                }
            }
        }
        return init;
    }

    private static boolean initUsingExternalWedges(IAtomContainer mol, long[] z) {
        boolean init = false;
        for (IBond bond : mol.bonds()) {
            IAtom bgn = bond.getBegin();
            IAtom end = bond.getEnd();
            if (bgn.getBondCount() != 1 && end.getBondCount() != 1) continue;
            switch (bond.getDisplay()) {
                case WedgedHashBegin: 
                case WedgeEnd: {
                    int n = bgn.getIndex();
                    z[n] = z[n] - 10L;
                    int n2 = end.getIndex();
                    z[n2] = z[n2] + 10L;
                    break;
                }
                case WedgedHashEnd: 
                case WedgeBegin: {
                    int n = bgn.getIndex();
                    z[n] = z[n] + 10L;
                    int n3 = end.getIndex();
                    z[n3] = z[n3] - 10L;
                    init = true;
                }
            }
        }
        return init;
    }
}

