/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools.scaffold;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.openscience.cdk.tools.scaffold.ScaffoldNodeBase;

public class NetworkNode<MoleculeType>
extends ScaffoldNodeBase<MoleculeType> {
    private List<NetworkNode<MoleculeType>> parents = new ArrayList<NetworkNode<MoleculeType>>();

    public NetworkNode(MoleculeType aMolecule) {
        super(aMolecule);
    }

    @Override
    public boolean isOrphan() {
        return this.parents.isEmpty();
    }

    @Override
    public NetworkNode<MoleculeType> addChild(MoleculeType aMolecule) throws NullPointerException {
        Objects.requireNonNull(aMolecule, "Given molecule is 'null'");
        NetworkNode<MoleculeType> tmpChildNode = new NetworkNode<MoleculeType>(aMolecule);
        this.children.add(tmpChildNode);
        return tmpChildNode;
    }

    public void addParent(NetworkNode<MoleculeType> aParent) throws NullPointerException {
        Objects.requireNonNull(aParent, "Given NetworkNode is 'null'");
        boolean tmpIsAlreadyChild = false;
        for (ScaffoldNodeBase tmpBaseNode : aParent.getChildren()) {
            NetworkNode tmpNode = (NetworkNode)tmpBaseNode;
            if (!tmpNode.getMolecule().equals(this.getMolecule())) continue;
            tmpIsAlreadyChild = true;
            break;
        }
        if (!tmpIsAlreadyChild) {
            aParent.addChild(this.getMolecule());
        }
        this.parents.add(aParent);
    }

    @Override
    public int getLevel() {
        if (this.isOrphan()) {
            return 0;
        }
        return this.parents.get(0).getLevel() + 1;
    }

    public List<NetworkNode<MoleculeType>> getParents() {
        return this.parents;
    }

    public void setParents(List<NetworkNode<MoleculeType>> aParents) throws NullPointerException {
        Objects.requireNonNull(aParents, "Given NetworkNode is 'null'");
        this.parents = aParents;
    }
}

