/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools.scaffold;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.TreeMap;
import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.aromaticity.Aromaticity;
import org.openscience.cdk.aromaticity.ElectronDonation;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.fragment.MurckoFragmenter;
import org.openscience.cdk.graph.ConnectivityChecker;
import org.openscience.cdk.graph.CycleFinder;
import org.openscience.cdk.graph.Cycles;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IRingSet;
import org.openscience.cdk.interfaces.IStereoElement;
import org.openscience.cdk.smiles.SmilesGenerator;
import org.openscience.cdk.tools.CDKHydrogenAdder;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;
import org.openscience.cdk.tools.scaffold.NetworkNode;
import org.openscience.cdk.tools.scaffold.ScaffoldNetwork;
import org.openscience.cdk.tools.scaffold.ScaffoldTree;
import org.openscience.cdk.tools.scaffold.TreeNode;

public class ScaffoldGenerator {
    public static final String SCAFFOLD_ATOM_COUNTER_PROPERTY = "SCAFFOLD_ATOM_COUNTER_PROPERTY";
    public static final CycleFinder CYCLE_FINDER = Cycles.relevant();
    public static final String CYCLE_FINDER_BACKUP_PROPERTY = "CYCLE_FINDER_BACKUP_PROPERTY";
    public static final CycleFinder CYCLE_FINDER_BACKUP = Cycles.mcb();
    public static final boolean DETERMINE_AROMATICITY_SETTING_DEFAULT = true;
    public static final Aromaticity AROMATICITY_MODEL_SETTING_DEFAULT = new Aromaticity(ElectronDonation.cdk(), Cycles.cdkAromaticSet());
    public static final SmilesGenerator SMILES_GENERATOR_SETTING_DEFAULT = new SmilesGenerator(17);
    public static final boolean RULE_SEVEN_APPLIED_SETTING_DEFAULT = true;
    public static final boolean RETAIN_ONLY_HYBRIDISATIONS_AT_AROMATIC_BONDS_SETTING_DEFAULT = false;
    public static final ScaffoldModeOption SCAFFOLD_MODE_OPTION_DEFAULT = ScaffoldModeOption.SCAFFOLD;
    private boolean determineAromaticitySetting;
    private Aromaticity aromaticityModelSetting;
    private SmilesGenerator smilesGeneratorSetting;
    private boolean ruleSevenAppliedSetting;
    private ScaffoldModeOption scaffoldModeSetting;
    private boolean retainOnlyHybridisationsAtAromaticBondsSetting;
    private int tmpLogExceptionCounter = 0;
    private static final ILoggingTool LOGGER = LoggingToolFactory.createLoggingTool(ScaffoldGenerator.class);

    public ScaffoldGenerator() {
        this.restoreDefaultSettings();
    }

    public boolean isAromaticityDetermined() {
        return this.determineAromaticitySetting;
    }

    public Aromaticity getAromaticityModel() {
        return this.aromaticityModelSetting;
    }

    public SmilesGenerator getSmilesGenerator() {
        return this.smilesGeneratorSetting;
    }

    public boolean isRuleSevenApplied() {
        return this.ruleSevenAppliedSetting;
    }

    public ScaffoldModeOption getScaffoldModeSetting() {
        return this.scaffoldModeSetting;
    }

    public boolean areOnlyHybridisationsAtAromaticBondsRetained() {
        return this.retainOnlyHybridisationsAtAromaticBondsSetting;
    }

    public void setDetermineAromaticitySetting(boolean anIsAromaticitySet) {
        this.determineAromaticitySetting = anIsAromaticitySet;
    }

    public void setAromaticityModelSetting(Aromaticity anAromaticity) throws NullPointerException {
        Objects.requireNonNull(anAromaticity, "Given aromaticity model must not be null. The aromaticity detection can instead be deactivated via setDetermineAromaticitySetting(false).");
        this.aromaticityModelSetting = anAromaticity;
    }

    public void setSmilesGeneratorSetting(SmilesGenerator aSmilesGenerator) throws NullPointerException {
        Objects.requireNonNull(aSmilesGenerator, "Given SmilesGenerator must not be null");
        this.smilesGeneratorSetting = aSmilesGenerator;
    }

    public void setRuleSevenAppliedSetting(boolean anIsRuleSevenApplied) {
        this.ruleSevenAppliedSetting = anIsRuleSevenApplied;
    }

    public void setScaffoldModeSetting(ScaffoldModeOption anScaffoldMode) throws NullPointerException {
        Objects.requireNonNull(anScaffoldMode, "Given scaffold mode is null");
        this.scaffoldModeSetting = anScaffoldMode;
    }

    public void setRetainOnlyHybridisationsAtAromaticBondsSetting(boolean anIsOnlyHybridisationsAtAromaticBondsRetained) {
        this.retainOnlyHybridisationsAtAromaticBondsSetting = anIsOnlyHybridisationsAtAromaticBondsRetained;
    }

    public void restoreDefaultSettings() {
        this.setDetermineAromaticitySetting(true);
        this.setAromaticityModelSetting(AROMATICITY_MODEL_SETTING_DEFAULT);
        this.setSmilesGeneratorSetting(SMILES_GENERATOR_SETTING_DEFAULT);
        this.setRuleSevenAppliedSetting(true);
        this.setRetainOnlyHybridisationsAtAromaticBondsSetting(false);
        this.setScaffoldModeSetting(SCAFFOLD_MODE_OPTION_DEFAULT);
    }

    public IAtomContainer getScaffold(IAtomContainer aMolecule, boolean anAddImplicitHydrogens) throws CDKException, CloneNotSupportedException, NullPointerException {
        Objects.requireNonNull(aMolecule, "Input molecule must be non null");
        IAtomContainer tmpMolecule = this.getScaffoldInternal(aMolecule, anAddImplicitHydrogens, this.determineAromaticitySetting, this.aromaticityModelSetting, this.scaffoldModeSetting);
        return tmpMolecule;
    }

    public List<IAtomContainer> getRings(IAtomContainer aMolecule, boolean anAddImplicitHydrogens) throws CloneNotSupportedException, CDKException, NullPointerException {
        IAtomContainer tmpScaffold = this.getScaffold(aMolecule, anAddImplicitHydrogens);
        List<IAtomContainer> tmpMoleculeList = this.getRingsInternal(tmpScaffold, this.scaffoldModeSetting.equals((Object)ScaffoldModeOption.SCAFFOLD));
        if (anAddImplicitHydrogens) {
            for (IAtomContainer tmpRing : tmpMoleculeList) {
                AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms((IAtomContainer)tmpRing);
                CDKHydrogenAdder.getInstance((IChemObjectBuilder)tmpRing.getBuilder()).addImplicitHydrogens(tmpRing);
            }
        }
        return tmpMoleculeList;
    }

    public List<IAtomContainer> getSideChains(IAtomContainer aMolecule, boolean anAddImplicitHydrogens) throws CloneNotSupportedException, CDKException, NullPointerException {
        Objects.requireNonNull(aMolecule, "Input molecule must be non null");
        IAtomContainer tmpClonedMolecule = aMolecule.clone();
        ArrayList<IAtomContainer> tmpSideChainList = new ArrayList<IAtomContainer>(tmpClonedMolecule.getAtomCount());
        Integer tmpCounter = 0;
        HashMap<Integer, IAtom> tmpMoleculePropertyMap = new HashMap<Integer, IAtom>((int)((double)tmpClonedMolecule.getAtomCount() * 1.5), 0.75f);
        for (IAtom tmpAtom : tmpClonedMolecule.atoms()) {
            tmpAtom.setProperty((Object)SCAFFOLD_ATOM_COUNTER_PROPERTY, (Object)tmpCounter);
            tmpMoleculePropertyMap.put(tmpCounter, tmpAtom);
            Iterator iterator = tmpCounter;
            tmpCounter = tmpCounter + 1;
        }
        IAtomContainer tmpScaffold = this.scaffoldModeSetting.equals((Object)ScaffoldModeOption.ELEMENTAL_WIRE_FRAME) || this.scaffoldModeSetting.equals((Object)ScaffoldModeOption.BASIC_FRAMEWORK) || this.scaffoldModeSetting.equals((Object)ScaffoldModeOption.BASIC_WIRE_FRAME) ? this.getScaffoldInternal(tmpClonedMolecule, anAddImplicitHydrogens, this.determineAromaticitySetting, this.aromaticityModelSetting, ScaffoldModeOption.MURCKO_FRAMEWORK) : this.getScaffoldInternal(tmpClonedMolecule, anAddImplicitHydrogens, this.determineAromaticitySetting, this.aromaticityModelSetting, this.scaffoldModeSetting);
        ArrayList<Integer> tmpRemovedNumberList = new ArrayList<Integer>(tmpClonedMolecule.getAtomCount());
        for (IAtom tmpAtom : tmpScaffold.atoms()) {
            tmpRemovedNumberList.add((Integer)tmpAtom.getProperty((Object)SCAFFOLD_ATOM_COUNTER_PROPERTY));
        }
        for (Integer tmpNumber : tmpRemovedNumberList) {
            if (!tmpMoleculePropertyMap.containsKey(tmpNumber) || !tmpClonedMolecule.contains((IAtom)tmpMoleculePropertyMap.get(tmpNumber))) continue;
            tmpClonedMolecule.removeAtom((IAtom)tmpMoleculePropertyMap.get(tmpNumber));
        }
        IAtomContainerSet tmpFragments = ConnectivityChecker.partitionIntoMolecules((IAtomContainer)tmpClonedMolecule);
        for (IAtomContainer tmpFragment : tmpFragments.atomContainers()) {
            if (tmpFragment.getAtomCount() == 1 && tmpFragment.getAtom(0).getSymbol().equals("H")) continue;
            AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms((IAtomContainer)tmpFragment);
            if (anAddImplicitHydrogens) {
                CDKHydrogenAdder.getInstance((IChemObjectBuilder)tmpFragment.getBuilder()).addImplicitHydrogens(tmpFragment);
            }
            tmpSideChainList.add(tmpFragment);
        }
        return tmpSideChainList;
    }

    public List<IAtomContainer> getLinkers(IAtomContainer aMolecule, boolean anAddImplicitHydrogens) throws CloneNotSupportedException, CDKException, NullPointerException {
        Objects.requireNonNull(aMolecule, "Input molecule must be non null");
        IAtomContainer tmpClonedMolecule = aMolecule.clone();
        IAtomContainer tmpScaffold = this.getScaffoldInternal(tmpClonedMolecule, anAddImplicitHydrogens, this.determineAromaticitySetting, this.aromaticityModelSetting, this.scaffoldModeSetting);
        ArrayList<IAtomContainer> tmpLinkerList = new ArrayList<IAtomContainer>(tmpClonedMolecule.getAtomCount());
        List<IAtomContainer> tmpRingList = this.getRingsInternal(tmpScaffold, true);
        ArrayList<Integer> tmpRingAtomNumberList = new ArrayList<Integer>(tmpClonedMolecule.getAtomCount());
        HashMap<Integer, IAtom> tmpScaffoldPropertyMap = new HashMap<Integer, IAtom>((int)((double)tmpClonedMolecule.getAtomCount() * 1.5), 0.75f);
        for (IAtomContainer tmpRing : tmpRingList) {
            for (IAtom tmpAtom : tmpRing.atoms()) {
                tmpRingAtomNumberList.add((Integer)tmpAtom.getProperty((Object)SCAFFOLD_ATOM_COUNTER_PROPERTY));
            }
        }
        for (IAtom tmpScaffoldAtom : tmpScaffold.atoms()) {
            tmpScaffoldPropertyMap.put((Integer)tmpScaffoldAtom.getProperty((Object)SCAFFOLD_ATOM_COUNTER_PROPERTY), tmpScaffoldAtom);
        }
        for (Integer tmpAtomNumber : tmpRingAtomNumberList) {
            if (!tmpScaffoldPropertyMap.containsKey(tmpAtomNumber) || !tmpScaffold.contains((IAtom)tmpScaffoldPropertyMap.get(tmpAtomNumber))) continue;
            tmpScaffold.removeAtom((IAtom)tmpScaffoldPropertyMap.get(tmpAtomNumber));
        }
        IAtomContainerSet tmpFragments = ConnectivityChecker.partitionIntoMolecules((IAtomContainer)tmpScaffold);
        for (IAtomContainer tmpFragment : tmpFragments.atomContainers()) {
            if (tmpFragment.getAtomCount() == 1 && tmpFragment.getAtom(0).getSymbol().equals("H")) continue;
            AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms((IAtomContainer)tmpFragment);
            if (anAddImplicitHydrogens) {
                CDKHydrogenAdder.getInstance((IChemObjectBuilder)tmpFragment.getBuilder()).addImplicitHydrogens(tmpFragment);
            }
            tmpLinkerList.add(tmpFragment);
        }
        return tmpLinkerList;
    }

    public List<IAtomContainer> applyEnumerativeRemoval(IAtomContainer aMolecule) throws CDKException, CloneNotSupportedException, NullPointerException {
        Objects.requireNonNull(aMolecule, "Input molecule must be non null");
        IAtomContainer tmpScaffoldOriginal = this.getScaffoldInternal(aMolecule, true, this.determineAromaticitySetting, this.aromaticityModelSetting, this.scaffoldModeSetting);
        int tmpRingCount = this.getRingsInternal(tmpScaffoldOriginal, true).size();
        ArrayList<String> tmpAddedSMILESList = new ArrayList<String>(tmpRingCount * 45);
        ArrayList<IAtomContainer> tmpIterativeRemovalList = new ArrayList<IAtomContainer>(tmpRingCount * 45);
        tmpIterativeRemovalList.add(tmpScaffoldOriginal);
        for (int tmpCounter = 0; tmpCounter < tmpIterativeRemovalList.size(); ++tmpCounter) {
            IAtomContainer tmpIterMol = (IAtomContainer)tmpIterativeRemovalList.get(tmpCounter);
            List<IAtomContainer> tmpAllRingsList = this.getRingsInternal(tmpIterMol, true);
            int tmpRingSize = tmpAllRingsList.size();
            for (IAtomContainer tmpRing : tmpAllRingsList) {
                if (tmpRingSize < 2 || !this.isRingTerminal(tmpIterMol, tmpRing) || !this.isRingRemovable(tmpRing, tmpAllRingsList, tmpIterMol)) continue;
                boolean tmpIsInList = false;
                IAtomContainer tmpRingRemoved = this.getScaffoldInternal(this.removeRing(tmpIterMol, true, tmpRing), true, this.determineAromaticitySetting, this.aromaticityModelSetting, this.scaffoldModeSetting);
                String tmpRingRemovedSMILES = this.getSmilesGenerator().create(tmpRingRemoved);
                if (tmpAddedSMILESList.contains(tmpRingRemovedSMILES)) {
                    tmpIsInList = true;
                }
                if (tmpIsInList) continue;
                tmpIterativeRemovalList.add(tmpRingRemoved);
                tmpAddedSMILESList.add(tmpRingRemovedSMILES);
            }
        }
        return tmpIterativeRemovalList;
    }

    public ScaffoldNetwork generateScaffoldNetwork(IAtomContainer aMolecule) throws CDKException, CloneNotSupportedException, NullPointerException {
        Objects.requireNonNull(aMolecule, "Input molecule must be non null");
        ScaffoldNetwork tmpScaffoldNetwork = new ScaffoldNetwork(this.getSmilesGenerator());
        IAtomContainer tmpScaffoldOriginal = this.getScaffoldInternal(aMolecule, true, this.determineAromaticitySetting, this.aromaticityModelSetting, this.scaffoldModeSetting);
        int tmpRingCount = this.getRingsInternal(tmpScaffoldOriginal, true).size();
        ArrayList<IAtomContainer> tmpIterativeRemovalList = new ArrayList<IAtomContainer>(tmpRingCount * 45);
        tmpIterativeRemovalList.add(tmpScaffoldOriginal);
        NetworkNode<IAtomContainer> tmpFirstNode = new NetworkNode<IAtomContainer>(tmpScaffoldOriginal);
        tmpScaffoldNetwork.addNode(tmpFirstNode);
        String tmpFirstNodeSmiles = this.getSmilesGenerator().create(aMolecule);
        tmpFirstNode.addOriginSmiles(tmpFirstNodeSmiles);
        tmpFirstNode.addNonVirtualOriginSmiles(tmpFirstNodeSmiles);
        for (int tmpCounter = 0; tmpCounter < tmpIterativeRemovalList.size(); ++tmpCounter) {
            IAtomContainer tmpIterMol = (IAtomContainer)tmpIterativeRemovalList.get(tmpCounter);
            List<IAtomContainer> tmpAllRingsList = this.getRingsInternal(tmpIterMol, true);
            int tmpRingSize = tmpAllRingsList.size();
            for (IAtomContainer tmpRing : tmpAllRingsList) {
                if (tmpRingSize < 2 || !this.isRingTerminal(tmpIterMol, tmpRing) || !this.isRingRemovable(tmpRing, tmpAllRingsList, tmpIterMol)) continue;
                IAtomContainer tmpRingRemoved = this.getScaffoldInternal(this.removeRing(tmpIterMol, true, tmpRing), true, this.determineAromaticitySetting, this.aromaticityModelSetting, this.scaffoldModeSetting);
                if (!tmpScaffoldNetwork.containsMolecule(tmpRingRemoved)) {
                    tmpIterativeRemovalList.add(tmpRingRemoved);
                    NetworkNode<IAtomContainer> tmpNewNode = new NetworkNode<IAtomContainer>(tmpRingRemoved);
                    NetworkNode tmpNode1 = (NetworkNode)tmpScaffoldNetwork.getNode(tmpIterMol);
                    tmpNode1.addParent(tmpNewNode);
                    tmpNewNode.addOriginSmiles(tmpFirstNodeSmiles);
                    tmpScaffoldNetwork.addNode(tmpNewNode);
                    continue;
                }
                NetworkNode tmpOldNode = (NetworkNode)tmpScaffoldNetwork.getNode(tmpRingRemoved);
                NetworkNode tmpNewNode = (NetworkNode)tmpScaffoldNetwork.getNode(tmpIterMol);
                tmpNewNode.addParent(tmpOldNode);
            }
        }
        tmpScaffoldNetwork.updateLevelMap();
        return tmpScaffoldNetwork;
    }

    public ScaffoldNetwork generateScaffoldNetwork(List<IAtomContainer> aMoleculeList) throws CDKException, CloneNotSupportedException, NullPointerException {
        Objects.requireNonNull(aMoleculeList, "Input molecule list must be non null");
        ScaffoldNetwork tmpScaffoldNetwork = new ScaffoldNetwork(this.smilesGeneratorSetting);
        for (IAtomContainer tmpMolecule : aMoleculeList) {
            Objects.requireNonNull(tmpMolecule, "Input molecule must be non null");
            IAtomContainer tmpClonedMolecule = tmpMolecule.clone();
            try {
                tmpScaffoldNetwork.mergeNetwork(this.generateScaffoldNetwork(tmpClonedMolecule));
            }
            catch (Exception anException) {
                ++this.tmpLogExceptionCounter;
                try {
                    LOGGER.warn((Object)(anException.toString() + "\n generateScaffoldNetwork() Exception. SMILES of the skipped molecule number " + this.tmpLogExceptionCounter + ": " + this.smilesGeneratorSetting.create(tmpClonedMolecule)), new Object[]{anException});
                }
                catch (Exception anExceptionException) {
                    LOGGER.warn((Object)(anException.toString() + "\nException inside the generateScaffoldNetwork() Exception. Probably a problem with the SMILES generator."), new Object[]{anException});
                }
            }
        }
        return tmpScaffoldNetwork;
    }

    public List<IAtomContainer> applySchuffenhauerRules(IAtomContainer aMolecule) throws CloneNotSupportedException, CDKException, NullPointerException {
        List<IAtomContainer> tmpRings;
        Objects.requireNonNull(aMolecule, "Input molecule must be non null");
        IAtomContainer tmpClonedMolecule = aMolecule.clone();
        IAtomContainer tmpScaffold = this.getScaffoldInternal(tmpClonedMolecule, true, this.determineAromaticitySetting, this.aromaticityModelSetting, this.scaffoldModeSetting);
        int tmpRingNumber = this.getRingsInternal(tmpScaffold, false).size();
        float tmpRingAtomRatio = (float)tmpScaffold.getAtomCount() / (float)tmpRingNumber;
        if ((double)tmpRingAtomRatio < 1.0) {
            for (IAtom tmpAtom : tmpClonedMolecule.atoms()) {
                tmpAtom.setProperty((Object)CYCLE_FINDER_BACKUP_PROPERTY, (Object)true);
            }
            tmpRingNumber = this.getRingsInternal(tmpScaffold, false).size();
            tmpScaffold = this.getScaffoldInternal(tmpClonedMolecule, true, this.determineAromaticitySetting, this.aromaticityModelSetting, this.scaffoldModeSetting);
        }
        ArrayList<IAtomContainer> tmpScaffoldFragments = new ArrayList<IAtomContainer>(tmpRingNumber);
        tmpScaffoldFragments.add(tmpScaffold);
        for (int tmpCounter = 0; tmpCounter < tmpScaffoldFragments.size() && (tmpRings = this.getRingsInternal((IAtomContainer)tmpScaffoldFragments.get(tmpCounter), true)).size() != 1 && !tmpRings.isEmpty(); ++tmpCounter) {
            List<IAtomContainer> tmpRemovableRings = new ArrayList<IAtomContainer>(tmpRings.size());
            for (IAtomContainer tmpRing : tmpRings) {
                if (!this.isRingTerminal((IAtomContainer)tmpScaffoldFragments.get(tmpCounter), tmpRing) || !this.isRingRemovable(tmpRing, tmpRings, (IAtomContainer)tmpScaffoldFragments.get(tmpCounter))) continue;
                tmpRemovableRings.add(tmpRing);
            }
            if (tmpRemovableRings.isEmpty()) break;
            if ((tmpRemovableRings = this.applySchuffenhauerRuleOne(tmpRemovableRings)).size() == 1) {
                this.removeRingForSchuffenhauerRule(tmpRemovableRings.get(0), tmpScaffoldFragments);
                continue;
            }
            if ((tmpRemovableRings = this.applySchuffenhauerRuleTwo(tmpRemovableRings)).size() == 1) {
                this.removeRingForSchuffenhauerRule(tmpRemovableRings.get(0), tmpScaffoldFragments);
                continue;
            }
            tmpRemovableRings = this.applySchuffenhauerRuleThree((IAtomContainer)tmpScaffoldFragments.get(tmpScaffoldFragments.size() - 1), tmpRemovableRings);
            if (tmpRemovableRings.size() == 1) {
                this.removeRingForSchuffenhauerRule(tmpRemovableRings.get(0), tmpScaffoldFragments);
                continue;
            }
            tmpRemovableRings = this.applySchuffenhauerRuleFourAndFive((IAtomContainer)tmpScaffoldFragments.get(tmpScaffoldFragments.size() - 1), tmpRemovableRings);
            if (tmpRemovableRings.size() == 1) {
                this.removeRingForSchuffenhauerRule(tmpRemovableRings.get(0), tmpScaffoldFragments);
                continue;
            }
            if ((tmpRemovableRings = this.applySchuffenhauerRuleSix(tmpRemovableRings)).size() == 1) {
                this.removeRingForSchuffenhauerRule(tmpRemovableRings.get(0), tmpScaffoldFragments);
                continue;
            }
            if (this.ruleSevenAppliedSetting && this.determineAromaticitySetting && (tmpRemovableRings = this.applySchuffenhauerRuleSeven((IAtomContainer)tmpScaffoldFragments.get(tmpScaffoldFragments.size() - 1), tmpRemovableRings)).size() == 1) {
                this.removeRingForSchuffenhauerRule(tmpRemovableRings.get(0), tmpScaffoldFragments);
                continue;
            }
            if ((tmpRemovableRings = this.applySchuffenhauerRuleEight(tmpRemovableRings)).size() == 1) {
                this.removeRingForSchuffenhauerRule(tmpRemovableRings.get(0), tmpScaffoldFragments);
                continue;
            }
            if ((tmpRemovableRings = this.applySchuffenhauerRuleNine(tmpRemovableRings)).size() == 1) {
                this.removeRingForSchuffenhauerRule(tmpRemovableRings.get(0), tmpScaffoldFragments);
                continue;
            }
            if ((tmpRemovableRings = this.applySchuffenhauerRuleTen(tmpRemovableRings)).size() == 1) {
                this.removeRingForSchuffenhauerRule(tmpRemovableRings.get(0), tmpScaffoldFragments);
                continue;
            }
            if ((tmpRemovableRings = this.applySchuffenhauerRuleEleven(tmpRemovableRings)).size() == 1) {
                this.removeRingForSchuffenhauerRule(tmpRemovableRings.get(0), tmpScaffoldFragments);
                continue;
            }
            tmpRemovableRings = this.applySchuffenhauerRuleTwelve((IAtomContainer)tmpScaffoldFragments.get(tmpScaffoldFragments.size() - 1), tmpRemovableRings);
            if (tmpRemovableRings.size() == 1) {
                this.removeRingForSchuffenhauerRule(tmpRemovableRings.get(0), tmpScaffoldFragments);
                continue;
            }
            IAtomContainer tmpFragment = this.getScaffoldInternal(this.applySchuffenhauerRuleThirteen((IAtomContainer)tmpScaffoldFragments.get(tmpScaffoldFragments.size() - 1), tmpRemovableRings), true, this.determineAromaticitySetting, this.aromaticityModelSetting, this.scaffoldModeSetting);
            tmpScaffoldFragments.add(tmpFragment);
        }
        return tmpScaffoldFragments;
    }

    public ScaffoldTree generateSchuffenhauerTree(IAtomContainer aMolecule) throws CloneNotSupportedException, CDKException, NullPointerException {
        Objects.requireNonNull(aMolecule, "Input molecule must be non null");
        IAtomContainer tmpClonedMolecule = aMolecule.clone();
        List<IAtomContainer> tmpFragmentList = this.applySchuffenhauerRules(tmpClonedMolecule);
        TreeNode<IAtomContainer> tmpReverseParentNode = new TreeNode<IAtomContainer>(tmpFragmentList.get(tmpFragmentList.size() - 1));
        String tmpSmiles = this.getSmilesGenerator().create(tmpClonedMolecule);
        tmpReverseParentNode.addOriginSmiles(tmpSmiles);
        if (tmpFragmentList.size() == 1) {
            tmpReverseParentNode.addNonVirtualOriginSmiles(tmpSmiles);
        }
        ScaffoldTree tmpScaffoldTree = new ScaffoldTree(this.smilesGeneratorSetting);
        tmpScaffoldTree.addNode(tmpReverseParentNode);
        for (int i = 1; i < tmpFragmentList.size(); ++i) {
            TreeNode<IAtomContainer> tmpNewNode = new TreeNode<IAtomContainer>(tmpFragmentList.get(tmpFragmentList.size() - 1 - i));
            IAtomContainer tmpTestMol = (IAtomContainer)tmpNewNode.getMolecule();
            TreeNode tmpNode = (TreeNode)tmpScaffoldTree.getAllNodesOnLevel(i - 1).get(0);
            tmpNode.addChild(tmpTestMol);
            TreeNode tmpChildNode = (TreeNode)tmpScaffoldTree.getAllNodesOnLevel(i - 1).get(0).getChildren().get(0);
            tmpChildNode.addOriginSmiles(tmpSmiles);
            if (i == tmpFragmentList.size() - 1) {
                tmpChildNode.addNonVirtualOriginSmiles(tmpSmiles);
            }
            tmpScaffoldTree.addNode(tmpChildNode);
        }
        return tmpScaffoldTree;
    }

    public List<ScaffoldTree> generateSchuffenhauerForest(List<IAtomContainer> aMoleculeList) throws CDKException, CloneNotSupportedException, NullPointerException {
        Objects.requireNonNull(aMoleculeList, "Input molecule list must be non null");
        ArrayList<ScaffoldTree> tmpOutputForest = new ArrayList<ScaffoldTree>();
        ScaffoldTree tmpFirstTree = new ScaffoldTree(this.getSmilesGenerator());
        tmpOutputForest.add(tmpFirstTree);
        for (IAtomContainer tmpMolecule : aMoleculeList) {
            try {
                boolean isMoleculeMerged = false;
                ScaffoldTree tmpOldTree = this.generateSchuffenhauerTree(tmpMolecule);
                for (ScaffoldTree tmpNewTree : tmpOutputForest) {
                    if (!tmpNewTree.mergeTree(tmpOldTree)) continue;
                    isMoleculeMerged = true;
                    break;
                }
                if (isMoleculeMerged) continue;
                tmpOutputForest.add(tmpOldTree);
            }
            catch (Exception anException) {
                ++this.tmpLogExceptionCounter;
                try {
                    LOGGER.warn((Object)(anException.toString() + "\n generateSchuffenhauerForest() Exception. SMILES of the skipped molecule number " + this.tmpLogExceptionCounter + ": " + this.smilesGeneratorSetting.create(tmpMolecule)), new Object[]{anException});
                }
                catch (Exception anExceptionException) {
                    LOGGER.warn((Object)(anException.toString() + "\nException inside the generateSchuffenhauerForest() Exception. Probably a problem with the SMILES generator."), new Object[]{anException});
                }
            }
        }
        return tmpOutputForest;
    }

    protected IAtomContainer getScaffoldInternal(IAtomContainer aMolecule, boolean anAddImplicitHydrogens, boolean anIsAromaticitySet, Aromaticity anAromaticity, ScaffoldModeOption aScaffoldModeOption) throws CDKException, CloneNotSupportedException {
        IAtomContainer tmpClonedMolecule = aMolecule.clone();
        if (!ScaffoldModeOption.BASIC_WIRE_FRAME.equals((Object)aScaffoldModeOption) && !ScaffoldModeOption.ELEMENTAL_WIRE_FRAME.equals((Object)aScaffoldModeOption)) {
            Integer tmpCounter = 0;
            for (IAtom tmpAtom : tmpClonedMolecule.atoms()) {
                tmpAtom.setProperty((Object)SCAFFOLD_ATOM_COUNTER_PROPERTY, (Object)tmpCounter);
                Integer n = tmpCounter;
                tmpCounter = tmpCounter + 1;
            }
        }
        IAtomContainer tmpMurckoFragment = this.getMurckoFragment(tmpClonedMolecule);
        switch (aScaffoldModeOption.ordinal()) {
            case 1: {
                break;
            }
            case 2: {
                tmpMurckoFragment = AtomContainerManipulator.anonymise((IAtomContainer)tmpMurckoFragment);
                Integer tmpCounterBWF = 0;
                for (IAtom tmpAtom : tmpMurckoFragment.atoms()) {
                    tmpAtom.setProperty((Object)SCAFFOLD_ATOM_COUNTER_PROPERTY, (Object)tmpCounterBWF);
                    Integer n = tmpCounterBWF;
                    tmpCounterBWF = tmpCounterBWF + 1;
                }
                break;
            }
            case 0: {
                HashSet<Integer> tmpMurckoAtomNumbers = new HashSet<Integer>((int)((double)tmpClonedMolecule.getAtomCount() * 1.5), 0.75f);
                for (Object tmpMurckoAtom : tmpMurckoFragment.atoms()) {
                    tmpMurckoAtomNumbers.add((Integer)tmpMurckoAtom.getProperty((Object)SCAFFOLD_ATOM_COUNTER_PROPERTY));
                }
                HashSet<Object> tmpAddBondSet = new HashSet<Object>(tmpClonedMolecule.getAtomCount(), 0.75f);
                for (Object tmpBond : tmpClonedMolecule.bonds()) {
                    if (tmpBond.getOrder().equals((Object)IBond.Order.SINGLE) || tmpBond.getOrder().equals((Object)IBond.Order.UNSET)) continue;
                    Integer n = (Integer)tmpBond.getAtom(0).getProperty((Object)SCAFFOLD_ATOM_COUNTER_PROPERTY);
                    Integer tmpBondProperty1 = (Integer)tmpBond.getAtom(1).getProperty((Object)SCAFFOLD_ATOM_COUNTER_PROPERTY);
                    if (tmpMurckoAtomNumbers.contains(n) && tmpMurckoAtomNumbers.contains(tmpBondProperty1)) continue;
                    tmpAddBondSet.add(tmpBond);
                }
                HashMap<Integer, IAtom> tmpMurckoAtomMap = new HashMap<Integer, IAtom>((int)((double)tmpMurckoFragment.getAtomCount() * 1.5), 0.75f);
                for (IAtom iAtom : tmpMurckoFragment.atoms()) {
                    int tmpAtomProperty = (Integer)iAtom.getProperty((Object)SCAFFOLD_ATOM_COUNTER_PROPERTY);
                    tmpMurckoAtomMap.put(tmpAtomProperty, iAtom);
                }
                for (IBond iBond : tmpAddBondSet) {
                    IBond tmpNewBond;
                    IAtom tmpClonedAtom;
                    Integer tmpAtomProperty0 = (Integer)iBond.getAtom(0).getProperty((Object)SCAFFOLD_ATOM_COUNTER_PROPERTY);
                    Integer tmpAtomProperty1 = (Integer)iBond.getAtom(1).getProperty((Object)SCAFFOLD_ATOM_COUNTER_PROPERTY);
                    if (tmpMurckoAtomMap.containsKey(tmpAtomProperty0) && tmpMurckoAtomMap.containsKey(tmpAtomProperty1)) continue;
                    if (tmpMurckoAtomMap.containsKey(tmpAtomProperty1)) {
                        tmpClonedAtom = iBond.getAtom(0).clone();
                        tmpMurckoFragment.addAtom(tmpClonedAtom);
                        tmpNewBond = iBond.clone();
                        tmpNewBond.setAtom((IAtom)tmpMurckoAtomMap.get(tmpAtomProperty1), 1);
                        tmpNewBond.setAtom(tmpClonedAtom, 0);
                        tmpMurckoFragment.addBond(tmpNewBond);
                        continue;
                    }
                    if (!tmpMurckoAtomMap.containsKey(tmpAtomProperty0)) continue;
                    tmpClonedAtom = iBond.getAtom(1).clone();
                    tmpMurckoFragment.addAtom(tmpClonedAtom);
                    tmpNewBond = iBond.clone();
                    tmpNewBond.setAtom((IAtom)tmpMurckoAtomMap.get(tmpAtomProperty0), 0);
                    tmpNewBond.setAtom(tmpClonedAtom, 1);
                    tmpMurckoFragment.addBond(tmpNewBond);
                }
                break;
            }
            case 3: {
                tmpMurckoFragment = AtomContainerManipulator.skeleton((IAtomContainer)tmpMurckoFragment);
                Integer tmpCounterEWF = 0;
                for (IAtom tmpAtom : tmpMurckoFragment.atoms()) {
                    tmpAtom.setProperty((Object)SCAFFOLD_ATOM_COUNTER_PROPERTY, (Object)tmpCounterEWF);
                    Integer n = tmpCounterEWF;
                    tmpCounterEWF = tmpCounterEWF + 1;
                }
                break;
            }
            case 4: {
                for (IAtom tmpAtom : tmpMurckoFragment.atoms()) {
                    if (tmpAtom.getSymbol().equals("C")) continue;
                    tmpAtom.setSymbol("C");
                }
                break;
            }
        }
        AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms((IAtomContainer)tmpMurckoFragment);
        if (anAddImplicitHydrogens) {
            CDKHydrogenAdder.getInstance((IChemObjectBuilder)tmpMurckoFragment.getBuilder()).addImplicitHydrogens(tmpMurckoFragment);
        }
        if (anIsAromaticitySet) {
            Objects.requireNonNull(anAromaticity, "If anIsAromaticitySet == true, anAromaticity must be non null");
            anAromaticity.apply(tmpMurckoFragment);
        }
        return tmpMurckoFragment;
    }

    protected List<IAtomContainer> getRingsInternal(IAtomContainer aMolecule, boolean anIsKeepingNonSingleBonds) throws CloneNotSupportedException, CDKException {
        IAtomContainer tmpClonedMolecule = aMolecule.clone();
        Cycles tmpNewCycles = this.getCycleFinder(tmpClonedMolecule).find(tmpClonedMolecule);
        IRingSet tmpRingSet = tmpNewCycles.toRingSet();
        ArrayList<IAtomContainer> tmpCycles = new ArrayList<IAtomContainer>(tmpNewCycles.numberOfCycles());
        int tmpCycleNumber = tmpNewCycles.numberOfCycles();
        HashSet<IBond> tmpAddBondSet = new HashSet<IBond>(tmpClonedMolecule.getAtomCount(), 0.75f);
        if (anIsKeepingNonSingleBonds) {
            IAtomContainer tmpMurckoFragment = this.getMurckoFragment(tmpClonedMolecule);
            HashSet<Integer> tmpMurckoAtomNumbers = new HashSet<Integer>((int)((double)tmpClonedMolecule.getAtomCount() * 1.5), 0.75f);
            for (IAtom tmpMurckoAtom : tmpMurckoFragment.atoms()) {
                tmpMurckoAtomNumbers.add((Integer)tmpMurckoAtom.getProperty((Object)SCAFFOLD_ATOM_COUNTER_PROPERTY));
            }
            for (IBond tmpBond : tmpClonedMolecule.bonds()) {
                if (tmpBond.getOrder().equals((Object)IBond.Order.SINGLE)) continue;
                Integer tmpBondProperty0 = (Integer)tmpBond.getAtom(0).getProperty((Object)SCAFFOLD_ATOM_COUNTER_PROPERTY);
                Integer tmpBondProperty1 = (Integer)tmpBond.getAtom(1).getProperty((Object)SCAFFOLD_ATOM_COUNTER_PROPERTY);
                if (tmpMurckoAtomNumbers.contains(tmpBondProperty0) && tmpMurckoAtomNumbers.contains(tmpBondProperty1)) continue;
                tmpAddBondSet.add(tmpBond);
            }
        }
        for (int tmpCount = 0; tmpCount < tmpCycleNumber; ++tmpCount) {
            IAtomContainer tmpCycle = tmpRingSet.getAtomContainer(tmpCount);
            if (anIsKeepingNonSingleBonds) {
                HashMap<Integer, IAtom> tmpMurckoAtomMap = new HashMap<Integer, IAtom>((int)((double)tmpCycle.getAtomCount() * 1.5), 0.75f);
                for (IAtom tmpAtom : tmpCycle.atoms()) {
                    int tmpAtomPropertyNumber = (Integer)tmpAtom.getProperty((Object)SCAFFOLD_ATOM_COUNTER_PROPERTY);
                    tmpMurckoAtomMap.put(tmpAtomPropertyNumber, tmpAtom);
                }
                for (IBond tmpBond : tmpAddBondSet) {
                    IBond tmpNewBond;
                    IAtom tmpClonedAtom;
                    Integer tmpBondProperty0 = (Integer)tmpBond.getAtom(0).getProperty((Object)SCAFFOLD_ATOM_COUNTER_PROPERTY);
                    Integer tmpBondProperty1 = (Integer)tmpBond.getAtom(1).getProperty((Object)SCAFFOLD_ATOM_COUNTER_PROPERTY);
                    if (tmpMurckoAtomMap.containsKey(tmpBondProperty0) && tmpMurckoAtomMap.containsKey(tmpBondProperty1)) continue;
                    if (tmpMurckoAtomMap.containsKey(tmpBondProperty1)) {
                        tmpClonedAtom = tmpBond.getAtom(0).clone();
                        tmpCycle.addAtom(tmpClonedAtom);
                        tmpNewBond = tmpBond.clone();
                        tmpNewBond.setAtom((IAtom)tmpMurckoAtomMap.get(tmpBondProperty1), 1);
                        tmpNewBond.setAtom(tmpClonedAtom, 0);
                        tmpCycle.addBond(tmpNewBond);
                        continue;
                    }
                    if (!tmpMurckoAtomMap.containsKey(tmpBondProperty0)) continue;
                    tmpClonedAtom = tmpBond.getAtom(1).clone();
                    tmpCycle.addAtom(tmpClonedAtom);
                    tmpNewBond = tmpBond.clone();
                    tmpNewBond.setAtom((IAtom)tmpMurckoAtomMap.get(tmpBondProperty0), 0);
                    tmpNewBond.setAtom(tmpClonedAtom, 1);
                    tmpCycle.addBond(tmpNewBond);
                }
            }
            tmpCycles.add(tmpCycle);
        }
        return tmpCycles;
    }

    protected IAtomContainer getMurckoFragment(IAtomContainer aMolecule) {
        IAtomContainer tmpMurckoFragment = MurckoFragmenter.scaffold((IAtomContainer)aMolecule);
        for (IStereoElement tmpElement : aMolecule.stereoElements()) {
            ArrayList<IChemObject> tmpList = new ArrayList<IChemObject>(tmpElement.getCarriers().size() + 1);
            tmpList.addAll(tmpElement.getCarriers());
            tmpList.add(tmpElement.getFocus());
            boolean tmpAllElementsStillPresent = true;
            for (IChemObject tmpObj : tmpList) {
                if (tmpObj instanceof IAtom) {
                    if (tmpMurckoFragment.contains((IAtom)tmpObj)) continue;
                    tmpAllElementsStillPresent = false;
                    break;
                }
                if (tmpObj instanceof IBond) {
                    if (tmpMurckoFragment.contains((IBond)tmpObj)) continue;
                    tmpAllElementsStillPresent = false;
                    break;
                }
                tmpAllElementsStillPresent = false;
                break;
            }
            if (!tmpAllElementsStillPresent) continue;
            tmpMurckoFragment.addStereoElement(tmpElement);
        }
        return tmpMurckoFragment;
    }

    protected IAtomContainer removeRing(IAtomContainer aMolecule, boolean anAddImplicitHydrogens, IAtomContainer aRing) throws CloneNotSupportedException, CDKException {
        IAtomContainer tmpMoleculeClone = aMolecule.clone();
        IAtomContainer tmpRingClone = aRing.clone();
        boolean tmpIsRingAromatic = true;
        HashSet<Integer> tmpIsNotRing = new HashSet<Integer>((int)((double)aMolecule.getAtomCount() * 1.5), 0.75f);
        HashSet<Integer> tmpDoNotRemove = new HashSet<Integer>((int)((double)aMolecule.getAtomCount() * 1.5), 0.75f);
        int tmpBoundNumber = 0;
        HashSet<Integer> tmpEdgeAtomNumbers = new HashSet<Integer>((int)((double)tmpMoleculeClone.getAtomCount() * 1.5), 0.75f);
        for (IAtom tmpMolAtom : tmpMoleculeClone.atoms()) {
            tmpIsNotRing.add((Integer)tmpMolAtom.getProperty((Object)SCAFFOLD_ATOM_COUNTER_PROPERTY));
        }
        for (IAtom tmpRingAtom : tmpRingClone.atoms()) {
            Iterator tmpRemoveProperty = (Integer)tmpRingAtom.getProperty((Object)SCAFFOLD_ATOM_COUNTER_PROPERTY);
            tmpIsNotRing.remove(tmpRemoveProperty);
        }
        for (IAtom tmpRingAtom : tmpRingClone.atoms()) {
            for (IAtom tmpMolAtom : tmpMoleculeClone.atoms()) {
                if (!tmpMolAtom.getProperty((Object)SCAFFOLD_ATOM_COUNTER_PROPERTY).equals(tmpRingAtom.getProperty((Object)SCAFFOLD_ATOM_COUNTER_PROPERTY))) continue;
                for (Object tmpBond : tmpMolAtom.bonds()) {
                    Integer tmpBondProperty0 = (Integer)tmpBond.getAtom(0).getProperty((Object)SCAFFOLD_ATOM_COUNTER_PROPERTY);
                    Integer tmpBondProperty1 = (Integer)tmpBond.getAtom(1).getProperty((Object)SCAFFOLD_ATOM_COUNTER_PROPERTY);
                    if (!tmpIsNotRing.contains(tmpBondProperty0) && !tmpIsNotRing.contains(tmpBondProperty1)) continue;
                    ++tmpBoundNumber;
                }
            }
        }
        Cycles tmpCycles = this.getCycleFinder(tmpMoleculeClone).find(tmpMoleculeClone);
        HashSet<Integer> tmpRingPropertySet = new HashSet<Integer>((int)((double)tmpRingClone.getAtomCount() * 1.5), 0.75f);
        for (IAtom tmpRingAtom : tmpRingClone.atoms()) {
            tmpRingPropertySet.add((Integer)tmpRingAtom.getProperty((Object)SCAFFOLD_ATOM_COUNTER_PROPERTY));
        }
        for (IAtomContainer tmpCycle : tmpCycles.toRingSet().atomContainers()) {
            boolean tmpIsRingToRemove = true;
            for (Object tmpCycleAtom : tmpCycle.atoms()) {
                Integer tmpCycleAtomProperty = (Integer)tmpCycleAtom.getProperty((Object)SCAFFOLD_ATOM_COUNTER_PROPERTY);
                if (tmpRingPropertySet.contains(tmpCycleAtomProperty)) continue;
                tmpIsRingToRemove = false;
            }
            if (tmpIsRingToRemove) continue;
            for (Object tmpCycleAtom : tmpCycle.atoms()) {
                Integer tmpPropertyNumber = (Integer)tmpCycleAtom.getProperty((Object)SCAFFOLD_ATOM_COUNTER_PROPERTY);
                tmpDoNotRemove.add(tmpPropertyNumber);
            }
        }
        if (tmpBoundNumber < 2) {
            for (IAtom tmpRingAtom : tmpRingClone.atoms()) {
                for (IAtom tmpMolAtom : tmpMoleculeClone.atoms()) {
                    if (!tmpMolAtom.getProperty((Object)SCAFFOLD_ATOM_COUNTER_PROPERTY).equals(tmpRingAtom.getProperty((Object)SCAFFOLD_ATOM_COUNTER_PROPERTY))) continue;
                    tmpMoleculeClone.removeAtom(tmpMolAtom);
                    AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms((IAtomContainer)tmpMoleculeClone);
                    if (!anAddImplicitHydrogens) continue;
                    CDKHydrogenAdder.getInstance((IChemObjectBuilder)tmpMoleculeClone.getBuilder()).addImplicitHydrogens(tmpMoleculeClone);
                }
            }
        } else {
            if (tmpRingClone.getAtomCount() == 3) {
                int tmpNonCCounter = 0;
                Object tmpNonCAtom = null;
                for (IAtom tmpRingAtom : tmpRingClone.atoms()) {
                    if (tmpRingAtom.getSymbol().equals("C") || tmpDoNotRemove.contains((int)((Integer)tmpRingAtom.getProperty((Object)SCAFFOLD_ATOM_COUNTER_PROPERTY)))) continue;
                    ++tmpNonCCounter;
                    tmpNonCAtom = tmpRingAtom;
                }
                if (tmpNonCCounter == 1) {
                    tmpRingClone.removeAtom(tmpNonCAtom);
                    IAtom tmpBondAtom1 = null;
                    IAtom tmpRemoveAtom = null;
                    for (IAtom tmpMolAtom : tmpMoleculeClone.atoms()) {
                        Integer tmpMolAtomProperty = (Integer)tmpMolAtom.getProperty((Object)SCAFFOLD_ATOM_COUNTER_PROPERTY);
                        Integer tmpRingCloneProperty0 = (Integer)tmpRingClone.getAtom(0).getProperty((Object)SCAFFOLD_ATOM_COUNTER_PROPERTY);
                        Integer tmpRingCloneProperty1 = (Integer)tmpRingClone.getAtom(1).getProperty((Object)SCAFFOLD_ATOM_COUNTER_PROPERTY);
                        if (tmpMolAtomProperty.equals(tmpRingCloneProperty0) || tmpMolAtomProperty.equals(tmpRingCloneProperty1)) {
                            if (tmpBondAtom1 != null) {
                                tmpMoleculeClone.getBond(tmpBondAtom1, tmpMolAtom).setOrder(IBond.Order.DOUBLE);
                            } else {
                                tmpBondAtom1 = tmpMolAtom;
                            }
                        }
                        if (!tmpNonCAtom.getProperty((Object)SCAFFOLD_ATOM_COUNTER_PROPERTY).equals(tmpMolAtom.getProperty((Object)SCAFFOLD_ATOM_COUNTER_PROPERTY))) continue;
                        tmpRemoveAtom = tmpMolAtom;
                    }
                    tmpMoleculeClone.removeAtom(tmpRemoveAtom);
                }
            }
            IAtomContainer tmpExocyclicRemovedRing = this.getRingsInternal(aRing.clone(), false).get(0);
            tmpIsRingAromatic = this.isAtomContainerAromatic(tmpExocyclicRemovedRing);
            for (IAtom tmpRingAtom : tmpRingClone.atoms()) {
                for (IAtom tmpMolAtom : tmpMoleculeClone.atoms()) {
                    Integer tmpMolAtomProperty = (Integer)tmpMolAtom.getProperty((Object)SCAFFOLD_ATOM_COUNTER_PROPERTY);
                    if (!tmpMolAtomProperty.equals(tmpRingAtom.getProperty((Object)SCAFFOLD_ATOM_COUNTER_PROPERTY)) || tmpDoNotRemove.contains(tmpMolAtomProperty)) continue;
                    tmpMoleculeClone.removeAtom(tmpMolAtom);
                    AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms((IAtomContainer)tmpMoleculeClone);
                    if (!anAddImplicitHydrogens) continue;
                    CDKHydrogenAdder.getInstance((IChemObjectBuilder)tmpMoleculeClone.getBuilder()).addImplicitHydrogens(tmpMoleculeClone);
                }
            }
            if (tmpIsRingAromatic || !this.retainOnlyHybridisationsAtAromaticBondsSetting) {
                for (IAtom tmpMolAtom : tmpMoleculeClone.atoms()) {
                    Integer tmpMolAtomProperty = (Integer)tmpMolAtom.getProperty((Object)SCAFFOLD_ATOM_COUNTER_PROPERTY);
                    if (tmpMolAtom.getHybridization() != IAtomType.Hybridization.SP2 || !tmpRingPropertySet.contains(tmpMolAtomProperty)) continue;
                    boolean tmpIsSp3 = true;
                    for (IBond tmpBond : tmpMolAtom.bonds()) {
                        if (tmpBond.getOrder().equals((Object)IBond.Order.SINGLE)) continue;
                        tmpIsSp3 = false;
                    }
                    if (!tmpIsSp3) continue;
                    tmpEdgeAtomNumbers.add((Integer)tmpMolAtom.getProperty((Object)SCAFFOLD_ATOM_COUNTER_PROPERTY));
                }
            }
            for (IBond tmpBond : tmpMoleculeClone.bonds()) {
                Integer tmpBondProperty0 = (Integer)tmpBond.getAtom(0).getProperty((Object)SCAFFOLD_ATOM_COUNTER_PROPERTY);
                Integer tmpBondProperty1 = (Integer)tmpBond.getAtom(1).getProperty((Object)SCAFFOLD_ATOM_COUNTER_PROPERTY);
                if (!tmpEdgeAtomNumbers.contains(tmpBondProperty0) || !tmpEdgeAtomNumbers.contains(tmpBondProperty1)) continue;
                tmpBond.setOrder(IBond.Order.DOUBLE);
                tmpEdgeAtomNumbers.remove(tmpBondProperty0);
                tmpEdgeAtomNumbers.remove(tmpBondProperty1);
            }
            for (IAtom tmpAtom : tmpMoleculeClone.atoms()) {
                Integer tmpAtomProperty = (Integer)tmpAtom.getProperty((Object)SCAFFOLD_ATOM_COUNTER_PROPERTY);
                if (!tmpEdgeAtomNumbers.contains(tmpAtomProperty) || !tmpAtom.getSymbol().equals("C")) continue;
                tmpAtom.setImplicitHydrogenCount(Integer.valueOf(tmpAtom.getImplicitHydrogenCount() + 1));
            }
        }
        for (IAtom tmpAtom : tmpMoleculeClone.atoms()) {
            tmpAtom.setHybridization((IAtomType.Hybridization)CDKConstants.UNSET);
        }
        AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms((IAtomContainer)tmpMoleculeClone);
        if (anAddImplicitHydrogens) {
            CDKHydrogenAdder.getInstance((IChemObjectBuilder)tmpMoleculeClone.getBuilder()).addImplicitHydrogens(tmpMoleculeClone);
        }
        return tmpMoleculeClone;
    }

    protected boolean isRingTerminal(IAtomContainer aMolecule, IAtomContainer aRing) throws CloneNotSupportedException {
        IAtomContainer tmpClonedMolecule = aMolecule.clone();
        IAtomContainer tmpClonedRing = aRing.clone();
        HashMap<Integer, IAtom> tmpMoleculeCounterMap = new HashMap<Integer, IAtom>((int)((double)aMolecule.getAtomCount() * 1.5), 0.75f);
        for (IAtom tmpMolAtom : tmpClonedMolecule.atoms()) {
            tmpMoleculeCounterMap.put((Integer)tmpMolAtom.getProperty((Object)SCAFFOLD_ATOM_COUNTER_PROPERTY), tmpMolAtom);
        }
        for (IAtom tmpRingAtom : tmpClonedRing.atoms()) {
            Integer tmpRingAtomProperty = (Integer)tmpRingAtom.getProperty((Object)SCAFFOLD_ATOM_COUNTER_PROPERTY);
            if (!tmpMoleculeCounterMap.containsKey(tmpRingAtomProperty)) continue;
            tmpClonedMolecule.removeAtom((IAtom)tmpMoleculeCounterMap.get(tmpRingAtomProperty));
        }
        boolean tmpRingIsTerminal = ConnectivityChecker.isConnected((IAtomContainer)tmpClonedMolecule);
        return tmpRingIsTerminal;
    }

    protected boolean isRingRemovable(IAtomContainer aRing, List<IAtomContainer> aRings, IAtomContainer aMolecule) throws CloneNotSupportedException, CDKException {
        IAtomContainer tmpClonedMolecule = aMolecule.clone();
        IAtomContainer tmpClonedRing = aRing.clone();
        ArrayList<IAtomContainer> tmpClonedRings = new ArrayList<IAtomContainer>(aRings.size());
        HashSet<Integer> tmpRingsNumbers = new HashSet<Integer>((int)((double)(aRings.size() * tmpClonedRing.getAtomCount()) * 1.5), 0.75f);
        boolean isAnIndependentRing = false;
        for (IAtomContainer tmpRing : aRings) {
            if (tmpRing.equals((Object)aRing)) continue;
            tmpClonedRings.add(tmpRing.clone());
            for (IAtom tmpAtom : tmpRing.atoms()) {
                tmpRingsNumbers.add((Integer)tmpAtom.getProperty((Object)SCAFFOLD_ATOM_COUNTER_PROPERTY));
            }
        }
        for (IAtom tmpSingleRingAtom : aRing.atoms()) {
            Integer tmpRingAtomProperty = (Integer)tmpSingleRingAtom.getProperty((Object)SCAFFOLD_ATOM_COUNTER_PROPERTY);
            if (tmpRingsNumbers.contains(tmpRingAtomProperty)) continue;
            isAnIndependentRing = true;
        }
        if (!isAnIndependentRing) {
            return false;
        }
        IAtomContainer tmpRemovedRing = this.getRingsInternal(tmpClonedRing, false).get(0);
        if (this.determineAromaticitySetting || !this.areOnlyHybridisationsAtAromaticBondsRetained()) {
            this.aromaticityModelSetting.apply(tmpRemovedRing);
        }
        if (!this.isAtomContainerAromatic(tmpRemovedRing)) {
            return true;
        }
        HashSet<Integer> tmpMoleculeNumbers = new HashSet<Integer>((int)((double)tmpClonedMolecule.getAtomCount() * 1.5), 0.75f);
        for (IAtomContainer tmpRing : tmpClonedRings) {
            for (IAtom tmpRingAtom : tmpRing.atoms()) {
                int tmpAtomNumber = (Integer)tmpRingAtom.getProperty((Object)SCAFFOLD_ATOM_COUNTER_PROPERTY);
                tmpMoleculeNumbers.add(tmpAtomNumber);
            }
        }
        HashSet<Integer> tmpEdgeAtomNumbers = new HashSet<Integer>((int)((double)tmpClonedMolecule.getAtomCount() * 1.5), 0.75f);
        for (IAtom tmpRingAtom : tmpClonedRing.atoms()) {
            Integer tmpRingAtomProperty = (Integer)tmpRingAtom.getProperty((Object)SCAFFOLD_ATOM_COUNTER_PROPERTY);
            if (!tmpMoleculeNumbers.contains(tmpRingAtomProperty)) continue;
            tmpEdgeAtomNumbers.add((Integer)tmpRingAtom.getProperty((Object)SCAFFOLD_ATOM_COUNTER_PROPERTY));
        }
        if (tmpEdgeAtomNumbers.size() < 3) {
            return true;
        }
        for (Integer tmpEdgeAtomNumber : tmpEdgeAtomNumbers) {
            int tmpRingCounter = 0;
            for (IAtomContainer tmpRing : aRings) {
                for (IAtom tmpRingAtom : tmpRing.atoms()) {
                    if (!tmpRingAtom.getProperty((Object)SCAFFOLD_ATOM_COUNTER_PROPERTY).equals(tmpEdgeAtomNumber) || ++tmpRingCounter <= 1) continue;
                    return false;
                }
            }
        }
        return true;
    }

    protected void removeRingForSchuffenhauerRule(IAtomContainer aRing, List<IAtomContainer> aFragmentList) throws CDKException, CloneNotSupportedException {
        IAtomContainer tmpRingRemoved = this.removeRing(aFragmentList.get(aFragmentList.size() - 1), true, aRing);
        IAtomContainer tmpScaffoldRingRemoved = this.getScaffoldInternal(tmpRingRemoved, true, this.determineAromaticitySetting, this.aromaticityModelSetting, this.scaffoldModeSetting);
        aFragmentList.add(tmpScaffoldRingRemoved);
    }

    protected CycleFinder getCycleFinder(IAtomContainer aMolecule) {
        boolean tmpIsBackupFinderUsed = false;
        for (IAtom tmpAtom : aMolecule.atoms()) {
            if (tmpAtom.getProperty((Object)CYCLE_FINDER_BACKUP_PROPERTY) == null) {
                tmpAtom.setProperty((Object)CYCLE_FINDER_BACKUP_PROPERTY, (Object)false);
                continue;
            }
            if (!tmpAtom.getProperty((Object)CYCLE_FINDER_BACKUP_PROPERTY).equals(true)) continue;
            tmpIsBackupFinderUsed = true;
            break;
        }
        if (tmpIsBackupFinderUsed) {
            return CYCLE_FINDER_BACKUP;
        }
        return CYCLE_FINDER;
    }

    protected boolean hasFusedAromaticRings(IAtomContainer aRing, List<IAtomContainer> aRings, IAtomContainer aMolecule) throws CloneNotSupportedException {
        IAtomContainer tmpClonedMolecule = aMolecule.clone();
        IAtomContainer tmpClonedRing = aRing.clone();
        ArrayList<IAtomContainer> tmpClonedRings = new ArrayList<IAtomContainer>(aRings.size());
        ArrayList<Integer> tmpRingNumbers = new ArrayList<Integer>(aMolecule.getAtomCount());
        ArrayList<Integer> tmpRingsNumbers = new ArrayList<Integer>(aMolecule.getAtomCount());
        for (IAtom tmpAtom : tmpClonedRing.atoms()) {
            if (!tmpAtom.isAromatic()) {
                return false;
            }
            tmpRingNumbers.add((Integer)tmpAtom.getProperty((Object)SCAFFOLD_ATOM_COUNTER_PROPERTY));
        }
        for (IAtomContainer tmpRing : aRings) {
            if (tmpRing.equals((Object)aRing) || this.isAtomContainerAromatic(tmpRing)) continue;
            tmpClonedRings.add(tmpRing.clone());
            for (IAtom tmpAtom : tmpRing.atoms()) {
                tmpRingsNumbers.add((Integer)tmpAtom.getProperty((Object)SCAFFOLD_ATOM_COUNTER_PROPERTY));
            }
        }
        HashSet<Integer> tmpEdgeAtomNumbers = new HashSet<Integer>((int)((double)tmpClonedMolecule.getAtomCount() * 1.5), 0.75f);
        for (IAtom tmpRingAtom : tmpClonedRing.atoms()) {
            Integer tmpRingAtomProperty = (Integer)tmpRingAtom.getProperty((Object)SCAFFOLD_ATOM_COUNTER_PROPERTY);
            if (!tmpRingsNumbers.contains(tmpRingAtomProperty)) continue;
            tmpEdgeAtomNumbers.add((Integer)tmpRingAtom.getProperty((Object)SCAFFOLD_ATOM_COUNTER_PROPERTY));
        }
        if (tmpEdgeAtomNumbers.size() < 3) {
            return false;
        }
        for (Integer tmpEdgeAtomNumber : tmpEdgeAtomNumbers) {
            int tmpRingCounter = 0;
            for (IAtomContainer tmpRing : tmpClonedRings) {
                for (IAtom tmpRingAtom : tmpRing.atoms()) {
                    if (!tmpRingAtom.getProperty((Object)SCAFFOLD_ATOM_COUNTER_PROPERTY).equals(tmpEdgeAtomNumber) || ++tmpRingCounter <= 1) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected boolean isAtomContainerAromatic(IAtomContainer aMolecule) throws CloneNotSupportedException {
        IAtomContainer tmpClonedMolecule = aMolecule.clone();
        for (IAtom tmpAtom : tmpClonedMolecule.atoms()) {
            if (tmpAtom.isAromatic()) continue;
            return false;
        }
        return true;
    }

    protected List<IAtomContainer> applySchuffenhauerRuleOne(List<IAtomContainer> aRings) {
        int tmpHeteroCyclesCounter = 0;
        ArrayList<IAtomContainer> tmpHeteroRingList = new ArrayList<IAtomContainer>(aRings.size());
        for (IAtomContainer tmpRing : aRings) {
            if (tmpRing.getAtomCount() != 3) continue;
            int tmpHeteroAtomCounter = 0;
            for (IAtom tmpAtom : tmpRing.atoms()) {
                if (tmpAtom.getSymbol().equals("C")) continue;
                ++tmpHeteroAtomCounter;
            }
            if (tmpHeteroAtomCounter != true) continue;
            ++tmpHeteroCyclesCounter;
            tmpHeteroRingList.add(tmpRing);
        }
        if (tmpHeteroCyclesCounter == 0) {
            return aRings;
        }
        return tmpHeteroRingList;
    }

    protected List<IAtomContainer> applySchuffenhauerRuleTwo(List<IAtomContainer> aRings) throws CDKException {
        ArrayList<IAtomContainer> tmpSmallRings = new ArrayList<IAtomContainer>(aRings.size());
        boolean tmpHasRemovableMacroCycle = false;
        for (IAtomContainer tmpRing : aRings) {
            Cycles tmpRemovedExocyclic = this.getCycleFinder(tmpRing).find(tmpRing);
            if (tmpRemovedExocyclic.toRingSet().getAtomContainer(0).getAtomCount() > 11) {
                tmpHasRemovableMacroCycle = true;
                continue;
            }
            tmpSmallRings.add(tmpRing);
        }
        if (!tmpHasRemovableMacroCycle || tmpSmallRings.isEmpty()) {
            return aRings;
        }
        return tmpSmallRings;
    }

    protected List<IAtomContainer> applySchuffenhauerRuleThree(IAtomContainer aMolecule, List<IAtomContainer> aRings) throws CDKException, CloneNotSupportedException {
        IAtomContainer tmpClonedMolecule = aMolecule.clone();
        ArrayList<IAtomContainer> tmpRemoveRings = new ArrayList<IAtomContainer>(aRings.size());
        ArrayList<Integer> tmpLinkerSize = new ArrayList<Integer>(aRings.size());
        int tmpMoleculeAtomCount = this.getMurckoFragment(tmpClonedMolecule).getAtomCount();
        for (IAtomContainer tmpRing : aRings) {
            IAtomContainer tmpRemovedRing = this.removeRing(tmpClonedMolecule, true, tmpRing);
            IAtomContainer tmpRemovedRingMurckoFragment = this.getMurckoFragment(tmpRemovedRing);
            tmpLinkerSize.add(tmpMoleculeAtomCount - (tmpRing.getAtomCount() + tmpRemovedRingMurckoFragment.getAtomCount()));
        }
        Integer tmpMaxList = tmpLinkerSize.stream().mapToInt(v -> v).max().orElseThrow(NoSuchElementException::new);
        if (tmpMaxList > -1) {
            for (int tmpCounter = 0; tmpCounter < tmpLinkerSize.size(); ++tmpCounter) {
                if (!((Integer)tmpLinkerSize.get(tmpCounter)).equals(tmpMaxList)) continue;
                tmpRemoveRings.add(aRings.get(tmpCounter));
            }
            return tmpRemoveRings;
        }
        return aRings;
    }

    protected List<IAtomContainer> applySchuffenhauerRuleFourAndFive(IAtomContainer aMolecule, List<IAtomContainer> aRings) throws CDKException, CloneNotSupportedException {
        IAtomContainer tmpClonedMolecule = aMolecule.clone();
        ArrayList<IAtomContainer> tmpRingsReturn = new ArrayList<IAtomContainer>(aRings.size());
        ArrayList<Integer> tmpDeltaList = new ArrayList<Integer>(aRings.size());
        ArrayList<Integer> tmpDeltaListAbs = new ArrayList<Integer>(aRings.size());
        for (IAtomContainer tmpRing : aRings) {
            Object tmpAtom3;
            IAtomContainer tmpRingRemoved = this.removeRing(tmpClonedMolecule, true, tmpRing);
            Cycles tmpCycles = null;
            Iterable tmpCycleIterable = null;
            try {
                tmpCycles = this.getCycleFinder(tmpRingRemoved).find(tmpRingRemoved);
                tmpCycleIterable = tmpCycles.toRingSet().atomContainers();
            }
            catch (NegativeArraySizeException e) {
                for (IAtomContainer tmpOriginalRing : aRings) {
                    for (IAtom tmpAtom2 : tmpOriginalRing.atoms()) {
                        tmpAtom2.setProperty((Object)CYCLE_FINDER_BACKUP_PROPERTY, (Object)true);
                    }
                }
                for (Object tmpAtom3 : aMolecule.atoms()) {
                    tmpAtom3.setProperty((Object)CYCLE_FINDER_BACKUP_PROPERTY, (Object)true);
                }
                for (Object tmpAtom3 : tmpRingRemoved.atoms()) {
                    tmpAtom3.setProperty((Object)CYCLE_FINDER_BACKUP_PROPERTY, (Object)true);
                }
                tmpCycles = this.getCycleFinder(tmpRingRemoved).find(tmpRingRemoved);
                tmpCycleIterable = tmpCycles.toRingSet().atomContainers();
            }
            HashSet<IBond> tmpCycleBonds = new HashSet<IBond>((int)((double)aRings.size() * 1.5), 0.75f);
            int tmpFusedRingBondCounter = 0;
            tmpAtom3 = tmpCycleIterable.iterator();
            while (tmpAtom3.hasNext()) {
                IAtomContainer tmpCycle = (IAtomContainer)tmpAtom3.next();
                for (IBond tmpBond : tmpCycle.bonds()) {
                    if (tmpCycleBonds.contains(tmpBond)) {
                        ++tmpFusedRingBondCounter;
                    }
                    tmpCycleBonds.add(tmpBond);
                }
            }
            int tmpDelta = tmpFusedRingBondCounter - (tmpCycles.numberOfCycles() - 1);
            tmpDeltaListAbs.add(Math.abs(tmpDelta));
            tmpDeltaList.add(tmpDelta);
        }
        Integer tmpDeltaAbsMax = tmpDeltaListAbs.stream().mapToInt(v -> v).max().getAsInt();
        Integer tmpDeltaMax = tmpDeltaList.stream().mapToInt(v -> v).max().getAsInt();
        if (tmpDeltaAbsMax > 0) {
            if (tmpDeltaAbsMax.equals(tmpDeltaMax)) {
                for (int tmpCounter = 0; tmpCounter < tmpDeltaList.size(); ++tmpCounter) {
                    if (!((Integer)tmpDeltaList.get(tmpCounter)).equals(tmpDeltaAbsMax)) continue;
                    tmpRingsReturn.add(aRings.get(tmpCounter));
                }
                return tmpRingsReturn;
            }
            for (int tmpCounter = 0; tmpCounter < tmpDeltaListAbs.size(); ++tmpCounter) {
                if (!((Integer)tmpDeltaListAbs.get(tmpCounter)).equals(tmpDeltaAbsMax)) continue;
                tmpRingsReturn.add(aRings.get(tmpCounter));
            }
            return tmpRingsReturn;
        }
        return aRings;
    }

    protected List<IAtomContainer> applySchuffenhauerRuleSix(List<IAtomContainer> aRings) throws CDKException {
        ArrayList<IAtomContainer> tmpReturnRingList = new ArrayList<IAtomContainer>(aRings.size());
        for (IAtomContainer tmpRing : aRings) {
            Cycles tmpRemovedExocyclic = this.getCycleFinder(tmpRing).find(tmpRing);
            IAtomContainer tmpRemovedExoRing = tmpRemovedExocyclic.toRingSet().getAtomContainer(0);
            if (tmpRemovedExoRing.getAtomCount() != 3 && tmpRemovedExoRing.getAtomCount() != 5 && tmpRemovedExoRing.getAtomCount() != 6) continue;
            tmpReturnRingList.add(tmpRing);
        }
        if (!tmpReturnRingList.isEmpty()) {
            return tmpReturnRingList;
        }
        return aRings;
    }

    protected List<IAtomContainer> applySchuffenhauerRuleSeven(IAtomContainer aMolecule, List<IAtomContainer> aRings) throws CDKException, CloneNotSupportedException {
        ArrayList<IAtomContainer> tmpReturnRings = new ArrayList<IAtomContainer>(aRings.size());
        IAtomContainer tmpClonedMolecule = aMolecule.clone();
        int tmpOriginalAromaticRingCounter = 0;
        Cycles tmpOriginalCycles = this.getCycleFinder(tmpClonedMolecule).find(tmpClonedMolecule);
        for (IAtomContainer tmpCycle : tmpOriginalCycles.toRingSet().atomContainers()) {
            if (!this.isAtomContainerAromatic(tmpCycle)) continue;
            ++tmpOriginalAromaticRingCounter;
        }
        for (IAtomContainer tmpRing : aRings) {
            IAtomContainer tmpRemovedRing = this.removeRing(aMolecule, true, tmpRing);
            tmpRemovedRing = this.getScaffoldInternal(tmpRemovedRing, true, false, null, this.scaffoldModeSetting);
            this.aromaticityModelSetting.apply(tmpRemovedRing);
            int tmpRemovedAromaticRingCounter = 0;
            Cycles tmpRemovedCycles = null;
            Iterable tmpCycleIterable = null;
            try {
                tmpRemovedCycles = this.getCycleFinder(tmpRemovedRing).find(tmpRemovedRing);
                tmpCycleIterable = tmpRemovedCycles.toRingSet().atomContainers();
            }
            catch (Exception e) {
                for (IAtomContainer tmpOriginalRing : aRings) {
                    for (IAtom tmpAtom : tmpOriginalRing.atoms()) {
                        tmpAtom.setProperty((Object)CYCLE_FINDER_BACKUP_PROPERTY, (Object)true);
                    }
                }
                for (IAtom tmpAtom : aMolecule.atoms()) {
                    tmpAtom.setProperty((Object)CYCLE_FINDER_BACKUP_PROPERTY, (Object)true);
                }
                for (IAtom tmpAtom : tmpRemovedRing.atoms()) {
                    tmpAtom.setProperty((Object)CYCLE_FINDER_BACKUP_PROPERTY, (Object)true);
                }
                tmpRemovedCycles = this.getCycleFinder(tmpRemovedRing).find(tmpRemovedRing);
                tmpCycleIterable = tmpRemovedCycles.toRingSet().atomContainers();
            }
            for (IAtomContainer tmpCycle : tmpCycleIterable) {
                if (!this.isAtomContainerAromatic(tmpCycle)) continue;
                ++tmpRemovedAromaticRingCounter;
            }
            if (tmpOriginalAromaticRingCounter - tmpRemovedAromaticRingCounter >= 2) continue;
            tmpReturnRings.add(tmpRing);
        }
        if (tmpReturnRings.size() < aRings.size() && !tmpReturnRings.isEmpty()) {
            return tmpReturnRings;
        }
        return aRings;
    }

    protected List<IAtomContainer> applySchuffenhauerRuleEight(List<IAtomContainer> aRings) throws CDKException {
        ArrayList<IAtomContainer> tmpReturnRingList = new ArrayList<IAtomContainer>(aRings.size());
        Integer tmpMinNumberOfHeteroAtoms = null;
        for (IAtomContainer tmpRing : aRings) {
            Cycles tmpRemovedExocyclic = this.getCycleFinder(tmpRing).find(tmpRing);
            int tmpNumberOfHeteroAtoms = 0;
            for (IAtom tmpAtom : tmpRemovedExocyclic.toRingSet().getAtomContainer(0).atoms()) {
                if (tmpAtom.getSymbol().equals("C")) continue;
                ++tmpNumberOfHeteroAtoms;
            }
            if (tmpMinNumberOfHeteroAtoms == null) {
                tmpMinNumberOfHeteroAtoms = tmpNumberOfHeteroAtoms;
            }
            if (tmpNumberOfHeteroAtoms == tmpMinNumberOfHeteroAtoms) {
                tmpReturnRingList.add(tmpRing);
                continue;
            }
            if (tmpNumberOfHeteroAtoms >= tmpMinNumberOfHeteroAtoms) continue;
            tmpMinNumberOfHeteroAtoms = tmpNumberOfHeteroAtoms;
            tmpReturnRingList.clear();
            tmpReturnRingList.add(tmpRing);
        }
        return tmpReturnRingList;
    }

    protected List<IAtomContainer> applySchuffenhauerRuleNine(List<IAtomContainer> aRings) throws CDKException {
        ArrayList<IAtomContainer> tmpReturnRingList = new ArrayList<IAtomContainer>(aRings.size());
        Integer tmpMinNCount = null;
        Integer tmpMinOCount = null;
        Integer tmpMinSCount = null;
        for (IAtomContainer tmpRing : aRings) {
            Cycles tmpRemovedExocyclic = this.getCycleFinder(tmpRing).find(tmpRing);
            int tmpNCounter = 0;
            int tmpOCounter = 0;
            int tmpSCounter = 0;
            for (IAtom tmpAtom : tmpRemovedExocyclic.toRingSet().getAtomContainer(0).atoms()) {
                if (tmpAtom.getSymbol().equals("N")) {
                    ++tmpNCounter;
                }
                if (tmpAtom.getSymbol().equals("O")) {
                    ++tmpOCounter;
                }
                if (!tmpAtom.getSymbol().equals("S")) continue;
                ++tmpSCounter;
            }
            if (tmpMinNCount == null) {
                tmpMinNCount = tmpNCounter;
                tmpMinOCount = tmpOCounter;
                tmpMinSCount = tmpSCounter;
            }
            if (tmpNCounter > tmpMinNCount) continue;
            if (tmpNCounter < tmpMinNCount) {
                tmpReturnRingList.clear();
                tmpReturnRingList.add(tmpRing);
                tmpMinNCount = tmpNCounter;
                tmpMinOCount = tmpOCounter;
                tmpMinSCount = tmpSCounter;
                continue;
            }
            if (tmpOCounter > tmpMinOCount) continue;
            if (tmpOCounter < tmpMinOCount) {
                tmpReturnRingList.clear();
                tmpReturnRingList.add(tmpRing);
                tmpMinNCount = tmpNCounter;
                tmpMinOCount = tmpOCounter;
                tmpMinSCount = tmpSCounter;
                continue;
            }
            if (tmpSCounter > tmpMinSCount) continue;
            if (tmpSCounter < tmpMinSCount) {
                tmpReturnRingList.clear();
                tmpReturnRingList.add(tmpRing);
                tmpMinNCount = tmpNCounter;
                tmpMinOCount = tmpOCounter;
                tmpMinSCount = tmpSCounter;
                continue;
            }
            tmpReturnRingList.add(tmpRing);
        }
        return tmpReturnRingList;
    }

    protected List<IAtomContainer> applySchuffenhauerRuleTen(List<IAtomContainer> aRings) throws CDKException {
        ArrayList<IAtomContainer> tmpReturnRingList = new ArrayList<IAtomContainer>(aRings.size());
        Integer tmpMinimumAtomNumber = null;
        for (IAtomContainer tmpRing : aRings) {
            Cycles tmpRemovedExocyclic = this.getCycleFinder(tmpRing).find(tmpRing);
            IAtomContainer tmpCycle = tmpRemovedExocyclic.toRingSet().getAtomContainer(0);
            int tmpAtomNumber = tmpCycle.getAtomCount();
            if (tmpMinimumAtomNumber == null) {
                tmpMinimumAtomNumber = tmpAtomNumber;
            }
            if (tmpAtomNumber == tmpMinimumAtomNumber) {
                tmpReturnRingList.add(tmpRing);
                continue;
            }
            if (tmpAtomNumber >= tmpMinimumAtomNumber) continue;
            tmpMinimumAtomNumber = tmpAtomNumber;
            tmpReturnRingList.clear();
            tmpReturnRingList.add(tmpRing);
        }
        return tmpReturnRingList;
    }

    protected List<IAtomContainer> applySchuffenhauerRuleEleven(List<IAtomContainer> aRings) throws CDKException, CloneNotSupportedException {
        ArrayList<IAtomContainer> tmpReturnRingList = new ArrayList<IAtomContainer>(aRings.size());
        for (IAtomContainer tmpRing : aRings) {
            Cycles tmpRemovedExocyclic = this.getCycleFinder(tmpRing).find(tmpRing);
            IAtomContainer tmpCycle = tmpRemovedExocyclic.toRingSet().getAtomContainer(0);
            if (!this.isAtomContainerAromatic(tmpCycle)) continue;
            tmpReturnRingList.add(tmpRing);
        }
        if (!tmpReturnRingList.isEmpty()) {
            return tmpReturnRingList;
        }
        return aRings;
    }

    protected List<IAtomContainer> applySchuffenhauerRuleTwelve(IAtomContainer aMolecule, List<IAtomContainer> aRings) throws CDKException, CloneNotSupportedException {
        IAtomContainer tmpClonedMolecule = aMolecule.clone();
        ArrayList<IAtomContainer> tmpRemoveRings = new ArrayList<IAtomContainer>(aRings.size());
        for (IAtomContainer tmpRing : aRings) {
            if (!this.isRingAttachedToHeteroatomLinker(tmpClonedMolecule, tmpRing)) continue;
            tmpRemoveRings.add(tmpRing);
        }
        if (!tmpRemoveRings.isEmpty()) {
            return tmpRemoveRings;
        }
        return aRings;
    }

    protected boolean isRingAttachedToHeteroatomLinker(IAtomContainer aMolecule, IAtomContainer aRing) throws CDKException, CloneNotSupportedException {
        Integer tmpBondProperty1;
        HashSet<Integer> tmpRingPropertyNumbers = new HashSet<Integer>((int)((double)aRing.getAtomCount() * 1.5), 0.75f);
        HashSet<Integer> tmpRemovedMurckoAtomNumbers = new HashSet<Integer>((int)((double)aMolecule.getAtomCount() * 1.5), 0.75f);
        for (IAtom tmpAtom : aRing.atoms()) {
            tmpRingPropertyNumbers.add((Integer)tmpAtom.getProperty((Object)SCAFFOLD_ATOM_COUNTER_PROPERTY));
        }
        IAtomContainer tmpRemovedRing = this.removeRing(aMolecule, true, aRing);
        IAtomContainer tmpRemovedRingMurckoFragment = this.getMurckoFragment(tmpRemovedRing);
        for (IAtom tmpAtom : tmpRemovedRingMurckoFragment.atoms()) {
            tmpRemovedMurckoAtomNumbers.add((Integer)tmpAtom.getProperty((Object)SCAFFOLD_ATOM_COUNTER_PROPERTY));
        }
        for (IAtom tmpAtom : aMolecule.atoms()) {
            Integer tmpAtomProperty = (Integer)tmpAtom.getProperty((Object)SCAFFOLD_ATOM_COUNTER_PROPERTY);
            if (!tmpRingPropertyNumbers.contains(tmpAtomProperty)) continue;
            for (IBond tmpBond : tmpAtom.bonds()) {
                Integer tmpBondProperty0 = (Integer)tmpBond.getAtom(0).getProperty((Object)SCAFFOLD_ATOM_COUNTER_PROPERTY);
                if (tmpRemovedMurckoAtomNumbers.contains(tmpBondProperty0)) {
                    if (!tmpBond.getAtom(0).getSymbol().equals("C")) {
                        return true;
                    }
                    if (!tmpAtom.getSymbol().equals("C")) {
                        return true;
                    }
                }
                if (!tmpRemovedMurckoAtomNumbers.contains(tmpBondProperty1 = (Integer)tmpBond.getAtom(1).getProperty((Object)SCAFFOLD_ATOM_COUNTER_PROPERTY))) continue;
                if (!tmpBond.getAtom(1).getSymbol().equals("C")) {
                    return true;
                }
                if (tmpAtom.getSymbol().equals("C")) continue;
                return true;
            }
        }
        IAtomContainer tmpMurcko = this.getMurckoFragment(aMolecule);
        for (IAtom tmpAtom : tmpMurcko.atoms()) {
            Integer tmpAtomProperty = (Integer)tmpAtom.getProperty((Object)SCAFFOLD_ATOM_COUNTER_PROPERTY);
            if (tmpRemovedMurckoAtomNumbers.contains(tmpAtomProperty) || tmpRingPropertyNumbers.contains(tmpAtomProperty)) continue;
            for (IBond tmpBond : tmpAtom.bonds()) {
                Integer tmpBondProperty0;
                if (!tmpBond.getAtom(0).getSymbol().equals("C") && (tmpRemovedMurckoAtomNumbers.contains(tmpBondProperty0 = (Integer)tmpBond.getAtom(0).getProperty((Object)SCAFFOLD_ATOM_COUNTER_PROPERTY)) || tmpRingPropertyNumbers.contains(tmpBondProperty0))) {
                    return true;
                }
                if (tmpBond.getAtom(1).getSymbol().equals("C") || !tmpRemovedMurckoAtomNumbers.contains(tmpBondProperty1 = (Integer)tmpBond.getAtom(1).getProperty((Object)SCAFFOLD_ATOM_COUNTER_PROPERTY)) && !tmpRingPropertyNumbers.contains(tmpBondProperty1)) continue;
                return true;
            }
        }
        return false;
    }

    protected IAtomContainer applySchuffenhauerRuleThirteen(IAtomContainer aMolecule, List<IAtomContainer> aRings) throws CDKException, CloneNotSupportedException {
        IAtomContainer tmpClonedMolecule = aMolecule.clone();
        TreeMap<String, IAtomContainer> tmpRingRemovedMap = new TreeMap<String, IAtomContainer>();
        for (IAtomContainer tmpRing : aRings) {
            IAtomContainer tmpRingRemoved = this.removeRing(tmpClonedMolecule, true, tmpRing);
            IAtomContainer tmpScaffold = this.getScaffoldInternal(tmpRingRemoved, true, false, null, this.scaffoldModeSetting);
            tmpRingRemovedMap.put(SMILES_GENERATOR_SETTING_DEFAULT.create(tmpScaffold), tmpScaffold);
        }
        IAtomContainer tmpReturnedStructure = (IAtomContainer)tmpRingRemovedMap.get(tmpRingRemovedMap.firstKey());
        return tmpReturnedStructure;
    }

    public static enum ScaffoldModeOption {
        SCAFFOLD,
        MURCKO_FRAMEWORK,
        BASIC_WIRE_FRAME,
        ELEMENTAL_WIRE_FRAME,
        BASIC_FRAMEWORK;

    }
}

