/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools.scaffold;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.smiles.SmilesGenerator;
import org.openscience.cdk.tools.scaffold.NetworkNode;
import org.openscience.cdk.tools.scaffold.ScaffoldNodeBase;
import org.openscience.cdk.tools.scaffold.ScaffoldNodeCollectionBase;

public class ScaffoldNetwork
extends ScaffoldNodeCollectionBase {
    public ScaffoldNetwork(SmilesGenerator aSmilesGenerator) {
        super(aSmilesGenerator);
    }

    public ScaffoldNetwork() {
    }

    @Override
    public void addNode(ScaffoldNodeBase aNode) throws CDKException, IllegalArgumentException, NullPointerException {
        Objects.requireNonNull(aNode, "Given NetworkNode is 'null'");
        if (!(aNode instanceof NetworkNode)) {
            throw new IllegalArgumentException("Node can not be added to ScaffoldNetwork. Parameter must be a NetworkNode.");
        }
        this.addNodeToCollections(aNode);
        this.updateLevelMap();
        ++this.nodeCounter;
    }

    public void updateLevelMap() {
        HashMap<Integer, HashSet> tmpLevelMap = new HashMap<Integer, HashSet>(300, 0.6f);
        for (ScaffoldNodeBase tmpNodeBase : this.getAllNodes()) {
            NetworkNode tmpNetworkNode = (NetworkNode)tmpNodeBase;
            int tmpLevelInternal = tmpNetworkNode.getLevel();
            tmpLevelMap.computeIfAbsent(tmpLevelInternal, k -> new HashSet(50, 0.75f));
            ((HashSet)tmpLevelMap.get(tmpLevelInternal)).add(tmpNetworkNode);
        }
        this.levelMap = tmpLevelMap;
    }

    @Override
    public void removeNode(ScaffoldNodeBase aNode) throws CDKException, IllegalArgumentException, NullPointerException {
        Objects.requireNonNull(aNode, "Given ScaffoldNode is 'null'");
        if (!(aNode instanceof NetworkNode)) {
            throw new IllegalArgumentException("Node can not be removed from ScaffoldNetwork. Parameter must be a NetworkNode.");
        }
        if (!this.reverseNodeMap.containsKey(aNode)) {
            throw new IllegalArgumentException("Node is not in Scaffold");
        }
        int tmpNumberInNodeMap = (Integer)this.reverseNodeMap.get(aNode);
        this.nodeMap.remove(tmpNumberInNodeMap);
        this.reverseNodeMap.remove(aNode);
        String tmpSmiles = this.smilesGenerator.create((IAtomContainer)aNode.getMolecule());
        this.smilesMap.remove(tmpSmiles, aNode);
        HashSet tmpNodesOnLevelSet = (HashSet)this.levelMap.get(aNode.getLevel());
        tmpNodesOnLevelSet.remove(aNode);
    }

    public void mergeNetwork(ScaffoldNetwork aScaffoldNetwork) throws CDKException {
        if (this.getAllNodes().isEmpty()) {
            for (ScaffoldNodeBase tmpNode : aScaffoldNetwork.getAllNodes()) {
                this.addNode(tmpNode);
            }
        } else {
            ArrayList<IAtomContainer> tmpMoleculeList = new ArrayList<IAtomContainer>(aScaffoldNetwork.getAllNodes().size());
            for (ScaffoldNodeBase tmpNewNetworkObject : aScaffoldNetwork.getAllNodes()) {
                NetworkNode tmpNewNetworkNode = (NetworkNode)tmpNewNetworkObject;
                if (!this.containsMolecule((IAtomContainer)tmpNewNetworkNode.getMolecule())) {
                    NetworkNode<IAtomContainer> tmpNewNode = new NetworkNode<IAtomContainer>((IAtomContainer)tmpNewNetworkNode.getMolecule());
                    for (String tmpNonVirtualOriginSmiles : tmpNewNetworkNode.getNonVirtualOriginSmilesList()) {
                        tmpNewNode.addNonVirtualOriginSmiles(tmpNonVirtualOriginSmiles);
                    }
                    for (String tmpOriginSmiles : tmpNewNetworkNode.getOriginSmilesList()) {
                        tmpNewNode.addOriginSmiles(tmpOriginSmiles);
                    }
                    this.addNode(tmpNewNode);
                    tmpMoleculeList.add((IAtomContainer)tmpNewNetworkNode.getMolecule());
                    continue;
                }
                NetworkNode tmpOldNetworkNode = (NetworkNode)this.getNode((IAtomContainer)tmpNewNetworkNode.getMolecule());
                for (String tmpOriginSmiles : tmpNewNetworkNode.getOriginSmilesList()) {
                    tmpOldNetworkNode.addOriginSmiles(tmpOriginSmiles);
                }
                if (!tmpNewNetworkNode.hasNonVirtualOriginSmiles()) continue;
                for (String tmpNonVirtualOriginSmiles : tmpNewNetworkNode.getNonVirtualOriginSmilesList()) {
                    tmpOldNetworkNode.addNonVirtualOriginSmiles(tmpNonVirtualOriginSmiles);
                }
            }
            for (IAtomContainer tmpMolecule : tmpMoleculeList) {
                ScaffoldNodeBase tmpChildBase = aScaffoldNetwork.getNode(tmpMolecule);
                NetworkNode tmpChild = (NetworkNode)tmpChildBase;
                ArrayList tmpParentList = (ArrayList)tmpChild.getParents();
                for (NetworkNode tmpParentNode : tmpParentList) {
                    if (!this.containsMolecule((IAtomContainer)tmpParentNode.getMolecule())) continue;
                    NetworkNode tmpOldParentNode = (NetworkNode)this.getNode((IAtomContainer)tmpParentNode.getMolecule());
                    NetworkNode tmpOldChild = (NetworkNode)this.getNode(tmpMolecule);
                    tmpOldChild.addParent(tmpOldParentNode);
                }
            }
        }
        this.updateLevelMap();
    }

    @Override
    public Integer[][] getMatrix() throws IllegalStateException {
        int tmpSize = this.nodeMap.size();
        Integer[][] tmpMatrix = new Integer[tmpSize][tmpSize];
        for (int tmpRow = 0; tmpRow < tmpMatrix.length; ++tmpRow) {
            Arrays.fill(tmpMatrix[tmpRow], (Object)0);
        }
        int tmpCounter = 0;
        for (ScaffoldNodeBase tmpNodeBase : this.nodeMap.values()) {
            NetworkNode tmpNode = (NetworkNode)tmpNodeBase;
            if (tmpNode.getParents() != null) {
                for (NetworkNode tmpParentNode : tmpNode.getParents()) {
                    if (this.reverseNodeMap.get(tmpParentNode) == null) continue;
                    tmpMatrix[tmpCounter][this.getMatrixNodesNumbers().indexOf(this.reverseNodeMap.get(tmpParentNode))] = 1;
                    tmpMatrix[this.getMatrixNodesNumbers().indexOf(this.reverseNodeMap.get(tmpParentNode))][tmpCounter] = 1;
                }
            }
            ++tmpCounter;
        }
        return tmpMatrix;
    }

    public List<NetworkNode> getRoots() {
        ArrayList<NetworkNode> tmpNodeList = new ArrayList<NetworkNode>();
        for (ScaffoldNodeBase tmpNodeBase : this.nodeMap.values()) {
            NetworkNode tmpNode = (NetworkNode)tmpNodeBase;
            if (tmpNode.getLevel() != 0) continue;
            tmpNodeList.add(tmpNode);
        }
        return tmpNodeList;
    }
}

